/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import javax.swing.Icon;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.palette2.PaletteItem;

final class XmlPaletteItem
extends PaletteItem
implements Comparable<XmlPaletteItem> {
    private final XmlCreatable _creatable;
    private JDevPaletteGui _gui;
    private boolean _nameLoaded;
    private boolean _itemLoaded;
    private Icon _icon;
    private Icon _largeIcon;
    private String _id;
    private String _helpTopic;
    private String _name;
    private String _description;
    private String _searchKeywords;

    public XmlPaletteItem(XmlCreatable creatable, JDevPaletteGui gui) {
        this._creatable = creatable;
        this._nameLoaded = false;
        this._itemLoaded = false;
        this._gui = gui;
    }

    public String getName() {
        if (!this._nameLoaded) {
            this._loadName();
        }
        return this._name;
    }

    public String getDescription() {
        if (!this._itemLoaded) {
            this._loadItem();
        }
        return this._description;
    }

    public Icon getIcon() {
        if (!this._itemLoaded) {
            this._loadItem();
        }
        return this._icon;
    }

    public Icon getLargeIcon() {
        if (!this._itemLoaded) {
            this._loadItem();
        }
        return this._largeIcon;
    }

    public String getProviderId() {
        return "oracle.bali.xml.model.creatable.XmlCreatable_item";
    }

    public String getItemId() {
        if (!this._itemLoaded) {
            this._loadItem();
        }
        return this._id;
    }

    public String getSearchTextContext() {
        return "oracle.bali.xml.gui.jdev.palette.XmlPaletteSearch";
    }

    public String getSearchKeywords() {
        if (!this._itemLoaded) {
            this._loadItem();
        }
        return this._searchKeywords;
    }

    public String getHelpable() {
        if (!this._itemLoaded) {
            this._loadItem();
        }
        return this._helpTopic;
    }

    public Object getData(Object key) {
        if (XmlTransferUtils.FLAVOR_XMLCREATABLE.equals(key)) {
            return this._creatable;
        }
        return null;
    }

    @Override
    public int compareTo(XmlPaletteItem o) {
        int nameCompare;
        if (!this._nameLoaded) {
            this._loadName();
        }
        if ((nameCompare = String.CASE_INSENSITIVE_ORDER.compare(this._name, o.getName())) != 0) {
            return nameCompare;
        }
        return this._creatable.hashCode() - o._creatable.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof XmlPaletteItem && ((XmlPaletteItem)o)._creatable.equals((Object)this._creatable);
    }

    public int hashCode() {
        return 31 * this.getClass().hashCode() + this._creatable.hashCode();
    }

    public String toString() {
        if (!this._nameLoaded) {
            this._loadName();
        }
        return this._name;
    }

    XmlCreatable __getCreatable() {
        return this._creatable;
    }

    void __dispose() {
        this._gui = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _loadName() {
        XmlView view = this._gui.getView();
        XmlCreationContext context = XmlCreationContext.create((AbstractModel)view, (String)"xmlef-palette");
        view.acquireReadLock();
        try {
            this._name = this._creatable.getMediumDisplayName(context);
            this._nameLoaded = true;
        }
        finally {
            view.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadItem() {
        XmlView view = this._gui.getView();
        XmlCreationContext context = XmlCreationContext.create((AbstractModel)view, (String)"xmlef-palette");
        view.acquireReadLock();
        try {
            this._id = this._creatable.getIdentifier();
            this._description = this._creatable.getShortDescription(context);
            this._icon = this._creatable.getSmallIcon(context);
            this._largeIcon = this._creatable.getLargeIcon(context);
            this._helpTopic = this._creatable.getHelpTopic(context);
            this._searchKeywords = this._creatable.getSearchKeywords(context);
            this._itemLoaded = true;
        }
        finally {
            view.releaseReadLock();
        }
    }
}

