/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.xml.addin.palette.XMLPaletteItemHandler;
import oracle.bali.xml.addin.palette.XMLPaletteManager;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.gui.jdev.palette.XmlPalettePage;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.category.CategoryDefinitionFactory;
import oracle.bali.xml.model.category.IllegalCategoryException;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.model.creatable.XmlKeyCreatable;
import oracle.bali.xml.model.metadata.XmlMetadataResolverEvent;
import oracle.bali.xml.model.metadata.XmlMetadataResolverListener;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.palette2.PaletteEvent;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.view.View;

public class XmlPalettePages
extends PalettePages
implements PaletteListener {
    private final Map<String, XmlPalettePage> _pages = new LinkedHashMap<String, XmlPalettePage>();
    private Collection<PalettePage> _pagesCollection;
    private final Set<PalettePagesListener> _listeners = new CopyOnWriteArraySet<PalettePagesListener>();
    private final JDevPaletteGui _gui;
    private static final Logger _LOGGER = Logger.getLogger(XmlPalettePages.class.getName());
    private CategoryDefinition _categoryDefinitionPalettePage;
    private CategoryDefinition _categoryDefinitionPaletteGroup;
    private CategoryDefinition _categoryDefinitionPaletteSection;
    private Context _context;
    private String _preferredPageName;
    private float _categoryPageRank = -1.0f;
    private XmlCreationContext _xmlCreationContext;
    private XmlUsage _editorUsage;

    public XmlPalettePages(JDevPaletteGui gui, XmlUsage editorUsage) {
        this._gui = gui;
        MetadataListener metadataListener = new MetadataListener(this);
        this._gui.getGuiContext().getModel().getXmlMetadataResolver().addMetadataResolverListener((XmlMetadataResolverListener)metadataListener);
        this._editorUsage = editorUsage;
    }

    public void paletteOpened(PaletteEvent event) {
    }

    public void paletteClosed(PaletteEvent event) {
    }

    public void selectionChanged(PaletteEvent event) {
    }

    public void itemSelected(PaletteEvent event) {
        if (event.getAction().equals("PALETTE2_ITEM_DEFAULTCREATE") || event.getAction().equals("PALETTE2_ITEM_SELECTED")) {
            this.handleInsert(event);
        }
    }

    private void handleInsert(PaletteEvent event) {
        XMLPaletteItemHandler handler;
        Editor editor;
        XmlPaletteItem xmlPaletteItem;
        PaletteItem selectedPaletteItem;
        Object paletteItem = event.getSource();
        if (paletteItem instanceof XmlPaletteItem && (selectedPaletteItem = this.getItem("oracle.bali.xml.model.creatable.XmlCreatable_item", (xmlPaletteItem = (XmlPaletteItem)event.getSource()).getItemId())) != null && (editor = EditorManager.getEditorManager().getCurrentEditor()) != null && this._context != null && this._palettePageContextMatchesEditorContext(editor) && (handler = XMLPaletteManager.getItemHandler(editor.getClass())) != null) {
            handler.insertItem(this._context, xmlPaletteItem.__getCreatable(), editor);
            PaletteManager.getPaletteManager().getPaletteWindow().unSelectSelectedItem();
            EditorManager.getEditorManager().activateCurrentEditorFrame();
        }
    }

    public void itemUnselected(PaletteEvent event) {
    }

    public void stickyModeActivated(PaletteEvent event) {
    }

    public void stickyModeDeactivated(PaletteEvent event) {
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Collection<PalettePage> getPages() {
        if (this._pagesCollection == null) {
            this._loadPagesCollection();
        }
        return this._pagesCollection;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        this._listeners.add(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        this._listeners.remove(listener);
    }

    public PaletteItem getItem(String providerId, String itemId) {
        if ("oracle.bali.xml.model.creatable.XmlCreatable_item".equals(providerId) && itemId != null) {
            return this._findItem(itemId);
        }
        return null;
    }

    public PalettePage getPreferredPage() {
        String preferredPageName = this._gui.getPreferredPageName();
        if (preferredPageName != null) {
            return this._pages.get(preferredPageName);
        }
        this._preferredPageName = null;
        this.getPreferredPageRank();
        if (this._preferredPageName == null) {
            return null;
        }
        return this._pages.get(this._preferredPageName);
    }

    public float getPreferredPageRank() {
        float preferredPageRank = this._gui.getPreferredPageRank();
        if (preferredPageRank > -1.0f) {
            return preferredPageRank;
        }
        float highestPageRank = -1.0f;
        for (XmlPalettePage page : this._pages.values()) {
            float currPageRank = page.getPreferredPageRank();
            if (!(currPageRank > highestPageRank)) continue;
            highestPageRank = currPageRank;
            this._preferredPageName = page.getName();
        }
        return highestPageRank;
    }

    public void dispose() {
        this._context = null;
        this._pagesCollection = null;
        this._xmlCreationContext = null;
        Set<XmlPalettePage> currentPages = XmlPalettePages._createSet();
        currentPages.addAll(this._pages.values());
        this._pages.clear();
        for (XmlPalettePage page : currentPages) {
            page.__dispose();
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    private void _loadPagesCollection() {
        final HashSet added = new HashSet();
        final HashSet changed = new HashSet();
        this._xmlCreationContext = this._editorUsage == null ? XmlCreationContext.create((AbstractModel)this._gui.getView(), (String)"xmlef-palette") : XmlCreationContext.create((AbstractModel)this._gui.getView(), (String)"xmlef-palette", (XmlUsage)this._editorUsage);
        new ReadOnlyTask(){

            protected Object runImpl(AbstractModel model) {
                XmlMetadataResolver resolver = model.getXmlMetadataResolver();
                Iterator creatables = resolver.getXmlCreatables(XmlPalettePages.this._xmlCreationContext);
                XmlPalettePages.this._addItems(creatables, XmlPalettePages.this._xmlCreationContext, added, changed);
                XmlPalettePages.this._addMiscItems(XmlPalettePages.this._xmlCreationContext, added, changed);
                return null;
            }
        }.run((AbstractModel)this._gui.getView());
        this._pagesCollection = Collections.unmodifiableCollection(this._pages.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _update(XmlMetadataResolverEvent e) {
        if (this._xmlCreationContext == null) {
            return;
        }
        XmlMetadataResolver resolver = e.getXmlMetadataResolver();
        AbstractModel model = resolver.getModel();
        Iterator creatables = resolver.getXmlCreatables(this._xmlCreationContext);
        Set<XmlPalettePage> addedPages = XmlPalettePages._createSet();
        Set<XmlPalettePage> removedPages = XmlPalettePages._createSet();
        Set<XmlPalettePage> changedPages = XmlPalettePages._createSet();
        XmlPalettePages xmlPalettePages = this;
        synchronized (xmlPalettePages) {
            Set<XmlPalettePage> currentPages = XmlPalettePages._createSet();
            currentPages.addAll(this._pages.values());
            for (XmlPalettePage page : currentPages) {
                page.__clearItems();
            }
            this._addItems(creatables, this._xmlCreationContext, addedPages, changedPages);
            this._addMiscItems(this._xmlCreationContext, addedPages, changedPages);
            for (XmlPalettePage page : currentPages) {
                page.__trimEmptyContainers();
                if (!page.getGroups().isEmpty()) continue;
                this._pages.remove(page.getName());
                removedPages.add(page);
            }
            changedPages.removeAll(removedPages);
            changedPages.removeAll(addedPages);
        }
        this._fireEvent(addedPages, removedPages, changedPages);
    }

    private static <T> Set<T> _createSet() {
        return new HashSet();
    }

    private void _fireEvent(final Set<XmlPalettePage> addedPages, final Set<XmlPalettePage> removedPages, final Set<XmlPalettePage> changedPages) {
        if (!(addedPages.isEmpty() && removedPages.isEmpty() && changedPages.isEmpty() || this._listeners.isEmpty())) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.runPalettePagesChanged(addedPages, removedPages, changedPages);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XmlPalettePages.this.runPalettePagesChanged(addedPages, removedPages, changedPages);
                    }
                });
            }
        }
    }

    private void runPalettePagesChanged(Set<XmlPalettePage> addedPages, Set<XmlPalettePage> removedPages, Set<XmlPalettePage> changedPages) {
        for (PalettePagesListener listener : this._listeners) {
            listener.palettePagesChanged(Collections.unmodifiableSet(addedPages), Collections.unmodifiableSet(removedPages), Collections.unmodifiableSet(changedPages));
        }
    }

    private XmlPalettePage _getOrCreatePage(CategoryDefinition categoryDefinitionPalettePage, Set<XmlPalettePage> addedPages) {
        XmlPalettePage page = this._pages.get(categoryDefinitionPalettePage.getDisplayName());
        if (page == null) {
            page = new XmlPalettePage(this._gui, categoryDefinitionPalettePage);
            this._pages.put(categoryDefinitionPalettePage.getDisplayName(), page);
            addedPages.add(page);
        }
        return page;
    }

    private PaletteItem _findItem(String identifier) {
        for (XmlPalettePage page : this._pages.values()) {
            PaletteItem item = page.__findItem(identifier);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private void _addItems(Iterator<XmlCreatable> creatables, XmlCreationContext context, Set<XmlPalettePage> addedPages, Set<XmlPalettePage> changedPages) {
        while (creatables.hasNext()) {
            XmlCreatable creatable = creatables.next();
            this._addItem(creatable, context, addedPages, changedPages);
        }
    }

    private void _addItem(XmlCreatable creatable, XmlCreationContext context, Set<XmlPalettePage> addedPages, Set<XmlPalettePage> changedPages) {
        if (!creatable.isHidden(context)) {
            this._getCategoryDefinitions(creatable, context);
            XmlPalettePage page = this._getOrCreatePage(this._categoryDefinitionPalettePage, addedPages);
            XmlPaletteItem item = page.__addItem(creatable, this._categoryDefinitionPaletteGroup, this._categoryDefinitionPaletteSection);
            if (item != null) {
                changedPages.add(page);
            }
        }
    }

    private void _getCategoryDefinitions(XmlCreatable creatable, XmlCreationContext context) {
        this._categoryDefinitionPalettePage = null;
        this._categoryDefinitionPaletteGroup = null;
        this._categoryDefinitionPaletteSection = null;
        List catDefList = creatable.getCategoryDefinition(context);
        if (catDefList != null && !catDefList.isEmpty()) {
            Iterator iter = catDefList.iterator();
            this._categoryDefinitionPalettePage = (CategoryDefinition)iter.next();
            this._categoryPageRank = this._categoryDefinitionPalettePage.getPreferredPageRank();
            if (iter.hasNext()) {
                this._categoryDefinitionPaletteGroup = (CategoryDefinition)iter.next();
            } else {
                try {
                    this._categoryDefinitionPaletteGroup = CategoryDefinitionFactory.createMutableCategoryDefinition((String)"");
                }
                catch (IllegalCategoryException ex) {
                    this._categoryDefinitionPaletteGroup = null;
                }
            }
            if (iter.hasNext()) {
                this._categoryDefinitionPaletteSection = (CategoryDefinition)iter.next();
            } else {
                try {
                    this._categoryDefinitionPaletteSection = CategoryDefinitionFactory.createMutableCategoryDefinition((String)"");
                }
                catch (IllegalCategoryException ex) {
                    this._categoryDefinitionPaletteSection = null;
                }
            }
        } else {
            try {
                this._categoryDefinitionPalettePage = CategoryDefinitionFactory.createMutableCategoryDefinition((String)"");
            }
            catch (IllegalCategoryException ex) {
                this._categoryDefinitionPalettePage = null;
            }
        }
    }

    private void _addMiscItems(XmlCreationContext context, Set<XmlPalettePage> added, Set<XmlPalettePage> changed) {
        this._addItem((XmlCreatable)new XmlKeyCreatable((XmlKey)GlobalNodeTypeKey.TEXT_KEY), context, added, changed);
        this._addItem((XmlCreatable)new XmlKeyCreatable((XmlKey)GlobalNodeTypeKey.CDATA_SECTION_KEY), context, added, changed);
        this._addItem((XmlCreatable)new XmlKeyCreatable((XmlKey)GlobalNodeTypeKey.COMMENT_KEY), context, added, changed);
        this._addItem((XmlCreatable)new XmlKeyCreatable((XmlKey)GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY), context, added, changed);
    }

    private boolean _palettePageContextMatchesEditorContext(Editor editor) {
        Context context = editor.getContext();
        if (context == null) {
            return false;
        }
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Node node = context.getNode();
        if (node == null) {
            return false;
        }
        View view = context.getView();
        if (view == null) {
            return false;
        }
        boolean matches = workspace.equals((Object)this._context.getWorkspace()) && project.equals((Object)this._context.getProject()) && node.equals(this._context.getNode()) && view.equals(this._context.getView());
        return matches;
    }

    private static class MetadataListener
    implements XmlMetadataResolverListener {
        private WeakReference<XmlPalettePages> _xmlPalettePagesRef;

        public MetadataListener(XmlPalettePages xmlPalettePages) {
            this._xmlPalettePagesRef = new WeakReference<XmlPalettePages>(xmlPalettePages);
        }

        public void metadataResolverChanged(final XmlMetadataResolverEvent e) {
            final XmlPalettePages xmlPalettePages = (XmlPalettePages)((Object)this._xmlPalettePagesRef.get());
            if (xmlPalettePages == null) {
                return;
            }
            new ReadOnlyTask(){

                protected Object runImpl(AbstractModel model) {
                    xmlPalettePages._update(e);
                    return null;
                }
            }.run((AbstractModel)xmlPalettePages._gui.getView());
        }
    }
}

