/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

class XmlPaletteSection
extends PaletteSection {
    private _LazyLoadedCollectionDecorator _items;
    private JDevPaletteGui _gui;
    private final CategoryDefinition _categoryDefinitionPaletteSection;
    private final Collection<XmlPaletteItem> _unsortedItems = new ArrayList<XmlPaletteItem>();

    XmlPaletteSection(JDevPaletteGui gui, CategoryDefinition categoryDefinitionPaletteSection) {
        this._gui = gui;
        this._categoryDefinitionPaletteSection = categoryDefinitionPaletteSection;
    }

    public String getName() {
        return this._categoryDefinitionPaletteSection.getDisplayName();
    }

    public int getDisplayOrder() {
        return this._categoryDefinitionPaletteSection.getDisplayOrder();
    }

    public Collection<PaletteItem> getItems() {
        if (this._items == null) {
            this._items = new _LazyLoadedCollectionDecorator(this._unsortedItems);
        }
        return this._items;
    }

    public Object getData(Object key) {
        return null;
    }

    public String toString() {
        return "{" + this._categoryDefinitionPaletteSection.getDisplayName() + "; " + this._items + "}";
    }

    XmlPaletteItem __addItem(XmlCreatable creatable) {
        XmlPaletteItem item = new XmlPaletteItem(creatable, this._gui);
        this._unsortedItems.add(item);
        return item;
    }

    void __clearItems() {
        this._unsortedItems.clear();
        this._items = null;
    }

    void __dispose() {
        for (XmlPaletteItem item : this._unsortedItems) {
            item.__dispose();
        }
        this.__clearItems();
        this._gui = null;
    }

    PaletteItem __findItem(String identifier) {
        for (PaletteItem item : this.getItems()) {
            if (!identifier.equals(item.getItemId())) continue;
            return item;
        }
        return null;
    }

    private final class _LazyLoadedCollectionDecorator
    extends AbstractCollection<PaletteItem> {
        private Collection<XmlPaletteItem> _unsortedItems;
        private final Set<XmlPaletteItem> _items = new TreeSet<XmlPaletteItem>();
        private boolean _itemsLoaded;
        private final Collection<PaletteItem> _itemsUnmodifiable = Collections.unmodifiableCollection(this._items);

        public _LazyLoadedCollectionDecorator(Collection<XmlPaletteItem> unsortedItems) {
            this._unsortedItems = unsortedItems;
            this._itemsLoaded = false;
        }

        @Override
        public final int size() {
            return this._unsortedItems.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Iterator<PaletteItem> iterator() {
            if (!this._itemsLoaded && XmlPaletteSection.this._gui != null && XmlPaletteSection.this._gui.getPalettePagesLock() != null) {
                Object object = XmlPaletteSection.this._gui.getPalettePagesLock();
                synchronized (object) {
                    if (!this._itemsLoaded) {
                        for (XmlPaletteItem item : this._unsortedItems) {
                            this._items.add(item);
                        }
                        this._itemsLoaded = true;
                    }
                }
            }
            return this._itemsUnmodifiable.iterator();
        }
    }
}

