/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlPersistentModelListener;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.xml.XmlModelDependency;

class XmlModelDependencyListener
implements XmlPersistentModelListener {
    private static final Log LOG = new Log("xml-dependency", "dependency");
    private final URL file;
    private final URL projectFile;
    private final URL workspaceFile;
    private final List<XmlModelDependency> dependencies = new ArrayList<XmlModelDependency>();
    private volatile boolean disabled;
    private int changeCount;

    XmlModelDependencyListener(XmlModelDependency dependency) {
        this.file = dependency.getFile();
        this.projectFile = dependency.getProjectFile();
        this.workspaceFile = dependency.getWorkspaceFile();
        this.dependencies.add(dependency);
    }

    boolean matches(XmlModelDependency dependency) {
        return !this.disabled && XmlModelDependencyListener.equals(dependency.getWorkspaceFile(), this.workspaceFile) && XmlModelDependencyListener.equals(dependency.getProjectFile(), this.projectFile) && XmlModelDependencyListener.equals(dependency.getFile(), this.file);
    }

    private static boolean equals(URL left, URL right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        return URLFileSystem.equals((URL)left, (URL)right);
    }

    synchronized boolean disabled() {
        return this.disabled;
    }

    synchronized void addDependency(XmlModelDependency dependency) {
        if (this.disabled) {
            return;
        }
        this.dependencies.add(dependency);
    }

    synchronized void removeDependency(XmlModelDependency dependency) {
        if (this.disabled) {
            return;
        }
        this.dependencies.remove((Object)dependency);
        this.disabled = this.dependencies.isEmpty();
    }

    void addListener(XmlModelDependency dependency, XMLSourceNode node) {
        if (this.disabled) {
            return;
        }
        this.changeCount = node.acquireTextBuffer().getChangeId();
        LOG.trace("{1} attaching to node, change count {0}", this.changeCount, (Object)this);
        node.addPersistentXmlModelListener(dependency.getWorkspace(), dependency.getProject(), this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNodeOpened(XMLSourceNode node) {
        XmlModelDependency dependency;
        assert (node.isWriteLockHeld()) : "node " + node.getURL() + " (" + ((Object)((Object)node)).getClass() + ") not write-locked by caller";
        XmlModelDependencyListener xmlModelDependencyListener = this;
        synchronized (xmlModelDependencyListener) {
            if (this.disabled) {
                return;
            }
            dependency = this.dependencies.get(0);
        }
        this.changeCount = node.acquireTextBuffer().getChangeId();
        LOG.trace("{1} attaching to node, change count {0}", this.changeCount, (Object)this);
        node.addPersistentXmlModelListener(dependency.getWorkspace(), dependency.getProject(), this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNodeClosedOrRenamed(XMLSourceNode node) {
        XmlModelDependency dependency;
        assert (node.isWriteLockHeld()) : " node " + this.file + " (" + ((Object)((Object)node)).getClass() + ") not write-locked by caller";
        XmlModelDependencyListener xmlModelDependencyListener = this;
        synchronized (xmlModelDependencyListener) {
            if (this.disabled) {
                return;
            }
            dependency = this.dependencies.get(0);
        }
        LOG.trace("{1} detaching from node, change count {0}", this.changeCount, (Object)this);
        node.removePersistentXmlModelListener(dependency.getWorkspace(), dependency.getProject(), this);
    }

    void removeListener(XmlModelDependency dependency, XMLSourceNode node) {
        assert (!node.isReadLockHeld()) : " node " + node.getURL() + " (" + ((Object)((Object)node)).getClass() + ") read-locked by caller";
        LOG.trace("{2} (disabled {1}) detaching from node, change count {0}", this.changeCount, (Object)this.disabled, (Object)this);
        node.removePersistentXmlModelListener(dependency.getWorkspace(), dependency.getProject(), this);
    }

    public void xmlContextCreated(XmlModelEvent event, boolean fileChanged) {
        if (this.disabled) {
            return;
        }
        LOG.trace("{0} xmlContextCreated event", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(XmlModelEvent event) {
        int oldChangeCount;
        if (this.disabled) {
            return;
        }
        LOG.trace("{1} invalidate event ({0}) {2}\n[END event]", this.changeCount, (Object)this, (Object)event);
        XMLSourceNode node = ((JDevXmlContext)event.getModel().getContext()).getIdeDocument();
        if (!node.isLockHeld()) {
            String message = "invalidated node " + (Object)((Object)node) + " not locked by caller in " + this;
            LOG.trace(message);
            AuditLogger.error((Throwable)new Throwable(message), (String)message, (Object[])new Object[0]);
            return;
        }
        TextBuffer buffer = node.tryAcquireTextBuffer();
        if (buffer == null) {
            String message = "invalidated node " + (Object)((Object)node) + " not open in " + this;
            LOG.trace(message);
            AuditLogger.error((Throwable)new Throwable(message), (String)message, (Object[])new Object[0]);
            return;
        }
        XmlModelDependencyListener xmlModelDependencyListener = this;
        synchronized (xmlModelDependencyListener) {
            if (this.dependencies.isEmpty()) {
                return;
            }
            oldChangeCount = this.changeCount;
            this.changeCount = buffer.getChangeId();
        }
        if (this.changeCount == oldChangeCount && (event.isDomTreeChanged() || event.isAnnotationModelChanged() || event.getCachedUrlMapPropertyChange() != null)) {
            this.fireDependencyChanged();
        } else {
            LOG.trace("{2} ignoring invalidate event ({0}, was {1})", this.changeCount, oldChangeCount, (Object)this);
        }
    }

    public void modelChanged(XmlModelEvent event) {
        if (this.disabled) {
            return;
        }
        if (LOG.isEnabled() && event.containsPropertyChange("XmlModelIssueList")) {
            IssueList issues = (IssueList)event.getIssueListPropertyChange().getNewValue();
            StringBuilder builder = new StringBuilder(issues.getClass().getSimpleName());
            builder.append("[");
            builder.append(issues.getErrorCount());
            builder.append("/");
            builder.append(issues.getWarningCount());
            builder.append("/");
            builder.append(issues.getIncompleteCount());
            builder.append("/");
            builder.append(issues.getAdvisoryCount());
            builder.append("]");
            String EOL = System.getProperty("line.separator");
            for (Issue issue : issues) {
                builder.append(EOL);
                builder.append("\t");
                String message = issue.getMessage().trim();
                int line = message.indexOf(10);
                if (line > 0) {
                    if (message.charAt(line - 1) == '\r') {
                        --line;
                    }
                    message = message.substring(0, line).trim();
                }
                builder.append(message);
            }
            builder.append("END issue list");
            LOG.trace("{0} handling new issue list: {0}", (Object)this, (Object)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDependencyChanged() {
        Dependency[] array;
        if (this.disabled) {
            return;
        }
        XmlModelDependencyListener xmlModelDependencyListener = this;
        synchronized (xmlModelDependencyListener) {
            array = this.dependencies.toArray(new Dependency[this.dependencies.size()]);
        }
        for (Dependency dependency : array) {
            dependency.fireDependencyChanged(false);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + URLFileSystem.getFileName((URL)this.file) + "]";
    }
}

