/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JSplitPane;
import oracle.dbtools.migration.gui.ScratchEditorProvider;
import oracle.dbtools.migration.gui.SourceWorksheet;
import oracle.dbtools.migration.gui.TargetWorksheet;
import oracle.dbtools.worksheet.ActionProvider;

public class DoubleWorksheetGUI
extends JSplitPane {
    SourceWorksheet m_sourceWS = null;
    TargetWorksheet m_targetWS = null;
    private boolean isFirstPaint = true;
    private boolean m_isSourceSelected = true;
    protected ArrayList<ActionProvider> m_providers = new ArrayList();

    public boolean isSourceSelected() {
        return this.m_isSourceSelected;
    }

    public DoubleWorksheetGUI() {
        super(1);
        ScratchEditorProvider scratchEditorProvider = new ScratchEditorProvider();
        this.m_providers.add(scratchEditorProvider);
        this.m_sourceWS = new SourceWorksheet(this.m_providers);
        this.m_targetWS = new TargetWorksheet();
        scratchEditorProvider.setWorksheets(this.m_sourceWS, this.m_targetWS);
        Component component = this.m_sourceWS.getGUI();
        Component component2 = this.m_targetWS.getGUI();
        component.setMinimumSize(new Dimension(1, 1));
        component2.setMinimumSize(new Dimension(1, 1));
        this.setLeftComponent(component);
        this.setRightComponent(component2);
    }

    public void activate() {
        this.initFocusListners();
        this.m_targetWS.getFocusedEditorPane().requestFocusInWindow();
        this.m_sourceWS.getFocusedEditorPane().requestFocusInWindow();
        this.m_sourceWS.activate();
        this.m_targetWS.activate();
    }

    private void initFocusListners() {
        this.m_sourceWS.getDefaultFocusComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DoubleWorksheetGUI.this.m_isSourceSelected = true;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.m_targetWS.getDefaultFocusComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DoubleWorksheetGUI.this.m_isSourceSelected = false;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isFirstPaint) {
            double d = 0.5;
            this.setDividerLocation(d);
            this.doLayout();
            this.isFirstPaint = false;
        }
        super.paint(graphics);
    }

    public SourceWorksheet getSourceWS() {
        return this.m_sourceWS;
    }

    public void setSourceWS(SourceWorksheet sourceWorksheet) {
        this.m_sourceWS = sourceWorksheet;
    }

    public TargetWorksheet getTargetWS() {
        return this.m_targetWS;
    }

    public void setTargetWS(TargetWorksheet targetWorksheet) {
        this.m_targetWS = targetWorksheet;
    }
}

