/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.migration.gui.AScratchWorksheet;
import oracle.dbtools.migration.gui.LanguageComboBoxRenderer;
import oracle.dbtools.migration.gui.ParserSetting;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.translation.SchemaDetails;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.navigator.SchemaDetailsRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.ide.controls.Toolbar;

public class SourceWorksheet
extends AScratchWorksheet {
    protected ArrayList<ActionProvider> m_translateActionProviders = null;
    private JComboBox m_translatorSelectBox = null;
    private static JComboBox m_captureModelSelectBox = null;
    private final String[] m_labels = new String[]{SEMessages.getString("TSQL_TO_PLSQL"), SEMessages.getString("ACCESS_TO_PLSQL"), SEMessages.getString("SYBASE_TO_PLSQL"), SEMessages.getString("DB2_TO_PLSQL"), SEMessages.getString("TD_TO_PLSQL")};
    private final Icon[] m_icons = new Icon[]{SEMessages.getIcon("TSQL_ICON"), SEMessages.getIcon("ACCESS_ICON"), SEMessages.getIcon("SYBASE_ICON"), SEMessages.getIcon("DB2_ICON"), SEMessages.getIcon("TD_ICON")};
    private final String[] m_databases = new String[]{"SQLSERVER", "ACCESS", "SYBASE", "DB2", "TERADATA"};
    private HashMap<String, String> m_db_to_lbl = new HashMap();

    public SourceWorksheet(ArrayList<ActionProvider> arrayList) {
        MigrationAddin.addMigrationRepositoryStateListener((MigrationRepositoryStateListener)new MigrationRepositoryStateListener(){

            public void repositoryOpened(String string) {
                this.updateCaptureModelSelectBox();
            }

            public void repositoryClosed() {
                this.updateCaptureModelSelectBox();
            }

            private void updateCaptureModelSelectBox() {
                Vector<SchemaDetails> vector = new Vector<SchemaDetails>();
                vector.add(new SchemaDetails());
                if (MigrationAddin.isRepositoryOpen()) {
                    vector.addAll(SourceWorksheet.this.getSchemas());
                }
                Integer[] integerArray = new Integer[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    integerArray[i] = new Integer(i);
                }
                m_captureModelSelectBox.setRenderer(new SchemaDetailsRenderer(vector));
                m_captureModelSelectBox.setModel(new DefaultComboBoxModel<Integer>(integerArray));
            }
        });
        this.m_translateActionProviders = arrayList;
        this.extraInitActions();
        this.initContext();
        this.extraInitGUI();
        Toolbar toolbar = this.getToolbar();
        Container container = (Container)this.getGUI();
        container.add((Component)toolbar, "North");
        this.initializeDBToLabel();
    }

    public void extraInitGUI() {
        this.getToolbar().add((Component)this.getTranslatorSelector(), 2);
        this.getToolbar().add((Component)this.getCaptureModelSelector(), 3);
    }

    private JComboBox getCaptureModelSelector() {
        Vector<SchemaDetails> vector = new Vector<SchemaDetails>();
        vector.add(new SchemaDetails());
        if (MigrationAddin.isRepositoryOpen()) {
            vector.addAll(this.getSchemas());
        }
        Integer[] integerArray = new Integer[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            integerArray[i] = new Integer(i);
        }
        m_captureModelSelectBox = new JComboBox<Integer>(integerArray);
        m_captureModelSelectBox.setRenderer(new SchemaDetailsRenderer(vector));
        m_captureModelSelectBox.setSize(new Dimension(40, 20));
        m_captureModelSelectBox.setPreferredSize(m_captureModelSelectBox.getSize());
        m_captureModelSelectBox.setMaximumSize(m_captureModelSelectBox.getPreferredSize());
        m_captureModelSelectBox.setToolTipText("Captured Schema");
        m_captureModelSelectBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Integer n = (Integer)m_captureModelSelectBox.getSelectedItem();
                SchemaDetails schemaDetails = ((SchemaDetailsRenderer)m_captureModelSelectBox.getRenderer()).getSchemaDetails(n.intValue());
                ParserSetting.setSchemaDetails(schemaDetails);
            }
        });
        return m_captureModelSelectBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<SchemaDetails> getSchemas() {
        Vector<SchemaDetails> vector = new Vector<SchemaDetails>();
        String string = "select capprojectname||':'||capconnname||':'||capqualifiedname label, capschemaid,capcatalogid,capconnid,  conschemaid,concatalogid,conconnid,capprojectid from mgv_derived_details where capobjtype='MD_SCHEMAS' AND conschemaid IS NOT NULL ORDER BY label";
        DBUtil dBUtil = DBUtil.getInstance((String)MigrationAddin.getRepositoryConnectionName());
        Connections.getInstance().lock(MigrationAddin.getRepositoryConnectionName());
        ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(string, null);
        if (resultSetWrapper != null) {
            ResultSet resultSet = resultSetWrapper.getResultSet();
            String string2 = null;
            Object var21_7 = null;
            try {
                while (resultSet.next()) {
                    string2 = resultSet.getString("label");
                    long l = resultSet.getLong("capschemaid");
                    long l2 = resultSet.getLong("capcatalogid");
                    long l3 = resultSet.getLong("capconnid");
                    long l4 = resultSet.getLong("conschemaid");
                    long l5 = resultSet.getLong("concatalogid");
                    long l6 = resultSet.getLong("conconnid");
                    long l7 = resultSet.getLong("capprojectid");
                    l = resultSet.getLong("capschemaid");
                    l = resultSet.getLong("capschemaid");
                    vector.add(new SchemaDetails(string2, l7, l3, l2, l, l6, l5, l4));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                resultSetWrapper.close();
                Connections.getInstance().unlock(MigrationAddin.getRepositoryConnectionName());
            }
        }
        return vector;
    }

    public void extraInitActions() {
        this.removeUnwantedActions();
        this.addExtraActions();
    }

    private void removeUnwantedActions() {
        this.m_toolbarActions.clear();
    }

    protected void addExtraActions() {
        this.addActionProvider(this.m_translateActionProviders);
    }

    private void initializeDBToLabel() {
        this.m_db_to_lbl.clear();
        for (int i = 0; i < this.m_databases.length && this.m_databases.length == this.m_labels.length; ++i) {
            this.m_db_to_lbl.put(this.m_databases[i], this.m_labels[i]);
        }
    }

    private JComboBox getTranslatorSelector() {
        if (this.m_translatorSelectBox == null) {
            Integer[] integerArray = new Integer[this.m_labels.length];
            for (int i = 0; i < this.m_labels.length; ++i) {
                integerArray[i] = new Integer(i);
            }
            JComboBox<Integer> jComboBox = new JComboBox<Integer>(integerArray);
            jComboBox.setSize(new Dimension(40, 20));
            jComboBox.setPreferredSize(jComboBox.getSize());
            jComboBox.setMaximumSize(jComboBox.getPreferredSize());
            LanguageComboBoxRenderer languageComboBoxRenderer = new LanguageComboBoxRenderer(this.m_icons, this.m_labels);
            jComboBox.setRenderer(languageComboBoxRenderer);
            this.m_translatorSelectBox = jComboBox;
            this.m_translatorSelectBox.setToolTipText(SEMessages.getString("TRANSLATOR"));
            this.m_translatorSelectBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SourceWorksheet.this.m_translatorSelectBox.getSelectedIndex() == 0) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.tsql.TSQLParserMain");
                    } else if (SourceWorksheet.this.m_translatorSelectBox.getSelectedIndex() == 1) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.msaccess.MSAccessParserMain");
                    } else if (SourceWorksheet.this.m_translatorSelectBox.getSelectedIndex() == 2) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.sybase.SybaseParserMain");
                    } else if (SourceWorksheet.this.m_translatorSelectBox.getSelectedIndex() == 3) {
                        ParserSetting.setParserString("oracle.dbtools.migration.parser.db2.Db2ParserMain");
                    } else if (SourceWorksheet.this.m_translatorSelectBox.getSelectedIndex() == 4) {
                        ParserSetting.setParserString("oracle.dbtools.migration.teradata.parser.TeradataParserMain");
                    } else if (SourceWorksheet.this.m_translatorSelectBox.getSelectedIndex() == 5) {
                        ParserSetting.setParserString("oracle.dbtools.migration.mysql.parser.MySQLParserMain");
                    } else {
                        ParserSetting.setParserString(null);
                    }
                }
            });
        }
        return this.m_translatorSelectBox;
    }

    public WorksheetContext createWorksheetContext() {
        return super.createWorksheetContext();
    }

    public void setTranslator(String string) {
        String string2 = this.m_db_to_lbl.get(string.toUpperCase());
        int n = -1;
        for (int i = 0; i < this.m_labels.length; ++i) {
            if (!this.m_labels[i].equals(string2)) continue;
            n = i;
            break;
        }
        this.getTranslatorSelector().setSelectedIndex(n);
    }

    public void setComboCapturedProject(long l, long l2) {
        Vector<SchemaDetails> vector = this.getSchemas();
        for (int i = 0; i < vector.size(); ++i) {
            SchemaDetails schemaDetails = vector.get(i);
            if (schemaDetails.getProjectId() != l || schemaDetails.getCapSchemaId() != l2) continue;
            m_captureModelSelectBox.setSelectedIndex(i + 1);
        }
    }
}

