/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import oracle.dbtools.migration.gui.babelfish.InstallSQLTranslatorMenu;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.newscriptrunner.commands.PromptClosure;
import oracle.javatools.util.ClosureException;

public abstract class ABabelfishTask
extends RaptorTask<Void> {
    public static final String SYBASETRANSLATOR = "Sybase SQL Translator";
    public static final String SQLSERVERTRANSLATOR = "SQL Server SQL Translator";
    public static final String DB2FINGERPRINTER = "DB2 SQL Fingerprinter";
    public static final String SYBASEPACKAGEFILENAME = "offline/package_sybase.sql";
    public static final String SQLSERVERPACKAGEFILENAME = "offline/package_sqlserver.sql";
    public static final String DB2PACKAGEFILENAME = "offline/package_db2.sql";
    public static final String SYBASEPACKAGENAME = "sybase_tsql_translator";
    public static final String SQLSERVERPACKAGENAME = "sqlserver_tsql_translator";
    public static final String DB2PACKAGENAME = "db2_sql_fingerprinter";
    public static final String SYBASEZIP = "sybase_translator.zip";
    public static final String SQLSERVERZIP = "sqlserver_translator.zip";
    public static final String DB2ZIP = "db2_fingerpinter.zip";
    public static final String[] SYBASEFILES = new String[]{"create_profile.sh", "create_profile.sql", "load_abstract.sh", "load_sybase.sh", "loadjava_sybase.sh", "package_sybase.sql", "permission_profile_run.sql", "permission_profile_create.sql", "permission_translator_create.sql", "permission_translator_run.sql", "run.sql"};
    public static final String[] SQLSERVERFILES = new String[]{"create_profile.sh", "create_profile.sql", "load_abstract.sh", "load_sqlserver.sh", "loadjava_sqlserver.sh", "package_sqlserver.sql", "permission_profile_run.sql", "permission_profile_create.sql", "permission_translator_create.sql", "permission_translator_run.sql", "run.sql"};
    public static final String[] DB2FILES = new String[]{"create_profile.sh", "create_profile.sql", "load_abstract.sh", "load_db2.sh", "loadjava_db2.sh", "package_db2.sql", "permission_profile_run.sql", "permission_profile_create.sql", "permission_translator_create.sql", "permission_translator_run.sql", "run.sql"};

    public ABabelfishTask(String string) {
        super(string);
    }

    public ABabelfishTask(String string, boolean bl) {
        super(string, bl);
    }

    public ABabelfishTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(string, bl, iRaptorTaskRunMode);
    }

    public static String[] getJarFiles(String string) {
        String string2 = ABabelfishTask.getInstallHome();
        String[] stringArray = null;
        if (string.equalsIgnoreCase(SYBASETRANSLATOR)) {
            String[] stringArray2 = new String[]{string2 + "lib/antlr-all-2.7.6.jar", string2 + "lib/antlr-runtime-3.1.3.jar", string2 + "lib/stringtemplate-3.1b1.jar", string2 + "lib/PropertyStorage.jar", string2 + "extensions/oracle.sqldeveloper.migration.translation.core.jar", string2 + "extensions/oracle.sqldeveloper.migration.jar", string2 + "extensions/oracle.sqldeveloper.migration.sqlserver.jar", string2 + "extensions/oracle.sqldeveloper.migration.sybase.jar"};
            stringArray = stringArray2;
        } else if (string.equalsIgnoreCase(SQLSERVERTRANSLATOR)) {
            String[] stringArray3 = new String[]{string2 + "lib/antlr-all-2.7.6.jar", string2 + "lib/antlr-runtime-3.1.3.jar", string2 + "lib/stringtemplate-3.1b1.jar", string2 + "lib/PropertyStorage.jar", string2 + "extensions/oracle.sqldeveloper.migration.translation.core.jar", string2 + "extensions/oracle.sqldeveloper.migration.jar", string2 + "extensions/oracle.sqldeveloper.migration.sqlserver.jar"};
            stringArray = stringArray3;
        } else if (string.equalsIgnoreCase(DB2FINGERPRINTER)) {
            String[] stringArray4 = new String[]{string2 + "lib/antlr-all-2.7.6.jar", string2 + "lib/antlr-runtime-3.1.3.jar", string2 + "lib/stringtemplate-3.1b1.jar", string2 + "lib/PropertyStorage.jar", string2 + "extensions/oracle.sqldeveloper.migration.translation.core.jar", string2 + "extensions/oracle.sqldeveloper.migration.jar", string2 + "extensions/oracle.sqldeveloper.migration.translation.db2.jar"};
            stringArray = stringArray4;
        }
        stringArray = ABabelfishTask.replaceSeperator(stringArray);
        return stringArray;
    }

    private static String[] replaceSeperator(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replace("/", File.separator);
            stringArray[i] = stringArray[i].replace("\\", File.separator);
        }
        return stringArray;
    }

    protected static String genMissingHome() {
        return ABabelfishTask.getInstallHome() + "genmissing" + File.separator;
    }

    protected static String getInstallHome() {
        String string = InstallSQLTranslatorMenu.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String string2 = null;
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
            File file = new File(string2);
            File file2 = file.getParentFile().getParentFile();
            String string3 = file2.getAbsolutePath() + File.separator;
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    protected static String createMissingFileName(String string) {
        return "gm_" + string;
    }

    public static String getPackageName(String string) {
        if (string.equalsIgnoreCase(SQLSERVERTRANSLATOR)) {
            return SQLSERVERPACKAGENAME;
        }
        if (string.equalsIgnoreCase(SYBASETRANSLATOR)) {
            return SYBASEPACKAGENAME;
        }
        if (string.equalsIgnoreCase(DB2FINGERPRINTER)) {
            return DB2PACKAGENAME;
        }
        return null;
    }

    public static String getPackageFileName(String string) {
        if (string.equalsIgnoreCase(SQLSERVERTRANSLATOR)) {
            return SQLSERVERPACKAGEFILENAME;
        }
        if (string.equalsIgnoreCase(SYBASETRANSLATOR)) {
            return SYBASEPACKAGEFILENAME;
        }
        if (string.equalsIgnoreCase(DB2FINGERPRINTER)) {
            return DB2PACKAGEFILENAME;
        }
        return null;
    }

    protected String getFileName(String string) {
        int n;
        int n2;
        int n3 = string.lastIndexOf("/");
        int n4 = n2 = n3 > (n = string.lastIndexOf("\\")) ? n3 : n;
        if (n2 > -1) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    protected String getPassword(String string, boolean bl) {
        PromptClosure promptClosure = new PromptClosure(string, bl);
        try {
            promptClosure.run();
        }
        catch (ClosureException closureException) {
            // empty catch block
        }
        return promptClosure.m_result;
    }
}

