/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class PackageEntry {
    URL _packageURL;
    long _lastModified;
    String _packageName;
    private byte[] _data;
    private int _subPackageNamesOffset;
    private int _classCnt;
    private int _subPackageNameCnt;

    PackageEntry(URL packageURL, List<String> classNames, List<String> subPackageNames, long lastModified) {
        this._packageName = null;
        this._packageURL = packageURL;
        this._lastModified = lastModified;
        this.initData(classNames, subPackageNames);
    }

    PackageEntry(String packageName, Collection<String> classNames, Collection<String> subPackageNames) {
        this._packageName = packageName;
        this._packageURL = null;
        this._lastModified = -1L;
        this.initData(classNames, subPackageNames);
    }

    private void initData(Collection<String> classNames, Collection<String> subPackageNames) {
        byte[] src;
        this._classCnt = classNames == null ? 0 : classNames.size();
        this._subPackageNameCnt = subPackageNames == null ? 0 : subPackageNames.size();
        int len = 0;
        if (classNames != null) {
            for (String s : classNames) {
                len += s.getBytes().length + 1;
            }
        }
        if (subPackageNames != null) {
            for (String s : subPackageNames) {
                len += s.getBytes().length + 1;
            }
        }
        this._data = new byte[len];
        len = 0;
        if (classNames != null) {
            for (String s : classNames) {
                src = s.getBytes();
                System.arraycopy(src, 0, this._data, len, src.length);
                len += src.length;
                this._data[len++] = 0;
            }
        }
        this._subPackageNamesOffset = len;
        if (subPackageNames != null) {
            for (String s : subPackageNames) {
                src = s.getBytes();
                System.arraycopy(src, 0, this._data, len, src.length);
                len += src.length;
                this._data[len++] = 0;
            }
        }
    }

    String[] getClasses() {
        String[] classes = new String[this._classCnt];
        int idx = 0;
        int i = 0;
        while (i < this._classCnt) {
            int start = idx;
            while (this._data[idx] != 0) {
                ++idx;
            }
            classes[i] = new String(this._data, start, idx - start);
            ++i;
            ++idx;
        }
        return classes;
    }

    List<String> getClassesAsList() {
        ArrayList<String> classes = new ArrayList<String>();
        int idx = 0;
        int i = 0;
        while (i < this._classCnt) {
            int start = idx;
            while (this._data[idx] != 0) {
                ++idx;
            }
            classes.add(new String(this._data, start, idx - start));
            ++i;
            ++idx;
        }
        return classes;
    }

    String[] getSubpackageNames() {
        String[] classes = new String[this._subPackageNameCnt];
        int idx = this._subPackageNamesOffset;
        int i = 0;
        while (i < this._subPackageNameCnt) {
            int start = idx;
            while (this._data[idx] != 0) {
                ++idx;
            }
            classes[i] = new String(this._data, start, idx - start);
            ++i;
            ++idx;
        }
        return classes;
    }

    List<String> getSubpackageNamesAsList() {
        ArrayList<String> classes = new ArrayList<String>(this._subPackageNameCnt);
        int idx = this._subPackageNamesOffset;
        int i = 0;
        while (i < this._subPackageNameCnt) {
            int start = idx;
            while (this._data[idx] != 0) {
                ++idx;
            }
            classes.add(new String(this._data, start, idx - start));
            ++i;
            ++idx;
        }
        return classes;
    }
}

