/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.internal.symbol.JavaFileSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.write.SourceFileListener;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.util.Log;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.provider.BaseFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.java.util.JRLClassLoader;

public abstract class CachedFileProvider
extends BaseFileProvider
implements CacheSupport {
    private static final Log logger = new Log("CachedFileProvider");
    protected final Object _cacheLock = new Object[]{"CACHE_LOCK", this};
    protected ClassLoader _nullClassLoader = null;
    protected ClassLoader _defaultClassLoader = null;
    protected long _lastCacheFlushedTime = System.nanoTime();
    protected Map<String, JavaPackage> _packageCacheMap;
    protected Map<URL, SourceFile> _sourceFileCacheMap;
    protected Map<String, JavaType> _arrayCacheMap;
    protected Map<String, JavaClass> _classCacheMap;
    protected Map<URL, JavaFile> _classFileCacheMap;
    protected Map<URL, JavaFile> _lightSourceFileCacheMap;
    protected static final JavaClass CLASS_NOT_FOUND = new NullJavaClass();
    private final String scopeDescription;
    protected int _cacheRefCount = 0;

    public CachedFileProvider(ProviderContext environment, String scopeDescription) {
        super(environment);
        this.scopeDescription = scopeDescription;
        String prefix = this.getClass().getSimpleName() + ",scope=" + ObjectName.quote(scopeDescription) + ",items=";
        this._packageCacheMap = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, prefix + "packages");
        this._sourceFileCacheMap = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, prefix + "sourceFiles");
        this._arrayCacheMap = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, prefix + "arrayTypes");
        this._classCacheMap = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, prefix + "types");
        this._classFileCacheMap = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, prefix + "classFiles");
        this._lightSourceFileCacheMap = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, prefix + "lightSourceFiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ClassLoader parentLoader) {
        if (parentLoader != null) {
            JavaResourceLocator locator = (JavaResourceLocator)((Object)this.getClassLocator());
            return new JRLClassLoader(parentLoader, locator);
        }
        if (this._nullClassLoader != null) {
            return this._nullClassLoader;
        }
        JavaResourceLocator locator = (JavaResourceLocator)((Object)this.getClassLocator());
        CachedFileProvider cachedFileProvider = this;
        synchronized (cachedFileProvider) {
            if (this._nullClassLoader == null) {
                this._nullClassLoader = new JRLClassLoader(null, locator);
            }
            return this._nullClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        if (this._defaultClassLoader != null) {
            return this._defaultClassLoader;
        }
        JavaResourceLocator locator = (JavaResourceLocator)((Object)this.getClassLocator());
        CachedFileProvider cachedFileProvider = this;
        synchronized (cachedFileProvider) {
            if (this._defaultClassLoader == null) {
                this._defaultClassLoader = new JRLClassLoader(locator);
            }
            return this._defaultClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClassLoader() {
        CachedFileProvider cachedFileProvider = this;
        synchronized (cachedFileProvider) {
            this._defaultClassLoader = null;
            this._nullClassLoader = null;
        }
    }

    @Override
    public SourceFile createSourceFile(URL url) throws IOException, IllegalArgumentException {
        SourceFile possiblyThrowAwayFile = super.createSourceFile(url);
        if (possiblyThrowAwayFile == null) {
            return null;
        }
        return this.getSourceFile(url);
    }

    @Override
    protected SourceFile getSourceFileImpl(URL sourceURL) {
        if (sourceURL == null) {
            throw new IllegalArgumentException("sourceURL == null");
        }
        SourceFile sourceFile = this.getCachedSourceFile(sourceURL);
        if (sourceFile != null) {
            return sourceFile;
        }
        logger.trace("Getting heavy sourcefile of " + sourceURL.getPath());
        sourceURL = URLFactory.intern((URL)sourceURL);
        sourceFile = super.getSourceFileImpl(sourceURL);
        if (sourceFile != null) {
            this.storeCachedSourceFile(sourceURL, sourceFile);
            SourceFileTracker tracker = new SourceFileTracker(sourceFile, sourceURL);
            sourceFile.addSourceFileListener((SourceFileListener)tracker);
            this.context.startTracking(sourceURL);
        }
        return sourceFile;
    }

    private SourceFile getCachedSourceFile(URL sourceURL) {
        SourceFile sourceFile = this.lookupCachedSourceFile(sourceURL);
        if (sourceFile != null && !sourceFile.isExpired()) {
            if (sourceFile.getTransaction() != null) {
                return sourceFile;
            }
            TextBuffer checkBuffer = this.getTextBuffer(sourceURL);
            TextBuffer currentBuffer = null;
            try {
                currentBuffer = sourceFile.getTextBuffer();
            }
            catch (ExpiredTextBufferException e) {
                // empty catch block
            }
            if (currentBuffer != checkBuffer) {
                this.removeCachedSourceFile(sourceURL, sourceFile);
                sourceFile.expire();
                this.removeCachedLightSourceFile(sourceURL, null);
            } else {
                return sourceFile;
            }
        }
        return null;
    }

    @Override
    protected JavaFile getLightSourceFileImpl(URL sourceURL) {
        if (sourceURL == null) {
            throw new IllegalArgumentException("sourceURL == null");
        }
        SourceFile cachedSourceFile = this.getCachedSourceFile(sourceURL);
        if (cachedSourceFile != null) {
            return cachedSourceFile;
        }
        JavaFile lightSourceFile = this.lookupCachedLightSourceFile(sourceURL);
        if (lightSourceFile != null) {
            return lightSourceFile;
        }
        logger.trace("Getting light sourcefile of " + sourceURL.getPath());
        sourceURL = URLFactory.intern((URL)sourceURL);
        lightSourceFile = super.getLightSourceFileImpl(sourceURL);
        if (lightSourceFile != null) {
            this.storeCachedLightSourceFile(sourceURL, lightSourceFile);
            this.context.startTracking(sourceURL);
        }
        return lightSourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginCacheUse() {
        Object object = this._cacheLock;
        synchronized (object) {
            ++this._cacheRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endCacheUse() {
        Object object = this._cacheLock;
        synchronized (object) {
            --this._cacheRefCount;
            if (this._cacheRefCount < 0) {
                Assert.println((String)"Warning: cache ref count negative");
                Assert.printStackTrace();
                this._cacheRefCount = 0;
            }
            if (this._cacheRefCount == 0) {
                // empty if block
            }
        }
    }

    public long lastCacheFlushed() {
        return this._lastCacheFlushedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this.clearClassFileCache();
            this.clearSourceFileCache();
            this.clearClassCache();
            this.clearArrayCache();
            this.clearPackageCache();
            this.clearLightSourceFileCache();
            this._lastCacheFlushedTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushFoundCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this.clearClassCache();
            this.clearArrayCache();
            this.clearPackageCache();
        }
    }

    protected void clearAllData() {
        this.context.clearTracking();
        this.expireAllSourceFiles();
        this.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaFile getClassFileImpl(URL classURL) {
        JavaFile javaFile;
        Object object = this._cacheLock;
        synchronized (object) {
            javaFile = this._classFileCacheMap.get(classURL);
        }
        if (javaFile != null) {
            return javaFile;
        }
        javaFile = super.getClassFileImpl(classURL = URLFactory.intern((URL)classURL));
        if (javaFile != null) {
            object = this._cacheLock;
            synchronized (object) {
                this._classFileCacheMap.put(classURL, javaFile);
            }
        }
        return javaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClassFileCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._classFileCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceFile lookupCachedSourceFile(URL sourceURL) {
        Object object = this._cacheLock;
        synchronized (object) {
            return this._sourceFileCacheMap.get(sourceURL);
        }
    }

    @Deprecated
    protected void removeCachedSourceFile(URL sourceURL) {
        this.removeCachedSourceFile(sourceURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCachedSourceFile(URL sourceURL, SourceFile sourceFile) {
        Object object = this._cacheLock;
        synchronized (object) {
            if (sourceFile == null || sourceFile == this._sourceFileCacheMap.get(sourceURL)) {
                this._sourceFileCacheMap.remove(sourceURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeCachedSourceFile(URL sourceURL, SourceFile sourceFile) {
        if (sourceFile != null) {
            Object object = this._cacheLock;
            synchronized (object) {
                this._sourceFileCacheMap.put(sourceURL, sourceFile);
                logger.trace("Storing heavy sourcefile of " + sourceURL.getPath() + " cachesize = " + this._sourceFileCacheMap.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireAllSourceFiles() {
        ArrayList<URL> urlList;
        Object object = this._cacheLock;
        synchronized (object) {
            urlList = new ArrayList<URL>(this._sourceFileCacheMap.keySet());
        }
        for (URL url : urlList) {
            SourceFile sourceFile = this.lookupCachedSourceFile(url);
            if (sourceFile == null) continue;
            sourceFile.expire();
        }
    }

    protected void clearSourceFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCompiledInfo() {
        ArrayList<JavaFileSym> lightSourceFiles;
        ArrayList<SourceFile> sourceFiles;
        Object object = this._cacheLock;
        synchronized (object) {
            sourceFiles = new ArrayList<SourceFile>(this._sourceFileCacheMap.size());
            lightSourceFiles = new ArrayList<JavaFileSym>(this._lightSourceFileCacheMap.size());
            for (SourceFile sourceFile : this._sourceFileCacheMap.values()) {
                if (sourceFile == null) continue;
                sourceFiles.add(sourceFile);
            }
            for (JavaFile lightSourceFile : this._lightSourceFileCacheMap.values()) {
                if (!(lightSourceFile instanceof JavaFileSym)) continue;
                lightSourceFiles.add((JavaFileSym)lightSourceFile);
            }
        }
        for (SourceFile sourceFile : sourceFiles) {
            sourceFile.clearCompiledInfo();
        }
        for (JavaFileSym javaFileSym : lightSourceFiles) {
            javaFileSym.clearCompiledInfo();
        }
    }

    @Override
    public void notifyOfChange(URL url) {
        SourceFile sourceFile = this.lookupCachedSourceFile(url);
        if (sourceFile != null) {
            sourceFile.expire();
            sourceFile.unpinTextBuffer();
            this.removeCachedSourceFile(url, sourceFile);
        }
        this.removeCachedLightSourceFile(url, null);
    }

    private void clearClasses(SourceFile file) {
        List classes = file.getSourceClasses();
        for (SourceClass oneClass : classes) {
            this.clearOneClass((JavaClass)oneClass);
        }
    }

    private void clearOneClass(JavaClass javaClass) {
        String className = javaClass.getQualifiedName();
        this._classCacheMap.remove(className);
        className = javaClass.getRawName();
        this._classCacheMap.remove(className);
        Collection innerClasses = javaClass.getDeclaredClasses();
        for (JavaClass innerClass : innerClasses) {
            this.clearOneClass(innerClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaFile lookupCachedLightSourceFile(URL sourceURL) {
        Object object = this._cacheLock;
        synchronized (object) {
            return this._lightSourceFileCacheMap.get(sourceURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaFile removeCachedLightSourceFile(URL sourceURL, JavaFile javaFile) {
        Object object = this._cacheLock;
        synchronized (object) {
            JavaFile removedValue = null;
            if (javaFile == null || javaFile == this._lightSourceFileCacheMap.get(sourceURL)) {
                removedValue = this._lightSourceFileCacheMap.remove(sourceURL);
            }
            return removedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeCachedLightSourceFile(URL sourceURL, JavaFile sourceFile) {
        if (sourceFile != null) {
            Object object = this._cacheLock;
            synchronized (object) {
                this._lightSourceFileCacheMap.put(sourceURL, sourceFile);
                logger.trace("Storing light sourcefile of " + sourceURL.getPath() + " cachesize = " + this._lightSourceFileCacheMap.size());
            }
        }
    }

    protected void clearLightSourceFileCache() {
    }

    @Override
    protected JavaClass getClassExactImpl(String fqOuterClassName) {
        try {
            return this.getClassExactImplImpl(fqOuterClassName, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected JavaClass getClassExactImplInterruptibly(String fqOuterClassName) throws InterruptedException {
        return this.getClassExactImplImpl(fqOuterClassName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaClass getClassExactImplImpl(String fqOuterClassName, boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.checkInterrupt();
        }
        Object object = this._cacheLock;
        synchronized (object) {
            JavaClass type = this._classCacheMap.get(fqOuterClassName);
            if (type != null) {
                if (type == CLASS_NOT_FOUND) {
                    return null;
                }
                return type;
            }
        }
        JavaClass type = interruptibly ? super.getClassExactImplInterruptibly(fqOuterClassName) : super.getClassExactImpl(fqOuterClassName);
        Object object2 = this._cacheLock;
        synchronized (object2) {
            this._classCacheMap.put(fqOuterClassName, type == null ? CLASS_NOT_FOUND : type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClassCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._classCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaType getArrayTypeImpl(String typeKey, JavaType component, int dimensions) {
        JavaType arrayType;
        Object object = this._cacheLock;
        synchronized (object) {
            arrayType = this._arrayCacheMap.get(typeKey);
            if (arrayType != null) {
                return arrayType;
            }
        }
        arrayType = super.getArrayTypeImpl(typeKey, component, dimensions);
        if (arrayType != null) {
            object = this._cacheLock;
            synchronized (object) {
                this._arrayCacheMap.put(typeKey, arrayType);
            }
        }
        return arrayType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearArrayCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._arrayCacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BaseFileProvider.BasePackage getPackageImpl(String fqName) {
        BaseFileProvider.BasePackage foundPackage;
        Object object = this._cacheLock;
        synchronized (object) {
            foundPackage = (BaseFileProvider.BasePackage)this._packageCacheMap.get(fqName);
        }
        if (foundPackage != null) {
            return foundPackage;
        }
        foundPackage = super.getPackageImpl(fqName);
        if (foundPackage != null) {
            object = this._cacheLock;
            synchronized (object) {
                this._packageCacheMap.put(fqName, (JavaPackage)foundPackage);
            }
        }
        return foundPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPackageCache() {
        Object object = this._cacheLock;
        synchronized (object) {
            this._packageCacheMap.clear();
        }
    }

    public String getScopeDescription() {
        return this.scopeDescription;
    }

    private static class NullJavaClass
    implements JavaClass {
        private NullJavaClass() {
        }

        public void clearCompiledInfo() {
        }

        public JavaClass getClosestClass() {
            return null;
        }

        public JavaClass getTypeErasure() {
            return null;
        }

        public CompiledTmpVariable getThisValue() {
            return null;
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public JavaType getComponentType() {
            return null;
        }

        public int getArrayDimensions() {
            return 0;
        }

        public JavaType getBaseComponentType() {
            return null;
        }

        public boolean isInterface() {
            return false;
        }

        public boolean isEnum() {
            return false;
        }

        public boolean isAnnotation() {
            return false;
        }

        public boolean isExported() {
            return false;
        }

        public boolean isMemberClass() {
            return false;
        }

        public boolean isAnonymousClass() {
            return false;
        }

        public boolean isLocalClass() {
            return false;
        }

        public String getName() {
            return null;
        }

        public String getUnqualifiedName() {
            return null;
        }

        public String getQualifiedName() {
            return null;
        }

        public String getRawName() {
            return null;
        }

        public String getVMName() {
            return null;
        }

        public String getDescriptor() {
            return null;
        }

        public String getTypeSignature() {
            return null;
        }

        public String getSignature() {
            return null;
        }

        public String getUniqueIdentifier() {
            return null;
        }

        public JavaPackage getPackage() {
            return null;
        }

        public String getPackageName() {
            return null;
        }

        public JavaType getSuperclass() {
            return null;
        }

        public UnresolvedType getUnresolvedSuperclass() {
            return null;
        }

        public Collection getInterfaces() {
            return Collections.emptyList();
        }

        public Set getHierarchy() {
            return Collections.emptySet();
        }

        public boolean isAssignableFrom(JavaType subject) {
            return false;
        }

        public boolean isSubtypeOf(JavaType supertype) {
            return false;
        }

        public Collection getDeclaredFields() {
            return Collections.emptyList();
        }

        public JavaField getDeclaredField(String name) {
            return null;
        }

        public Collection getDeclaredConstructors() {
            return Collections.emptyList();
        }

        public JavaMethod getDeclaredConstructor(JavaType[] parameters) {
            return null;
        }

        public Collection getDeclaredMethods() {
            return Collections.emptyList();
        }

        public Collection getDeclaredMethods(String name) {
            return Collections.emptyList();
        }

        public JavaMethod getDeclaredMethod(String name, JavaType[] parameters) {
            return null;
        }

        public Collection getDeclaredClasses() {
            return Collections.emptyList();
        }

        public JavaClass getDeclaredClass(String name) {
            return null;
        }

        public Collection getDeclaredAnonymousClasses() {
            return Collections.emptyList();
        }

        public Collection getDeclaredLocalClasses() {
            return Collections.emptyList();
        }

        public JavaMethod getClinitMethod() {
            return null;
        }

        public Collection getFields() {
            return Collections.emptyList();
        }

        public JavaField getField(String name) {
            return null;
        }

        public Collection getMethods() {
            return Collections.emptyList();
        }

        public Collection getMethods(String name) {
            return Collections.emptyList();
        }

        public JavaMethod getMethod(String name, JavaType[] parameters) {
            return null;
        }

        public Collection getClasses() {
            return Collections.emptyList();
        }

        public JavaClass getClass(String name) {
            return null;
        }

        public URL getURL() {
            return null;
        }

        public JavaClass getOwningClass() {
            return null;
        }

        public boolean isPublic() {
            return false;
        }

        public boolean isProtected() {
            return false;
        }

        public boolean isPrivate() {
            return false;
        }

        public boolean isStatic() {
            return false;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isPackagePrivate() {
            return false;
        }

        public int getElementKind() {
            return 0;
        }

        public JavaFile getFile() {
            return null;
        }

        public JavaElement getOwner() {
            return null;
        }

        public boolean isSourceElement() {
            return false;
        }

        public SourceElement getSourceElement() {
            return null;
        }

        public int getModifiers() {
            return 0;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isSynthetic() {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public boolean isDeprecated() {
            return false;
        }

        public String printCompiledInfo() {
            return null;
        }

        public JavaType getResolvedType() {
            return null;
        }

        public UnresolvedType getUnresolvedType() {
            return null;
        }

        public Collection getDeclaredAnnotations() {
            return Collections.emptyList();
        }

        public Collection getAnnotations() {
            return Collections.emptyList();
        }

        public JavaAnnotation getDeclaredAnnotation(JavaType annotationType) {
            return null;
        }

        public JavaAnnotation getAnnotation(JavaType annotationType) {
            return null;
        }

        public boolean hasTypeParameters() {
            return false;
        }

        public Collection getTypeParameters() {
            return Collections.emptyList();
        }

        public JavaTypeVariable getTypeParameter(String name) {
            return null;
        }

        public boolean hasActualTypeArguments() {
            return false;
        }

        public Collection getActualTypeArguments() {
            return Collections.emptyList();
        }

        public Collection<UnresolvedType> getUnresolvedInterfaces() {
            return Collections.emptyList();
        }

        public String toString() {
            return "<null>";
        }

        public List<JavaAnnotation> getTypeAnnotations() {
            return Collections.emptyList();
        }

        public boolean isErasedType() {
            return false;
        }
    }

    protected class SourceFileTracker
    implements SourceFileListener {
        private URL _sourceURL;

        protected SourceFileTracker(SourceFile sourceFile, URL sourceURL) {
            this._sourceURL = sourceURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expiredUpdate(SourceFile file) {
            Object object = CachedFileProvider.this._cacheLock;
            synchronized (object) {
                CachedFileProvider.this.removeCachedSourceFile(this._sourceURL, file);
                CachedFileProvider.this.removeCachedLightSourceFile(this._sourceURL, null);
                CachedFileProvider.this.clearClasses(file);
                CachedFileProvider.this.clearArrayCache();
            }
            CachedFileProvider.this.clearCompiledInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeUpdate(SourceFile file, SourceTransaction transaction) {
            for (SourceClass c : file.getSourceClasses()) {
                String qualifiedName = c.getQualifiedName();
                String rawName = c.getRawName();
                Object object = CachedFileProvider.this._cacheLock;
                synchronized (object) {
                    CachedFileProvider.this._classCacheMap.remove(qualifiedName);
                    CachedFileProvider.this._classCacheMap.remove(rawName);
                }
            }
            CachedFileProvider.this.context.writeSourceFile(file);
        }
    }
}

