/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class NamingUtil {
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    private static final Set<String> JAVA_RESERVED_WORDS = new HashSet<String>(Arrays.asList("true", "false", "null"));

    private NamingUtil() {
    }

    public static boolean isJavaKeyword(String name) {
        return JAVA_KEYWORDS.contains(name);
    }

    public static boolean isJavaReservedWord(String name) {
        return NamingUtil.isJavaKeyword(name) || JAVA_RESERVED_WORDS.contains(name);
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        if (NamingUtil.isJavaReservedWord(name)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPackageIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len <= 0) {
            return false;
        }
        int start = 0;
        while (start <= len) {
            int end = name.indexOf(46, start);
            if (end < 0) {
                end = len;
            }
            if (!NamingUtil.isJavaIdentifier(name.substring(start, end))) {
                return false;
            }
            start = end + 1;
        }
        return true;
    }
}

