/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.adfdtinternal.model.dvt.util.gui.BIFontPane;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;

public class FontButton
extends JButton
implements ActionListener,
PropertyChangeListener {
    private ResourceBundle rBundle = ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle");
    protected JButton m_fontButton;
    protected Font m_font = null;
    protected int m_horizontalAlignment;
    protected int m_verticalAlignment;
    protected BIFontPane m_fontPane = null;
    protected boolean m_underline = false;
    protected boolean m_strikethrough = false;
    protected Color m_foreground = Color.black;
    protected Color m_background = Color.white;
    protected String m_faceStr;
    protected int m_visibleStyle = 15;
    protected int m_visibleAlignment = 479;
    protected int m_visibleColor = 7;
    protected int m_textRotation = 0;
    protected int m_textRotationMask = 0;
    protected Locale m_locale = null;
    protected HelpProvider m_helpProvider;
    protected boolean m_customColorsEnabled = false;
    public static final String PROPERTY_CANCELLED = "fontDialogCancelled";
    private static ArrayTwoDModel m_colorPalette = null;
    private static Color[][] m_defaultColorArray = null;
    private static int m_currentColumn = 0;
    private Color[][] m_colors;
    private static ArrayTwoDModel m_cPalette = null;
    private boolean m_bColorPaletteSet = false;
    private String m_dialogTitle = "";
    private boolean panelShow = false;

    public FontButton(ImageIcon icon, String str) {
        super(str, icon);
        this.addActionListener(this);
    }

    public FontButton(String str) {
        this();
        this.m_faceStr = str;
        this.setText(str);
    }

    public FontButton() {
        this.addActionListener(this);
    }

    public void setColorPalette(Color[][] colors) {
        this.m_colors = colors;
        if (this.m_colors != null) {
            m_cPalette = FontButton.getArrayTwoDModel(colors);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            m_cPalette = null;
        }
        if (this.m_fontPane != null) {
            this.setColorPaletteOnChoices();
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.m_fontPane != null) {
            return FontButton.getColorArray(this.m_fontPane.getFontColorChoice().getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel model) {
        this.m_bColorPaletteSet = model != null;
        m_cPalette = model;
        if (this.m_fontPane != null) {
            this.setColorPaletteOnChoices();
        }
    }

    protected int convertBaliHAlignmentToSwing(int fPane) {
        int alignment = 0;
        switch (fPane) {
            case 2: {
                alignment = 2;
                break;
            }
            case 4: {
                alignment = 4;
                break;
            }
            case 10: {
                alignment = 10;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        return alignment;
    }

    protected int convertBaliVAlignmentToSwing(int fPane) {
        int alignment = 0;
        switch (fPane) {
            case 1: {
                alignment = 1;
                break;
            }
            case 3: {
                alignment = 3;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        return alignment;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void setText(String str) {
        String text = MessageFormat.format(this.rBundle.getString("ellipses"), str);
        super.setText(text);
    }

    public void setDialogTitle(String str) {
        this.m_dialogTitle = str;
    }

    public FontPane getFontPane() {
        return this.m_fontPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.panelShow) {
            return;
        }
        this.panelShow = true;
        if (this.m_fontPane == null) {
            this.m_fontPane = new BIFontPane();
            this.m_fontPane.setCustomColorsEnabled(this.m_customColorsEnabled);
            if (this.m_bColorPaletteSet) {
                this.setColorPaletteOnChoices();
            }
            ColorChoice choice = this.m_fontPane.getFontBackgroundColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)this.m_background)) {
                    choice.setColorPalette(FontButton.getNewColorPalette(choice.getColorPalette(), this.m_background, this.m_bColorPaletteSet));
                }
                choice.setSelectedColor(this.m_background);
            } else {
                choice.setSelectedColor(choice.getClosestColor(this.m_background));
            }
            if (!this.m_bColorPaletteSet) {
                choice = this.m_fontPane.getFontColorChoice();
                if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)this.m_foreground)) {
                    choice.setColorPalette(FontButton.getNewColorPalette(choice.getColorPalette(), this.m_foreground, this.m_bColorPaletteSet));
                }
                choice.setSelectedColor(this.m_foreground);
            } else {
                choice.setSelectedColor(choice.getClosestColor(this.m_foreground));
            }
        }
        HelpUtils.setHelpProvider((JComponent)((Object)this.m_fontPane), (HelpProvider)this.getHelpProvider());
        this.m_fontPane.setStyleButtonMask(this.m_visibleStyle);
        this.m_fontPane.setAlignmentButtonMask(this.m_visibleAlignment);
        this.m_fontPane.setColorComponentMask(this.m_visibleColor);
        this.m_fontPane.setRotationButtonMask(this.m_textRotationMask);
        if (this.m_locale != null) {
            this.m_fontPane.setLocale(this.m_locale);
        }
        this._initFontPane();
        this.m_fontPane.addPropertyChangeListener(this);
        int state = FontPane.showDialog((Component)this, (FontPane)this.m_fontPane, (String)this.m_dialogTitle, (boolean)false);
        if (state == 2) {
            this.firePropertyChange(PROPERTY_CANCELLED, false, true);
        } else {
            this.applyFontPane();
            this.firePropertyChange(PROPERTY_CANCELLED, true, false);
        }
        this.m_fontPane.removePropertyChangeListener(this);
        this.panelShow = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == "fontHorizontalAlignment") {
            int oldAlignment = (Integer)e.getOldValue();
            int newAlignment = (Integer)e.getNewValue();
            this.firePropertyChange(propertyName, this.convertBaliHAlignmentToSwing(oldAlignment), this.convertBaliHAlignmentToSwing(newAlignment));
        } else if (propertyName == "fontVerticalAlignment") {
            int oldAlignment = (Integer)e.getOldValue();
            int newAlignment = (Integer)e.getNewValue();
            this.firePropertyChange(propertyName, this.convertBaliVAlignmentToSwing(oldAlignment), this.convertBaliVAlignmentToSwing(newAlignment));
        } else {
            this.firePropertyChange(propertyName, e.getOldValue(), e.getNewValue());
        }
    }

    public void setRotationButtonMask(int buttonMask) {
        this.m_textRotationMask = buttonMask;
    }

    public void setStyleButtonMask(int style) {
        this.m_visibleStyle = style;
    }

    public void setAlignmentButtonMask(int alignment) {
        this.m_visibleAlignment = alignment;
    }

    public void setColorComponentMask(int buttons) {
        this.m_visibleColor = buttons;
    }

    public int getTextRotation() {
        return this.m_textRotation;
    }

    public void setTextRotation(int rotation) {
        this.m_textRotation = rotation;
    }

    public Color getComponentForeground() {
        return this.m_foreground;
    }

    public void setComponentForeground(Color c) {
        if (this.m_fontPane != null) {
            ColorChoice choice = this.m_fontPane.getFontColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)c)) {
                    choice.setColorPalette(FontButton.getNewColorPalette(choice.getColorPalette(), c, this.m_bColorPaletteSet));
                }
                choice.setSelectedColor(c);
            } else {
                this.m_foreground = choice.getClosestColor(c);
                choice.setSelectedColor(this.m_foreground);
            }
        }
        this.m_foreground = c;
    }

    public Color getComponentBackground() {
        return this.m_background;
    }

    public void setComponentBackground(Color c) {
        if (this.m_fontPane != null) {
            ColorChoice choice = this.m_fontPane.getFontBackgroundColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)c)) {
                    choice.setColorPalette(FontButton.getNewColorPalette(choice.getColorPalette(), c, this.m_bColorPaletteSet));
                }
                choice.setSelectedColor(c);
            } else {
                this.m_background = choice.getClosestColor(c);
                choice.setSelectedColor(this.m_background);
            }
        }
        this.m_background = c;
    }

    public Font getComponentFont() {
        return this.m_font;
    }

    public void setComponentFont(Font f) {
        this.m_font = f;
    }

    public boolean isUnderlineStyle() {
        return this.m_underline;
    }

    public void setUnderlineStyle(boolean yesNo) {
        this.m_underline = yesNo;
    }

    public boolean isStrikeThroughStyle() {
        return this.m_strikethrough;
    }

    public void setStrikeThroughStyle(boolean yesNo) {
        this.m_strikethrough = yesNo;
    }

    public int getPaneHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    public void setPaneHorizontalAlignment(int alignment) {
        this.m_horizontalAlignment = alignment;
    }

    public int getPaneVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public void setPaneVerticalAlignment(int alignment) {
        this.m_verticalAlignment = alignment;
    }

    public void applyFontPane() {
        if (!this.m_foreground.equals(this.m_fontPane.getFontColor())) {
            this.m_foreground = this.m_fontPane.getFontColor();
        }
        if (!this.m_background.equals(this.m_fontPane.getFontBackgroundColor())) {
            this.m_background = this.m_fontPane.getFontBackgroundColor();
        }
        if (!this.m_font.equals(this.m_fontPane.getCurrentFont())) {
            this.m_font = this.m_fontPane.getCurrentFont();
        }
        if (this.m_textRotation != this.m_fontPane.getTextRotation()) {
            this.m_textRotation = this.m_fontPane.getTextRotation();
        }
        this.m_horizontalAlignment = this.convertBaliHAlignmentToSwing(this.m_fontPane.getFontHorizontalAlignment());
        this.m_verticalAlignment = this.convertBaliVAlignmentToSwing(this.m_fontPane.getFontVerticalAlignment());
        this.m_underline = this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 4;
        this.m_strikethrough = this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 8;
        if (this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 12) {
            this.m_strikethrough = true;
            this.m_underline = true;
        }
    }

    public void setPaneLocale(Locale loc) {
        this.m_locale = loc;
        this.updateResourceBundle(loc);
        this.setText(this.m_faceStr);
    }

    public static TwoDModel getNewColorPalette(TwoDModel model, Color c, boolean createNew) {
        int j;
        int rowCount = model.getRowCount();
        int columnCount = model.getColumnCount();
        if (m_colorPalette == null || createNew) {
            ArrayTwoDModel colorPalette = new ArrayTwoDModel(columnCount, rowCount + 1);
            for (j = 0; j < rowCount; ++j) {
                for (int i = 0; i < columnCount; ++i) {
                    colorPalette.setData(i, j, model.getData(i, j));
                }
            }
            for (int k = 0; k < columnCount; ++k) {
                colorPalette.setData(k, rowCount, (Object)Color.white);
            }
            if (createNew) {
                colorPalette.setData(0, colorPalette.getRowCount() - 1, (Object)c);
                return colorPalette;
            }
            m_colorPalette = colorPalette;
        }
        for (j = 0; j < m_colorPalette.getColumnCount(); ++j) {
            if (!c.equals(m_colorPalette.getData(j, m_colorPalette.getRowCount() - 1))) continue;
            return m_colorPalette;
        }
        if (m_currentColumn == columnCount) {
            m_currentColumn = 0;
        }
        m_colorPalette.setData(m_currentColumn++, m_colorPalette.getRowCount() - 1, (Object)c);
        return m_colorPalette;
    }

    public static ArrayTwoDModel getArrayTwoDModel(Color[][] colors) {
        int rows = colors.length;
        int columns = colors[0].length;
        ArrayTwoDModel cp = new ArrayTwoDModel(columns, rows);
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columns; ++i) {
                cp.setData(i, j, (Object)colors[j][i]);
            }
        }
        return cp;
    }

    public static Color[][] getColorArray(TwoDModel model) {
        Color[][] colors = new Color[model.getRowCount()][model.getColumnCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                colors[i][j] = (Color)model.getData(j, i);
            }
        }
        return colors;
    }

    public static Color[][] getDefaultColorArray() {
        if (m_defaultColorArray == null) {
            ColorChoice choice = new ColorChoice();
            m_defaultColorArray = FontButton.getColorArray(choice.getColorPalette());
            Object var0 = null;
        }
        return m_defaultColorArray;
    }

    public void cleanUp() {
        m_colorPalette = null;
        m_cPalette = null;
    }

    public void setCustomColorsEnabled(boolean enabled) {
        this.m_customColorsEnabled = enabled;
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle", loc) : ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle");
    }

    private void setColorPaletteOnChoices() {
        ColorChoice fChoice = this.m_fontPane.getFontColorChoice();
        if (this.m_foreground != null) {
            fChoice.setSelectedColor((Color)fChoice.getColorPalette().getData(0, 0));
            fChoice.setColorPalette((TwoDModel)m_cPalette);
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)fChoice.getColorPalette(), (Color)this.m_foreground)) {
                    fChoice.setColorPalette(FontButton.getNewColorPalette(fChoice.getColorPalette(), this.m_foreground, this.m_bColorPaletteSet));
                }
                fChoice.setSelectedColor(this.m_foreground);
            } else {
                fChoice.setSelectedColor(fChoice.getClosestColor(this.m_foreground));
            }
        } else {
            fChoice.setColorPalette((TwoDModel)m_cPalette);
        }
        ColorChoice bChoice = this.m_fontPane.getFontBackgroundColorChoice();
        if (this.m_background != null) {
            bChoice.setSelectedColor((Color)bChoice.getColorPalette().getData(0, 0));
            bChoice.setColorPalette((TwoDModel)m_cPalette);
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)bChoice.getColorPalette(), (Color)this.m_background)) {
                    bChoice.setColorPalette(FontButton.getNewColorPalette(bChoice.getColorPalette(), this.m_background, this.m_bColorPaletteSet));
                }
                bChoice.setSelectedColor(this.m_background);
            } else {
                bChoice.setSelectedColor(bChoice.getClosestColor(this.m_background));
            }
        } else {
            bChoice.setColorPalette((TwoDModel)m_cPalette);
        }
    }

    private void _initFontPane() {
        int alignment;
        if (this.m_font != null) {
            try {
                this.m_fontPane.setFontName(this.m_font.getName());
            }
            catch (IllegalArgumentException iae) {
                String[] oldFontNames = this.m_fontPane.getFontNames();
                String[] newFontNames = new String[oldFontNames.length + 1];
                boolean bDoneSorting = false;
                int i = 0;
                for (int j = 0; j < newFontNames.length; ++j) {
                    if (bDoneSorting || i < oldFontNames.length && this.m_font.getName().compareTo(oldFontNames[i]) > 0) {
                        newFontNames[j] = oldFontNames[i];
                        ++i;
                        continue;
                    }
                    newFontNames[j] = this.m_font.getName();
                    bDoneSorting = true;
                }
                this.m_fontPane.setFontNames(newFontNames);
                this.m_fontPane.setFontName(this.m_font.getName());
            }
            this.m_fontPane.setFontStyle(this.m_font.getStyle());
            if (this.m_underline) {
                this.m_fontPane.setFontStyle(this.m_fontPane.getFontStyle() | 4);
            }
            if (this.m_strikethrough) {
                this.m_fontPane.setFontStyle(this.m_fontPane.getFontStyle() | 8);
            }
            this.m_fontPane.setFontSize(this.m_font.getSize());
        }
        if (this.m_foreground != null) {
            this.m_fontPane.setFontColor(this.m_foreground);
        }
        if (this.m_background != null) {
            this.m_fontPane.setFontBackgroundColor(this.m_background);
        }
        switch (this.m_horizontalAlignment) {
            case 2: {
                alignment = 2;
                break;
            }
            case 4: {
                alignment = 4;
                break;
            }
            case 10: {
                alignment = 10;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        this.m_fontPane.setFontHorizontalAlignment(alignment);
        switch (this.m_verticalAlignment) {
            case 1: {
                alignment = 1;
                break;
            }
            case 3: {
                alignment = 3;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        this.m_fontPane.setFontVerticalAlignment(alignment);
        this.m_fontPane.setTextRotation(this.m_textRotation);
    }
}

