/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Crosstab;
import oracle.adfdtinternal.model.dvt.util.gui.layout.Layout;
import oracle.adfdtinternal.model.dvt.util.gui.layout.LayoutComponent;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.SingleAppearanceManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeaderInputHandler;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.ImmInsets;

abstract class AbstractCrosstabHeader
extends PivotHeader
implements LayoutComponent {
    public static final int SELECTOR_SIZE = 10;
    private Crosstab _crosstab;
    private int _edge;
    private CrosstabModel _model;
    private UIListener _listener;
    private Layout.PopupManager _popupManager;
    private static final int _PIVOT_SIZE = 6;

    public AbstractCrosstabHeader(Crosstab parent, int orientation, int edge) {
        super(NullTwoDModel.getTwoDModel(), orientation);
        this._crosstab = parent;
        this._edge = edge;
        this._model = this.createModel();
        this.setModel((TwoDModel)this._model);
        this.setGridFocusTraversable(true);
        this._listener = new UIListener();
        this.setInputHandler((CellInputHandler)this._listener);
        this.addPropertyChangeListener(this._listener);
        this.getGrid().addFocusListener((FocusListener)this._listener);
    }

    public abstract int getSelectedIndex();

    public void setItems(String[] items) {
        this.getCrosstabModel().setItems(items);
        this.invalidate();
    }

    public String getItem(int index) {
        return this.getCrosstabModel().getElement(index);
    }

    public void clearSelection() {
        try {
            this.getGrid().deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getItemCount() {
        return this.getCrosstabModel().getRowCount();
    }

    public void cleanup() {
        this.getGrid().removeFocusListener((FocusListener)this._listener);
        this.removePropertyChangeListener(this._listener);
        this.setModel(NullTwoDModel.getTwoDModel());
        this.setInputHandler(null);
        this._crosstab = null;
        this._model = null;
        this._listener = null;
    }

    @Override
    public int getEdge() {
        return this._edge;
    }

    @Override
    public void setEdge(int edge) {
        this._edge = edge;
    }

    @Override
    public String[] getItems() {
        int count = this.getItemCount();
        String[] items = new String[count];
        for (int i = 0; i < count; ++i) {
            items[i] = this.getItem(i);
        }
        return items;
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        this._popupManager = popupManager;
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable() && this.getItemCount() != 0;
    }

    protected Crosstab getCrosstab() {
        return this._crosstab;
    }

    protected CrosstabModel getCrosstabModel() {
        return this._model;
    }

    protected int getElementWidth(String element) {
        int width = 0;
        Font font = this.getFont();
        if (font != null) {
            SingleAppearanceManager am = (SingleAppearanceManager)this.getAppearanceManager();
            ImmInsets insets = am.getAppearance().getInsets();
            int extra = insets.left + insets.right + 6;
            String text = element;
            if (text != null) {
                width = this.getFontMetrics(font).stringWidth(text) + extra;
            }
        }
        return width;
    }

    protected boolean isSwap(Point p, boolean inHeader) {
        int index = -1;
        if (this.getOrientation() == 0) {
            Header header = this.getRowHeader();
            index = header.getItemAt(p.x, p.y);
            if (index == -1) {
                return false;
            }
            int position = header.getItemPosition(index);
            int size = header.getItemSize(index);
            if (p.y < position + 6) {
                return false;
            }
            if (p.y > position + size - 6) {
                return false;
            }
        } else {
            Header header = this.getColumnHeader();
            index = header.getItemAt(p.x, p.y);
            if (index == -1) {
                return false;
            }
            int position = header.getItemPosition(index);
            int size = this.getRowHeight(index);
            if (p.y < position + 6) {
                return false;
            }
            if (p.y > position + size - 6) {
                return false;
            }
        }
        return true;
    }

    protected abstract CrosstabModel createModel();

    protected abstract void selectionChanged();

    protected abstract void focusLost();

    protected abstract TwoDSelection getNewFocusSelection();

    protected void firePivotEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        this._crosstab.firePivotEvent(source, sourceIndex, destination, destinationIndex);
    }

    protected void fireSwapEvent(Object source, int sourceIndex, Object destination, int destinationIndex) {
        this._crosstab.fireSwapEvent(source, sourceIndex, destination, destinationIndex);
    }

    private class UIListener
    extends PivotHeaderInputHandler
    implements PropertyChangeListener,
    FocusListener {
        private UIListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selection".equals(e.getPropertyName()) && !TwoDSelection.getEmptySelection().equals(e.getNewValue())) {
                AbstractCrosstabHeader.this.selectionChanged();
            }
        }

        public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 2) {
                    AbstractCrosstabHeader.this._crosstab.axisItemToDataPoint(AbstractCrosstabHeader.this, row);
                    e.consume();
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                int i;
                e.consume();
                String currentItem = ((CrosstabModel)AbstractCrosstabHeader.this.getModel()).getElement(row);
                int offsetX = 0;
                int offsetY = 0;
                for (i = 0; i < column; ++i) {
                    offsetX += AbstractCrosstabHeader.this.getGrid().getColumnWidth(i);
                }
                for (i = 0; i < row; ++i) {
                    offsetY += AbstractCrosstabHeader.this.getGrid().getRowHeight(i);
                }
                Point p = new Point(offsetX + e.getX(), offsetY + e.getY());
                if (AbstractCrosstabHeader.this._popupManager != null) {
                    AbstractCrosstabHeader.this._popupManager.createPopup(AbstractCrosstabHeader.this, currentItem, (JComponent)((Object)AbstractCrosstabHeader.this), p);
                }
                AbstractCrosstabHeader.this.getGrid().requestFocus(column, row, null);
                try {
                    TwoDSelection s = new TwoDSelection(column, row);
                    AbstractCrosstabHeader.this.getGrid().setSelection(s);
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
            }
            super.mousePressed(e, grid, column, row);
        }

        public void keyPressed(KeyEvent e, Grid grid, int column, int row) {
            if (e.isShiftDown() && e.getKeyCode() == 121) {
                e.consume();
                PivotHeader header = this.getHeader(grid);
                Point p = new Point();
                p.x = 0;
                p.y = AbstractCrosstabHeader.this.getRowHeight(0) * (row + 1);
                String currentItem = ((CrosstabModel)AbstractCrosstabHeader.this.getModel()).getElement(row);
                AbstractCrosstabHeader.this._popupManager.createPopup(AbstractCrosstabHeader.this, currentItem, (JComponent)((Object)AbstractCrosstabHeader.this), p);
            }
            super.keyPressed(e, grid, column, row);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (AbstractCrosstabHeader.this.getGrid().getRowCount() != 0) {
                AbstractCrosstabHeader.this.getGrid().requestFocus(0, 0, (AWTEvent)e);
                try {
                    TwoDSelection s = AbstractCrosstabHeader.this.getNewFocusSelection();
                    AbstractCrosstabHeader.this.getGrid().setSelection(s);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                try {
                    AbstractCrosstabHeader.this.getGrid().deselectAll();
                    AbstractCrosstabHeader.this.focusLost();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected class ExtendedCell
    extends PivotHeaderCell {
        private String _item;

        public ExtendedCell(int column, int columnCount, int row, int rowCount, String item) {
            super(column, columnCount, row, rowCount, null);
            this._item = item;
        }

        public Object getData() {
            return this._item;
        }
    }

    protected abstract class CrosstabModel
    extends AbstractTwoDModel {
        private ArrayOneDModel _itemStore = new ArrayOneDModel(0);
        private ArrayOneDModel _bigCellStore = new ArrayOneDModel(0);

        public abstract int getColumnCount();

        public String getElement(int item) {
            return (String)this._itemStore.getData(item);
        }

        public void setItems(String[] items) {
            int newCount;
            int count = this._itemStore.getItemCount();
            this._itemStore.removeItems(0, count);
            this._bigCellStore.removeItems(0, count);
            int n = newCount = items == null ? 0 : items.length;
            if (newCount != 0) {
                this._itemStore.addItems(0, (Object[])items);
                this._bigCellStore.addItems(0, newCount);
                this._updateBigCellStore();
            }
            this.fireEvents(count, newCount);
        }

        public int getRowCount() {
            return this._bigCellStore.getItemCount();
        }

        public Object getData(int column, int row) {
            if (row < this._bigCellStore.getItemCount()) {
                return this._bigCellStore.getData(row);
            }
            return null;
        }

        public void setData(int column, int row, Object data) {
        }

        protected abstract AbstractPivotHeaderCell createCell(int var1, int var2);

        protected abstract void fireEvents(int var1, int var2);

        private void _updateBigCellStore() {
            int count = this._itemStore.getItemCount();
            for (int i = 0; i < count; ++i) {
                this._bigCellStore.setData(i, (Object)this.createCell(i, count));
            }
        }
    }
}

