/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.PageEdge;
import oracle.dss.util.AbstractMap;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.dss.util.xml.XMLObjectWriter;

public abstract class BaseCachedDataSource
extends DataAccessAdapter
implements DataSource,
Persistable {
    protected Map m_dataMap;
    protected Map m_metadataMap;
    protected Map m_layerMetadataMap;
    protected Data m_data;
    protected Edge[] m_edges;
    protected PersistableAttributes m_attrs;
    protected boolean m_isOutline;
    protected static final String[] DEFAULT_SUPPORTED_DATAMAP = new String[]{"dataValue", "dataFormattedValue", "dataIsTotal"};
    protected static final String[] DEFAULT_SUPPORTED_LAYERMETADATAMAP = new String[]{"layerName", "layerLabel", "dimMediumName", "dimShortName"};
    protected String m_measureDim;
    public static final String COLUMN_EDGE = "ColumnEdge";
    public static final String ROW_EDGE = "RowEdge";
    public static final String PAGE_EDGE = "PageEdge";
    public static final String DATAMAP = "DataMap";
    public static final String METADATAMAP = "MetadataMap";
    public static final String LAYERMETADATAMAP = "LayerMetadataMap";
    private static final String MEASURE_ATTR = "measure";
    public static final String IS_OUTLINE = "IsOutline";

    public BaseCachedDataSource() {
        this.init();
    }

    public void copyDataSource(DataAccess da, DataDirector dd) {
        this.init();
        this.initializeDataSource(da, dd, -1, -1);
    }

    public void copyDataSource(DataAccess da, DataDirector dd, int rowLimit, int colLimit) {
        this.init();
        this.initializeDataSource(da, dd, rowLimit, colLimit);
    }

    public int getEdgeCount() {
        int count = 0;
        int i = 0;
        while (i < this.m_edges.length && this.m_edges[i] != null) {
            ++i;
            ++count;
        }
        return count;
    }

    public Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (type.equals("dimIsMeasure")) {
            return new Boolean(this.m_measureDim != null && this.m_measureDim.equals(this.getEdge(edge).getLayerMetadata(layer, "layerName")));
        }
        return this.getEdge(edge).getLayerMetadata(layer, type);
    }

    public int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getMemberSiblingCount(hPos, memberLayer);
    }

    public Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getMemberMetadata(hPos, memberLayer, hIndex, type);
    }

    public int getLayerCount(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getLayerCount();
    }

    public int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getExtent();
    }

    public int getLimit(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getLimit();
    }

    public int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getSliceMemberCount(slice);
    }

    public int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getMemberDepth(layer, slice);
    }

    public int getMemberStartLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getMemberStartLayer(layer, slice);
    }

    public int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getMemberExtent(layer, slice);
    }

    public int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getMemberStartSlice(layer, slice);
    }

    public Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getEdge(edge).getMemberMetadata(layer, slice, type);
    }

    public int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getEdge(edge).getMemberHPos(layer, slice);
    }

    public Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getSliceLabel(slice);
    }

    public int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getFirstHPos();
    }

    public int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getLastHPos();
    }

    public int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getNextHPos(hPos);
    }

    public int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getEdge(edge).getPrevHPos(hPos);
    }

    public int getEdgeCurrentSlice(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getCurrentSlice();
    }

    public int[] getEdgeCurrentHPos(int edge) throws EdgeOutOfRangeException {
        return this.getEdge(edge).getCurrentHPos();
    }

    public Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        return this.m_data.getValue(row, col, type);
    }

    private Edge getEdge(int edge) throws EdgeOutOfRangeException {
        if (edge < 0) {
            throw new EdgeOutOfRangeException(edge, 0);
        }
        int count = this.getEdgeCount();
        if (edge >= count) {
            throw new EdgeOutOfRangeException(edge, count - 1);
        }
        return this.m_edges[edge];
    }

    public boolean isOutline() {
        return this.m_isOutline;
    }

    public int getSliceOutlineLayer(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (!this.m_isOutline) {
            return super.getSliceOutlineLayer(edge, slice);
        }
        return this.getEdge(edge).getSliceOutlineLayer(slice);
    }

    public void setExpectedDataMap(DataMap map) {
        this.m_dataMap.setExpectedMap((AbstractMap)map);
    }

    public DataMap getExpectedDataMap() {
        return (DataMap)this.m_dataMap.getExpectedMap();
    }

    public void setExpectedMetadataMap(MetadataMap map) {
        this.m_metadataMap.setExpectedMap((AbstractMap)map);
    }

    public MetadataMap getExpectedMetadataMap() {
        return (MetadataMap)this.m_metadataMap.getExpectedMap();
    }

    public void setExpectedLayerMetadataMap(LayerMetadataMap map) {
        this.m_layerMetadataMap.setExpectedMap((AbstractMap)map);
    }

    public LayerMetadataMap getExpectedLayerMetadataMap() {
        return (LayerMetadataMap)this.m_layerMetadataMap.getExpectedMap();
    }

    public MetadataMap getSupportedMetadataMap() {
        return (MetadataMap)this.m_metadataMap.getSupportedMap();
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        return (LayerMetadataMap)this.m_layerMetadataMap.getSupportedMap();
    }

    public DataMap getSupportedDataMap() {
        return (DataMap)this.m_dataMap.getSupportedMap();
    }

    public void addDataDirectorListener(DataDirectorListener l) {
        l.viewDataAvailable(new DataAvailableEvent((Object)this, (DataAccess)this));
    }

    public CubeDataDirector createCubeDataDirector() {
        return null;
    }

    public DataDirector createDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return null;
    }

    public void initialize(Hashtable env) {
    }

    public AggregateInfo[] getPersistableComponents() {
        return null;
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes attrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (attrs != null) {
            result.merge(attrs);
        }
        result.setObjectType(this.getXMLObjectType());
        return result;
    }

    public void setPersistableAttributes(PersistableAttributes attrs) {
        this.m_attrs = attrs;
    }

    public String getXMLAsString() throws BIPersistenceException {
        String ret = null;
        try {
            ret = this.getXML();
        }
        catch (BIIOException e) {
            throw new BIPersistenceException(e.getMessage(), (Exception)((Object)e));
        }
        return ret;
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        boolean success = false;
        try {
            this.setXML(xml);
            success = true;
        }
        catch (BIParseException e1) {
            throw new BIPersistenceException(e1.getMessage(), (Exception)((Object)e1));
        }
        catch (BISAXException e2) {
            throw new BIPersistenceException(e2.getMessage(), (Exception)((Object)e2));
        }
        catch (BIIOException e3) {
            throw new BIPersistenceException(e3.getMessage(), (Exception)((Object)e3));
        }
        return success;
    }

    protected abstract String getXMLObjectName();

    protected abstract String getXMLObjectType();

    public void writeXML(OutputStream stream) throws BIIOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF8");
            this._writeXML(writer);
        }
        catch (UnsupportedEncodingException e) {
            throw new BIIOException(e.getMessage(), (Exception)e);
        }
    }

    protected void _writeXML(Writer writer) throws BIIOException {
        XMLObjectWriter xml_writer = new XMLObjectWriter(writer);
        xml_writer.setIndentMode(1);
        ObjectNode top = new ObjectNode(this.getXMLObjectName());
        if (this.m_measureDim != null) {
            top.addProperty(MEASURE_ATTR, this.m_measureDim);
        }
        this.m_dataMap.addMapToXML(top);
        this.m_metadataMap.addMapToXML(top);
        this.m_layerMetadataMap.addMapToXML(top);
        int nEdges = this.getEdgeCount();
        Edge edge = null;
        if (nEdges >= 1) {
            edge = this.m_edges[0];
            ObjectNode col_edge = edge.addEdgeToXML(COLUMN_EDGE, this.m_data, this.m_metadataMap, this.m_layerMetadataMap);
            top.addProperty(col_edge);
        }
        if (nEdges >= 2) {
            edge = this.m_edges[1];
            ObjectNode row_edge = edge.addEdgeToXML(ROW_EDGE, null, this.m_metadataMap, this.m_layerMetadataMap);
            top.addProperty(row_edge);
        }
        if (nEdges >= 3) {
            edge = this.m_edges[2];
            ObjectNode page_edge = edge.addEdgeToXML(PAGE_EDGE, null, this.m_metadataMap, this.m_layerMetadataMap);
            top.addProperty(page_edge);
        }
        top.addProperty(IS_OUTLINE, this.m_isOutline);
        xml_writer.writeObjectNode((BaseObjectNode)top);
    }

    public String getXML() throws BIIOException {
        StringWriter writer = new StringWriter(1024);
        this._writeXML(writer);
        writer.flush();
        return writer.toString();
    }

    public void readXML(InputStream stream) throws BIIOException, BIParseException, BISAXException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, "UTF8");
            this._readXML(reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new BIIOException(e.getMessage(), (Exception)e);
        }
    }

    protected void _readXML(Reader reader) throws BIIOException, BIParseException, BISAXException {
        this.init();
        XMLObjectReader obj_reader = new XMLObjectReader(reader);
        ObjectNode node = obj_reader.readObjectNode();
        PropertyNode measure_attr = node.getProperty(MEASURE_ATTR);
        if (measure_attr != null) {
            this.m_measureDim = measure_attr.getValueAsString();
        }
        this.m_dataMap.readMapFromXML(node);
        this.m_metadataMap.readMapFromXML(node);
        this.m_layerMetadataMap.readMapFromXML(node);
        int nRows = 0;
        int nCols = 0;
        ObjectNode colEdge = node.getPropertyValueAsObjectNode(COLUMN_EDGE, true);
        if (colEdge == null) {
            return;
        }
        try {
            nCols = this.getEdgeExtent(colEdge);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        ObjectNode rowEdge = node.getPropertyValueAsObjectNode(ROW_EDGE, true);
        if (rowEdge != null) {
            try {
                nRows = this.getEdgeExtent(rowEdge);
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
        }
        this.m_data = new Data(this.m_dataMap, nRows, nCols);
        try {
            this.m_isOutline = node.getPropertyValueAsBoolean(IS_OUTLINE);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        this.m_edges[0] = this.createRowColumnEdge(colEdge, false, this.m_data, this.m_metadataMap, this.m_layerMetadataMap);
        this.m_edges[1] = this.createRowColumnEdge(rowEdge, this.isOutline(), this.m_data, this.m_metadataMap, this.m_layerMetadataMap);
        ObjectNode pageEdge = node.getPropertyValueAsObjectNode(PAGE_EDGE, true);
        if (pageEdge != null) {
            this.m_edges[2] = new PageEdge(pageEdge, this.m_metadataMap, this.m_layerMetadataMap);
        }
    }

    public void setXML(String xml) throws BIParseException, BISAXException, BIIOException {
        StringReader reader = new StringReader(xml);
        this._readXML(reader);
    }

    protected abstract Edge createRowColumnEdge(DataAccess var1, boolean var2, int var3, Map var4, Map var5, int var6);

    protected abstract Edge createRowColumnEdge(ObjectNode var1, boolean var2, Data var3, Map var4, Map var5);

    protected int getInitialRowCount() {
        return 0;
    }

    protected abstract int getEdgeExtent(ObjectNode var1) throws NoSuchPropertyException;

    protected abstract MetadataMap getDefaultSupportedMetadataMap();

    protected void init() {
        this.m_edges = new Edge[3];
        this.m_measureDim = null;
        this.m_dataMap = this.m_dataMap == null ? new Map(DATAMAP, (AbstractMap)new DataMap(DEFAULT_SUPPORTED_DATAMAP)) : new Map(DATAMAP, this.m_dataMap.getExpectedMap());
        this.m_metadataMap = this.m_metadataMap == null ? new Map(METADATAMAP, (AbstractMap)this.getDefaultSupportedMetadataMap()) : new Map(METADATAMAP, this.m_metadataMap.getExpectedMap());
        this.m_layerMetadataMap = this.m_layerMetadataMap == null ? new Map(LAYERMETADATAMAP, (AbstractMap)new LayerMetadataMap(DEFAULT_SUPPORTED_LAYERMETADATAMAP)) : new Map(LAYERMETADATAMAP, this.m_layerMetadataMap.getExpectedMap());
    }

    protected void initializeDataSource(DataAccess da, DataDirector dd, int rowLimit, int colLimit) {
        this.m_dataMap.setSupportedMap((AbstractMap)dd.getSupportedDataMap());
        this.m_metadataMap.setSupportedMap((AbstractMap)dd.getSupportedMetadataMap());
        this.m_layerMetadataMap.setSupportedMap((AbstractMap)dd.getSupportedLayerMetadataMap());
        this.m_isOutline = dd.isOutline();
        int nEdges = da.getEdgeCount();
        if (nEdges < 1) {
            return;
        }
        int nRows = this.getInitialRowCount();
        int nCols = 0;
        try {
            if (nEdges >= 2) {
                nRows = da.getEdgeExtent(1);
            }
            if (rowLimit != -1 && nRows > rowLimit) {
                nRows = rowLimit;
            }
            nCols = da.getEdgeExtent(0);
            if (colLimit != -1 && nCols > colLimit) {
                nCols = colLimit;
            }
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        this.m_data = new Data(this.m_dataMap, nRows, nCols);
        this.m_data.initializeDataSource(da);
        this.m_edges[0] = this.createRowColumnEdge(da, false, 0, this.m_metadataMap, this.m_layerMetadataMap, colLimit);
        if (nEdges >= 2) {
            this.m_edges[1] = this.createRowColumnEdge(da, this.m_isOutline, 1, this.m_metadataMap, this.m_layerMetadataMap, rowLimit);
        }
        if (nEdges >= 3) {
            this.m_edges[2] = new PageEdge(da, 2, this.m_metadataMap, this.m_layerMetadataMap);
        }
        try {
            QDR sample = da.getValueQDR(0, 0, 0);
            if (sample != null) {
                this.m_measureDim = sample.getMeasureDim();
            }
        }
        catch (RowOutOfRangeException e) {
        }
        catch (ColumnOutOfRangeException e) {
            // empty catch block
        }
    }

    QDR createQDR() {
        return new QDR(this.m_measureDim);
    }
}

