/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import oracle.dss.dataView.datacache.RelationalCachedDataSource;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class DiscovererRelationalCachedDataSource
extends RelationalCachedDataSource {
    private static final String _QDR_ROW_DIM = "DISCOVERER_ROWNUMBER_DIMENSION";

    public static RelationalCachedDataSource createCachedDataSource(DataAccess da, DataDirector dd) {
        DiscovererRelationalCachedDataSource cached = new DiscovererRelationalCachedDataSource();
        cached.initializeDataSource(da, dd, -1, -1);
        return cached;
    }

    public static RelationalCachedDataSource createCachedDataSource(DataAccess da, DataDirector dd, int rowLimit, int colLimit) {
        DiscovererRelationalCachedDataSource cached = new DiscovererRelationalCachedDataSource();
        cached.initializeDataSource(da, dd, rowLimit, colLimit);
        return cached;
    }

    @Override
    public QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        QDR qdr = new QDR();
        try {
            qdr = this.getSliceQDR(0, column, flags);
        }
        catch (EdgeOutOfRangeException e1) {
        }
        catch (SliceOutOfRangeException e2) {
            // empty catch block
        }
        return qdr;
    }

    @Override
    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = new QDR();
        if (edge == 0) {
            qdr.setMeasureDim(this.m_measureDim);
            try {
                String itemName = (String)this.getLayerMetadata(edge, slice, "layerName");
                qdr.addDimMemberPair(this.m_measureDim, itemName);
            }
            catch (LayerOutOfRangeException e) {
                // empty catch block
            }
        }
        return qdr;
    }

    @Override
    public QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge > 1) {
            return super.getMemberQDR(edge, layer, slice, flags);
        }
        QDR qdr = new QDR();
        if (edge == 1) {
            qdr.addDimMemberPair(_QDR_ROW_DIM, (String)null);
            return qdr;
        }
        try {
            String itemName = (String)this.getLayerMetadata(edge, layer, "layerName");
            qdr.setMeasureDim(this.m_measureDim);
            qdr.addDimMemberPair(this.m_measureDim, itemName);
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        return qdr;
    }

    @Override
    public QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (edge > 1) {
            return super.getLayerQDR(edge, layer, flags);
        }
        return null;
    }
}

