/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import oracle.dss.dataView.datacache.BaseCachedDataSource;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.RelationalEdge;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class RelationalCachedDataSource
extends BaseCachedDataSource
implements RelationalDataDirector {
    private static final boolean DEBUG_QDR = false;
    protected static final String[] DEFAULT_SUPPORTED_METADATAMAP = new String[]{"label", "mediumName", "shortName", "value", "dataType", "isTotal"};
    public static final String CACHED_DATA = "RelationalCachedData";

    public static RelationalCachedDataSource createCachedDataSource(DataAccess da, DataDirector dd) {
        RelationalCachedDataSource cached = new RelationalCachedDataSource();
        cached.initializeDataSource(da, dd, -1, -1);
        return cached;
    }

    public static RelationalCachedDataSource createCachedDataSource(DataAccess da, DataDirector dd, int rowLimit, int colLimit) {
        RelationalCachedDataSource cached = new RelationalCachedDataSource();
        cached.initializeDataSource(da, dd, rowLimit, colLimit);
        return cached;
    }

    public QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        QDR qdr = null;
        try {
            qdr = this.getSliceQDR(1, row, flags);
            String layerName = (String)this.getLayerMetadata(0, column, "layerName");
            qdr.setTarget(new QDRMember(layerName));
        }
        catch (EdgeOutOfRangeException e1) {
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (SliceOutOfRangeException e2) {
            // empty catch block
        }
        return qdr;
    }

    public QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = null;
        switch (edge) {
            case 2: {
                qdr = this.createQDR();
                try {
                    this.addPageEdgeToQDR(qdr);
                }
                catch (LayerOutOfRangeException e) {
                    qdr = null;
                }
                break;
            }
            case 1: {
                qdr = this.createQDR();
                try {
                    this.addEdgeToQDR(qdr, edge, slice);
                    if (flags != 1) break;
                    this.addPageEdgeToQDR(qdr);
                }
                catch (LayerOutOfRangeException e) {
                    qdr = null;
                }
                break;
            }
            case 0: {
                try {
                    qdr = this.getLayerQDR(edge, slice, flags);
                    break;
                }
                catch (LayerOutOfRangeException l) {
                    throw new SliceOutOfRangeException(slice, this.getLayerCount(edge));
                }
            }
            default: {
                return super.getSliceQDR(edge, slice, 0);
            }
        }
        return qdr;
    }

    public QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = null;
        switch (edge) {
            case 2: {
                qdr = this.createQDR();
                for (int l = 0; l <= layer; ++l) {
                    Object member = this.getMemberMetadata(edge, l, slice, "value");
                    String layerName = (String)this.getLayerMetadata(edge, l, "layerName");
                    qdr.addDimMemberPair(layerName, member == null ? null : member.toString());
                }
                break;
            }
            case 1: {
                qdr = this.getSliceQDR(edge, layer, flags);
                break;
            }
            case 0: {
                qdr = this.getLayerQDR(edge, layer, flags);
            }
        }
        return qdr;
    }

    public QDR getMemberQDR(int edge, int[] hPos, int memberLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        QDR qdr = null;
        switch (edge) {
            case 2: {
                qdr = this.createQDR();
                for (int l = 0; l <= memberLayer; ++l) {
                    Object member = this.getMemberMetadata(edge, hPos, l, hPos[l], "value");
                    String layerName = (String)this.getLayerMetadata(edge, l, "layerName");
                    qdr.addDimMemberPair(layerName, member == null ? null : member.toString());
                }
                break;
            }
            case 1: {
                qdr = this.getSliceQDR(edge, memberLayer, flags);
                break;
            }
            case 0: {
                qdr = this.getLayerQDR(edge, memberLayer, flags);
            }
        }
        return qdr;
    }

    public QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        QDR qdr = null;
        switch (edge) {
            case 0: 
            case 2: {
                String layerName = (String)this.getLayerMetadata(edge, layer, "layerName");
                qdr = new QDR();
                try {
                    if (edge != 2 && flags == 1) {
                        this.addPageEdgeToQDR(qdr);
                    }
                }
                catch (SliceOutOfRangeException sre) {
                    qdr = null;
                }
                qdr.addDimMemberPair(layerName, (String)null);
                break;
            }
        }
        return qdr;
    }

    @Override
    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    @Override
    protected String getXMLObjectType() {
        return "RelationalDataCache";
    }

    @Override
    protected String getXMLObjectName() {
        return CACHED_DATA;
    }

    @Override
    protected Edge createRowColumnEdge(ObjectNode edgeNode, boolean outline, Data data, Map metadataMap, Map layerMap) {
        return this.createRowColumnEdge(edgeNode, data, metadataMap, layerMap);
    }

    protected Edge createRowColumnEdge(ObjectNode edgeNode, Data data, Map metadataMap, Map layerMap) {
        return new RelationalEdge(edgeNode, data, metadataMap);
    }

    @Override
    protected Edge createRowColumnEdge(DataAccess da, boolean outline, int edge, Map metadataMap, Map layerMap, int limit) {
        return this.createRowColumnEdge(da, edge, metadataMap, layerMap, limit);
    }

    protected Edge createRowColumnEdge(DataAccess da, int edge, Map metadataMap, Map layerMap, int limit) {
        return new RelationalEdge(da, edge, metadataMap, limit);
    }

    @Override
    protected int getEdgeExtent(ObjectNode edgeNode) throws NoSuchPropertyException {
        return edgeNode.getPropertyValueAsInteger("layerCount");
    }

    @Override
    protected MetadataMap getDefaultSupportedMetadataMap() {
        return new MetadataMap(DEFAULT_SUPPORTED_METADATAMAP);
    }

    private void addPageEdgeToQDR(QDR qdr) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        Edge page_edge = this.m_edges[2];
        if (page_edge == null) {
            return;
        }
        int[] hPos = page_edge.getCurrentHPos();
        for (int i = 0; i < hPos.length; ++i) {
            if (hPos[i] == -1) continue;
            String layerName = (String)page_edge.getLayerMetadata(i, "layerName");
            Object member = page_edge.getMemberMetadata(hPos, i, hPos[i], "value");
            qdr.addDimMemberPair(layerName, member == null ? null : member.toString());
        }
    }

    private void addEdgeToQDR(QDR qdr, int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        edge = 0;
        try {
            for (int col = 0; col < this.getLayerCount(edge); ++col) {
                String layerName = (String)this.getLayerMetadata(edge, col, "layerName");
                qdr.addDimMemberPair(layerName, new QDRMember(0, (Object)this.getValue(slice, col, "dataValue").toString()));
            }
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (ColumnOutOfRangeException e) {
        }
        catch (RowOutOfRangeException e) {
            // empty catch block
        }
    }

    private void writeQDR(String caller, QDR qdr) {
        System.out.println("***** " + caller);
        System.out.print("QDR = ");
        if (qdr == null) {
            System.out.println("null");
        } else {
            System.out.println(qdr.toString());
            QDRMember target = qdr.getTarget();
            if (target != null) {
                System.out.println("\tTarget = " + target.toString());
            }
        }
    }
}

