/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.formattedTextArea.UIFormattedTextView;
import oracle.dss.pagingControl.PageItemComponentHandle;

public class FontNameTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_NAME = "FontName";
    protected ToolBar m_toolBar = null;
    protected Object m_selectedObject = null;
    protected ComponentHandle m_selectedComponentHandle = null;
    protected UIView m_currentDataview = null;
    protected boolean m_flag = true;
    JComboBox m_fontName = new JComboBox();
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle = null;
    private boolean m_bSuperCalled = true;
    protected boolean m_bRolloverIconEnabled = false;

    public FontNameTool() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] itemList = ge.getAvailableFontFamilyNames();
        int length = 0;
        try {
            length = Array.getLength(itemList);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        for (int i = 0; i < length; ++i) {
            this.m_fontName.addItem(itemList[i]);
        }
        this.m_fontName.setEditable(false);
        this.m_fontName.setEnabled(false);
        int height = this.m_fontName.getPreferredSize().height;
        this.m_fontName.setMinimumSize(new Dimension(90, height));
        this.m_fontName.setMaximumSize(new Dimension(90, height));
        this.m_fontName.setPreferredSize(new Dimension(90, height));
        this.m_fontName.addActionListener(this);
        this.setMinimumSize(new Dimension(95, height));
        this.setMaximumSize(new Dimension(95, height));
        this.setPreferredSize(new Dimension(95, height));
        this.add(this.m_fontName);
        this.setBorder(null);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fontName.setToolTipText(this.rBundle.getString(PROPERTY_FONT_NAME));
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_fontName.setToolTipText(this.rBundle.getString(PROPERTY_FONT_NAME));
    }

    public void setDefaultName(String name) {
        this.m_fontName.setSelectedItem(name);
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && e.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.m_fontName.setEnabled(false);
            return;
        }
        this.m_flag = false;
        Object selectedObject = e.getComponentHandle().getComponent();
        if (this.isEnabled(e.getComponentHandle())) {
            int imin;
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.m_fontName.setEnabled(true);
            String fontName = this.getFontName();
            int imax = this.m_fontName.getItemCount();
            for (imin = 0; imin < imax; ++imin) {
                if (!this.m_fontName.getItemAt(imin).equals(fontName)) continue;
                this.m_fontName.setSelectedIndex(imin);
                break;
            }
            if (imin == imax) {
                this.m_fontName.setSelectedIndex(1);
            }
        } else {
            this.m_fontName.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_flag = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.m_flag) {
            return;
        }
        if (e == null) {
            return;
        }
        if (e.getSource() == this.m_fontName) {
            this.setFontName((String)this.m_fontName.getSelectedItem());
        }
    }

    @Override
    public void update() {
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)this.m_currentDataview).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(selectedComponentHandle) != null) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof FontAttribute) {
            return true;
        }
        if (selectedComponentHandle.getComponent() instanceof UIFormattedTextView) {
            return ((UIFormattedTextView)selectedComponentHandle.getComponent()).isEditable();
        }
        return false;
    }

    private String getFontName() {
        ViewStyle viewStyle;
        UIFormattedTextView view;
        if (this.m_selectedObject instanceof UIFormattedTextView && (view = (UIFormattedTextView)this.m_selectedObject).isEditable() && !view.isCurrentAttributeChanging()) {
            return view.getFontName();
        }
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            return ((DataviewTitles)this.m_selectedObject).getFont().getName();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            viewStyle = ((GridViewAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontName();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            viewStyle = ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontName();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().getName();
        }
        return null;
    }

    private void setFontName(String name) {
        String oldName = this.getFontName();
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            Font f = ((DataviewTitles)this.m_selectedObject).getFont();
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(name, f.getStyle(), f.getSize()));
        } else {
            if (this.m_currentDataview instanceof GridViewAttribute) {
                ViewStyle viewStyle = new ViewStyle();
                viewStyle.setFontName(name);
                ((GridViewAttribute)this.m_currentDataview).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
                if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)this.m_currentDataview).compareComponentViewStyle(this.m_selectedComponentHandle, viewStyle)) {
                    this.m_toolBar.displayFormatAlert();
                }
                return;
            }
            if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)this.m_currentDataview).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
                ViewStyle viewStyle = new ViewStyle();
                viewStyle.setFontName(name);
                ((GraphAttribute)this.m_currentDataview).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            } else if (this.m_selectedObject instanceof FontAttribute) {
                Font f = ((FontAttribute)this.m_selectedObject).getFont();
                ((FontAttribute)this.m_selectedObject).setFont(new Font(name, f.getStyle(), f.getSize()));
            }
        }
        if (this.m_selectedObject instanceof UIFormattedTextView) {
            ((UIFormattedTextView)this.m_selectedObject).setFontName(name);
        }
        this.firePropertyChange(PROPERTY_FONT_NAME, oldName, name);
    }
}

