/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.DataviewDialogBarLayout;
import oracle.dss.dataView.gui.PreviewPanel;
import oracle.dss.dataView.gui.PrintDialogsProvider;

public class PreviewDialog
extends JDialog
implements ActionListener,
HelpContext {
    private PrintDialogsProvider m_pdp = null;
    private PreviewPanel m_previewPanel;
    private UIViewPrinter[] m_printers = null;
    protected PushButton pgButton = null;
    private boolean m_entireWkbkSelected = false;
    protected PushButton printButton = null;
    protected PushButton closeButton = null;
    protected PushButton helpButton = null;
    private final int _BORDER_INSET = 6;
    private Locale m_locale = null;
    private final Border _sBorder = new EmptyBorder(6, 6, 6, 6);
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    private GrayPane gp = null;
    private ComponentAdapter m_componentListener = null;
    ResourceBundle dvStrings = null;

    public PreviewDialog(Frame frame, String title, ViewPrinter printer, PrintDialogsProvider pdp) {
        super(frame, title, true);
        UIViewPrinter[] printers = new UIViewPrinter[]{printer};
        this.setResizable(true);
        this.constructDialog(frame, title, printers, pdp);
    }

    public PreviewDialog(Frame frame, String title, ViewPrinter[] printers, PrintDialogsProvider pdp) {
        super(frame, title, true);
        this.setResizable(true);
        this.constructDialog(frame, title, (UIViewPrinter[])printers, pdp);
    }

    public PreviewDialog(Frame frame, String title, UIViewPrinter printer, PrintDialogsProvider pdp) {
        super(frame, title, true);
        UIViewPrinter[] printers = new UIViewPrinter[]{printer};
        this.setResizable(true);
        this.constructDialog(frame, title, printers, pdp);
    }

    public PreviewDialog(Frame frame, String title, UIViewPrinter printer, PrintDialogsProvider pdp, boolean entireWkbkSelected) {
        super(frame, title, true);
        UIViewPrinter[] printers = new UIViewPrinter[]{printer};
        this.setResizable(true);
        this.m_entireWkbkSelected = entireWkbkSelected;
        this.constructDialog(frame, title, printers, pdp);
    }

    public PreviewPanel getPreviewPanel() {
        return this.m_previewPanel;
    }

    private void constructDialog(Frame frame, String title, UIViewPrinter[] printers, PrintDialogsProvider pdp) {
        this.m_printers = printers;
        this.m_pdp = pdp;
        this.updateResourceBundle(printers[0].getLocale());
        this.setSize(800, 600);
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout(0, 6));
        content.setBorder(this._sBorder);
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new DataviewDialogBarLayout(buttonPanel));
        String m_translatedText = this.getIntlString("help");
        this.helpButton = new PushButton(StringUtils.stripMnemonic((String)m_translatedText));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)m_translatedText));
        buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setLeftmost(true);
        this.helpButton.setRightmost(true);
        m_translatedText = this.getIntlString("pagesetup");
        this.pgButton = new PushButton(StringUtils.stripMnemonic((String)m_translatedText));
        this.pgButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)m_translatedText));
        buttonPanel.add((Component)this.pgButton, DialogButtonBar.CONSTRAINT_FINISH);
        this.pgButton.addActionListener((ActionListener)this);
        this.pgButton.setLeftmost(true);
        this.pgButton.setRightmost(true);
        if (this.m_entireWkbkSelected) {
            this.pgButton.setEnabled(false);
        }
        m_translatedText = this.getIntlString("pnt");
        this.printButton = new PushButton(StringUtils.stripMnemonic((String)m_translatedText));
        this.printButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)m_translatedText));
        buttonPanel.add((Component)this.printButton, DialogButtonBar.CONSTRAINT_YES);
        this.printButton.addActionListener((ActionListener)this);
        this.printButton.setLeftmost(true);
        this.printButton.setRightmost(true);
        m_translatedText = this.getIntlString("Close");
        this.closeButton = new PushButton(StringUtils.stripMnemonic((String)m_translatedText));
        this.closeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)m_translatedText));
        buttonPanel.add((Component)this.closeButton, DialogButtonBar.CONSTRAINT_NO);
        this.closeButton.addActionListener((ActionListener)this);
        this.closeButton.setLeftmost(true);
        this.closeButton.setRightmost(true);
        this.closeButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(27, 0), 2);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.helpButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(112, 0), 2);
        if (printers.length > 1) {
            this.m_previewPanel = new PreviewPanel((ViewPrinter[])printers, this.m_pdp);
        } else {
            if (this.m_previewPanel != null) {
                this.m_previewPanel.cleanUp();
                this.m_previewPanel = null;
            }
            this.m_previewPanel = new PreviewPanel(printers[0], this.m_pdp);
        }
        if (this.gp != null) {
            this.gp.removeAll();
            this.gp = null;
        }
        this.gp = new GrayPane((Component)this.m_previewPanel);
        this.getContentPane().add((Component)this.gp, "Center");
        this.m_componentListener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                for (int i = 0; i < PreviewDialog.this.m_printers.length; ++i) {
                    PreviewDialog.this.m_printers[i].endPrint();
                }
            }

            @Override
            public void componentResized(ComponentEvent event) {
                PreviewDialog.this.m_previewPanel.componentResized();
            }

            @Override
            public void componentShown(ComponentEvent event) {
                PreviewDialog.this.m_previewPanel.componentResized();
            }
        };
        this.addComponentListener(this.m_componentListener);
        WindowUtils.centerWindow((Window)this, (Component)frame);
    }

    public void refreshPreviewDialog(Frame frame, String title, UIViewPrinter[] printers, PrintDialogsProvider pdp) {
        this.getContentPane().removeAll();
        this.constructDialog(frame, title, printers, pdp);
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.printButton) {
            if (this.m_pdp != null) {
                for (int i = 0; i < this.m_printers.length; ++i) {
                    this.m_printers[i].endPrint();
                }
                this.setVisible(false);
                Frame frame = WindowUtils.parentFrame((Component)this.printButton);
                this.m_pdp.showPrintDialog(frame);
            }
        } else if (event.getSource() == this.pgButton) {
            if (this.m_pdp != null) {
                for (int i = 0; i < this.m_printers.length; ++i) {
                    this.m_printers[i].endPrint();
                }
                Frame frame = WindowUtils.parentFrame((Component)this.printButton);
                this.setVisible(false);
                this.m_pdp.showPageSetupDialog(frame);
            }
        } else if (event.getSource() == this.helpButton) {
            if (this.getHelpProvider() == null) {
                return;
            }
            try {
                if (this.getHelpProvider() != null) {
                    this.getHelpProvider().showHelp((Component)this);
                } else if (HelpUtils.getDefaultHelpProvider() != null) {
                    HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                }
            }
            catch (HelpUnavailableException e1) {}
        } else {
            for (int i = 0; i < this.m_printers.length; ++i) {
                this.m_printers[i].endPrint();
            }
            this.setVisible(false);
        }
    }

    protected void setCursor(Component component, Cursor c) {
        component.setCursor(c);
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setCursor(cont.getComponent(i), c);
            }
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public String getIntlString(String key) {
        return this.getIntlString(key, this.dvStrings);
    }

    public String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return strTemp;
    }

    private void updateResourceBundle(Locale loc) {
        try {
            this.dvStrings = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException e) {
            this.dvStrings = null;
        }
    }

    public void cleanUp() {
        this.helpButton.removeActionListener((ActionListener)this);
        this.helpButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        this.pgButton.removeActionListener((ActionListener)this);
        this.printButton.removeActionListener((ActionListener)this);
        this.closeButton.removeActionListener((ActionListener)this);
        this.closeButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.removeComponentListener(this.m_componentListener);
        this.m_pdp = null;
        this.m_previewPanel.cleanUp();
        this.m_previewPanel = null;
        this.m_printers = null;
        this.pgButton.removeAll();
        this.pgButton = null;
        this.printButton.removeAll();
        this.printButton = null;
        this.closeButton.removeAll();
        this.closeButton = null;
        this.helpButton.removeAll();
        this.helpButton = null;
        this.m_locale = null;
        this.m_strHelpContextID = null;
        this.m_helpProvider = null;
        this.m_componentListener = null;
        this.dvStrings = null;
        this.gp.removeAll();
        this.getContentPane().remove((Component)this.gp);
        this.gp = null;
        this.getContentPane().removeAll();
        this.removeAll();
        super.removeAll();
        super.dispose();
    }
}

