/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.adfdtinternal.model.dvt.util.gui.BIColorChoice;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.adfdtinternal.model.dvt.util.gui.LimitedTextDocument;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.ReferenceObject;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.graph.gui.Series;
import oracle.dss.graph.pfj.Attr;

public class ReferenceLine
extends JPanel {
    protected Graph m_graph;
    protected int m_componentID;
    protected int[] m_objID;
    protected int m_graphType;
    protected String[] m_referenceNames;
    protected TableColumn m_itemColumn;
    protected TableColumn m_colorColumn;
    protected TableColumn m_lineColumn;
    protected TableColumn m_labelColumn;
    protected TableColumn m_valueColumn;
    protected Object[][] m_data;
    protected String[] m_names;
    protected ReferenceJTable m_table;
    protected LineWidth lineWidth;
    protected CheckBoxEditor checkBoxEditor;
    protected ColorEditor colorEditor;
    protected ColorRenderer colorRenderer;
    protected CheckBoxRenderer itemLabelRenderer;
    protected LabelRenderer lineWidthRenderer;
    protected LabelRenderer labelRenderer;
    protected LabelRenderer crossRenderer;
    protected BIColorChoice button;
    protected Color[][] m_colors;
    protected ArrayTwoDModel m_colorPalette = null;
    protected boolean m_bColorPaletteSet = false;
    protected JScrollPane m_scrollPane;
    protected ActionListener editAction;
    protected boolean[] m_visibleInit;
    protected boolean[] m_lineColorChanged;
    protected boolean[] m_lineWidthChanged;
    protected boolean[] m_textChanged;
    protected boolean[] m_valueChanged;
    private boolean m_focusOut = true;
    private boolean _flag = false;
    private NumberFormat m_numberFormat;
    private ResourceBundle rBundle = null;
    private Filter _filter = new Filter();
    private static final int NUMBER_OF_REFERENCE_LINE = 3;
    private int oldAnchorRow = 0;
    private int oldAnchorColumn = 0;
    private boolean editorFocus = false;
    private int m_colToSelect = 0;
    private int m_rowToSelect = 0;
    private int tableMnemonicKey;
    private boolean spacePressedInEditor = false;
    private boolean spacePressedInTable = false;

    public ReferenceLine(Graph graph, int componentID) {
        this.m_graph = graph;
        this.m_componentID = componentID;
        this.initAll();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.m_numberFormat = loc != null ? NumberFormat.getInstance(loc) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
    }

    public JTable getTable() {
        return this.m_table;
    }

    private void initAll() {
        this.removeAll();
        this.m_numberFormat = this.m_graph.getLocale() != null ? NumberFormat.getInstance(this.m_graph.getLocale()) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
        this.updateResourceBundle(this.m_graph.getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String translatedText = this.rBundle.getString("ReferenceLinePanelLabel");
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.tableMnemonicKey = StringUtils.getMnemonicKeyCode((String)translatedText);
        label.setAlignmentX(0.0f);
        this.add(label);
        this.add(Box.createVerticalStrut(3));
        this._initialize();
        this.m_table = new ReferenceJTable(this.m_data, this.m_names);
        label.setLabelFor(this.m_table);
        this.m_table.setAlignmentX(0.0f);
        this.m_table.setRowHeight(24);
        this.m_table.setAutoResizeMode(4);
        this.m_table.setCellSelectionEnabled(true);
        this.m_table.getSelectionModel().setSelectionInterval(0, 0);
        this.m_table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.editAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectionModel rsm = ReferenceLine.this.m_table.getSelectionModel();
                int anchorRow = rsm.getAnchorSelectionIndex();
                ListSelectionModel csm = ReferenceLine.this.m_table.getColumnModel().getSelectionModel();
                int anchorColumn = csm.getAnchorSelectionIndex();
                ReferenceLine.this.m_table.editCellAt(anchorRow, anchorColumn);
                Component editor = ReferenceLine.this.m_table.getEditorComponent();
                if (editor != null) {
                    editor.requestFocus();
                } else {
                    ReferenceLine.this.m_table.requestFocus();
                }
            }
        };
        this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(113, 0), 1);
        Object actionKey = new Object();
        AbstractAction ignoreKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReferenceLine.this.getRootPane().getDefaultButton() != null) {
                    ReferenceLine.this.getRootPane().getDefaultButton().requestFocus();
                    ReferenceLine.this.m_table.getParent().dispatchEvent(new KeyEvent(ReferenceLine.this.m_table, 401, System.currentTimeMillis(), 0, 10, '\uffff'));
                }
            }
        };
        this.m_table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), actionKey);
        this.m_table.getActionMap().put(actionKey, ignoreKeyAction);
        actionKey = new Object();
        AbstractAction tableMnemonicAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ReferenceLine.this.m_table.hasFocus()) {
                    int row = ReferenceLine.this.m_table.getEditingRow();
                    int col = ReferenceLine.this.m_table.getEditingColumn();
                    if (row >= 0 && col >= 0) {
                        ReferenceLine.this.m_table.getCellEditor(row, col).cancelCellEditing();
                    }
                    ReferenceLine.this.m_table.requestFocus();
                } else {
                    int selectedCol = ReferenceLine.this.m_table.getSelectedColumn();
                    int selectedRow = ReferenceLine.this.m_table.getSelectedRow();
                    if (selectedCol >= 0 && selectedCol < ReferenceLine.this.m_table.getColumnCount() && selectedRow >= 0 && selectedRow < ReferenceLine.this.m_table.getRowCount()) {
                        ReferenceLine.this.m_table.getCellEditor(selectedRow, selectedCol).cancelCellEditing();
                    }
                }
                ReferenceLine.this.m_table.setRowSelectionInterval(0, 0);
                ReferenceLine.this.m_table.setColumnSelectionInterval(0, 0);
                ReferenceLine.this.m_rowToSelect = 0;
                ReferenceLine.this.m_colToSelect = 0;
            }
        };
        this.m_table.getInputMap(2).put(KeyStroke.getKeyStroke(this.tableMnemonicKey, 8), actionKey);
        this.m_table.getInputMap(0).put(KeyStroke.getKeyStroke(this.tableMnemonicKey, 8), actionKey);
        this.m_table.getActionMap().put(actionKey, tableMnemonicAction);
        this.m_itemColumn = this.m_table.getColumnModel().getColumn(0);
        this._setupItemColumn();
        this.m_colorColumn = this.m_table.getColumnModel().getColumn(1);
        this._setupColorColumn();
        this.m_lineColumn = this.m_table.getColumnModel().getColumn(2);
        this._setupLineWidthColumn();
        this.m_labelColumn = this.m_table.getColumnModel().getColumn(3);
        this._setupLabelColumn();
        this.m_valueColumn = this.m_table.getColumnModel().getColumn(4);
        this._setupValueColumn();
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_scrollPane.setAlignmentX(0.0f);
        this.m_scrollPane.setPreferredSize(new Dimension(this.m_table.getPreferredSize().width + 5, this.m_table.getPreferredSize().height + this.m_table.getTableHeader().getPreferredSize().height + 4));
        this.m_scrollPane.setMinimumSize(this.m_scrollPane.getPreferredSize());
        this.add(this.m_scrollPane);
        this.setMinimumSize(new Dimension(this.m_scrollPane.getMinimumSize().width + 20, this.getPreferredSize().height));
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.removeAll();
        this.m_table = null;
        this.resetFocus();
        this.initAll();
    }

    public void cleanUp() {
        this.m_table.getInputMap().clear();
        this.m_table.getActionMap().clear();
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this.editAction = null;
        this.m_scrollPane.setViewportView(null);
        this.m_table = null;
    }

    public void setColorPalette(Color[][] colors) {
        this.m_colors = colors;
        if (this.m_colors != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel(colors);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.button != null) {
            return FontButton.getColorArray(this.button.getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel model) {
        this.m_bColorPaletteSet = model != null;
        this.m_colorPalette = model;
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    protected void resetFocus() {
        this.m_focusOut = true;
        this.m_colToSelect = 0;
        this.m_rowToSelect = 0;
    }

    protected void resetFocusLast() {
        this.m_focusOut = true;
        this.m_colToSelect = this.m_table.getColumnCount() - 1;
        this.m_rowToSelect = this.m_table.getRowCount() - 1;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _setupItemColumn() {
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[0]);
        for (int i = 0; i < 3; ++i) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_referenceNames[i]) + 20;
            if (newLength <= length) continue;
            length = newLength;
        }
        this.m_itemColumn.setPreferredWidth(length += 10);
        this.m_itemColumn.setMinWidth(this.m_itemColumn.getPreferredWidth());
        this.m_itemColumn.setMaxWidth(this.m_itemColumn.getPreferredWidth());
        this.m_itemColumn.setResizable(false);
        TabCheckBox m_checkBox = new TabCheckBox();
        this.m_itemColumn.setCellEditor(new CheckBoxEditor(m_checkBox));
        this.itemLabelRenderer = new CheckBoxRenderer();
        this.m_itemColumn.setCellRenderer(this.itemLabelRenderer);
    }

    private void _setupLineWidthColumn() {
        this.lineWidth = new LightLineWidth();
        this.lineWidth.setCellColor(Color.black);
        this.m_lineColumn.setCellEditor(new LineWidthEditor(this.lineWidth));
        LineWidthRenderer renderer = new LineWidthRenderer(true);
        this.m_lineColumn.setCellRenderer(renderer);
        this.m_lineColumn.setPreferredWidth(80);
        this.m_lineColumn.setMinWidth(this.m_lineColumn.getPreferredWidth());
        this.m_lineColumn.setMaxWidth(this.m_lineColumn.getPreferredWidth());
        this.m_lineColumn.setResizable(false);
    }

    private void _setupColorColumn() {
        this.button = new BIColorChoice();
        this.button.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_bColorPaletteSet) {
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.colorEditor = new ColorEditor(this.button);
        this.m_colorColumn.setCellEditor(this.colorEditor);
        this.colorRenderer = new ColorRenderer(true);
        this.m_colorColumn.setCellRenderer(this.colorRenderer);
        this.m_colorColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[1]) + 10);
        this.m_colorColumn.setMinWidth(this.m_colorColumn.getPreferredWidth());
        this.m_colorColumn.setMaxWidth(this.m_colorColumn.getPreferredWidth());
        this.m_colorColumn.setResizable(false);
    }

    private void _setupLabelColumn() {
        LimitedTextDocument ltd = new LimitedTextDocument(1024);
        TabTextField label = new TabTextField(ltd, "", 0);
        this.m_labelColumn.setCellEditor(new TextFieldEditor(label));
        this.m_labelColumn.setCellRenderer(new LabelRenderer());
        this.m_labelColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[3]) + 30);
        this.m_labelColumn.setMinWidth(this.m_labelColumn.getPreferredWidth());
        this.m_labelColumn.setMaxWidth(this.m_labelColumn.getPreferredWidth());
        this.m_labelColumn.setResizable(false);
    }

    private void _setupValueColumn() {
        TabNumberTextField cross = new TabNumberTextField();
        if (this.m_graph.getLocale() != null) {
            cross.setLocale(this.m_graph.getLocale());
        }
        cross.setDataType(Double.class);
        this.m_valueColumn.setCellEditor(new TextFieldEditor((JTextField)((Object)cross)));
        this.m_valueColumn.setCellRenderer(new LabelRenderer());
        this.m_valueColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[4]) + 20);
        this.m_valueColumn.setMinWidth(this.m_valueColumn.getPreferredWidth());
        this.m_valueColumn.setMaxWidth(this.m_valueColumn.getPreferredWidth());
        this.m_valueColumn.setResizable(false);
    }

    private ImageIcon _getImageIcon(String imageName) {
        return new ImageIcon(ImageUtils.getImageResource(Series.class, (String)imageName));
    }

    private void _initialize() {
        int i;
        this.m_referenceNames = new String[3];
        Boolean[] m_referenceShow = new Boolean[3];
        Integer[] m_lineWidths = new Integer[3];
        Color[] m_colors = new Color[3];
        String[] m_labels = new String[3];
        String[] m_value = new String[3];
        this.m_objID = new int[3];
        this.m_visibleInit = new boolean[3];
        this.m_lineColorChanged = new boolean[3];
        this.m_lineWidthChanged = new boolean[3];
        this.m_textChanged = new boolean[3];
        this.m_valueChanged = new boolean[3];
        Integer i2 = 0;
        while (i2 < 3) {
            this.m_referenceNames[i2.intValue()] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), i2.toString()));
            this.m_objID[i2.intValue()] = -1;
            Integer n = i2;
            Integer n2 = i2 = Integer.valueOf(i2 + 1);
        }
        List rl = this.m_graph.getReferenceObjects(this.m_componentID);
        if (rl != null) {
            int size = rl.size() <= 3 ? rl.size() : 3;
            for (int i3 = 0; i3 < size; ++i3) {
                ReferenceObject r = (ReferenceObject)rl.get(i3);
                this.m_objID[i3] = r.getID();
                this.m_visibleInit[i3] = true;
                m_referenceShow[i3] = true;
                m_lineWidths[i3] = new Integer(r.getLineWidth());
                m_colors[i3] = r.getColor();
                m_labels[i3] = r.getText();
                m_value[i3] = this.m_numberFormat.format(r.getLineValue());
            }
            for (int j = size; j < 3; ++j) {
                m_referenceShow[j] = false;
                this.m_visibleInit[j] = false;
                m_lineWidths[j] = (Integer)Attr.LineWidth.getDefault();
                m_colors[j] = (Color)Attr.ReferenceColor.getDefault();
                m_labels[j] = (String)Attr.ReferenceLegendText.getDefault();
                m_value[j] = this.m_numberFormat.format((Double)Attr.ReferenceLineValue.getDefault());
            }
        } else {
            for (i = 0; i < 3; ++i) {
                m_referenceShow[i] = new Boolean(false);
                this.m_visibleInit[i] = false;
                m_lineWidths[i] = (Integer)Attr.LineWidth.getDefault();
                m_colors[i] = (Color)Attr.ReferenceColor.getDefault();
                m_labels[i] = (String)Attr.ReferenceLegendText.getDefault();
                m_value[i] = this.m_numberFormat.format((Double)Attr.ReferenceLineValue.getDefault());
            }
        }
        this.m_names = new String[5];
        this.m_names[0] = this.rBundle.getString("ShowRefrenceLine");
        this.m_names[1] = this.rBundle.getString("Color");
        this.m_names[2] = this.rBundle.getString("Thickness");
        this.m_names[3] = this.rBundle.getString("ReferenceLineLabel");
        this.m_names[4] = this.rBundle.getString("ReferenceLineCrossAt");
        this.m_data = new Object[3][5];
        for (i = 0; i < 3; ++i) {
            this.m_data[i][0] = m_referenceShow[i];
            this.m_data[i][1] = m_colors[i];
            this.m_data[i][2] = m_lineWidths[i];
            this.m_data[i][3] = m_labels[i];
            this.m_data[i][4] = m_value[i];
        }
    }

    private Icon _getColorIcon(Image image, int i) {
        this._filter.setColor(i);
        Image newImage = ReferenceLine._createFilteredImage(image, this._filter);
        return new ImageIcon(newImage);
    }

    private static Image _createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource prod = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    private void _processTabKey(KeyEvent e) {
        int anchorRow = this.m_table.getSelectionModel().getAnchorSelectionIndex();
        int anchorColumn = this.m_table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        if (e.isControlDown()) {
            this.m_table.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
            if (!e.isShiftDown()) {
                FocusManager.getCurrentManager().focusNextComponent(this.m_table);
            } else {
                FocusManager.getCurrentManager().focusPreviousComponent(this.m_table);
            }
            this.resetFocus();
        } else if (!e.isShiftDown()) {
            this.m_table.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
            if (anchorRow == this.m_table.getRowCount() - 1 && anchorColumn == this.m_table.getColumnCount() - 1) {
                if (FocusManager.isFocusManagerEnabled()) {
                    FocusManager.getCurrentManager().focusNextComponent(this.m_table);
                    e.consume();
                }
            } else {
                this.m_table.moveRight();
            }
        } else {
            this.m_table.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
            if (anchorRow == 0 && anchorColumn == 0) {
                if (FocusManager.isFocusManagerEnabled()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this.m_table);
                    e.consume();
                }
            } else {
                this.m_table.moveLeft();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply() {
        List rl = this.m_graph.getReferenceObjects(this.m_componentID);
        int j = 0;
        while (true) {
            block15: {
                ReferenceObject r;
                boolean visible;
                block14: {
                    block12: {
                        block13: {
                            if (j >= 3) {
                                return;
                            }
                            visible = (Boolean)this.m_table.getValueAt(j, 0);
                            r = null;
                            if (this.m_visibleInit[j] == visible) break block12;
                            if (!visible) break block13;
                            r = this.m_graph.createReferenceObject();
                            r.setAssociation(this.m_componentID);
                            r.setDisplayedInLegend(true);
                            r.setLineWidth(((Integer)Attr.LineWidth.getDefault()).intValue());
                            r.setColor((Color)Attr.ReferenceColor.getDefault());
                            r.setText((String)Attr.ReferenceLegendText.getDefault());
                            r.setLineValue((Object)((Double)Attr.ReferenceLineValue.getDefault()));
                            break block14;
                        }
                        this.m_graph.destroyReferenceObject(this.m_objID[j]);
                        break block15;
                    }
                    if (!visible) break block15;
                    if (rl != null && rl.size() > j) {
                        r = (ReferenceObject)rl.get(j);
                    }
                }
                if (r != null) {
                    r.setDisplayedInLegend(visible);
                    if (this.m_lineColorChanged[j]) {
                        Color color = (Color)this.m_table.getValueAt(j, 1);
                        r.setColor(color);
                    }
                    if (this.m_lineWidthChanged[j]) {
                        int lineWidth = new Integer(this.m_table.getValueAt(j, 2).toString());
                        r.setLineWidth(lineWidth);
                    }
                    if (this.m_textChanged[j]) {
                        String text = new String((String)this.m_table.getValueAt(j, 3));
                        r.setText(text);
                    }
                    if (this.m_valueChanged[j]) {
                        double d = 0.0;
                        try {
                            d = this.m_numberFormat.parse((String)this.m_table.getValueAt(j, 4)).doubleValue();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        r.setLineValue((Object)d);
                    }
                }
            }
            ++j;
        }
    }

    protected static int hexStringToInt(String str) {
        String noPound = str.substring(1);
        return Integer.parseInt(noPound, 16);
    }

    protected class ReferenceJTable
    extends JTable
    implements TableModelListener {
        private boolean helpKey;

        public ReferenceJTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
            this.helpKey = false;
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public void setCellEditor(TableCellEditor editor) {
            super.setCellEditor(editor);
            if (editor != null) {
                ReferenceLine.this._flag = false;
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            int column = e.getColumn();
            int row = e.getFirstRow();
            if (row < 0) {
                return;
            }
            if (!ReferenceLine.this._flag) {
                return;
            }
            if (column == 0) {
                ReferenceLine.this._flag = false;
                return;
            }
            if (column == 1) {
                ReferenceLine.this.m_lineColorChanged[row] = true;
            } else if (column == 2) {
                ReferenceLine.this.m_lineWidthChanged[row] = true;
            } else if (column == 3) {
                ReferenceLine.this.m_textChanged[row] = true;
            } else if (column == 4) {
                ReferenceLine.this.m_valueChanged[row] = true;
            }
            if (!((Boolean)this.getValueAt(row, 0)).booleanValue()) {
                this.setValueAt(new Boolean(true), row, 0);
            }
            ReferenceLine.this._flag = false;
        }

        public void moveLeft() {
            this.requestFocus();
            int row = this.getSelectionModel().getAnchorSelectionIndex();
            int column = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (row == 0 && column == 0) {
                this.changeSelection(this.getRowCount() - 1, this.getColumnCount() - 1, false, false);
            } else if (column == 0) {
                this.changeSelection(row - 1, this.getColumnCount() - 1, false, false);
            } else {
                this.changeSelection(row, column - 1, false, false);
            }
            ReferenceLine.this._flag = false;
        }

        public void moveRight() {
            this.requestFocus();
            int row = this.getSelectionModel().getAnchorSelectionIndex();
            int column = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (row == this.getRowCount() - 1 && column == this.getColumnCount() - 1) {
                this.changeSelection(0, 0, false, false);
            } else if (column == this.getColumnCount() - 1) {
                this.changeSelection(row + 1, 0, false, false);
            } else {
                this.changeSelection(row, column + 1, false, false);
            }
            ReferenceLine.this._flag = false;
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            TableCellEditor editor;
            if (this.isEditing() && (editor = this.getCellEditor()) != null) {
                Object value = editor.getCellEditorValue();
                this.setValueAt(value, this.getEditingRow(), this.getEditingColumn());
            }
            this.resizeAndRepaint();
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
            int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (e.getKeyCode() == 9 || e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                if (e.getKeyCode() == 9) {
                    if (e.isControlDown()) {
                        if (e.getID() != 402) {
                            this.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
                            if (!e.isShiftDown()) {
                                FocusManager.getCurrentManager().focusNextComponent(this);
                            } else {
                                FocusManager.getCurrentManager().focusPreviousComponent(this);
                            }
                            ReferenceLine.this.resetFocus();
                        }
                    } else {
                        if (anchorColumn == this.getColumnCount() - 1 && anchorRow == this.getRowCount() - 1 && !e.isShiftDown() && e.getID() != 402) {
                            this.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
                            if (FocusManager.isFocusManagerEnabled()) {
                                FocusManager.getCurrentManager().focusNextComponent(this);
                                e.consume();
                            }
                            return;
                        }
                        if (anchorColumn == 0 && anchorRow == 0 && e.isShiftDown() && e.getID() != 402) {
                            if (FocusManager.isFocusManagerEnabled()) {
                                FocusManager.getCurrentManager().focusPreviousComponent(this);
                                e.consume();
                            }
                            return;
                        }
                    }
                } else if (e.getKeyCode() == 40 && e.isAltDown() && e.getID() != 402 && (anchorColumn == 1 || anchorColumn == 2)) {
                    this.editCellAt(anchorRow, anchorColumn);
                    ReferenceLine.this._flag = false;
                    this.getEditorComponent().requestFocus();
                    if (this.getEditorComponent() instanceof JComboBox) {
                        this.getEditorComponent().setVisible(true);
                        ((JComboBox)this.getEditorComponent()).showPopup();
                    }
                }
            } else if (e.getKeyCode() == 32 && anchorColumn != 0) {
                if (!ReferenceLine.this.spacePressedInEditor) {
                    this.editCellAt(anchorRow, anchorColumn);
                    ReferenceLine.this._flag = false;
                    this.getEditorComponent().requestFocus();
                    if (this.getEditorComponent() instanceof JComboBox) {
                        this.getEditorComponent().setVisible(true);
                        ((JComboBox)this.getEditorComponent()).showPopup();
                    }
                    ReferenceLine.this.spacePressedInTable = true;
                } else {
                    ReferenceLine.this.spacePressedInEditor = false;
                }
            } else if (e.getKeyCode() == 72) {
                if (e.isAltDown() && e.getID() != 402) {
                    this.helpKey = true;
                } else if (anchorColumn == 3 || anchorColumn == 4) {
                    return;
                }
            } else if (!(anchorColumn != 3 && anchorColumn != 4 || this.isEditing() || e.getKeyCode() == 10 || e.isAltDown() && e.getKeyCode() == ReferenceLine.this.tableMnemonicKey)) {
                return;
            }
            super.processKeyEvent(e);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1004) {
                if (ReferenceLine.this.m_focusOut) {
                    int selectedCol = this.getSelectedColumn();
                    int selectedRow = this.getSelectedRow();
                    if (selectedCol >= 0 && selectedCol < this.getColumnCount() && selectedRow >= 0 && selectedRow < this.getRowCount()) {
                        this.getCellEditor(selectedRow, selectedCol).cancelCellEditing();
                    }
                    this.setRowSelectionInterval(ReferenceLine.this.m_rowToSelect, ReferenceLine.this.m_rowToSelect);
                    this.setColumnSelectionInterval(ReferenceLine.this.m_colToSelect, ReferenceLine.this.m_colToSelect);
                    ReferenceLine.this.m_focusOut = false;
                }
            } else if (e.getID() == 1005 && this.helpKey) {
                int selectedCol = this.getSelectedColumn();
                int selectedRow = this.getSelectedRow();
                if (selectedCol >= 0 && selectedCol < this.getColumnCount() && selectedRow >= 0 && selectedRow < this.getRowCount()) {
                    this.getCellEditor(selectedRow, selectedCol).cancelCellEditing();
                }
                this.helpKey = false;
            }
            super.processFocusEvent(e);
        }
    }

    class TextFieldEditor
    extends DefaultCellEditor
    implements FocusListener,
    CaretListener {
        private JTextField textField;
        private int rowEdited;
        private int columnEdited;

        public TextFieldEditor(JTextField t) {
            super(t);
            this.textField = t;
            this.setClickCountToStart(1);
            this.textField.addFocusListener(this);
            this.textField.addCaretListener(this);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            String text = this.textField.getText();
            int column = ReferenceLine.this.m_table.getEditingColumn();
            if (column < 0) {
                return;
            }
            int length = ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(ReferenceLine.this.m_names[column]) + 20;
            for (int i = 0; i < 3; ++i) {
                int newLength = 0;
                newLength = i == ReferenceLine.this.m_table.getEditingRow() ? ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(this.textField.getText()) : ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(ReferenceLine.this.m_table.getValueAt(i, column).toString());
                if (newLength <= length) continue;
                length = newLength;
            }
            length += 10;
            if (column == 3) {
                ReferenceLine.this.m_labelColumn.setMaxWidth(length);
            } else {
                ReferenceLine.this.m_valueColumn.setMaxWidth(length);
            }
            ReferenceLine.this.m_table.revalidate();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                if (this.textField instanceof TabNumberTextField) {
                    TabNumberTextField numTextField = (TabNumberTextField)((Object)this.textField);
                    if (numTextField.isValidValue()) {
                        this.fireEditingStopped();
                    } else if (numTextField.isShowing()) {
                        numTextField.showErrorDialog();
                    }
                } else {
                    this.fireEditingStopped();
                }
            }
        }

        @Override
        public boolean stopCellEditing() {
            TabNumberTextField numTextField;
            if (this.textField instanceof TabNumberTextField && !(numTextField = (TabNumberTextField)((Object)this.textField)).isValidValue()) {
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public void fireEditingCanceled() {
            ReferenceLine.this._flag = false;
            super.fireEditingCanceled();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!ReferenceLine.this.m_table.isEditing()) {
                ReferenceLine.this.m_table.editCellAt(this.rowEdited, this.columnEdited);
            }
            if (ReferenceLine.this.m_table.getEditingColumn() != -1) {
                String name = ReferenceLine.this.m_names[ReferenceLine.this.m_table.getEditingColumn()];
                this.textField.getAccessibleContext().setAccessibleName(name);
            }
            this.textField.selectAll();
            ReferenceLine.this.m_focusOut = false;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.textField instanceof NumberTextField) {
                if (this.textField.getText().length() == 0) {
                    return ReferenceLine.this.m_table.getValueAt(ReferenceLine.this.m_table.getEditingRow(), ReferenceLine.this.m_table.getEditingColumn());
                }
                if (((NumberTextField)this.textField).getNumber() != null) {
                    String val = ReferenceLine.this.m_numberFormat.format(((NumberTextField)this.textField).getNumber().doubleValue());
                    return val;
                }
                return this.textField.getText();
            }
            return this.textField.getText();
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor
    implements ItemListener,
    FocusListener {
        public CheckBoxEditor(JCheckBox c) {
            super(c);
            c.removeItemListener(this);
            this.editorComponent = c;
            c.addItemListener(this);
            c.addFocusListener(this);
            this.setClickCountToStart(1);
        }

        @Override
        public Object getCellEditorValue() {
            return new Boolean(((JCheckBox)this.editorComponent).isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.fireEditingStopped();
        }

        @Override
        public void focusGained(FocusEvent e) {
            ReferenceLine.this.m_focusOut = false;
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JCheckBox)this.editorComponent).setSelected((Boolean)value);
            ((JCheckBox)this.editorComponent).setText(ReferenceLine.this.m_referenceNames[row]);
            return this.editorComponent;
        }
    }

    class ColorEditor
    extends DefaultCellEditor
    implements PropertyChangeListener {
        Color currentColor;

        public ColorEditor(BIColorChoice b) {
            super(new JCheckBox());
            this.currentColor = null;
            this.editorComponent = b;
            this.setClickCountToStart(1);
            this.editorComponent.addPropertyChangeListener(this);
            this.editorComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        ColorEditor.this.fireEditingCanceled();
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selectedColor")) {
                ReferenceLine.this._flag = true;
                this.fireEditingStopped();
            }
        }

        @Override
        public void fireEditingStopped() {
            this.currentColor = ((BIColorChoice)((Object)this.editorComponent)).getSelectedColor();
            super.fireEditingStopped();
        }

        @Override
        public void fireEditingCanceled() {
            ReferenceLine.this._flag = false;
            super.fireEditingCanceled();
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            BIColorChoice choice = (BIColorChoice)((Object)this.editorComponent);
            if (!ReferenceLine.this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)choice.getColorPalette(), (Color)((Color)value))) {
                    choice.setColorPalette(FontButton.getNewColorPalette(choice.getColorPalette(), (Color)value, ReferenceLine.this.m_bColorPaletteSet));
                }
                choice.setSelectedColor((Color)value);
            } else {
                choice.setSelectedColor(choice.getClosestColor((Color)value));
            }
            this.currentColor = (Color)value;
            return this.editorComponent;
        }
    }

    private class CheckBoxRenderer
    extends JPanel
    implements TableCellRenderer {
        JCheckBox checkBox;

        public CheckBoxRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setLayout(new BoxLayout(this, 0));
            this.checkBox = new JCheckBox();
            this.checkBox.setBackground(Color.white);
            this.checkBox.setForeground(Color.black);
            this.add(this.checkBox);
            this.checkBox.setAlignmentX(0.0f);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.checkBox.setSelected((Boolean)value);
            }
            this.checkBox.setText(ReferenceLine.this.m_referenceNames[row]);
            this.getAccessibleContext().setAccessibleName(this.checkBox.getText());
            if (isSelected) {
                this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            } else {
                this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            }
            return this;
        }
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        private LabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.getAccessibleContext().setAccessibleName(value.toString());
            }
            renderer.setBackground(Color.white);
            renderer.setForeground(Color.black);
            if (isSelected) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
            } else {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            return renderer;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            this.setText("");
            if (value instanceof Color) {
                this.setBackground((Color)value);
            } else {
                this.setBackground(Color.white);
            }
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            return this;
        }

        public void cleanUp() {
            this.setBorder(null);
            this.unselectedBorder = null;
            this.selectedBorder = null;
        }
    }

    class LineWidthRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public LineWidthRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int width = new Integer(table.getValueAt(row, column).toString());
            this.setIcon(ReferenceLine.this._getColorIcon(ImageUtils.getImageResource(LineWidthRenderer.class, (String)("images/Line" + width + ".gif")), row));
            if (width == 1) {
                this.getAccessibleContext().setAccessibleName(ReferenceLine.this.rBundle.getString("Single pixel"));
            } else {
                this.getAccessibleContext().setAccessibleName(MessageFormat.format(ReferenceLine.this.rBundle.getString("pixels"), new Integer(width)));
            }
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            }
            return this;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(int i) {
            Color c = (Color)ReferenceLine.this.m_table.getValueAt(i, 1);
            if (c.getRGB() == -1) {
                c = Color.black;
            }
            this._color = c == null ? 0 : c.getRGB();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._sCOLOR) {
                return this._color;
            }
            return rgb;
        }
    }

    private class LineWidthEditor
    extends ComboBoxCellEditor {
        public LineWidthEditor(JComboBox box) {
            super(box);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value.toString());
            LineWidth width = (LineWidth)this.editorComponent;
            if (ReferenceLine.this.lineWidth.getBackground().getRGB() == -1 && ((Color)ReferenceLine.this.m_table.getValueAt(row, 1)).getRGB() == -1) {
                width.setCellColor(Color.black);
            } else {
                width.setCellColor((Color)ReferenceLine.this.m_table.getValueAt(row, 1));
            }
            return this.editorComponent;
        }
    }

    private class ComboBoxCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        boolean stopEditing;

        public ComboBoxCellEditor(final JComboBox comboBox) {
            super(comboBox);
            this.stopEditing = false;
            comboBox.addFocusListener(this);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ComboBoxCellEditor.this.stopEditing) {
                        ComboBoxCellEditor.this.fireEditingStopped();
                    } else {
                        ComboBoxCellEditor.this.stopEditing = true;
                    }
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ReferenceLine.this._flag = true;
                    ComboBoxCellEditor.this.fireEditingStopped();
                }

                @Override
                public void setValue(Object value) {
                    comboBox.setSelectedItem(value);
                }

                @Override
                public Object getCellEditorValue() {
                    return comboBox.getSelectedItem();
                }
            };
            comboBox.addItemListener(this.delegate);
        }

        @Override
        public void fireEditingCanceled() {
            ReferenceLine.this._flag = false;
            super.fireEditingCanceled();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.stopEditing = false;
            ReferenceLine.this.m_focusOut = false;
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.stopEditing = true;
            }
        }
    }

    private class LightLineWidth
    extends LineWidth
    implements ActionListener {
        public LightLineWidth() {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ReferenceLine.this._processTabKey(e);
            } else {
                if (e.getKeyCode() != 27 && !this.isPopupVisible()) {
                    ReferenceLine.this.m_table.requestFocus();
                    return;
                }
                if (e.getKeyCode() == 32) {
                    ReferenceLine.this.spacePressedInEditor = true;
                    if (ReferenceLine.this.spacePressedInTable) {
                        ReferenceLine.this.spacePressedInTable = false;
                        return;
                    }
                } else {
                    ReferenceLine.this.spacePressedInEditor = false;
                }
            }
            super.processKeyEvent(e);
        }
    }

    private class TabCheckBox
    extends JCheckBox {
        @Override
        public void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 501) {
                ReferenceLine.this._flag = true;
            }
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ReferenceLine.this._processTabKey(e);
            } else {
                ReferenceLine.this._flag = true;
            }
            super.processKeyEvent(e);
        }
    }

    private class TabNumberTextField
    extends NumberTextField
    implements FocusListener {
        public boolean keyTyped = false;

        public TabNumberTextField() {
            this.addFocusListener(this);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.keyTyped = false;
            ReferenceLine.this._flag = false;
        }

        public boolean isValidValue() {
            return !this.getText().equals("-") && !this.getText().equals("+") && !this.getText().equals(".");
        }

        public void showErrorDialog() {
            String errorMsg = MessageFormat.format(ReferenceLine.this.rBundle.getString("WrongCrossAtValue"), this.getText());
            JOptionPane jpane = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(ReferenceLine.class, (String)"images/stop.gif")));
            jpane.getAccessibleContext().setAccessibleName(errorMsg);
            JDialog tmpDialog = jpane.createDialog(ReferenceLine.this.m_table, ReferenceLine.this.rBundle.getString("Graph"));
            tmpDialog.show();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabNumberTextField.this.requestFocus();
                }
            });
            this.selectAll();
        }

        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                if (this.isValidValue()) {
                    ReferenceLine.this._processTabKey(e);
                } else {
                    this.showErrorDialog();
                    return;
                }
            }
            if (!e.isActionKey() && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 18 && e.getKeyCode() != 10 && e.getKeyCode() != 0 && e.getKeyCode() != 32 && e.getKeyCode() != 521 && e.getKeyCode() != 45 && e.getKeyCode() != 46) {
                this.keyTyped = true;
            }
            ReferenceLine.this._flag = this.keyTyped;
            super.processKeyEvent(e);
        }
    }

    private class TabTextField
    extends JTextField
    implements FocusListener {
        private boolean keyTyped;
        private boolean startEditing;

        public TabTextField() {
            this.keyTyped = false;
            this.startEditing = false;
            this.addFocusListener(this);
        }

        public TabTextField(Document doc, String text, int columns) {
            super(doc, text, columns);
            this.keyTyped = false;
            this.startEditing = false;
            this.addFocusListener(this);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.keyTyped = false;
            ReferenceLine.this._flag = false;
            this.startEditing = false;
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            this.startEditing = true;
            super.processMouseEvent(e);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                ReferenceLine.this._processTabKey(e);
            } else if (e.getKeyCode() == 0) {
                if (!this.keyTyped) {
                    this.selectAll();
                    return;
                }
            } else if (e.getKeyCode() == 32) {
                if (this.startEditing) {
                    this.keyTyped = true;
                } else {
                    this.startEditing = true;
                }
            } else if (!e.isActionKey() && e.getKeyCode() != 17 && e.getKeyCode() != 16 && e.getKeyCode() != 18 && e.getKeyCode() != 10) {
                this.keyTyped = true;
            }
            ReferenceLine.this._flag = this.keyTyped;
            super.processKeyEvent(e);
        }
    }
}

