/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.adfdtinternal.model.dvt.util.gui.BIColorChoice;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.GraphUtils;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class Series
extends JPanel {
    protected Graph m_graph;
    protected int m_graphType;
    protected String[] m_seriesList;
    protected int m_seriesCount;
    protected TableColumn m_seriesline;
    protected TableColumn m_color;
    protected TableColumn m_marker;
    protected TableColumn m_yAxis;
    protected TableColumn m_type;
    protected TableColumn m_fitline;
    protected TableColumn m_typeLine;
    protected TableColumn m_typeArea;
    protected boolean m_isLine;
    protected boolean m_isLineType;
    protected boolean m_isArea;
    protected boolean m_isMarker;
    protected boolean m_isDualY;
    protected boolean m_isCombination;
    protected boolean m_isFitline;
    protected int[] m_assignToY2;
    protected Integer[] m_lineWidth;
    protected Integer[] m_markerType;
    protected Integer[] m_markerShape;
    protected Integer[] m_fitlineType;
    protected Color[] m_seriesColor;
    protected Integer[] m_lineType;
    protected Integer[] m_areaType;
    protected Object m_defaultMarkerShape;
    protected Object m_defaultColor;
    protected Object m_defaultLineWidth;
    protected Object m_defaultYAxis;
    protected Object m_defaultMarkerType;
    protected Object m_defaultFitline;
    protected Object m_defaultLineType;
    protected Object m_defaultAreaType;
    protected Object[][] m_data;
    protected boolean[][] m_dataChanged;
    protected boolean m_noneMissingInMarkerRows = false;
    protected boolean m_lineNone = false;
    protected Object[] m_previousData;
    protected String[] m_names;
    protected SeriesJTable m_table;
    protected ImageIcon[] m_icons;
    protected String m_y1;
    protected String m_y2;
    protected String m_auto;
    protected boolean m_colorColumn = true;
    protected boolean m_lineColumn = true;
    protected boolean m_markerShapeColumn = true;
    protected boolean m_yAxisColumn = true;
    protected boolean m_markerTypeColumn = true;
    protected boolean m_fitlineColumn = true;
    protected boolean m_lineTypeColumn = true;
    protected boolean m_areaTypeColumn = true;
    protected int m_markerShapeCol = -1;
    protected int m_colorCol = -1;
    protected int m_lineCol = -1;
    protected int m_yAxisCol = -1;
    protected int m_markerTypeCol = -1;
    protected int m_fitlineCol = -1;
    protected int m_lineTypeCol = -1;
    protected int m_areaTypeCol = -1;
    protected LineWidthWithBlank lineWidth;
    protected LightCombo fitline;
    protected LightCombo type;
    protected LightCombo defaultType;
    protected LightCombo typeLine;
    protected LightCombo defaultTypeLine;
    protected LightCombo typeArea;
    protected LightCombo defaultTypeArea;
    protected LightCombo markers;
    protected LightCombo defaultmarkers;
    protected ComboBoxCellEditor defaultLineCellEditor;
    protected ComboBoxCellEditor defaultMarkerCellEditor;
    protected ComboBoxCellEditor defaultMarkerTypeEditor;
    protected ComboBoxCellEditor defaultLineTypeEditor;
    protected ComboBoxCellEditor defaultAreaTypeEditor;
    protected ComboBoxCellEditor defaultYAxisEditor;
    protected LightCombo defaultYAxis;
    protected LightCombo yAxis;
    protected ColorEditor colorEditor;
    protected ColorEditor defaultColorEditor;
    protected BIColorChoice autoColor;
    protected ColorRenderer colorRenderer;
    protected TableColumn item;
    protected LabelRenderer itemLabelRenderer;
    protected LabelRenderer fitlineLabelRenderer;
    protected LabelRenderer typeLabelRenderer;
    protected LabelRenderer typeLineLabelRenderer;
    protected LabelRenderer typeAreaLabelRenderer;
    protected LabelRenderer yAxisLabelRenderer;
    protected BIColorChoice button;
    protected Color[][] m_colors;
    protected ArrayTwoDModel m_colorPalette = null;
    protected boolean m_bColorPaletteSet = false;
    protected boolean m_isMSNone = false;
    protected NumberFormat m_numFormat;
    protected boolean m_isPareto = false;
    protected boolean m_showDataMarker = true;
    protected int m_numUsedCols;
    protected JScrollPane m_scrollPane;
    protected ActionListener editAction;
    protected ComponentListener m_componentListener;
    protected FocusListener m_focusListener;
    private static final int[] markerTypes = new int[]{1, 2, 3};
    private static final int AUTOMATIC = -1;
    private static final int BLANK = 0;
    private static final int SAME = 1;
    private ResourceBundle rBundle = null;
    private Filter _filter = new Filter();
    private final int MAX_COL = 7;
    private boolean _flag = true;
    private boolean _flag2 = true;
    private boolean editorFocus = false;

    public Series(Graph graph, int mask) {
        this.m_graph = graph;
        this.setLayout(new BorderLayout());
        this._excludeColumns(mask);
        this.initAll();
    }

    public Series(Graph graph, int mask, String str) {
        this(graph, mask);
        this.m_table.getAccessibleContext().setAccessibleName(str);
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public void setSelectedSeries(int series) {
        int rowCount = this.m_table.getRowCount();
        if (series >= rowCount) {
            return;
        }
        this.m_table.setCellSelectionEnabled(true);
        if (this._isAllSeriesSupported()) {
            ++series;
        }
        this.m_table.getSelectionModel().setSelectionInterval(series, series);
        this.m_table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        Rectangle rowRect = this.m_table.getCellRect(series, 0, false);
        this.m_table.scrollRectToVisible(rowRect);
    }

    public int getSelectedSeries() {
        if (this.m_table != null) {
            return this.m_table.getSelectedRow();
        }
        return -1;
    }

    private void initAll() {
        this.updateResourceBundle(this.m_graph.getLocale());
        this.setLayout(new BoxLayout(this, 0));
        if (this.m_graph.getGraphTypeConverter() == null) {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter((GraphTypeConverter)graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(this.m_graph.getLocale());
        }
        this.m_graphType = this.m_graph.getGraphType();
        this._initialize();
        this.m_table = new SeriesJTable(this.m_data, this.m_names);
        this.m_table.setName("SeriesTable");
        this.m_table.setRowHeight(24);
        this.m_table.setAutoResizeMode(0);
        this.editAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectionModel rsm = Series.this.m_table.getSelectionModel();
                int anchorRow = rsm.getAnchorSelectionIndex();
                ListSelectionModel csm = Series.this.m_table.getColumnModel().getSelectionModel();
                int anchorColumn = csm.getAnchorSelectionIndex();
                Series.this.m_table.editCellAt(anchorRow, anchorColumn);
                Component editor = Series.this.m_table.getEditorComponent();
                if (editor != null) {
                    editor.requestFocus();
                } else {
                    Series.this.m_table.requestFocus();
                }
            }
        };
        this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(32, 0), 1);
        this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(113, 0), 1);
        Object actionKey = new Object();
        AbstractAction ignoreKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Series.this.getRootPane().getDefaultButton() != null) {
                    Series.this.getRootPane().getDefaultButton().requestFocus();
                    Series.this.m_table.getParent().dispatchEvent(new KeyEvent(Series.this.m_table, 401, System.currentTimeMillis(), 0, 10, '\uffff'));
                }
            }
        };
        this.m_table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), actionKey);
        this.m_table.getActionMap().put(actionKey, ignoreKeyAction);
        this._setupItemColumn();
        int column = 0;
        if (this.m_colorColumn) {
            this.m_color = this.m_table.getColumnModel().getColumn(++column);
            this._setupColorColumn(column);
        }
        if (this.m_isCombination) {
            this.m_type = this.m_table.getColumnModel().getColumn(++column);
            this._setupMarkerTypeColumn(column);
        }
        if (this.m_isArea) {
            this.m_typeArea = this.m_table.getColumnModel().getColumn(++column);
            this._setupAreaTypeColumn(column);
        }
        if (this.m_isLineType) {
            this.m_typeLine = this.m_table.getColumnModel().getColumn(++column);
            this._setupLineTypeColumn(column);
        }
        if (this.m_isLine) {
            this.m_seriesline = this.m_table.getColumnModel().getColumn(++column);
            this._setupLineWidthColumn(column);
        }
        if (this.m_isMarker) {
            this.m_marker = this.m_table.getColumnModel().getColumn(++column);
            this._setupMarkerShapeColumn(column);
        }
        if (this.m_isDualY) {
            this.m_yAxis = this.m_table.getColumnModel().getColumn(++column);
            this._setupAssignToY2Column(column);
        }
        if (this.m_isFitline) {
            this.m_fitline = this.m_table.getColumnModel().getColumn(++column);
            this._setupFitlineColumn(column);
        }
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.add(this.m_scrollPane);
        this.m_scrollPane.setPreferredSize(new Dimension(this.m_table.getPreferredSize().width + 5, this.m_table.getPreferredSize().height + this.m_table.getTableHeader().getPreferredSize().height + 5));
        this.setPreferredSize(this.m_scrollPane.getPreferredSize());
        this.m_componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = Series.this.m_scrollPane.getPreferredSize().width;
                int h = Series.this.m_scrollPane.getPreferredSize().height;
                int maxWidth = Series.this.getHeight() < h ? w + Series.this.m_scrollPane.getVerticalScrollBar().getPreferredSize().width : w;
                int maxHeight = Series.this.getWidth() < w ? h + Series.this.m_scrollPane.getHorizontalScrollBar().getPreferredSize().height : h;
                Series.this.setMaximumSize(new Dimension(maxWidth, maxHeight));
                Series.this.setPreferredSize(Series.this.getMaximumSize());
                Series.this.revalidate();
            }
        };
        this.addComponentListener(this.m_componentListener);
        this.m_focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Series.this.m_table.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        this.addFocusListener(this.m_focusListener);
        this.setSelectedSeries(-1);
        if (this._isAllSeriesSupported()) {
            this.m_defaultColor = this.m_table.getValueAt(0, this.m_colorCol);
            if (this.m_isCombination) {
                this.m_defaultMarkerType = this.m_table.getValueAt(0, this.m_markerTypeCol);
            }
            if (this.m_isMarker) {
                this.m_defaultMarkerShape = this.m_table.getValueAt(0, this.m_markerShapeCol);
            }
            if (this.m_isArea) {
                this.m_defaultAreaType = this.m_table.getValueAt(0, this.m_areaTypeCol);
            }
            if (this.m_isLineType) {
                this.m_defaultLineType = this.m_table.getValueAt(0, this.m_lineTypeCol);
            }
            if (this.m_isLine) {
                this.m_defaultLineWidth = this.m_table.getValueAt(0, this.m_lineCol);
            }
            if (this.m_isDualY) {
                this.m_defaultYAxis = this.m_table.getValueAt(0, this.m_yAxisCol);
            }
            if (this.m_isFitline) {
                this.m_defaultFitline = this.m_table.getValueAt(0, this.m_fitlineCol);
            }
            for (int i = 1; i < this.m_table.getColumnCount(); ++i) {
                int value = this._areSeriesSameValueOrAuto(i);
                if (i == this.m_colorCol) {
                    if (value == -1) {
                        this.autoColor.setAutomaticSelected(true);
                    }
                    if (this.m_table.getValueAt(0, this.m_colorCol) == null && value == -1) {
                        continue;
                    }
                } else if (i == this.m_yAxisCol) {
                    if (value == -1 && this.m_table.getValueAt(0, this.m_yAxisCol).equals(this.m_auto)) continue;
                    if (value == 1 && this.m_table.getValueAt(0, this.m_yAxisCol).equals(this.m_auto)) {
                        this.m_table.setValueAt("", 0, i);
                    }
                } else if (i != this.m_markerTypeCol ? i == this.m_markerShapeCol && value == -1 && Integer.parseInt(this.m_table.getValueAt(0, this.m_markerShapeCol).toString()) == -1 : value == -1 && this.m_table.getValueAt(0, this.m_markerTypeCol).equals(this.m_auto)) continue;
                if (value != 0) continue;
                this.m_table.setValueAt("", 0, i);
            }
        }
        if (this._isMarkerSupported()) {
            this.m_dataChanged[0][this.m_markerShapeCol] = false;
        }
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.removeAll();
        this.m_table = null;
        this.removeComponentListener(this.m_componentListener);
        this.m_colorCol = -1;
        this.m_lineCol = -1;
        this.m_markerTypeCol = -1;
        this.m_markerShapeCol = -1;
        this.m_fitlineCol = -1;
        this.m_yAxisCol = -1;
        this.initAll();
    }

    public void setDataMarkerEnabled(boolean b) {
        this.m_showDataMarker = this.m_graphType >= 61 && this.m_graphType <= 64 || this.m_graphType >= 65 && this.m_graphType <= 66 ? true : b;
        if (this.m_isMarker) {
            this.repaint();
        }
    }

    public boolean isDataMarkerEnabled() {
        return this.m_showDataMarker;
    }

    public void cleanUp() {
        this.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.removeFocusListener(this.m_focusListener);
        this.m_focusListener = null;
        this.m_table.getInputMap().clear();
        this.m_table.getActionMap().clear();
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this.editAction = null;
        if (this.markers != null) {
            this.m_marker.setCellEditor(null);
            this.markers.cleanUp();
            this.markers = null;
        }
        if (this.yAxis != null) {
            this.m_yAxis.setCellEditor(null);
            this.yAxis.cleanUp();
            this.yAxis = null;
            this.m_yAxis.setCellRenderer(null);
            this.yAxisLabelRenderer = null;
        }
        if (this.fitline != null) {
            this.m_fitline.setCellEditor(null);
            this.fitline.cleanUp();
            this.fitline = null;
            this.m_fitline.setCellRenderer(null);
            this.fitlineLabelRenderer = null;
        }
        if (this.type != null) {
            this.m_type.setCellEditor(null);
            this.type.cleanUp();
            this.type = null;
            this.m_type.setCellRenderer(null);
            this.typeLabelRenderer = null;
        }
        this.m_color.setCellEditor(null);
        this.colorEditor = null;
        this.m_color.setCellRenderer(null);
        this.colorRenderer.cleanUp();
        this.colorRenderer = null;
        if (this.item != null) {
            this.item.setCellRenderer(null);
            this.itemLabelRenderer = null;
        }
        this.m_scrollPane.setViewportView(null);
        this.m_table = null;
    }

    public void setColorPalette(Color[][] colors) {
        this.m_colors = colors;
        if (this.m_colors != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel(colors);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.button != null) {
            return FontButton.getColorArray(this.button.getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel model) {
        this.m_bColorPaletteSet = model != null;
        this.m_colorPalette = model;
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    private String _truncateText(String t) {
        if (t == null) {
            return t;
        }
        String str = new String(t);
        if (str.length() > 30) {
            str = str.substring(0, 26) + "...)";
        }
        return str;
    }

    String _getMarkerShape(int shape) {
        String str = this.rBundle.getString("None");
        switch (shape) {
            case 1: {
                str = this.rBundle.getString("Square");
                break;
            }
            case 2: {
                str = this.rBundle.getString("Circle");
                break;
            }
            case 3: {
                str = this.rBundle.getString("Diamond");
                break;
            }
            case 4: {
                str = this.rBundle.getString("Plus");
                break;
            }
            case 5: {
                str = this.rBundle.getString("Triangle Down");
                break;
            }
            case 6: {
                str = this.rBundle.getString("Triangle Up");
            }
        }
        return str;
    }

    int _getMarkerType(String str) {
        int type = 0;
        if (str.equals(this.rBundle.getString("Default"))) {
            type = 0;
        } else if (str.equals(this.rBundle.getString("SeriesBar"))) {
            type = 1;
        } else if (str.equals(this.rBundle.getString("SeriesLine"))) {
            type = 2;
        } else if (str.equals(this.rBundle.getString("SeriesArea"))) {
            type = 3;
        } else if (str.equals(this.rBundle.getString("CurveLine"))) {
            type = 4;
        } else if (str.equals(this.rBundle.getString("SteppedLine"))) {
            type = 5;
        } else if (str.equals(this.rBundle.getString("CenteredSteppedLine"))) {
            type = 6;
        }
        return type;
    }

    String _getMarkerTypeString(int type) {
        switch (type) {
            case 0: {
                return this.rBundle.getString("Default");
            }
            case 1: {
                return this.rBundle.getString("SeriesBar");
            }
            case 2: {
                return this.rBundle.getString("SeriesLine");
            }
            case 3: {
                return this.rBundle.getString("SeriesArea");
            }
            case 4: {
                return this.rBundle.getString("CurveLine");
            }
            case 5: {
                return this.rBundle.getString("SteppedLine");
            }
            case 6: {
                return this.rBundle.getString("CenteredSteppedLine");
            }
        }
        return this.rBundle.getString("Default");
    }

    int _getAreaType(String str) {
        int type = 0;
        if (str.equals(this.rBundle.getString("CurveLine"))) {
            type = 4;
        }
        return type;
    }

    String _getAreaTypeString(int type) {
        switch (type) {
            case 7: {
                return this.rBundle.getString("CurveArea");
            }
        }
        return this.rBundle.getString("SeriesArea");
    }

    int _getLineType(int markerType) {
        int type = 0;
        switch (markerType) {
            case 4: {
                type = 1;
                break;
            }
            case 5: {
                type = 2;
                break;
            }
            case 6: {
                type = 3;
            }
        }
        return type;
    }

    int _getLineType(String str) {
        int type = 0;
        if (str.equals(this.rBundle.getString("CurveLine"))) {
            type = 4;
        } else if (str.equals(this.rBundle.getString("SteppedLine"))) {
            type = 5;
        } else if (str.equals(this.rBundle.getString("CenteredSteppedLine"))) {
            type = 6;
        }
        return type;
    }

    String _getLineTypeString(int type) {
        switch (type) {
            case 4: {
                return this.rBundle.getString("CurveLine");
            }
            case 5: {
                return this.rBundle.getString("SteppedLine");
            }
            case 6: {
                return this.rBundle.getString("CenteredSteppedLine");
            }
        }
        return this.rBundle.getString("SeriesLine");
    }

    int _getFitlineType(String str) {
        int type = 0;
        if (str.equals(this.rBundle.getString("None"))) {
            type = 0;
        } else if (str.equals(this.rBundle.getString("Linear"))) {
            type = 1;
        } else if (str.equals(this.rBundle.getString("Logarithmic"))) {
            type = 5;
        } else if (str.equals(this.rBundle.getString("Exponential"))) {
            type = 8;
        }
        return type;
    }

    private void _excludeColumns(int mask) {
        if ((mask & 1) == 1) {
            this.m_colorColumn = false;
        }
        if ((mask & 2) == 2) {
            this.m_lineColumn = false;
            this.m_lineTypeColumn = false;
        }
        if ((mask & 4) == 4) {
            this.m_markerShapeColumn = false;
        }
        if ((mask & 0x10) == 16) {
            this.m_yAxisColumn = false;
        }
        if ((mask & 0x20) == 32) {
            this.m_markerTypeColumn = false;
        }
        if ((mask & 0x40) == 64) {
            this.m_fitlineColumn = false;
        }
    }

    private void _setupItemColumn() {
        this.item = this.m_table.getColumnModel().getColumn(0);
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[0]);
        for (int i = 0; i < this.m_seriesList.length; ++i) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_seriesList[i]);
            if (newLength <= length) continue;
            length = newLength;
        }
        this.item.setPreferredWidth(length += 10);
        this.item.setMinWidth(this.item.getPreferredWidth());
        this.item.setMaxWidth(this.item.getPreferredWidth());
        this.item.setResizable(false);
        this.itemLabelRenderer = new LabelRenderer();
        this.item.setCellRenderer(this.itemLabelRenderer);
    }

    private void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc);
            this.m_numFormat = NumberFormat.getNumberInstance(loc);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
            this.m_numFormat = NumberFormat.getNumberInstance(loc);
        }
        this.m_numFormat.setMinimumFractionDigits(2);
        this.m_numFormat.setMaximumFractionDigits(2);
    }

    private void _setupAreaTypeColumn(int column) {
    }

    private void _setupLineWidthColumn(int column) {
        this.m_lineCol = column;
        this.lineWidth = new LineWidthWithBlank();
        this.lineWidth.setCellColor(Color.black);
        final LineWidthWithBlankAndNone lineWidthNone = new LineWidthWithBlankAndNone();
        lineWidthNone.setCellColor(Color.black);
        if (!this.m_graph.isLineDataLineDisplayed()) {
            this.m_table.setValueAt(new Integer(0).toString(), 0, this.m_lineCol);
            this.m_lineNone = true;
        } else {
            this.m_lineNone = false;
        }
        ItemListener itemListener1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && lineWidthNone.isPopupVisible()) {
                    if (lineWidthNone.getSelectedIndex() == 0) {
                        if (!Series.this.m_noneMissingInMarkerRows) {
                            Series.this.markers.removeItemAt(0);
                            Series.this.m_noneMissingInMarkerRows = true;
                        }
                        Series.this.m_lineNone = true;
                        String strTemp = Series.this.m_table.getValueAt(0, Series.this.m_markerShapeCol).toString();
                        if (strTemp.equals("0")) {
                            Series.this.m_table.setValueAt(new Integer(-1).toString(), 0, Series.this.m_markerShapeCol);
                        } else if (strTemp.equals("")) {
                            for (int i = 1; i < Series.this.m_table.getRowCount(); ++i) {
                                int tmpShape1 = new Integer(Series.this.m_table.getValueAt(i, Series.this.m_markerShapeCol).toString());
                                if (tmpShape1 == 0) {
                                    Series.this.m_table.setValueAt(new Integer((i - 1) % 6 + 1).toString(), i, Series.this.m_markerShapeCol);
                                    Series.this.m_dataChanged[i][Series.this.m_markerShapeCol] = false;
                                }
                                Series.this.m_defaultMarkerShape = new Integer(-1);
                                Series.this.m_dataChanged[0][Series.this.m_markerShapeCol] = true;
                            }
                        }
                        Series.this.repaint();
                    } else {
                        if (Series.this.m_noneMissingInMarkerRows) {
                            Series.this.markers.insertItemAt(new Integer(0).toString(), 0);
                            Series.this.m_noneMissingInMarkerRows = false;
                        }
                        Series.this.m_lineNone = false;
                    }
                }
            }
        };
        lineWidthNone.addItemListener(itemListener1);
        LineWidthCellRenderer lineWidthRenderer = new LineWidthCellRenderer(true);
        this.lineWidth.setRenderer(lineWidthRenderer);
        this.defaultLineCellEditor = new ComboBoxCellEditor(lineWidthNone);
        this.m_seriesline.setCellEditor(new ComboBoxCellEditor(this.lineWidth));
        LineWidthRenderer renderer = new LineWidthRenderer(true);
        this.m_seriesline.setCellRenderer(renderer);
        this.m_seriesline.setPreferredWidth(80);
        this.m_seriesline.setMinWidth(this.m_seriesline.getPreferredWidth());
        this.m_seriesline.setMaxWidth(this.m_seriesline.getPreferredWidth());
        this.m_seriesline.setResizable(false);
    }

    private boolean isAnyMarkerRowNone() {
        boolean bReturn = false;
        if (this.m_markerShapeCol > -1) {
            for (int i = 1; i < this.m_table.getRowCount(); ++i) {
                int tmpShape1 = new Integer(this.m_table.getValueAt(i, this.m_markerShapeCol).toString());
                if (tmpShape1 != 0) continue;
                bReturn = true;
            }
        }
        return bReturn;
    }

    private boolean isAnyLineRowNone() {
        boolean bReturn = false;
        if (this.m_lineCol > -1) {
            for (int i = 1; i < this.m_table.getRowCount(); ++i) {
                int tmpLine1 = new Integer(this.m_table.getValueAt(i, this.m_lineCol).toString());
                if (tmpLine1 != 0) continue;
                bReturn = true;
            }
        }
        return bReturn;
    }

    private void _setupColorColumn(int column) {
        this.m_colorCol = column;
        this.button = new BIColorChoice();
        this.button.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_bColorPaletteSet) {
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.colorEditor = new ColorEditor(this.button);
        this.m_color.setCellEditor(this.colorEditor);
        this.autoColor = new BIColorChoice();
        this.autoColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.autoColor.setAutomaticAllowed(true);
        this.autoColor.setAutomaticSelected(false);
        this.autoColor.setSelectedColor(Color.red);
        this.autoColor.setLocale(this.m_graph.getLocale());
        this.defaultColorEditor = new ColorEditor(this.autoColor);
        this.colorRenderer = new ColorRenderer(true);
        this.m_color.setCellRenderer(this.colorRenderer);
        int length = Math.max(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[column]), this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_auto));
        this.m_color.setPreferredWidth(length + 10);
        this.m_color.setMinWidth(this.m_color.getPreferredWidth());
        this.m_color.setMaxWidth(this.m_color.getPreferredWidth());
        this.m_color.setResizable(false);
    }

    private void _setupMarkerShapeColumn(int column) {
        this.m_markerShapeCol = column;
        if (!this.m_graph.isMarkerDisplayed() && this._isLineSupported()) {
            if (!this.m_isPareto) {
                this.m_table.setValueAt(new Integer(0).toString(), 0, column);
            } else {
                this.m_table.setValueAt(new Integer(0).toString(), 1, column);
            }
        }
        this.markers = new LightCombo();
        this.defaultmarkers = new LightCombo();
        ItemListener itemListener1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int itemVal;
                Object item;
                if (e.getStateChange() == 1 && Series.this.defaultmarkers.isPopupVisible() && (item = Series.this.defaultmarkers.getSelectedItem()) != null && !item.equals("") && (itemVal = new Integer(item.toString()).intValue()) == 0 && Series.this.isAnyLineRowNone()) {
                    Series.this.m_table.setValueAt(new Integer(3).toString(), 0, Series.this.m_lineCol);
                    Series.this.m_lineNone = false;
                    Series.this.repaint();
                }
            }
        };
        this.defaultmarkers.addItemListener(itemListener1);
        this.defaultmarkers.addItem(new Integer(-1).toString());
        for (int i = 0; i < 7; ++i) {
            if (i == 0 && !this.m_isMSNone && GraphUtils.isDotType((int)this.m_graphType)) continue;
            if (i == 0) {
                if (this.m_graph.isLineDataLineDisplayed()) {
                    this.m_noneMissingInMarkerRows = false;
                    this.markers.addItem(new Integer(i).toString());
                } else {
                    this.m_noneMissingInMarkerRows = true;
                }
            } else {
                this.markers.addItem(new Integer(i).toString());
            }
            this.defaultmarkers.addItem(new Integer(i).toString());
        }
        this.m_isMSNone = false;
        MarkerShapeEditor editor = new MarkerShapeEditor();
        MarkerShapeEditor defaultEditorRenderer = new MarkerShapeEditor();
        this.markers.setRenderer(editor);
        this.defaultmarkers.setRenderer(defaultEditorRenderer);
        this.defaultMarkerCellEditor = new ComboBoxCellEditor(this.defaultmarkers);
        this.m_marker.setCellEditor(new ComboBoxCellEditor(this.markers));
        MarkerShapeRenderer renderer = new MarkerShapeRenderer(true);
        this.m_marker.setCellRenderer(renderer);
        int length = Math.max(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[column]), this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_auto));
        this.m_marker.setPreferredWidth(length + 10);
        this.m_marker.setMinWidth(this.m_marker.getPreferredWidth());
        this.m_marker.setMaxWidth(this.m_marker.getPreferredWidth());
        this.m_marker.setResizable(false);
    }

    private void _setupLineTypeColumn(int column) {
        this.m_lineTypeCol = column;
        String[] str = new String[]{this.rBundle.getString("SeriesLine"), this.rBundle.getString("CurveLine"), this.rBundle.getString("SteppedLine"), this.rBundle.getString("CenteredSteppedLine")};
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[column]);
        for (int i = 0; i < str.length; ++i) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(str[i]);
            if (newLength <= length) continue;
            length = newLength;
        }
        length += 10;
        this.typeLine = new LightCombo(str);
        this.defaultTypeLine = new LightCombo(str);
        this.defaultLineTypeEditor = new ComboBoxCellEditor(this.defaultTypeLine);
        this.m_typeLine.setCellEditor(new ComboBoxCellEditor(this.typeLine));
        this.typeLineLabelRenderer = new LabelRenderer();
        this.m_typeLine.setCellRenderer(this.typeLabelRenderer);
        this.m_typeLine.setPreferredWidth(length);
        this.m_typeLine.setMinWidth(this.m_typeLine.getPreferredWidth());
        this.m_typeLine.setMaxWidth(this.m_typeLine.getPreferredWidth());
        this.m_typeLine.setResizable(false);
    }

    private void _setupMarkerTypeColumn(int column) {
        this.m_markerTypeCol = column;
        String[] str = new String[]{this.rBundle.getString("SeriesBar"), this.rBundle.getString("SeriesLine"), this.rBundle.getString("SeriesArea"), this.rBundle.getString("CurveLine"), this.rBundle.getString("SteppedLine"), this.rBundle.getString("CenteredSteppedLine")};
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[column]);
        for (int i = 0; i < str.length; ++i) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(str[i]);
            if (newLength <= length) continue;
            length = newLength;
        }
        length += 10;
        this.type = new LightCombo(str);
        this.defaultType = new LightCombo(str);
        this.defaultType.insertItemAt(this.m_auto, 0);
        this.defaultMarkerTypeEditor = new ComboBoxCellEditor(this.defaultType);
        this.m_type.setCellEditor(new ComboBoxCellEditor(this.type));
        this.typeLabelRenderer = new LabelRenderer();
        this.m_type.setCellRenderer(this.typeLabelRenderer);
        this.m_type.setPreferredWidth(length);
        this.m_type.setMinWidth(this.m_type.getPreferredWidth());
        this.m_type.setMaxWidth(this.m_type.getPreferredWidth());
        this.m_type.setResizable(false);
    }

    private void _setupAssignToY2Column(int column) {
        this.m_yAxisCol = column;
        String[] str = new String[]{this.m_y1, this.m_y2};
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[column]);
        for (int i = 0; i < str.length; ++i) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this._truncateText(str[i]));
            if (newLength <= length) continue;
            length = newLength;
        }
        length += 10;
        this.yAxis = new LightCombo(str);
        this.defaultYAxis = new LightCombo(str);
        this.defaultYAxis.insertItemAt(this.m_auto, 0);
        this.defaultYAxisEditor = new ComboBoxCellEditor(this.defaultYAxis);
        this.m_yAxis.setCellEditor(new ComboBoxCellEditor(this.yAxis));
        this.yAxisLabelRenderer = new YAxisLabelRenderer();
        this.m_yAxis.setCellRenderer(this.yAxisLabelRenderer);
        this.m_yAxis.setPreferredWidth(length);
        this.m_yAxis.setMinWidth(this.m_yAxis.getPreferredWidth());
        this.m_yAxis.setMaxWidth(this.m_yAxis.getPreferredWidth());
        this.m_yAxis.setResizable(false);
    }

    private void _setupFitlineColumn(int column) {
        this.m_fitlineCol = column;
        String[] str = new String[]{this.rBundle.getString("None"), this.rBundle.getString("Linear"), this.rBundle.getString("Logarithmic"), this.rBundle.getString("Exponential")};
        int length = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[column]);
        for (int i = 0; i < str.length; ++i) {
            int newLength = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(str[i]);
            if (newLength <= length) continue;
            length = newLength;
        }
        this.fitline = new LightCombo(str);
        this.m_fitline.setCellEditor(new ComboBoxCellEditor(this.fitline));
        this.fitlineLabelRenderer = new LabelRenderer();
        this.m_fitline.setCellRenderer(this.fitlineLabelRenderer);
        this.m_fitline.setPreferredWidth(length += 10);
        this.m_fitline.setMinWidth(this.m_fitline.getPreferredWidth());
        this.m_fitline.setMaxWidth(this.m_fitline.getPreferredWidth());
        this.m_fitline.setResizable(false);
    }

    private ImageIcon _getImageIcon(String imageName) {
        return new ImageIcon(ImageUtils.getImageResource(Series.class, (String)imageName));
    }

    private boolean _isAllSeriesSupported() {
        return GraphUtils.isAllSeriesSupported((int)this.m_graphType);
    }

    private boolean _isMarkerSupported() {
        return GraphUtils.isMarkerShapeSupported((int)this.m_graphType);
    }

    private boolean _isLineSupported() {
        return GraphUtils.isLineSupported((CommonGraph)this.m_graph.getCommonGraph());
    }

    private boolean _isFitlineSupported() {
        return GraphUtils.isFitlineSupported((int)this.m_graphType);
    }

    private boolean _isAreaTypeSupported() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void _initialize() {
        block72: {
            block71: {
                this.m_auto = this.rBundle.getString("Auto");
                this.m_icons = new ImageIcon[]{this._getImageIcon("images/Square.gif"), this._getImageIcon("images/Circle.gif"), this._getImageIcon("images/Diamond.gif"), this._getImageIcon("images/Plus.gif"), this._getImageIcon("images/TriangleDown.gif"), this._getImageIcon("images/TriangleUp.gif")};
                this.m_seriesCount = GraphUtils.getSeriesCount((CommonGraph)this.m_graph.getCommonGraph());
                offset = this._isAllSeriesSupported() != false ? 1 : 0;
                this.m_seriesList = new String[this.m_seriesCount + offset];
                if (this.m_graph.getGraphType() != 96) {
                    this.m_seriesList[0] = new String(this.rBundle.getString("All Series"));
                    try {
                        if (this.m_graph.isDataRowShownAsASeries()) {
                            for (i = 0; i < this.m_seriesCount; ++i) {
                                this.m_seriesList[i + offset] = (String)this.m_graph.getDataAccessSliceLabel(1, i, "label");
                            }
                        }
                        for (i = 0; i < this.m_seriesCount; ++i) {
                            this.m_seriesList[i + offset] = (String)this.m_graph.getDataAccessSliceLabel(0, i, "label");
                        }
                    }
                    catch (SliceOutOfRangeException se) {
                    }
                    catch (EdgeOutOfRangeException ee) {}
                } else {
                    this.m_seriesList[0] = this.rBundle.getString("Bar");
                    this.m_seriesList[1] = this.rBundle.getString("Line");
                }
                this.m_assignToY2 = new int[this.m_seriesCount + offset];
                this.m_lineWidth = new Integer[this.m_seriesCount + offset];
                this.m_markerType = new Integer[this.m_seriesCount + offset];
                this.m_markerShape = new Integer[this.m_seriesCount + offset];
                this.m_seriesColor = new Color[this.m_seriesCount + offset];
                this.m_fitlineType = new Integer[this.m_seriesCount + offset];
                this.m_lineType = new Integer[this.m_seriesCount + offset];
                this.m_areaType = new Integer[this.m_seriesCount + offset];
                try {
                    if (this.m_graph.getGraphType() != 96) {
                        if (this._isAllSeriesSupported()) {
                            this.m_markerType[0] = new Integer(this.m_graph.getSeries().getDefaultMarkerType());
                            lineType = this._getLineType(this.m_graph.getSeries().getDefaultMarkerType());
                            this.m_lineType[0] = new Integer(lineType);
                            areaType = this.m_graph.getSeries().getDefaultMarkerType();
                            areaType = areaType != 7 ? 0 : 1;
                            this.m_areaType[0] = new Integer(areaType);
                            this.m_lineWidth[0] = this.m_graph.isLineDataLineDisplayed() == false ? new Integer(0) : new Integer(this.m_graph.getSeries().getDefaultLineWidth());
                            this.m_assignToY2[0] = this.m_graph.getSeries().getDefaultAssignedToY2();
                            this.m_markerShape[0] = this.m_graph.isMarkerDisplayed() == false && this._isLineSupported() != false ? new Integer(0) : new Integer(this.m_graph.getSeries().getDefaultMarkerShape());
                            this.m_seriesColor[0] = this.m_graph.getSeries().getDefaultColor();
                            this.m_fitlineType[0] = new Integer(this.m_graph.getSeries().getDefaultFitlineType());
                        }
                        for (i = 0; i < this.m_seriesCount; ++i) {
                            if (this.m_markerTypeColumn) {
                                markerType = this.m_graph.getSeries().getMarkerType(i);
                                if (markerType == 0) {
                                    markerType = 1;
                                }
                                this.m_markerType[i + offset] = new Integer(markerType);
                            }
                            if (this.m_lineTypeColumn) {
                                lineType = this._getLineType(this.m_graph.getSeries().getMarkerType(i));
                                this.m_lineType[i + offset] = new Integer(lineType);
                            }
                            if (this.m_areaTypeColumn) {
                                areaType = this.m_graph.getSeries().getMarkerType(i);
                                areaType = areaType != 7 ? 0 : 1;
                                this.m_areaType[i + offset] = new Integer(areaType);
                            }
                            if (this.m_lineColumn) {
                                this.m_lineWidth[i + offset] = this.m_graph.isLineDataLineDisplayed() == false ? new Integer(0) : new Integer(this.m_graph.getSeries().getLineWidth(i));
                            }
                            if (this.m_yAxisColumn) {
                                this.m_assignToY2[i + offset] = this.m_graph.getSeries().isAssignedToY2(i) != false ? 1 : 0;
                            }
                            if (this.m_markerShapeColumn) {
                                mShape = this.m_graph.getSeries().getMarkerShape(i);
                                if (mShape == 0) {
                                    this.m_isMSNone = true;
                                }
                                this.m_markerShape[i + offset] = new Integer(mShape);
                            }
                            if (this.m_colorColumn) {
                                this.m_seriesColor[i + offset] = this.m_graph.getSeries().getColor(i);
                            }
                            if (!this.m_fitlineColumn) continue;
                            this.m_fitlineType[i + offset] = new Integer(this.m_graph.getSeries().getFitlineType(i));
                        }
                        this.m_isPareto = false;
                    } else {
                        this.m_markerShape[0] = new Integer(0);
                        this.m_markerShape[1] = new Integer(this.m_graph.getParetoLine().getMarkerShape());
                        this.m_seriesColor[0] = this.m_graph.getSeries().getColor(0);
                        this.m_seriesColor[1] = this.m_graph.getParetoLine().getColor();
                        this.m_lineWidth[0] = new Integer(0);
                        this.m_lineWidth[1] = new Integer(this.m_graph.getParetoLine().getWidth());
                        this.m_assignToY2[0] = 0;
                        this.m_assignToY2[1] = 1;
                        this.m_isPareto = true;
                    }
                }
                catch (SeriesOutOfRangeException e) {
                    // empty catch block
                }
                this.m_isLine = this.m_lineColumn != false ? this._isLineSupported() : false;
                if (!this.m_lineTypeColumn) break block71;
                if (!this._isLineSupported() || GraphUtils.isMarkerTypeSupported((int)this.m_graphType)) ** GOTO lbl-1000
                if (this.m_graphType != 96) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                this.m_isLineType = v0;
                break block72;
            }
            this.m_isLineType = false;
        }
        this.m_isMarker = this.m_markerShapeColumn != false ? this._isMarkerSupported() : false;
        this.m_isDualY = this.m_yAxisColumn != false ? GraphUtils.isAssignedToY2Supported((int)this.m_graphType) : false;
        this.m_isCombination = this.m_markerTypeColumn != false ? GraphUtils.isMarkerTypeSupported((int)this.m_graphType) : false;
        this.m_isFitline = this.m_fitlineColumn != false ? this._isFitlineSupported() : false;
        this.m_isArea = this.m_areaTypeColumn != false ? this._isAreaTypeSupported() : false;
        noOfColumns = 1;
        column = 0;
        if (this.m_colorColumn) {
            ++noOfColumns;
        }
        if (this.m_isLine) {
            ++noOfColumns;
        }
        if (this.m_isMarker) {
            ++noOfColumns;
        }
        if (this.m_isDualY) {
            ++noOfColumns;
        }
        if (this.m_isCombination) {
            ++noOfColumns;
        }
        if (this.m_isFitline) {
            ++noOfColumns;
        }
        if (this.m_isLineType) {
            ++noOfColumns;
        }
        if (this.m_isArea) {
            ++noOfColumns;
        }
        this.m_numUsedCols = noOfColumns;
        this.m_names = new String[noOfColumns];
        this.m_names[0] = this.rBundle.getString("Item");
        this.m_data = new Object[this.m_seriesList.length][noOfColumns];
        this.m_dataChanged = new boolean[this.m_seriesList.length][noOfColumns];
        this.m_previousData = new Object[noOfColumns];
        for (i = 0; i < this.m_seriesList.length; ++i) {
            this.m_data[i][column] = this.m_seriesList[i];
        }
        ++column;
        if (this.m_colorColumn) {
            this.m_names[column] = this.rBundle.getString("Color");
            for (i = 0; i < this.m_seriesColor.length; ++i) {
                this.m_data[i][column] = this.m_seriesColor[i];
            }
            ++column;
        }
        if (this.m_isCombination) {
            this.m_names[column] = this.rBundle.getString("Graph As");
            block31: for (i = 0; i < this.m_markerType.length; ++i) {
                switch (this.m_markerType[i]) {
                    case 0: {
                        this.m_data[i][column] = this.m_auto;
                        continue block31;
                    }
                    case 1: {
                        this.m_data[i][column] = this.rBundle.getString("SeriesBar");
                        continue block31;
                    }
                    case 2: {
                        this.m_data[i][column] = this.rBundle.getString("SeriesLine");
                        continue block31;
                    }
                    case 3: {
                        this.m_data[i][column] = this.rBundle.getString("SeriesArea");
                        continue block31;
                    }
                    case 4: {
                        this.m_data[i][column] = this.rBundle.getString("CurveLine");
                        continue block31;
                    }
                    case 5: {
                        this.m_data[i][column] = this.rBundle.getString("SteppedLine");
                        continue block31;
                    }
                    case 6: {
                        this.m_data[i][column] = this.rBundle.getString("CenteredSteppedLine");
                    }
                }
            }
            ++column;
        }
        if (this.m_isArea) {
            this.m_names[column] = this.rBundle.getString("Area Type");
            for (i = 0; i < this.m_areaType.length; ++i) {
                this.m_data[i][column] = this.m_areaType[i] == 0 ? this.rBundle.getString("SeriesArea") : this.rBundle.getString("CurveArea");
            }
            ++column;
        }
        if (this.m_isLineType) {
            this.m_names[column] = this.rBundle.getString("Line Type");
            block33: for (i = 0; i < this.m_lineType.length; ++i) {
                switch (this.m_lineType[i]) {
                    case 0: {
                        this.m_data[i][column] = this.rBundle.getString("SeriesLine");
                        continue block33;
                    }
                    case 1: {
                        this.m_data[i][column] = this.rBundle.getString("CurveLine");
                        continue block33;
                    }
                    case 2: {
                        this.m_data[i][column] = this.rBundle.getString("SteppedLine");
                        continue block33;
                    }
                    case 3: {
                        this.m_data[i][column] = this.rBundle.getString("CenteredSteppedLine");
                    }
                }
            }
            ++column;
        }
        if (this.m_isLine) {
            this.m_names[column] = this.rBundle.getString("SeriesLine");
            for (i = 0; i < this.m_lineWidth.length; ++i) {
                this.m_data[i][column] = this.m_lineWidth[i];
            }
            ++column;
        }
        if (this.m_isMarker) {
            this.m_names[column] = this.rBundle.getString("Marker");
            for (i = 0; i < this.m_markerShape.length; ++i) {
                this.m_data[i][column] = this.m_markerShape[i];
            }
            ++column;
        }
        if (this.m_isDualY) {
            this.m_names[column] = this.rBundle.getString("Y-Axis");
            cNumSeperator = ((DecimalFormat)this.m_numFormat).getDecimalFormatSymbols().getDecimalSeparator() == ',' ? 59 : 44;
            this.m_y1 = this.m_graph.getY1Title().getText().equals("") != false || this.m_graph.getY1Title().isVisible() == false ? this.rBundle.getString("Y1") : this.rBundle.getString("Y1") + "(" + this.m_graph.getY1Title().getText() + ")";
            this.m_y2 = this.m_graph.getY2Title().getText().equals("") != false || this.m_graph.getY2Title().isVisible() == false ? this.rBundle.getString("Y2") : this.rBundle.getString("Y2") + "(" + this.m_graph.getY2Title().getText() + ")";
            for (i = 0; i < this.m_assignToY2.length; ++i) {
                this.m_data[i][column] = this.m_assignToY2[i] == 1 ? this.m_y2 : (this.m_assignToY2[i] == 0 ? this.m_y1 : this.m_auto);
            }
            ++column;
        }
        if (this.m_isFitline) {
            this.m_names[column] = this.rBundle.getString("Fitline");
            block37: for (i = 0; i < this.m_fitlineType.length; ++i) {
                switch (this.m_fitlineType[i]) {
                    case 0: {
                        this.m_data[i][column] = this.rBundle.getString("None");
                        continue block37;
                    }
                    case 1: {
                        this.m_data[i][column] = this.rBundle.getString("Linear");
                        continue block37;
                    }
                    case 5: {
                        this.m_data[i][column] = this.rBundle.getString("Logarithmic");
                        continue block37;
                    }
                    case 8: {
                        this.m_data[i][column] = this.rBundle.getString("Exponential");
                    }
                }
            }
        }
    }

    private Icon _getColorIcon(Image image) {
        this._filter.setColor();
        Image newImage = Series._createFilteredImage(image, this._filter);
        return new ImageIcon(newImage);
    }

    private static Image _createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource prod = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    private int _areSeriesSameValueOrAuto(int column) {
        int valueSame;
        block38: {
            valueSame = 1;
            if (this.m_seriesCount == 0) {
                return valueSame;
            }
            int count = this.m_dataChanged[0][column] ? this.m_seriesCount : this.m_graph.getSeriesObjectCount();
            try {
                if (column == this.m_colorCol) {
                    int i;
                    Color tmpColor1 = (Color)this.m_table.getValueAt(1, this.m_colorCol);
                    for (i = 0; i < count - 1; ++i) {
                        Color tmpColor2 = i + 1 < this.m_seriesCount ? (Color)this.m_table.getValueAt(i + 2, this.m_colorCol) : this.m_graph.getSeries().getColor(i + 1);
                        if (tmpColor1 != tmpColor2) {
                            valueSame = 0;
                            break;
                        }
                        tmpColor1 = tmpColor2;
                    }
                    if (valueSame == 0) {
                        Color color;
                        i = 0;
                        for (i = 0; i < count && (color = i < this.m_seriesCount ? (Color)this.m_table.getValueAt(i + 1, this.m_colorCol) : this.m_graph.getSeries().getColor(i)).getRGB() == ((Color)Attr.SeriesFillColor[i % 30].getDefault()).getRGB(); ++i) {
                        }
                        if (i == count) {
                            valueSame = -1;
                        }
                    }
                    break block38;
                }
                if (column == this.m_lineCol) {
                    int tmpWidth1 = new Integer(this.m_table.getValueAt(1, this.m_lineCol).toString());
                    for (int i = 0; i < count - 1; ++i) {
                        int tmpWidth2 = i + 1 < this.m_seriesCount ? new Integer(this.m_table.getValueAt(i + 2, this.m_lineCol).toString()).intValue() : this.m_graph.getSeries().getLineWidth(i + 1);
                        if (tmpWidth1 != tmpWidth2) {
                            valueSame = 0;
                            break block38;
                        }
                        tmpWidth1 = tmpWidth2;
                    }
                    break block38;
                }
                if (column == this.m_lineTypeCol) {
                    int tmpType1 = this._getLineType(this.m_table.getValueAt(1, this.m_lineTypeCol).toString());
                    for (int i = 0; i < count - 1; ++i) {
                        int tmpType2 = i + 1 < this.m_seriesCount ? this._getLineType(this.m_table.getValueAt(i + 2, this.m_lineTypeCol).toString()) : this.m_graph.getSeries().getMarkerType(i + 1);
                        if (tmpType1 != tmpType2) {
                            valueSame = 0;
                            break block38;
                        }
                        tmpType1 = tmpType2;
                    }
                    break block38;
                }
                if (column == this.m_areaTypeCol) {
                    int tmpType1 = this._getAreaType(this.m_table.getValueAt(1, this.m_areaTypeCol).toString());
                    for (int i = 0; i < count - 1; ++i) {
                        int tmpType2 = i + 1 < this.m_seriesCount ? this._getAreaType(this.m_table.getValueAt(i + 2, this.m_areaTypeCol).toString()) : this.m_graph.getSeries().getMarkerType(i + 1);
                        if (tmpType1 != tmpType2) {
                            valueSame = 0;
                            break block38;
                        }
                        tmpType1 = tmpType2;
                    }
                    break block38;
                }
                if (column == this.m_markerTypeCol) {
                    int i;
                    int tmpType1 = this._getMarkerType(this.m_table.getValueAt(1, this.m_markerTypeCol).toString());
                    for (i = 0; i < count - 1; ++i) {
                        int tmpType2 = i + 1 < this.m_seriesCount ? this._getMarkerType(this.m_table.getValueAt(i + 2, this.m_markerTypeCol).toString()) : this.m_graph.getSeries().getMarkerType(i + 1);
                        if (tmpType1 != tmpType2) {
                            valueSame = 0;
                            break;
                        }
                        tmpType1 = tmpType2;
                    }
                    if (valueSame == 0) {
                        int tmpMarkerType;
                        i = 0;
                        for (i = 0; i < count && (tmpMarkerType = i < this.m_seriesCount ? this._getMarkerType(this.m_table.getValueAt(i + 1, this.m_markerTypeCol).toString()) : this.m_graph.getSeries().getMarkerType(i)) == markerTypes[i % 3]; ++i) {
                        }
                        if (i == count) {
                            valueSame = -1;
                        }
                    }
                    break block38;
                }
                if (column == this.m_markerShapeCol) {
                    int tmpShape;
                    int tmpShape1 = new Integer(this.m_table.getValueAt(1, this.m_markerShapeCol).toString());
                    for (int i = 0; i < count - 1; ++i) {
                        int tmpShape2 = i + 1 < this.m_seriesCount ? new Integer(this.m_table.getValueAt(i + 2, this.m_markerShapeCol).toString()).intValue() : this.m_graph.getSeries().getMarkerShape(i + 1);
                        if (tmpShape1 != tmpShape2) {
                            valueSame = 0;
                            break;
                        }
                        tmpShape1 = tmpShape2;
                    }
                    int j = 0;
                    for (j = 0; j < count && (tmpShape = j < this.m_seriesCount ? new Integer(this.m_table.getValueAt(j + 1, this.m_markerShapeCol).toString()).intValue() : this.m_graph.getSeries().getMarkerShape(j)) == this.m_graph.getPFJ().getLoopedMarkerShape(j); ++j) {
                    }
                    if (j == count) {
                        valueSame = -1;
                    }
                    break block38;
                }
                if (column == this.m_fitlineCol) {
                    int tmpType1 = this._getFitlineType(this.m_table.getValueAt(1, this.m_fitlineCol).toString());
                    for (int i = 0; i < count - 1; ++i) {
                        int tmpType2 = i + 1 < this.m_seriesCount ? this._getFitlineType(this.m_table.getValueAt(i + 2, this.m_fitlineCol).toString()) : this.m_graph.getSeries().getFitlineType(i + 1);
                        if (tmpType1 != tmpType2) {
                            valueSame = 0;
                            break block38;
                        }
                        tmpType1 = tmpType2;
                    }
                    break block38;
                }
                if (column == this.m_yAxisCol) {
                    boolean tmpAxis1 = this.m_table.getValueAt(1, this.m_yAxisCol).toString().equals(this.m_y2);
                    for (int i = 0; i < count - 1; ++i) {
                        boolean tmpAxis2 = i + 1 < this.m_seriesCount ? this.m_table.getValueAt(i + 2, this.m_yAxisCol).toString().equals(this.m_y2) : this.m_graph.getSeries().isAssignedToY2(i + 1);
                        if (tmpAxis1 != tmpAxis2) {
                            valueSame = 0;
                            break;
                        }
                        tmpAxis1 = tmpAxis2;
                    }
                    if (valueSame == 0) {
                        int j = 0;
                        for (j = 0; j < count; ++j) {
                            boolean tmpAxis = j < this.m_seriesCount ? this.m_table.getValueAt(j + 1, this.m_yAxisCol).toString().equals(this.m_y2) : this.m_graph.getSeries().isAssignedToY2(j);
                            if (j == 1 && !tmpAxis || j != 1 && tmpAxis) break;
                        }
                        if (j == count) {
                            valueSame = -1;
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return valueSame;
    }

    public void apply() {
        Object icon = null;
        try {
            if (!this.m_isPareto) {
                String str1;
                int i;
                int i2;
                int offset;
                boolean allSeries = this._isAllSeriesSupported();
                int n = offset = allSeries ? 1 : 0;
                if (allSeries && this.m_dataChanged[0][this.m_colorCol]) {
                    this.m_graph.getSeries().setDefaultColor((Color)this.m_defaultColor);
                }
                if (!allSeries || this.m_table.getValueAt(0, this.m_colorCol) != null && this.m_table.getValueAt(0, this.m_colorCol).toString() == "") {
                    for (i2 = 0; i2 < this.m_seriesCount; ++i2) {
                        if (!this.m_dataChanged[i2 + offset][this.m_colorCol]) continue;
                        this.m_graph.getSeries().setColor((Color)this.m_table.getValueAt(i2 + offset, this.m_colorCol), i2);
                    }
                }
                if (this.m_isLineType) {
                    String str = this.m_table.getValueAt(0, this.m_lineTypeCol).toString();
                    if (allSeries && this.m_dataChanged[0][this.m_lineTypeCol]) {
                        this.m_graph.getSeries().setDefaultMarkerType(this._getLineType(this.m_defaultLineType.toString()));
                    }
                    if (!allSeries || str == "") {
                        for (i = 0; i < this.m_seriesCount; ++i) {
                            if (!this.m_dataChanged[i + offset][this.m_lineTypeCol]) continue;
                            str1 = this.m_table.getValueAt(i + offset, this.m_lineTypeCol).toString();
                            this.m_graph.getSeries().setMarkerType(this._getLineType(str1), i);
                        }
                    }
                }
                if (this.m_isLine) {
                    if (allSeries && this.m_dataChanged[0][this.m_lineCol]) {
                        if (new Integer(this.m_defaultLineWidth.toString()) == 0) {
                            this.m_graph.setLineDataLineDisplayed(false);
                        } else {
                            this.m_graph.setLineDataLineDisplayed(true);
                            this.m_graph.getSeries().setDefaultLineWidth(new Integer(this.m_defaultLineWidth.toString()).intValue());
                        }
                    }
                    if (!allSeries || this.m_table.getValueAt(0, this.m_lineCol).toString() == "") {
                        for (i2 = 0; i2 < this.m_seriesCount; ++i2) {
                            if (!this.m_dataChanged[i2 + offset][this.m_lineCol]) continue;
                            this.m_graph.getSeries().setLineWidth(new Integer(this.m_table.getValueAt(i2 + offset, this.m_lineCol).toString()).intValue(), i2);
                        }
                    }
                }
                if (this.m_isArea) {
                    String str = this.m_table.getValueAt(0, this.m_areaTypeCol).toString();
                    if (allSeries && this.m_dataChanged[0][this.m_areaTypeCol]) {
                        this.m_graph.getSeries().setDefaultMarkerType(this._getAreaType(this.m_defaultAreaType.toString()));
                    }
                    if (!allSeries || str == "") {
                        for (i = 0; i < this.m_seriesCount; ++i) {
                            if (!this.m_dataChanged[i + offset][this.m_areaTypeCol]) continue;
                            str1 = this.m_table.getValueAt(i + offset, this.m_areaTypeCol).toString();
                            this.m_graph.getSeries().setMarkerType(this._getAreaType(str1), i);
                        }
                    }
                }
                if (this.m_isMarker) {
                    if (allSeries && this.m_dataChanged[0][this.m_markerShapeCol]) {
                        if (this.m_table.getValueAt(0, this.m_markerShapeCol).toString().equals("0") && (this.m_graphType >= 41 && this.m_graphType <= 54 || this.m_graphType == 67 || this.m_isCombination)) {
                            this.m_graph.setMarkerDisplayed(false);
                        } else {
                            this.m_graph.setMarkerDisplayed(true);
                        }
                        this.m_graph.getSeries().setDefaultMarkerShape(Integer.parseInt(this.m_defaultMarkerShape.toString()));
                    }
                    if (!allSeries || this.m_table.getValueAt(0, this.m_markerShapeCol).toString() == "") {
                        if (!this.m_graph.isMarkerDisplayed() && (this.m_graphType >= 41 && this.m_graphType <= 54 || this.m_graphType == 67 || this.m_isCombination)) {
                            this.m_graph.setMarkerDisplayed(true);
                        }
                        for (int i3 = 0; i3 < this.m_seriesCount; ++i3) {
                            if (!this.m_dataChanged[i3 + offset][this.m_markerShapeCol]) continue;
                            this.m_graph.getSeries().setMarkerShape(Integer.parseInt(this.m_table.getValueAt(i3 + offset, this.m_markerShapeCol).toString()), i3);
                        }
                    }
                }
                if (this.m_isDualY) {
                    if (allSeries && this.m_dataChanged[0][this.m_yAxisCol]) {
                        if (this.m_defaultYAxis.toString().equals(this.m_auto)) {
                            this.m_graph.getSeries().setDefaultAssignedToY2(2);
                        } else if (this.m_defaultYAxis.toString().equals(this.m_y1)) {
                            this.m_graph.getSeries().setDefaultAssignedToY2(0);
                        } else {
                            this.m_graph.getSeries().setDefaultAssignedToY2(1);
                        }
                    }
                    if (!allSeries || this.m_table.getValueAt(0, this.m_yAxisCol).toString() == "") {
                        for (int i4 = 0; i4 < this.m_seriesCount; ++i4) {
                            if (!this.m_dataChanged[i4 + offset][this.m_yAxisCol]) continue;
                            if (this.m_table.getValueAt(i4 + offset, this.m_yAxisCol).toString().equals(this.m_y1)) {
                                this.m_graph.getSeries().setAssignedToY2(false, i4);
                                continue;
                            }
                            this.m_graph.getSeries().setAssignedToY2(true, i4);
                        }
                    }
                }
                if (this.m_isCombination) {
                    String str = this.m_table.getValueAt(0, this.m_markerTypeCol).toString();
                    if (allSeries && this.m_dataChanged[0][this.m_markerTypeCol]) {
                        if (this.m_defaultMarkerType.toString() == this.m_auto) {
                            this.m_graph.getSeries().setDefaultMarkerType(0);
                            for (i = 0; i < this.m_graph.getSeriesObjectCount(); ++i) {
                                this.m_graph.getSeries().setMarkerType(markerTypes[i % 3], i);
                            }
                        } else {
                            this.m_graph.getSeries().setDefaultMarkerType(this._getMarkerType(this.m_defaultMarkerType.toString()));
                        }
                    }
                    if (!allSeries || str == "") {
                        for (i = 0; i < this.m_seriesCount; ++i) {
                            if (!this.m_dataChanged[i + offset][this.m_markerTypeCol]) continue;
                            str1 = this.m_table.getValueAt(i + offset, this.m_markerTypeCol).toString();
                            this.m_graph.getSeries().setMarkerType(this._getMarkerType(str1), i);
                        }
                    }
                }
                if (this.m_isFitline) {
                    if (allSeries && this.m_dataChanged[0][this.m_fitlineCol]) {
                        this.m_graph.getSeries().setDefaultFitlineType(this._getFitlineType(this.m_defaultFitline.toString()));
                    }
                    if (!allSeries || this.m_table.getValueAt(0, this.m_fitlineCol).toString() == "") {
                        for (int i5 = 0; i5 < this.m_seriesCount; ++i5) {
                            if (!this.m_dataChanged[i5 + offset][this.m_fitlineCol]) continue;
                            String str = this.m_table.getValueAt(i5 + offset, this.m_fitlineCol).toString();
                            this.m_graph.getSeries().setFitlineType(this._getFitlineType(str), i5);
                        }
                    }
                }
            } else {
                this.m_graph.getSeries().setColor((Color)this.m_table.getValueAt(0, 1), 0);
                this.m_graph.getParetoLine().setColor((Color)this.m_table.getValueAt(1, 1));
                if (this.m_lineCol != -1) {
                    this.m_graph.getParetoLine().setWidth(new Integer(this.m_table.getValueAt(1, this.m_lineCol).toString()).intValue());
                }
                if (this.m_markerShapeCol != -1 && this.m_dataChanged[1][this.m_markerShapeCol]) {
                    if (this.m_table.getValueAt(1, this.m_markerShapeCol).toString().equals("0")) {
                        this.m_graph.setMarkerDisplayed(false);
                    } else {
                        this.m_graph.setMarkerDisplayed(true);
                        this.m_graph.getParetoLine().setMarkerShape(new Integer(this.m_table.getValueAt(1, this.m_markerShapeCol).toString()).intValue());
                    }
                }
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
    }

    protected class SeriesJTable
    extends JTable
    implements TableModelListener {
        public SeriesJTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public boolean editCellAt(int row, int column) {
            if (!Series.this.editorFocus) {
                return false;
            }
            return super.editCellAt(row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            int markerType;
            if (column == 0 || column > Series.this.m_numUsedCols - 1) {
                return false;
            }
            if (!Series.this.m_showDataMarker && column == Series.this.m_markerShapeCol) {
                return false;
            }
            if (column == Series.this.m_lineCol && row > 0 && Series.this.m_lineNone) {
                return false;
            }
            if (Series.this.m_graph.getGraphType() == 96 && (column == 0 || column == Series.this.m_yAxisCol || row == 0 && (column == Series.this.m_lineCol || column == Series.this.m_markerShapeCol))) {
                return false;
            }
            return Series.this.m_markerTypeCol == -1 || column != Series.this.m_markerShapeCol && column != Series.this.m_lineCol || (markerType = Series.this._getMarkerType(Series.this.m_table.getValueAt(row, Series.this.m_markerTypeCol).toString())) != 1 && markerType != 3;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (!Series.this._isAllSeriesSupported()) {
                return super.getCellEditor(row, col);
            }
            if (col == Series.this.m_markerShapeCol && row == 0) {
                return Series.this.defaultMarkerCellEditor;
            }
            if (col == Series.this.m_lineCol && row == 0) {
                return Series.this.defaultLineCellEditor;
            }
            if (col == Series.this.m_markerTypeCol && row == 0) {
                return Series.this.defaultMarkerTypeEditor;
            }
            if (col == Series.this.m_colorCol && row == 0) {
                return Series.this.defaultColorEditor;
            }
            if (col == Series.this.m_yAxisCol && row == 0) {
                return Series.this.defaultYAxisEditor;
            }
            return super.getCellEditor(row, col);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            if (e.getFirstRow() == e.getLastRow() && e.getColumn() >= 0) {
                if (!Series.this._isAllSeriesSupported()) {
                    Series.this.m_dataChanged[e.getFirstRow()][e.getColumn()] = true;
                    return;
                }
                if (e.getFirstRow() == 0) {
                    if (!Series.this._flag2) {
                        return;
                    }
                    if (this.getValueAt(0, e.getColumn()) == "") {
                        return;
                    }
                    Series.this.m_dataChanged[e.getFirstRow()][e.getColumn()] = true;
                    Series.this._flag = false;
                    if (e.getColumn() == Series.this.m_markerShapeCol) {
                        Series.this.m_defaultMarkerShape = this.getValueAt(0, Series.this.m_markerShapeCol);
                        if (Integer.parseInt((String)this.getValueAt(0, Series.this.m_markerShapeCol)) != -1) {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt(this.getValueAt(0, Series.this.m_markerShapeCol), i, Series.this.m_markerShapeCol);
                                Series.this.m_dataChanged[i][Series.this.m_markerShapeCol] = false;
                            }
                        } else {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt(new Integer(Series.this.m_graph.getPFJ().getLoopedMarkerShape(i - 1)), i, Series.this.m_markerShapeCol);
                                Series.this.m_dataChanged[i][Series.this.m_markerShapeCol] = false;
                            }
                        }
                    } else if (e.getColumn() == Series.this.m_colorCol) {
                        Series.this.m_defaultColor = this.getValueAt(0, Series.this.m_colorCol);
                        if (this.getValueAt(0, Series.this.m_colorCol) instanceof Color) {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt((Color)this.getValueAt(0, Series.this.m_colorCol), i, Series.this.m_colorCol);
                                Series.this.m_dataChanged[i][Series.this.m_colorCol] = false;
                            }
                        } else if (Series.this.autoColor.isAutomaticSelected()) {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt((Color)Attr.SeriesFillColor[(i - 1) % 30].getDefault(), i, Series.this.m_colorCol);
                                Series.this.m_dataChanged[i][Series.this.m_colorCol] = false;
                            }
                        } else {
                            this.setValueAt("", 0, Series.this.m_colorCol);
                        }
                    } else if (e.getColumn() == Series.this.m_markerTypeCol) {
                        Series.this.m_defaultMarkerType = this.getValueAt(0, Series.this.m_markerTypeCol);
                        if (this.getValueAt(0, Series.this.m_markerTypeCol) != Series.this.m_auto) {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt(this.getValueAt(0, Series.this.m_markerTypeCol), i, Series.this.m_markerTypeCol);
                                Series.this.m_dataChanged[i][Series.this.m_markerTypeCol] = false;
                            }
                        } else {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt(Series.this._getMarkerTypeString(markerTypes[(i - 1) % 3]), i, Series.this.m_markerTypeCol);
                                Series.this.m_dataChanged[i][Series.this.m_markerTypeCol] = false;
                            }
                        }
                        this.repaint();
                    } else if (e.getColumn() == Series.this.m_yAxisCol) {
                        Series.this.m_defaultYAxis = this.getValueAt(0, Series.this.m_yAxisCol);
                        if (this.getValueAt(0, Series.this.m_yAxisCol) == Series.this.m_auto) {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                if (i == 2) {
                                    this.setValueAt(Series.this.m_y2, i, Series.this.m_yAxisCol);
                                } else {
                                    this.setValueAt(Series.this.m_y1, i, Series.this.m_yAxisCol);
                                }
                                Series.this.m_dataChanged[i][Series.this.m_yAxisCol] = false;
                            }
                        } else {
                            for (int i = 1; i < this.getRowCount(); ++i) {
                                this.setValueAt(this.getValueAt(0, Series.this.m_yAxisCol), i, Series.this.m_yAxisCol);
                                Series.this.m_dataChanged[i][Series.this.m_yAxisCol] = false;
                            }
                        }
                    } else if (e.getColumn() == Series.this.m_lineTypeCol) {
                        Series.this.m_defaultLineType = this.getValueAt(0, Series.this.m_lineTypeCol);
                        for (int i = 1; i < this.getRowCount(); ++i) {
                            this.setValueAt(this.getValueAt(0, Series.this.m_lineTypeCol), i, Series.this.m_lineTypeCol);
                            Series.this.m_dataChanged[i][Series.this.m_lineTypeCol] = false;
                        }
                    } else if (e.getColumn() == Series.this.m_areaTypeCol) {
                        Series.this.m_defaultAreaType = this.getValueAt(0, Series.this.m_areaTypeCol);
                        for (int i = 1; i < this.getRowCount(); ++i) {
                            this.setValueAt(this.getValueAt(0, Series.this.m_areaTypeCol), i, Series.this.m_areaTypeCol);
                            Series.this.m_dataChanged[i][Series.this.m_areaTypeCol] = false;
                        }
                    } else if (e.getColumn() == Series.this.m_lineCol) {
                        for (int i = 1; i < this.getRowCount(); ++i) {
                            this.setValueAt(this.getValueAt(0, Series.this.m_lineCol), i, Series.this.m_lineCol);
                            Series.this.m_dataChanged[i][Series.this.m_lineCol] = false;
                        }
                        Series.this.m_defaultLineWidth = this.getValueAt(0, Series.this.m_lineCol);
                    } else if (e.getColumn() == Series.this.m_fitlineCol) {
                        for (int i = 1; i < this.getRowCount(); ++i) {
                            this.setValueAt(this.getValueAt(0, Series.this.m_fitlineCol), i, Series.this.m_fitlineCol);
                            Series.this.m_dataChanged[i][Series.this.m_fitlineCol] = false;
                        }
                        Series.this.m_defaultFitline = this.getValueAt(0, Series.this.m_fitlineCol);
                    }
                    Series.this._flag = true;
                } else {
                    if (!Series.this._isAllSeriesSupported()) {
                        return;
                    }
                    Series.this.m_dataChanged[e.getFirstRow()][e.getColumn()] = true;
                    if (!Series.this._flag) {
                        return;
                    }
                    Series.this._flag2 = false;
                    int value = Series.this._areSeriesSameValueOrAuto(e.getColumn());
                    if (value == 0) {
                        this.setValueAt("", 0, e.getColumn());
                        if (e.getColumn() == Series.this.m_colorCol && Series.this.autoColor.isAutomaticSelected()) {
                            Series.this.autoColor.setAutomaticSelected(false);
                        }
                    } else if (value == -1) {
                        if (Series.this.m_previousData[e.getColumn()] == null || !this.getValueAt(e.getFirstRow(), e.getColumn()).toString().equals(Series.this.m_previousData[e.getColumn()].toString())) {
                            this.setValueAt("", 0, e.getColumn());
                            if (e.getColumn() == Series.this.m_colorCol) {
                                Series.this.autoColor.setAutomaticSelected(false);
                            }
                        }
                    } else if (e.getColumn() == Series.this.m_colorCol) {
                        if (this.getValueAt(1, Series.this.m_colorCol) == Series.this.m_defaultColor || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultColor = this.getValueAt(1, Series.this.m_colorCol);
                            this.setValueAt(Series.this.m_defaultColor, 0, Series.this.m_colorCol);
                            Series.this.m_dataChanged[0][Series.this.m_colorCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_colorCol);
                        }
                    } else if (e.getColumn() == Series.this.m_markerTypeCol) {
                        if (this.getValueAt(1, Series.this.m_markerTypeCol).toString().equals(Series.this.m_defaultMarkerType.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultMarkerType = this.getValueAt(1, Series.this.m_markerTypeCol);
                            this.setValueAt(Series.this.m_defaultMarkerType, 0, Series.this.m_markerTypeCol);
                            Series.this.m_dataChanged[0][Series.this.m_markerTypeCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_markerTypeCol);
                        }
                    } else if (e.getColumn() == Series.this.m_lineTypeCol) {
                        if (this.getValueAt(1, Series.this.m_lineTypeCol).toString().equals(Series.this.m_defaultLineType.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultLineType = this.getValueAt(1, Series.this.m_lineTypeCol);
                            this.setValueAt(Series.this.m_defaultLineType, 0, Series.this.m_lineTypeCol);
                            Series.this.m_dataChanged[0][Series.this.m_lineTypeCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_lineTypeCol);
                        }
                    } else if (e.getColumn() == Series.this.m_areaTypeCol) {
                        if (this.getValueAt(1, Series.this.m_areaTypeCol).toString().equals(Series.this.m_defaultAreaType.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultAreaType = this.getValueAt(1, Series.this.m_areaTypeCol);
                            this.setValueAt(Series.this.m_defaultAreaType, 0, Series.this.m_areaTypeCol);
                            Series.this.m_dataChanged[0][Series.this.m_areaTypeCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_areaTypeCol);
                        }
                    } else if (e.getColumn() == Series.this.m_markerShapeCol) {
                        if (this.getValueAt(1, Series.this.m_markerShapeCol).toString().equals(Series.this.m_defaultMarkerShape.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultMarkerShape = this.getValueAt(1, Series.this.m_markerShapeCol);
                            this.setValueAt(Series.this.m_defaultMarkerShape, 0, Series.this.m_markerShapeCol);
                            Series.this.m_dataChanged[0][Series.this.m_markerShapeCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_markerShapeCol);
                        }
                    } else if (e.getColumn() == Series.this.m_lineCol) {
                        if (this.getValueAt(1, Series.this.m_lineCol).toString().equals(Series.this.m_defaultLineWidth.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultLineWidth = this.getValueAt(1, Series.this.m_lineCol);
                            this.setValueAt(Series.this.m_defaultLineWidth, 0, Series.this.m_lineCol);
                            Series.this.m_dataChanged[0][Series.this.m_lineCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_lineCol);
                        }
                    } else if (e.getColumn() == Series.this.m_fitlineCol) {
                        if (this.getValueAt(1, Series.this.m_fitlineCol).toString().equals(Series.this.m_defaultFitline.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultFitline = this.getValueAt(1, Series.this.m_fitlineCol);
                            this.setValueAt(Series.this.m_defaultFitline, 0, Series.this.m_fitlineCol);
                            Series.this.m_dataChanged[0][Series.this.m_fitlineCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_fitlineCol);
                        }
                    } else if (e.getColumn() == Series.this.m_yAxisCol) {
                        if (this.getValueAt(1, Series.this.m_yAxisCol).toString().equals(Series.this.m_defaultYAxis.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultYAxis = this.getValueAt(1, Series.this.m_yAxisCol);
                            this.setValueAt(Series.this.m_defaultYAxis, 0, Series.this.m_yAxisCol);
                            Series.this.m_dataChanged[0][Series.this.m_yAxisCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_yAxisCol);
                        }
                    }
                    if (e.getColumn() == Series.this.m_markerTypeCol) {
                        this.repaint();
                    }
                    Series.this._flag2 = true;
                }
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
            int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (e.getKeyCode() == 9 || e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                if (e.getKeyCode() == 9) {
                    if (anchorColumn == this.getColumnCount() - 1 && anchorRow == this.getRowCount() - 1 && !e.isShiftDown() && e.getID() != 402) {
                        this.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
                        this.requestFocus();
                        if (FocusManager.isFocusManagerEnabled()) {
                            FocusManager.getCurrentManager().focusNextComponent(this);
                            e.consume();
                        }
                        return;
                    }
                    if (anchorColumn == 0 && anchorRow == 0 && e.isShiftDown() && e.getID() != 402) {
                        if (FocusManager.isFocusManagerEnabled()) {
                            FocusManager.getCurrentManager().focusPreviousComponent(this);
                            e.consume();
                        }
                        return;
                    }
                }
            } else if (e.getKeyCode() == 32 && anchorColumn != 0 && this.isCellEditable(anchorRow, anchorColumn)) {
                Series.this.editorFocus = true;
                this.editCellAt(anchorRow, anchorColumn);
                this.getEditorComponent().requestFocus();
                if (this.getEditorComponent() instanceof JComboBox) {
                    this.getEditorComponent().setVisible(true);
                    ((JComboBox)this.getEditorComponent()).showPopup();
                }
            }
            super.processKeyEvent(e);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1005 && !e.isTemporary() && Series.this.editorFocus) {
                Series.this.editorFocus = false;
            }
            super.processFocusEvent(e);
        }
    }

    class ColorEditor
    extends DefaultCellEditor
    implements PropertyChangeListener,
    FocusListener {
        BIColorChoice colorChoice;
        Color currentColor;
        boolean lookForSelectionEvent;

        public ColorEditor(BIColorChoice b) {
            super(new JCheckBox());
            this.currentColor = null;
            this.editorComponent = b;
            this.colorChoice = b;
            this.setClickCountToStart(1);
            b.addPropertyChangeListener(this);
            b.addFocusListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("popupVisible") && e.getNewValue().equals(Boolean.TRUE)) {
                this.lookForSelectionEvent = true;
            }
            if (this.lookForSelectionEvent && (e.getPropertyName().equals("selectedColor") || e.getPropertyName().equals("selectedColor"))) {
                this.currentColor = this.colorChoice.getSelectedColor();
                this._stopCellEditing();
            }
        }

        private void _stopCellEditing() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ColorEditor.this.colorChoice.isPopupVisible()) {
                        Component c = SwingUtilities.findFocusOwner(WindowUtils.getWindow((Component)((Object)ColorEditor.this.colorChoice)));
                        ColorEditor.this.stopCellEditing();
                        if (c != null && c.isShowing()) {
                            c.requestFocus();
                        }
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.colorChoice == null) {
                return null;
            }
            if (value != null && value.toString() == "") {
                value = null;
            }
            if (Series.this._isAllSeriesSupported() && row != 0) {
                Series.this.m_previousData[column] = value;
            }
            this.currentColor = value instanceof Color ? (Color)value : null;
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.colorChoice.getColorPalette(), (Color)this.currentColor)) {
                this.colorChoice.setColorPalette(FontButton.getNewColorPalette(this.colorChoice.getColorPalette(), this.currentColor, Series.this.m_bColorPaletteSet));
            }
            this.colorChoice.setSelectedColor(this.currentColor);
            return this.colorChoice;
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            return !(e instanceof MouseEvent) || ((MouseEvent)e).getID() != 506;
        }

        @Override
        public boolean stopCellEditing() {
            boolean stopEditing = super.stopCellEditing();
            if (stopEditing) {
                this.lookForSelectionEvent = false;
            }
            return stopEditing;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                Series.this.editorFocus = true;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && Series.this.editorFocus) {
                Series.this.editorFocus = false;
                this._stopCellEditing();
            }
        }
    }

    private class YAxisLabelRenderer
    extends LabelRenderer {
        private YAxisLabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                renderer.setText(Series.this._truncateText(value.toString()));
            }
            return renderer;
        }
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        private LabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            renderer.setBackground(Color.white);
            renderer.setForeground(Color.black);
            if (isSelected) {
                this.setBorder(new LineBorder(Color.black, 2));
            }
            return renderer;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String renderedColor = Series.this.rBundle.getString("Color Rendered");
            MessageFormat mf = new MessageFormat(renderedColor);
            if (value == null) {
                if (Series.this.autoColor.isAutomaticSelected()) {
                    this.setText(Series.this.m_auto);
                    this.getAccessibleContext().setAccessibleName(this.getText());
                } else {
                    this.setText("");
                    Object[] args = new Object[]{IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255)};
                    this.getAccessibleContext().setAccessibleName(mf.format(args));
                }
                this.setBackground(Color.white);
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()));
            } else {
                this.setText("");
                CompoundBorder border = new CompoundBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground()), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
                if (value instanceof Color) {
                    Color colorRendered = (Color)value;
                    this.setBackground(colorRendered);
                    Object[] args = new Object[]{IntegerUtils.getInteger((int)colorRendered.getRed()), IntegerUtils.getInteger((int)colorRendered.getGreen()), IntegerUtils.getInteger((int)colorRendered.getBlue())};
                    this.getAccessibleContext().setAccessibleName(mf.format(args));
                    this.setBorder(border);
                } else {
                    this.setBackground(Color.white);
                    Object[] args = new Object[]{IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255)};
                    this.getAccessibleContext().setAccessibleName(mf.format(args));
                    this.setBorder(null);
                }
            }
            if (this.isBordered && isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                }
                this.setBorder(this.selectedBorder);
            }
            return this;
        }

        public void cleanUp() {
            this.setBorder(null);
            this.unselectedBorder = null;
            this.selectedBorder = null;
        }
    }

    class LineWidthCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public LineWidthCellRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int width = new Integer(value.toString());
            if (isSelected) {
                this.setBackground(Color.blue);
            } else {
                this.setBackground(list.getBackground());
            }
            if (value == "") {
                this.setText("");
                this.setIcon(null);
            } else if (width == 0) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("None"));
            } else {
                this.setIcon(Series.this._getColorIcon(ImageUtils.getImageResource(LineWidthRenderer.class, (String)("images/Line" + width + ".gif"))));
                if (width == 1) {
                    this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("Single pixel"));
                } else {
                    this.getAccessibleContext().setAccessibleName(MessageFormat.format(Series.this.rBundle.getString("pixels"), new Integer(width)));
                }
            }
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!cellHasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground()));
            }
            return this;
        }
    }

    class LineWidthRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public LineWidthRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int markerType;
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (table.getValueAt(row, column) != null && table.getValueAt(row, column).toString() == "") {
                this.setText("");
                this.setIcon(null);
                this.setBackground(Color.white);
                return this;
            }
            int width = new Integer(table.getValueAt(row, column).toString());
            if (width == 0) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("None"));
            } else {
                this.setIcon(Series.this._getColorIcon(ImageUtils.getImageResource(LineWidthRenderer.class, (String)("images/Line" + width + ".gif"))));
                if (width == 1) {
                    this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("Single pixel"));
                } else {
                    this.getAccessibleContext().setAccessibleName(MessageFormat.format(Series.this.rBundle.getString("pixels"), new Integer(width)));
                }
            }
            if (row > 0) {
                if (Series.this.m_lineNone) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(true);
            }
            if (Series.this.m_markerTypeCol != -1 && ((markerType = Series.this._getMarkerType(Series.this.m_table.getValueAt(row, Series.this.m_markerTypeCol).toString())) == 1 || markerType == 3)) {
                this.setEnabled(false);
            }
            if (this.isEnabled()) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(Series.this.m_table.getTableHeader().getBackground());
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground()));
            }
            return this;
        }
    }

    class MarkerShapeEditor
    extends JLabel
    implements ListCellRenderer {
        public MarkerShapeEditor() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(Color.blue);
            } else {
                this.setBackground(list.getBackground());
            }
            if (value == "") {
                this.setText("");
                this.setIcon(null);
            } else if (value.equals("-1")) {
                this.setText(Series.this.m_auto);
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.m_auto);
            } else if (value.equals("0")) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("None"));
            } else {
                String gifFileName = "";
                int shape = new Integer((String)value);
                this.setText("");
                this.setIcon(Series.this.m_icons[shape - 1]);
                this.getAccessibleContext().setAccessibleName(Series.this._getMarkerShape(shape));
            }
            this.setMinimumSize(new Dimension(50, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(50, this.getPreferredSize().height));
            this.setMaximumSize(new Dimension(50, this.getMaximumSize().height));
            return this;
        }
    }

    class MarkerShapeRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public MarkerShapeRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(Series.this.m_showDataMarker);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (value == null || value == "") {
                this.setText("");
                this.setIcon(null);
                this.setBackground(Color.white);
                return this;
            }
            int shape = new Integer(value.toString());
            if (shape == -1) {
                this.setText(Series.this.m_auto);
                this.setIcon(null);
            } else if (shape == 0) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
            } else {
                this.setText("");
                this.setIcon(Series.this.m_icons[shape - 1]);
                this.getAccessibleContext().setAccessibleName(Series.this._getMarkerShape(shape));
            }
            if (Series.this.m_markerTypeCol != -1) {
                int markerType = Series.this._getMarkerType(Series.this.m_table.getValueAt(row, Series.this.m_markerTypeCol).toString());
                if (markerType == 1 || markerType == 3) {
                    this.setEnabled(false);
                    this.setBackground(Series.this.m_table.getTableHeader().getBackground());
                } else {
                    this.setEnabled(true);
                    this.setBackground(Color.white);
                }
            }
            if (!hasFocus) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground()));
            }
            return this;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor() {
            Color c = Color.black;
            this._color = c == null ? 0 : c.getRGB();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._sCOLOR) {
                return this._color;
            }
            return rgb;
        }
    }

    private class ComboBoxCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        public ComboBoxCellEditor(final JComboBox comboBox) {
            super(comboBox);
            comboBox.addFocusListener(this);
            comboBox.removeActionListener(this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Series.this.m_table.editCellAt(0, 0);
                    ComboBoxCellEditor.this.fireEditingStopped();
                }

                @Override
                public void setValue(Object value) {
                    if (value instanceof Integer) {
                        value = value.toString();
                    }
                    if (value == "") {
                        comboBox.setSelectedIndex(-1);
                    } else {
                        comboBox.setSelectedItem(value);
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    return comboBox.getSelectedItem();
                }
            };
            comboBox.addActionListener(this.delegate);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (Series.this._isAllSeriesSupported() && row != 0) {
                Series.this.m_previousData[column] = value;
            }
            this.delegate.setValue(value);
            return this.editorComponent;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                Series.this.editorFocus = true;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && Series.this.editorFocus) {
                Series.this.editorFocus = false;
                this.stopCellEditing();
            }
        }
    }

    private class LightCombo
    extends JComboBox {
        private ActionListener enterAction;

        public LightCombo() {
            this._init();
        }

        public LightCombo(String[] str) {
            super(str);
            this._init();
        }

        @Override
        public Object getSelectedItem() {
            if (this.getSelectedIndex() == -1) {
                return "";
            }
            return super.getSelectedItem();
        }

        private void _init() {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
            this.enterAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.registerKeyboardAction(this.enterAction, KeyStroke.getKeyStroke(10, 0), 1);
        }

        public void cleanUp() {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            this.enterAction = null;
        }
    }

    private class LineWidthWithBlank
    extends LineWidth {
        private LineWidthWithBlank() {
        }

        @Override
        public Object getSelectedItem() {
            if (this.getSelectedIndex() == -1) {
                return "";
            }
            return super.getSelectedItem();
        }
    }

    private class LineWidthWithBlankAndNone
    extends LineWidthWithBlank {
        public LineWidthWithBlankAndNone() {
            super.insertItemAt(new Integer(0).toString(), 0);
        }
    }
}

