/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.TableCellRenderer;
import oracle.adfdtinternal.model.dvt.util.gui.ViewLabel;
import oracle.dss.dataView.BorderPainter;
import oracle.dss.dataView.gui.DatePanel;
import oracle.dss.dataView.gui.NumberFormatPanel;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gridView.gui.FontPanel;
import oracle.dss.gridView.gui.FormatGeneralPanel;
import oracle.dss.gridView.gui.HeaderFormatGeneralPanel;
import oracle.dss.gridView.gui.RulesPanel;

public class SamplePanel
extends JPanel
implements PropertyChangeListener {
    protected Font m_font = null;
    protected FontPanel m_fontPanel = null;
    protected FormatGeneralPanel m_generalPanel = null;
    protected HeaderFormatGeneralPanel m_headerGeneralPanel = null;
    protected NumberFormatPanel m_numberPanel = null;
    protected DatePanel m_datePanel = null;
    private sampleTable sample = null;
    private myRenderer m_Renderer = null;
    private JLabel m_label;
    private Object[][] data = new Object[][]{{"1234"}, {"9012"}};
    private ViewFormat m_viewFormat = null;
    private ResourceBundle rBundle = null;
    private ResourceBundle rUtilBundle = null;
    private JPanel northPanel = new JPanel();
    private JPanel eastPanel = new JPanel();
    private JPanel westPanel = new JPanel();
    private JPanel m_tmpPanel;
    private int m_numType = 0;
    private char m_thousandSeparator = '\u0000';
    private char m_noThousandSeparator = '\u0000';
    private boolean m_leadingAlignment = false;
    private Color m_initBackground = Color.white;
    private Color m_initForegroundColor = Color.black;
    private int m_initHAlignment = 0;
    private int m_initVAlignment = 0;
    private boolean m_initIsNegRed = false;
    private String m_initDateFormat = null;
    private String m_newDateFormat = null;
    private int m_initLeftWidth = 0;
    private int m_initRightWidth = 0;
    private int m_initTopWidth = 0;
    private int m_initBottomWidth = 0;
    private Color m_initLeftColor = Color.black;
    private Color m_initRightColor = Color.black;
    private Color m_initTopColor = Color.black;
    private Color m_initBottomColor = Color.black;
    private Font m_initFont = null;
    private boolean m_initUnderline = false;
    private boolean m_initStrikeThrough = false;
    private boolean m_bSuperCalled = true;
    private static final int PANEL_GAP = 10;
    private static final Color OUTER_GAP_COLOR = Color.white;
    private static final int CELL_HEIGHT_GAP = 10;
    private static final int EMPTY_BORDER_GAP = 2;
    private static final int CELL_SIDE_GAP = 4;
    private static final int CELL_VERTICAL_GAP = 2;
    private static String[] SampleNumberData = new String[]{"1234", "9012"};
    private static String[] SampleDateData = new String[]{"2001-3-2", "2000-4-5"};
    private static String[] SampleNumberDateData = new String[]{"1234", "2003-2-2"};
    private static final String[] MySampleHeaderData = new String[]{" A", " B"};

    public SamplePanel(FormatGeneralPanel generalPanel, FontPanel fontPanel, NumberFormatPanel numberPanel, RulesPanel rulesPanel) {
        this(generalPanel, fontPanel, numberPanel);
    }

    public SamplePanel(FormatGeneralPanel generalPanel, FontPanel fontPanel, NumberFormatPanel numberPanel) {
        this.tableInit(generalPanel, null, fontPanel, numberPanel, null);
    }

    public SamplePanel(FormatGeneralPanel generalPanel, FontPanel fontPanel, NumberFormatPanel numberPanel, DatePanel datePanel, RulesPanel rulesPanel) {
        this(generalPanel, fontPanel, numberPanel, datePanel);
    }

    public SamplePanel(FormatGeneralPanel generalPanel, FontPanel fontPanel, NumberFormatPanel numberPanel, DatePanel datePanel) {
        this.tableInit(generalPanel, null, fontPanel, numberPanel, datePanel);
    }

    public SamplePanel(FormatGeneralPanel generalPanel, FontPanel fontPanel, DatePanel datePanel, RulesPanel rulesPanel) {
        this(generalPanel, fontPanel, datePanel);
    }

    public SamplePanel(FormatGeneralPanel generalPanel, FontPanel fontPanel, DatePanel datePanel) {
        this.tableInit(generalPanel, null, fontPanel, null, datePanel);
    }

    public SamplePanel(HeaderFormatGeneralPanel headerGeneralPanel, FontPanel fontPanel, RulesPanel rulesPanel) {
        this(headerGeneralPanel, fontPanel);
    }

    public SamplePanel(HeaderFormatGeneralPanel headerGeneralPanel, FontPanel fontPanel) {
        this.tableInit(null, headerGeneralPanel, fontPanel, null, null);
    }

    private void setColumnHAlignment(int hAlignment) {
        this.m_Renderer.setHAlignment(hAlignment);
        this.m_leadingAlignment = false;
        if (hAlignment == 10) {
            this.m_leadingAlignment = true;
            if (this._isLeftHeading()) {
                this.m_Renderer.setHAlignment(2);
            } else {
                this.m_Renderer.setHAlignment(4);
            }
        }
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private boolean _isLeftHeading() {
        Locale loc;
        try {
            loc = super.getLocale();
        }
        catch (Exception eee) {
            loc = null;
        }
        if (loc == null) {
            loc = this.m_viewFormat != null ? this.m_viewFormat.getLocale() : Locale.getDefault();
        }
        if (loc == null) {
            return false;
        }
        String language = loc.getLanguage();
        return !language.equals("ar") && !language.equals("he") && !language.equals("iw");
    }

    private void setColumnVAlignment(int vAlignment) {
        this.m_Renderer.setVAlignment(vAlignment);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setColumnFont(Font font) {
        this.m_font = new Font(font.getName(), font.getStyle(), font.getSize());
        this.m_Renderer.setFont(this.m_font, this.m_fontPanel.isUnderlineStyle(), this.m_fontPanel.isStrikeThroughStyle());
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setFontRules() {
        int fontSize = this.m_initFont.getSize();
        int fontStyle = this.m_initFont.getStyle();
        String fontName = this.m_initFont.getName();
        boolean underline = this.m_initUnderline;
        boolean strikeThrough = this.m_initStrikeThrough;
        fontSize = this.m_fontPanel.getFontSize();
        fontStyle = this.m_fontPanel.getFontPane().getFontStyle();
        underline = this.m_fontPanel.isUnderlineStyle();
        strikeThrough = this.m_fontPanel.isStrikeThroughStyle();
        fontName = this.m_fontPanel.getFontName();
        Font tempFont = new Font(fontName, fontStyle, fontSize);
        this.m_Renderer.setFont(tempFont, underline, strikeThrough);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
        int topWidth = 0;
        int bottomWidth = 0;
        if (this.m_generalPanel != null) {
            topWidth = this.m_generalPanel.getTopWidth();
            bottomWidth = this.m_generalPanel.getBottomWidth();
        } else if (this.m_headerGeneralPanel != null) {
            topWidth = this.m_headerGeneralPanel.getTopWidth();
            bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
        }
        this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
    }

    private void setColumnBackground(Color c) {
        this.sample.setBackground(c);
    }

    private void setColumnForeground(Color c) {
        this.m_Renderer.setForeground(c);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setDataBarsVisible(boolean v) {
        this.m_Renderer.setDataBarsVisible(v);
        this.setDataBarsColor(this.m_generalPanel.getDataBarColor());
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setDataBarsColor(Color c) {
        if (c == null) {
            c = Color.lightGray;
        }
        this.m_Renderer.setDataBarsColor(c);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersOutlineWidth(int width) {
        this.m_Renderer.setOutlineWidth(width);
        int topWidth = 0;
        int bottomWidth = 0;
        if (this.m_generalPanel != null) {
            this.m_Renderer.setOutlineStyle(this.m_generalPanel.getOutlineStyle());
            topWidth = this.m_generalPanel.getTopWidth();
            bottomWidth = this.m_generalPanel.getBottomWidth();
        } else if (this.m_headerGeneralPanel != null) {
            this.m_Renderer.setOutlineStyle(this.m_headerGeneralPanel.getOutlineStyle());
            topWidth = this.m_headerGeneralPanel.getTopWidth();
            bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
        }
        this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersOutlineColor(Color color) {
        this.m_Renderer.setOutlineColor(color);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersLeftLineWidth(int width) {
        this.m_Renderer.setLeftWidth(width);
        if (this.m_generalPanel != null) {
            this.m_Renderer.setLeftStyle(this.m_generalPanel.getLeftStyle());
        } else if (this.m_headerGeneralPanel != null) {
            this.m_Renderer.setLeftStyle(this.m_headerGeneralPanel.getLeftStyle());
        }
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersLeftLineColor(Color color) {
        this.m_Renderer.setLeftColor(color);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersRightLineWidth(int width) {
        this.m_Renderer.setRightWidth(width);
        if (this.m_generalPanel != null) {
            this.m_Renderer.setRightStyle(this.m_generalPanel.getRightStyle());
        } else if (this.m_headerGeneralPanel != null) {
            this.m_Renderer.setRightStyle(this.m_headerGeneralPanel.getRightStyle());
        }
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersRightLineColor(Color color) {
        this.m_Renderer.setRightColor(color);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersTopLineWidth(int width) {
        this.m_Renderer.setTopWidth(width);
        int topWidth = 0;
        int bottomWidth = 0;
        if (this.m_generalPanel != null) {
            this.m_Renderer.setTopStyle(this.m_generalPanel.getTopStyle());
            topWidth = this.m_generalPanel.getTopWidth();
            bottomWidth = this.m_generalPanel.getBottomWidth();
        } else if (this.m_headerGeneralPanel != null) {
            this.m_Renderer.setTopStyle(this.m_headerGeneralPanel.getTopStyle());
            topWidth = this.m_headerGeneralPanel.getTopWidth();
            bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
        }
        this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersTopLineColor(Color color) {
        this.m_Renderer.setTopColor(color);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersBottomLineWidth(int width) {
        this.m_Renderer.setBottomWidth(width);
        int topWidth = 0;
        int bottomWidth = 0;
        if (this.m_generalPanel != null) {
            this.m_Renderer.setBottomStyle(this.m_generalPanel.getBottomStyle());
            topWidth = this.m_generalPanel.getTopWidth();
            bottomWidth = this.m_generalPanel.getBottomWidth();
        } else if (this.m_headerGeneralPanel != null) {
            this.m_Renderer.setBottomStyle(this.m_headerGeneralPanel.getBottomStyle());
            topWidth = this.m_headerGeneralPanel.getTopWidth();
            bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
        }
        this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setBordersBottomLineColor(Color color) {
        this.m_Renderer.setBottomColor(color);
        this.sample.getColumnModel().getColumn(0).setCellRenderer(this.m_Renderer);
    }

    private void setWordWrap(boolean wrap) {
    }

    private void setDecimalPlaces(int numPlaces) {
        this.m_viewFormat.setDecimalDigit(numPlaces);
    }

    private void setThousandSeparator(boolean sep) {
        this.m_viewFormat.setThousandSeparatorUsed(sep);
        if (!sep) {
            this.m_viewFormat.setThousandSeparator(this.m_noThousandSeparator);
        } else {
            this.m_viewFormat.setThousandSeparator(this.m_thousandSeparator);
        }
    }

    private void setScale(boolean scale) {
        this.m_viewFormat.setScaleFactorUsed(scale);
        if (!scale) {
            this.m_viewFormat.setScaleFactor(0);
        } else {
            this.setScaleSign(this.m_numberPanel.getScaleFactor());
        }
    }

    private void setScaleSign(int scale) {
        this.m_viewFormat.setScaleFactor(scale);
        this.setScaleSignMarker(this.m_numberPanel.isShowScaleMark());
    }

    private void setScaleSignMarker(boolean scale) {
        switch (this.m_viewFormat.getScaleFactor()) {
            case 0: {
                break;
            }
            case 1: {
                if (scale) {
                    this.m_viewFormat.setScaleDownThousands(this.rUtilBundle.getString("K"));
                    break;
                }
                this.m_viewFormat.setScaleDownThousands("");
                break;
            }
            case 2: {
                if (scale) {
                    this.m_viewFormat.setScaleDownMillions(this.rUtilBundle.getString("M"));
                    break;
                }
                this.m_viewFormat.setScaleDownMillions("");
                break;
            }
            case 3: {
                if (scale) {
                    this.m_viewFormat.setScaleDownBillions(this.rUtilBundle.getString("B"));
                    break;
                }
                this.m_viewFormat.setScaleDownBillions("");
                break;
            }
            case 4: {
                if (scale) {
                    this.m_viewFormat.setScaleDownTrillions(this.rUtilBundle.getString("T"));
                    break;
                }
                this.m_viewFormat.setScaleDownTrillions("");
                break;
            }
            case 5: {
                if (scale) {
                    this.m_viewFormat.setScaleDownQuadrillions(this.rUtilBundle.getString("Q"));
                    break;
                }
                this.m_viewFormat.setScaleDownQuadrillions("");
            }
        }
    }

    private void setNegativeFormat(int nf) {
        if (this.m_numType == 0) {
            this.m_viewFormat.setNegNumFmt(nf);
        } else if (this.m_numType == 1) {
            this.m_viewFormat.setNegCurFmt(nf);
        }
        this.m_Renderer.setNegativeRed(this.m_numberPanel.isNegativeRed());
    }

    private void setNumberFormatType(int type) {
        switch (type) {
            case 6: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                break;
            }
            case 0: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                break;
            }
            case 1: {
                this.m_viewFormat = new ViewFormat(this.m_numberPanel.getDefaultFormat(), 1);
                this.m_viewFormat.setLocale(super.getLocale());
                break;
            }
            case 2: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                this.m_viewFormat.setNumberType(0);
                this.m_numType = 0;
                this.setDecimalPlaces(this.m_numberPanel.getDecimalPlaces());
                this.setThousandSeparator(this.m_numberPanel.isShowThousandSeparator());
                this.setScale(this.m_numberPanel.isScale());
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
                break;
            }
            case 3: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                this.m_viewFormat.setNumberType(1);
                this.m_numType = 1;
                this.setCurrencySymbolUsed(this.m_numberPanel.isShowCurrencySymbol());
                this.setDecimalPlaces(this.m_numberPanel.getDecimalPlaces());
                this.setThousandSeparator(this.m_numberPanel.isShowThousandSeparator());
                this.setScale(this.m_numberPanel.isScale());
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
                break;
            }
            case 4: {
                this.m_viewFormat = new ViewFormat();
                this.m_viewFormat.setLocale(super.getLocale());
                this.m_viewFormat.setNumberType(2);
                this.m_numType = 2;
                this.setDecimalPlaces(this.m_numberPanel.getDecimalPlaces());
                break;
            }
            case 5: {
                this.setNumberCustomType(this.m_numberPanel.getCurrentCustomPatternString());
            }
        }
    }

    private void setNumberCustomType(String nf) {
        try {
            this.m_viewFormat = new ViewFormat(nf, 1);
            this.m_viewFormat.setLocale(super.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setDollarSign(String sign) {
        this.m_viewFormat.setCurrencySymbol(sign);
        this.m_viewFormat.setCurrencySymbolUsed(true);
        this.m_viewFormat.setNumberType(1);
        this.m_numType = 1;
        this.sample.repaint();
    }

    private void setPositiveFormat(int position) {
        this.m_viewFormat.setPosCurFmt(position);
        this.sample.repaint();
    }

    private void setCurrencySymbolUsed(boolean used) {
        this.m_viewFormat.setCurrencySymbolUsed(used);
        if (used) {
            this.setDollarSign(this.m_numberPanel.getDollarSign());
        } else {
            this.setDollarSign("");
        }
        this.sample.repaint();
    }

    private void setDateFormatChanged(String newFormat) {
        if (this.m_viewFormat == null) {
            this.m_viewFormat = new ViewFormat();
        }
        this.m_viewFormat.setOracleDateFormat(newFormat);
    }

    private void adjustRowHeight(int add) {
        int topWidth = 0;
        int leftWidth = 0;
        int bottomWidth = 0;
        int rightWidth = 0;
        if (this.m_generalPanel != null) {
            topWidth = this.m_generalPanel.getTopWidth();
            leftWidth = this.m_generalPanel.getLeftWidth();
            bottomWidth = this.m_generalPanel.getBottomWidth();
            rightWidth = this.m_generalPanel.getRightWidth();
        } else if (this.m_headerGeneralPanel != null) {
            topWidth = this.m_headerGeneralPanel.getTopWidth();
            leftWidth = this.m_headerGeneralPanel.getLeftWidth();
            bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
            rightWidth = this.m_headerGeneralPanel.getRightWidth();
        }
        this.sample.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.black), BorderFactory.createEmptyBorder(topWidth + 2, leftWidth + 2, bottomWidth + 2, rightWidth + 2)));
        if (this.m_font != null) {
            this.sample.setRowHeight(this.m_font.getSize() + 10 + add);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        if (this.m_viewFormat != null) {
            this.m_viewFormat.setLocale(loc);
        }
        if (this.m_leadingAlignment) {
            this.setColumnHAlignment(10);
        }
        this.m_label.setText(this.rBundle.getString("SampleTitle"));
    }

    public void removeListeners() {
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removePropertyChangeListener(this);
        }
        if (this.m_headerGeneralPanel != null) {
            this.m_headerGeneralPanel.removePropertyChangeListener(this);
        }
        this.m_fontPanel.removePropertyChangeListener(this);
        this.m_numberPanel.removePropertyChangeListener(this);
        this.m_datePanel.removePropertyChangeListener(this);
    }

    public void cleanUp() {
        this.sample.getColumnModel().getColumn(0).setCellRenderer(null);
        this.m_Renderer = null;
        this.sample = null;
        this.m_fontPanel = null;
        if (this.m_generalPanel != null) {
            this.m_generalPanel.removePropertyChangeListener(this);
        }
        this.m_generalPanel = null;
        if (this.m_headerGeneralPanel != null) {
            this.m_headerGeneralPanel.removePropertyChangeListener(this);
        }
        this.m_headerGeneralPanel = null;
        this.m_numberPanel = null;
        this.m_datePanel = null;
    }

    private void tableInit(FormatGeneralPanel generalPanel, HeaderFormatGeneralPanel headerGeneralPanel, FontPanel fontPanel, NumberFormatPanel numberPanel, DatePanel datePanel) {
        this.m_generalPanel = generalPanel;
        this.m_headerGeneralPanel = headerGeneralPanel;
        this.m_fontPanel = fontPanel;
        this.m_numberPanel = numberPanel;
        this.m_datePanel = datePanel;
        if (this.m_generalPanel != null) {
            this.m_generalPanel.addPropertyChangeListener(this);
        } else if (this.m_headerGeneralPanel != null) {
            this.m_headerGeneralPanel.addPropertyChangeListener(this);
        }
        this.m_fontPanel.addPropertyChangeListener(this);
        if (this.m_generalPanel != null) {
            if (this.m_numberPanel != null && this.m_datePanel != null) {
                if (numberPanel.getViewFormat() != null) {
                    this.updateResourceBundle(numberPanel.getViewFormat().getLocale());
                } else {
                    this.updateResourceBundle(numberPanel.getLocale());
                }
                this.m_numberPanel.addPropertyChangeListener(this);
                this.m_datePanel.addPropertyChangeListener(this);
            } else if (this.m_numberPanel != null) {
                if (numberPanel.getViewFormat() != null) {
                    this.updateResourceBundle(numberPanel.getViewFormat().getLocale());
                } else {
                    this.updateResourceBundle(numberPanel.getLocale());
                }
                this.m_numberPanel.addPropertyChangeListener(this);
            } else if (this.m_datePanel != null) {
                this.updateResourceBundle(datePanel.getViewFormat().getLocale());
                this.m_datePanel.addPropertyChangeListener(this);
            } else {
                this.updateResourceBundle(null);
            }
        } else if (this.m_headerGeneralPanel != null) {
            this.updateResourceBundle(null);
        }
        this.m_thousandSeparator = (char)44;
        if (numberPanel != null) {
            this.m_thousandSeparator = numberPanel.getGroupSeparator();
        }
        this.m_Renderer = new myRenderer();
        this.setLayout(new BoxLayout(this, 1));
        Object[] columnHeader = new String[]{""};
        this.sample = new sampleTable(this.data, columnHeader);
        this.sample.setColumnSelectionAllowed(false);
        this.sample.setRowSelectionAllowed(false);
        this.sample.setCellSelectionEnabled(false);
        this.sample.setRequestFocusEnabled(false);
        this.setRequestFocusEnabled(false);
        this.northPanel.setBackground(OUTER_GAP_COLOR);
        this.westPanel.setBackground(OUTER_GAP_COLOR);
        this.eastPanel.setBackground(OUTER_GAP_COLOR);
        this.sample.setIntercellSpacing(new Dimension(0, 0));
        this.sample.setRowMargin(0);
        if (this.m_generalPanel != null) {
            this.m_initBackground = this.m_generalPanel.getBackgroundColor();
            this.setColumnBackground(this.m_initBackground);
            this.m_initLeftWidth = this.m_generalPanel.getLeftWidth();
            this.m_initRightWidth = this.m_generalPanel.getRightWidth();
            this.m_initTopWidth = this.m_generalPanel.getTopWidth();
            this.m_initBottomWidth = this.m_generalPanel.getBottomWidth();
            this.m_initLeftColor = this.m_generalPanel.getLeftColor();
            this.m_initRightColor = this.m_generalPanel.getRightColor();
            this.m_initTopColor = this.m_generalPanel.getTopColor();
            this.m_initBottomColor = this.m_generalPanel.getBottomColor();
            this.setBordersLeftLineWidth(this.m_initLeftWidth);
            this.setBordersRightLineWidth(this.m_initRightWidth);
            this.setBordersTopLineWidth(this.m_initTopWidth);
            this.setBordersBottomLineWidth(this.m_initBottomWidth);
            this.setBordersLeftLineColor(this.m_initLeftColor);
            this.setBordersRightLineColor(this.m_initRightColor);
            this.setBordersTopLineColor(this.m_initTopColor);
            this.setBordersBottomLineColor(this.m_initBottomColor);
            this.sample.setGridColor(Color.lightGray);
            this.sample.setShowGrid(true);
            this.setDataBarsColor(this.m_generalPanel.getDataBarColor());
            this.setDataBarsVisible(this.m_generalPanel.isShowDataBar());
        }
        if (this.m_headerGeneralPanel != null) {
            this.m_initBackground = this.m_headerGeneralPanel.getBackgroundColor();
            this.setColumnBackground(this.m_initBackground);
            this.m_initLeftWidth = this.m_headerGeneralPanel.getLeftWidth();
            this.m_initRightWidth = this.m_headerGeneralPanel.getRightWidth();
            this.m_initTopWidth = this.m_headerGeneralPanel.getTopWidth();
            this.m_initBottomWidth = this.m_headerGeneralPanel.getBottomWidth();
            this.m_initLeftColor = this.m_headerGeneralPanel.getLeftColor();
            this.m_initRightColor = this.m_headerGeneralPanel.getRightColor();
            this.m_initTopColor = this.m_headerGeneralPanel.getTopColor();
            this.m_initBottomColor = this.m_headerGeneralPanel.getBottomColor();
            this.setBordersLeftLineWidth(this.m_initLeftWidth);
            this.setBordersRightLineWidth(this.m_initRightWidth);
            this.setBordersTopLineWidth(this.m_initTopWidth);
            this.setBordersBottomLineWidth(this.m_initBottomWidth);
            this.setBordersLeftLineColor(this.m_initLeftColor);
            this.setBordersRightLineColor(this.m_initRightColor);
            this.setBordersTopLineColor(this.m_initTopColor);
            this.setBordersBottomLineColor(this.m_initBottomColor);
            this.sample.setGridColor(Color.lightGray);
            this.sample.setShowGrid(true);
        }
        if (this.m_fontPanel != null) {
            this.m_font = fontPanel.getComponentFont();
            if (this.m_font == null) {
                String fontName = "Dialog";
                int fontSize = 12;
                if (this.m_fontPanel.getFontPane().getFontName() != null) {
                    fontName = this.m_fontPanel.getFontPane().getFontName();
                }
                if (this.m_fontPanel.getFontPane().getFontSize() != -1) {
                    fontSize = this.m_fontPanel.getFontPane().getFontSize();
                }
                this.m_font = new Font(fontName, this.m_fontPanel.getFontPane().getFontStyle(), fontSize);
            }
            this.m_initFont = this.m_font;
            this.m_initUnderline = this.m_fontPanel.isUnderlineStyle();
            this.m_initStrikeThrough = this.m_fontPanel.isStrikeThroughStyle();
            this.setColumnFont(this.m_font);
            int topWidth = 0;
            int bottomWidth = 0;
            if (generalPanel != null) {
                topWidth = this.m_generalPanel.getTopWidth();
                bottomWidth = this.m_generalPanel.getBottomWidth();
                this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
            } else if (this.m_headerGeneralPanel != null) {
                topWidth = this.m_headerGeneralPanel.getTopWidth();
                bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
                this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
            } else {
                this.adjustRowHeight(0);
            }
            this.m_initForegroundColor = fontPanel.getComponentForeground();
            this.setColumnForeground(this.m_initForegroundColor);
            this.m_initHAlignment = this.m_fontPanel.getHorizontalAlignment();
            this.setColumnHAlignment(this.m_initHAlignment);
            this.m_initVAlignment = this.m_fontPanel.getVerticalAlignment();
            this.setColumnVAlignment(this.m_initVAlignment);
        }
        if (this.m_numberPanel != null) {
            if (this.m_numberPanel.getViewFormat() != null) {
                this.m_viewFormat = (ViewFormat)this.m_numberPanel.getViewFormat().clone();
                this.m_numType = this.m_viewFormat.getNumberType();
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
            } else {
                this.m_viewFormat = null;
            }
        }
        if (this.m_datePanel != null && this.m_datePanel.getViewFormat() != null) {
            this.m_viewFormat = (ViewFormat)this.m_datePanel.getViewFormat().clone();
            this.m_initDateFormat = this.m_viewFormat.getOracleDateFormat();
        }
        this.m_label = new JLabel(this.rBundle.getString("SampleTitle"));
        this.m_label.setAlignmentX(0.0f);
        this.m_label.setBackground(null);
        this.m_label.setForeground(Color.white);
        JPanel samplePanel = new JPanel();
        samplePanel.setLayout(new BoxLayout(samplePanel, 0));
        samplePanel.setBackground(Color.white);
        samplePanel.setAlignmentX(0.0f);
        samplePanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        samplePanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        samplePanel.add(this.sample);
        this.add(this.m_label);
        this.add(Box.createVerticalStrut(3));
        this.add(samplePanel);
        this.setBackground(null);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.processEvent(e);
    }

    public void processEvent(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (e.getSource() == this.m_fontPanel) {
            if (propertyName.equals("fontColor")) {
                this.setColumnForeground((Color)e.getNewValue());
            } else if (propertyName.equals("fontBackgroundColor")) {
                this.setColumnBackground((Color)e.getNewValue());
            } else if (propertyName.equals("fontHorizontalAlignment")) {
                int newAlignment = (Integer)e.getNewValue();
                this.setColumnHAlignment(newAlignment);
                this.setColumnVAlignment(this.m_fontPanel.getVerticalAlignment());
            } else if (propertyName.equals("fontVerticalAlignment")) {
                int newAlignment = (Integer)e.getNewValue();
                this.setColumnVAlignment(newAlignment);
                this.setColumnHAlignment(this.m_fontPanel.getHorizontalAlignment());
            } else {
                Font curFont;
                if (this.m_fontPanel.getComponentFont() == null) {
                    int curFontSize;
                    String curFontName = this.m_fontPanel.getFontName();
                    if (curFontName == null) {
                        curFontName = "Dialog";
                    }
                    if ((curFontSize = this.m_fontPanel.getFontSize()) == -1) {
                        curFontSize = 12;
                    }
                    int curFontStyle = this.m_fontPanel.getFontStyle();
                    curFont = new Font(curFontName, curFontStyle, curFontSize);
                } else {
                    curFont = this.m_fontPanel.getComponentFont();
                }
                if (propertyName.equals("fontSize")) {
                    int newSize = (Integer)e.getNewValue();
                    this.m_font = new Font(curFont.getFamily(), curFont.getStyle(), newSize);
                    this.setColumnFont(this.m_font);
                    int topWidth = 0;
                    int bottomWidth = 0;
                    if (this.m_generalPanel != null) {
                        topWidth = this.m_generalPanel.getTopWidth();
                        bottomWidth = this.m_generalPanel.getBottomWidth();
                    } else if (this.m_headerGeneralPanel != null) {
                        topWidth = this.m_headerGeneralPanel.getTopWidth();
                        bottomWidth = this.m_headerGeneralPanel.getBottomWidth();
                    }
                    this.adjustRowHeight((topWidth >= 5 ? 1 : topWidth) + (bottomWidth >= 5 ? 1 : bottomWidth));
                } else if (propertyName.equals("fontStyle")) {
                    int newStyle = (Integer)e.getNewValue();
                    this.m_font = new Font(curFont.getFamily(), newStyle & 3, curFont.getSize());
                    this.setColumnFont(this.m_font);
                } else if (propertyName.equals("fontName")) {
                    String newName = (String)e.getNewValue();
                    this.m_font = new Font(newName, curFont.getStyle(), curFont.getSize());
                    this.setColumnFont(this.m_font);
                }
            }
        }
        if (e.getSource() == this.m_generalPanel || e.getSource() == this.m_headerGeneralPanel) {
            if (propertyName.equals("BackgroundColor")) {
                this.setColumnBackground((Color)e.getNewValue());
            } else if (propertyName.equals("DataBarsVisible")) {
                this.setDataBarsVisible((Boolean)e.getNewValue());
            } else if (propertyName.equals("DataBarsColor")) {
                this.setDataBarsColor((Color)e.getNewValue());
            } else if (propertyName.equals("OutLineWidth")) {
                this.setBordersOutlineWidth((Integer)e.getNewValue());
            } else if (propertyName.equals("OutlineColor")) {
                this.setBordersOutlineColor((Color)e.getNewValue());
            } else if (propertyName.equals("LeftLineWidth")) {
                this.setBordersLeftLineWidth((Integer)e.getNewValue());
            } else if (propertyName.equals("LeftLineColor")) {
                this.setBordersLeftLineColor((Color)e.getNewValue());
            } else if (propertyName.equals("RightLineWidth")) {
                this.setBordersRightLineWidth((Integer)e.getNewValue());
            } else if (propertyName.equals("RightLineColor")) {
                this.setBordersRightLineColor((Color)e.getNewValue());
            } else if (propertyName.equals("TopLineWidth")) {
                this.setBordersTopLineWidth((Integer)e.getNewValue());
            } else if (propertyName.equals("TopLineColor")) {
                this.setBordersTopLineColor((Color)e.getNewValue());
            } else if (propertyName.equals("BottomLineWidth")) {
                this.setBordersBottomLineWidth((Integer)e.getNewValue());
            } else if (propertyName.equals("BottomLineColor")) {
                this.setBordersBottomLineColor((Color)e.getNewValue());
            }
        } else if (e.getSource() == this.m_numberPanel) {
            if (propertyName.equals("DecimalPlaces")) {
                this.setDecimalPlaces((Integer)e.getNewValue());
            } else if (propertyName.equals("ThousandSeparator")) {
                this.setThousandSeparator((Boolean)e.getNewValue());
            } else if (propertyName.equals("Scale")) {
                this.setScale((Boolean)e.getNewValue());
            } else if (propertyName.equals("ScaleFactor")) {
                this.setScaleSign((Integer)e.getNewValue());
            } else if (propertyName.equals("ScaleSign")) {
                this.setScaleSignMarker((Boolean)e.getNewValue());
            } else if (propertyName.equals("NegativeNumberTypeChange")) {
                this.setNegativeFormat(this.m_numberPanel.getNegativeFormat());
            } else if (propertyName.equals("TypeChange")) {
                int type = (Integer)e.getNewValue();
                this.setNumberFormatType(type);
                if (type != 2 && type != 3) {
                    this.m_Renderer.setNegativeRed(false);
                } else {
                    this.m_Renderer.setNegativeRed(this.m_numberPanel.isNegativeRed());
                }
            } else if (propertyName.equals("CustomTypeChange")) {
                this.setNumberCustomType((String)e.getNewValue());
            } else if (propertyName.equals("DollarSign")) {
                this.setDollarSign((String)e.getNewValue());
            } else if (propertyName.equals("PositiveFormat")) {
                this.setPositiveFormat((Integer)e.getNewValue());
            } else if (propertyName.equals("CurrencySymbolUsed")) {
                this.setCurrencySymbolUsed((Boolean)e.getNewValue());
            }
        } else if (e.getSource() == this.m_datePanel && propertyName.equals("DateFormatChanged")) {
            this.m_newDateFormat = (String)e.getNewValue();
            this.setDateFormatChanged(this.m_newDateFormat);
        }
        this.sample.repaint();
    }

    private void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc);
            this.rUtilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", loc);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
            this.rUtilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
        }
        this.updateResourceData();
    }

    private void updateResourceData() {
        String[] resourceData = new String[2];
        if (this.m_generalPanel != null) {
            if (this.m_datePanel != null && this.m_numberPanel != null) {
                for (int i = 0; i < 2; ++i) {
                    resourceData[i] = SampleNumberDateData[i];
                }
            } else if (this.m_numberPanel != null) {
                for (int i = 0; i < 2; ++i) {
                    resourceData[i] = SampleNumberData[i];
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    resourceData[i] = SampleDateData[i];
                }
            }
        } else if (this.m_headerGeneralPanel != null) {
            Object[] arg = new String[1];
            for (int i = 0; i < 2; ++i) {
                String temp = new String(this.rBundle.getString("Header"));
                arg[0] = MySampleHeaderData[i];
                resourceData[i] = temp = MessageFormat.format(temp, arg);
            }
        }
        for (int i = 0; i < this.data.length; ++i) {
            try {
                this.data[i][0] = Date.valueOf(resourceData[i]);
                continue;
            }
            catch (Exception e) {
                this.data[i][0] = resourceData[i];
            }
        }
    }

    public JTable getSampleTable() {
        return this.sample;
    }

    private class sampleTable
    extends JTable {
        public sampleTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class myRenderer
    extends ViewLabel
    implements TableCellRenderer {
        private Color leftLineColor = Color.black;
        private int leftLineWidth = 0;
        private int leftLineStyle = 0;
        private Color rightLineColor = Color.black;
        private int rightLineWidth = 0;
        private int rightLineStyle = 0;
        private Color topLineColor = Color.black;
        private int topLineWidth = 0;
        private int topLineStyle = 0;
        private Color bottomLineColor = Color.black;
        private int bottomLineWidth = 0;
        private int bottomLineStyle = 0;
        private boolean isGraphicBarVisible = true;
        private String myValue = "";
        private int myRow = 0;
        private int myCol = 0;
        private Color graphicBarsColor = Color.blue;
        private boolean hasBorders = false;
        private int fontSize = 10;
        private String fontName = "";
        private int fontStyle = 0;
        private Color foregroundColor;
        private boolean negRed = false;

        public void setNegativeRed(boolean r) {
            this.negRed = r;
        }

        public void setFont(Font font, boolean isUnderlineStyle, boolean isStrikeThroughStyle) {
            super.setFont(font);
            this.setUnderline(isUnderlineStyle);
            this.setStrikeThrough(isStrikeThroughStyle);
            this.fontName = font.getName();
            this.fontSize = font.getSize();
            this.fontStyle = font.getStyle();
        }

        @Override
        public void setForeground(Color c) {
            this.foregroundColor = c;
            super.setForeground(c);
        }

        public void setAlignment(int xAlignment, int yAlignment) {
            this.setVerticalAlignment(yAlignment);
            this.setHorizontalAlignment(xAlignment);
        }

        public void setHAlignment(int hAlignment) {
            if (hAlignment != -1) {
                this.setHorizontalAlignment(hAlignment);
            } else {
                this.setHorizontalAlignment(0);
            }
        }

        public void setVAlignment(int vAlignment) {
            if (vAlignment != -1) {
                this.setVerticalAlignment(vAlignment);
            } else {
                this.setVerticalAlignment(0);
            }
        }

        public void setOutlineWidth(int width) {
            this.hasBorders = true;
            this.leftLineWidth = width;
            this.rightLineWidth = width;
            this.topLineWidth = width;
            this.bottomLineWidth = width;
        }

        public void setOutlineStyle(int style) {
            this.leftLineStyle = style;
            this.rightLineStyle = style;
            this.topLineStyle = style;
            this.bottomLineStyle = style;
        }

        public void setOutlineColor(Color color) {
            this.hasBorders = true;
            this.leftLineColor = color;
            this.rightLineColor = color;
            this.topLineColor = color;
            this.bottomLineColor = color;
        }

        public void setLeftWidth(int width) {
            this.hasBorders = true;
            this.leftLineWidth = width;
        }

        public void setLeftStyle(int style) {
            this.leftLineStyle = style;
        }

        public void setLeftColor(Color color) {
            this.hasBorders = true;
            this.leftLineColor = color;
        }

        public void setRightWidth(int width) {
            this.hasBorders = true;
            this.rightLineWidth = width;
        }

        public void setRightStyle(int style) {
            this.rightLineStyle = style;
        }

        public void setRightColor(Color color) {
            this.hasBorders = true;
            this.rightLineColor = color;
        }

        public void setTopWidth(int width) {
            this.hasBorders = true;
            this.topLineWidth = width;
        }

        public void setTopStyle(int style) {
            this.topLineStyle = style;
        }

        public void setTopColor(Color color) {
            this.hasBorders = true;
            this.topLineColor = color;
        }

        public void setBottomWidth(int width) {
            this.hasBorders = true;
            this.bottomLineWidth = width;
        }

        public void setBottomStyle(int style) {
            this.bottomLineStyle = style;
        }

        public void setBottomColor(Color color) {
            this.hasBorders = true;
            this.bottomLineColor = color;
        }

        public void setDataBarsVisible(boolean v) {
            this.isGraphicBarVisible = v;
        }

        public void setDataBarsColor(Color c) {
            this.graphicBarsColor = c;
        }

        protected void drawAlignedString(Graphics g, String s, int x, int y, int width, int baseline) {
            int sw = this.m_fm.stringWidth(s);
            if (this.getHorizontalAlignment() != 2) {
                if (this.getHorizontalAlignment() == 0) {
                    x += (width - sw) / 2;
                } else if (this.getHorizontalAlignment() == 4) {
                    x = x + width - sw;
                }
            }
            this.drawEnhancedAdornments(this.m_fm, g, x, y + this.m_baseline, sw, this.isUnderline(), this.isDoubleUnderline(), this.isStrikeThrough());
        }

        @Override
        protected void drawEnhancedAdornments(FontMetrics metrics, Graphics g, int x, int y, int sw, boolean underline, boolean doubleUnderline, boolean strikeThrough) {
            if (this.getVerticalAlignment() == 3) {
                y += 2;
            }
            if (this.getVerticalAlignment() == 1) {
                --y;
            }
            if (underline) {
                g.drawLine(x, y + 2, x + sw, y + 2);
            }
            if (strikeThrough) {
                g.drawLine(x, y - metrics.getAscent() / 2, x + sw, y - metrics.getAscent() / 2);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.isUnderline() || this.isDoubleUnderline() || this.isStrikeThrough() || this.isGraphicBarVisible || this.hasBorders) {
                float ratio;
                String strTxt = this.getText();
                Border b = this.getBorder();
                Insets insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
                this.m_fm = this.getToolkit().getFontMetrics(this.getFont());
                this.m_baseline = this.m_fm.getMaxAscent();
                int x = insets.left;
                int y = insets.top;
                int leftWidth = 0;
                int rightWidth = 0;
                int topWidth = 0;
                int bottomWidth = 0;
                if (SamplePanel.this.m_generalPanel != null) {
                    leftWidth = SamplePanel.this.m_generalPanel.getLeftWidth();
                    rightWidth = SamplePanel.this.m_generalPanel.getRightWidth();
                    topWidth = SamplePanel.this.m_generalPanel.getTopWidth();
                    bottomWidth = SamplePanel.this.m_generalPanel.getBottomWidth();
                } else if (SamplePanel.this.m_headerGeneralPanel != null) {
                    leftWidth = SamplePanel.this.m_headerGeneralPanel.getLeftWidth();
                    rightWidth = SamplePanel.this.m_headerGeneralPanel.getRightWidth();
                    topWidth = SamplePanel.this.m_headerGeneralPanel.getTopWidth();
                    bottomWidth = SamplePanel.this.m_headerGeneralPanel.getBottomWidth();
                }
                if (this.hasBorders) {
                    BorderPainter.paintBorder((Graphics)g, (int)(x - 4 + 2), (int)y, (int)(this.getWidth() - 2 - 2), (int)(SamplePanel.this.sample.getRowHeight() - 2 + 1), (int)0, (Color)Color.white, (int)this.topLineStyle, (int)this.bottomLineStyle, (int)this.leftLineStyle, (int)this.rightLineStyle, (int)(this.topLineWidth >= 5 ? 1 : this.topLineWidth), (int)(this.bottomLineWidth >= 5 ? 1 : this.bottomLineWidth), (int)(this.leftLineWidth >= 5 ? 1 : this.leftLineWidth), (int)(this.rightLineWidth >= 5 ? 1 : this.rightLineWidth), (Color)this.topLineColor, (Color)this.bottomLineColor, (Color)this.leftLineColor, (Color)this.rightLineColor);
                }
                if (this.isGraphicBarVisible && SamplePanel.this.m_generalPanel != null && (ratio = this.getGraphicBarRatio(this.myCol, this.myRow)) > 0.0f) {
                    Color oldColor = g.getColor();
                    g.setColor(this.graphicBarsColor);
                    int x1 = x;
                    int cellWidth = this.getWidth() - 8 + 1 - (leftWidth >= 5 ? 1 : leftWidth) - (rightWidth >= 5 ? 1 : rightWidth);
                    int barHeight = this.getHeight() - 4 - 1 - (topWidth >= 5 ? 1 : topWidth) - (bottomWidth >= 5 ? 1 : bottomWidth);
                    int barWidth = (int)((float)cellWidth * ratio);
                    if (this.getHorizontalAlignment() == 4) {
                        x1 += cellWidth - barWidth - 1;
                    }
                    g.fillRect(x1 + (leftWidth >= 5 ? 1 : topWidth), y + 2 + (topWidth >= 5 ? 1 : topWidth), barWidth, barHeight);
                    g.setColor(oldColor);
                }
                this.setBorder(BorderFactory.createEmptyBorder(topWidth >= 5 ? 1 : topWidth, (leftWidth >= 5 ? 1 : leftWidth) + 4, (bottomWidth >= 5 ? 1 : bottomWidth) + 2 + 2, (rightWidth >= 5 ? 1 : rightWidth) + 4));
                b = this.getBorder();
                insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
                int boundx = this.getWidth() - insets.right - insets.left;
                int boundy = this.getHeight() - insets.bottom - insets.top;
                y = insets.top + (boundy - this.m_fm.getHeight()) / 2;
                this.drawAlignedString(g, strTxt, insets.left, y, boundx, this.m_baseline);
            }
            super.paintComponent(g);
        }

        private float getGraphicBarRatio(int col, int row) {
            int max = 0;
            for (int i = 0; i < SamplePanel.this.data.length; ++i) {
                Integer value = null;
                try {
                    value = new Integer(SamplePanel.this.data[i][0].toString());
                    int intValue = value;
                    if (intValue <= max) continue;
                    max = intValue;
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int value = 0;
            try {
                value = new Integer(SamplePanel.this.data[row][col].toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            float ratio = (float)value / (float)max;
            return ratio;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            if (this.foregroundColor instanceof ColorUIResource) {
                this.foregroundColor = new Color(this.foregroundColor.getRGB());
            }
            this.setForeground(this.foregroundColor);
            if (value != null) {
                if (SamplePanel.this.m_viewFormat != null) {
                    if (!(value instanceof Date)) {
                        Integer tempValue = new Integer(value.toString());
                        int intValue = tempValue;
                        if (intValue < 0 && this.negRed) {
                            super.setForeground(Color.red);
                        }
                        this.myValue = ((ViewFormat)SamplePanel.this.m_viewFormat.clone()).DoubleToString(new Double(intValue).doubleValue());
                    } else {
                        this.myValue = SamplePanel.this.m_viewFormat.DateToString((Date)value);
                    }
                } else {
                    this.myValue = value.toString();
                }
                this.setText(this.myValue);
            } else {
                this.myValue = "";
                this.setText(this.myValue);
            }
            this.myRow = row;
            this.myCol = column;
            return this;
        }
    }
}

