/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.DeployCommandException;
import oracle.jdeveloper.deploy.cmd.spi.DeployCommandReader;
import oracle.jdeveloper.deploy.cmd.spi.DeployCommandWriter;

public class DeployCommandConfiguration
implements ToolkitFactory {
    private volatile DeployCommandReader[] readers_;
    private volatile DeployCommandWriter[] writers_;
    final Element element_;
    final Context context_;

    private DeployCommandConfiguration(Element element, Context context) {
        this.element_ = element;
        this.context_ = context;
    }

    public static DeployCommandConfiguration getInstance(Element element) {
        return DeployCommandConfiguration.getInstance(element, Context.newIdeContext((Element)element));
    }

    public static DeployCommandConfiguration getInstance(Element element, Context context) {
        return new DeployCommandConfiguration(element, context);
    }

    private synchronized DeployCommandReader[] getReaders() {
        if (this.readers_ == null) {
            this.readers_ = ToolkitFactory.Utils.build(this.element_, this.context_, DeployCommandReader.class, new DeployCommandReader[0]);
        }
        return this.readers_;
    }

    private synchronized DeployCommandWriter[] getWriters() {
        if (this.writers_ == null) {
            this.writers_ = ToolkitFactory.Utils.build(this.element_, this.context_, DeployCommandWriter.class, new DeployCommandWriter[0]);
        }
        return this.writers_;
    }

    private synchronized void invalidateReaders() {
        this.readers_ = null;
    }

    public void addCommand(DeployCommand deployCommand) throws DeployCommandException {
        for (DeployCommandWriter w : this.getWriters()) {
            if (!w.write(deployCommand)) continue;
            this.invalidateReaders();
            return;
        }
        throw new DeployCommandException("No DeployCommand writer found");
    }

    public DeployCommand getCommandAt(int index) {
        DeployCommandReader r;
        DeployCommand p = null;
        DeployCommandReader[] arr$ = this.getReaders();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (p = (r = arr$[i$]).getCommandAt(index)) == null; ++i$) {
        }
        return p;
    }

    public void removeCommand(int index) {
        int c = 0;
        for (DeployCommandWriter w : this.getWriters()) {
            c += w.count();
            if (index >= w.count()) continue;
            w.removeCommandAt(index);
            this.invalidateReaders();
            return;
        }
    }

    public List<Displayable> getDisplayables() {
        ArrayList<Displayable> displayables = new ArrayList<Displayable>();
        for (DeployCommandReader r : this.getReaders()) {
            displayables.addAll(r.getDisplayables());
        }
        return displayables;
    }

    public DeployCommand[] getCommands() {
        ArrayList<DeployCommand> commands = new ArrayList<DeployCommand>();
        for (DeployCommandReader r : this.getReaders()) {
            commands.addAll(r.getAllCommands());
        }
        return commands.toArray(new DeployCommand[0]);
    }

    public void setCommands(DeployCommand[] profiles) {
        for (DeployCommandWriter deployCommandWriter : this.getWriters()) {
            deployCommandWriter.removeAll();
        }
        block1: for (DeployCommand deployCommand : profiles) {
            for (DeployCommandWriter w : this.getWriters()) {
                if (!w.write(deployCommand)) continue;
                this.invalidateReaders();
                continue block1;
            }
        }
    }

    public Iterator<DeployCommand> iterator() {
        DeployCommandReader[] readers = this.getReaders();
        return new DeployCommandIterator(readers);
    }

    private static class DeployCommandIterator
    implements Iterator {
        final DeployCommandReader[] readers_;
        int index_ = 0;
        DeployCommand command_ = null;
        boolean read_ = false;
        boolean resetIter_ = true;
        Iterator<DeployCommand> iter_ = null;

        DeployCommandIterator(DeployCommandReader[] readers) {
            this.readers_ = readers;
        }

        @Override
        public boolean hasNext() {
            if (!this.read_) {
                this.read_ = this.read();
            }
            return this.read_;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Iteration error");
            }
            DeployCommand t = this.command_;
            this.command_ = null;
            this.read_ = false;
            return t;
        }

        @Override
        public void remove() {
        }

        boolean read() {
            while (this.index_ < this.readers_.length) {
                if (this.resetIter_) {
                    this.iter_ = this.readers_[this.index_].iterator();
                    this.resetIter_ = false;
                }
                if (this.iter_.hasNext()) {
                    this.command_ = this.iter_.next();
                    return true;
                }
                ++this.index_;
                this.resetIter_ = true;
            }
            return false;
        }
    }
}

