/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.ProgressState;
import oracle.jdeveloper.deploy.res.CmdBundle;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdeveloper.deploy.spi.ProgressEvent;
import oracle.jdeveloper.deploy.spi.ProgressListener;
import oracle.jdeveloper.deploy.spi.ProgressObject;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;
import oracle.jdevimpl.deploy.fwk.SequenceDeployer;

public abstract class AbstractDeployer
implements Deployer,
ProgressListener {
    private boolean deploymentCancelled_ = false;
    private DeployEvent deployEvent_ = null;
    private int sequenceId_;
    private ListenerSupport listenerSupport_ = DeploymentManager.getProfileListenerSupport();

    public AbstractDeployer(int deploymentSequenceId) {
        this.sequenceId_ = deploymentSequenceId;
    }

    public int getSequenceId() {
        return this.sequenceId_;
    }

    @Override
    public boolean canDeploy(int deploySequenceId) {
        return this.sequenceId_ == deploySequenceId;
    }

    public String getName() {
        return this.getClass().getName();
    }

    private void throwCancelDeployException() throws DeployException {
        throw new DeployException(CmdBundle.get("DEPLOYMENT_CANCELLED"));
    }

    private void checkIfCancelled(ProgressObject runner) throws DeployException {
        if (runner != null && runner.getState().equals(ProgressState.CANCELLING)) {
            this.throwCancelDeployException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(int deploySequenceId, DeployShell shell) throws DeployException {
        ProgressObject runner = null;
        try {
            Assert.startTracking((String)(this.getClass().getName() + "-" + Thread.currentThread().getName()));
            Assert.markTracking((String)(this.getClass().getName() + "-" + Thread.currentThread().getName()));
            shell.getSequenceStack().push(this.sequenceId_);
            runner = ShellAdapter.getInstance(shell).getDeploymentProgressObject();
            if (runner != null) {
                runner.addProgressListener(this);
            }
            this.checkIfCancelled(runner);
            DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
            this.listenerSupport_.fireWillPrepare(deployEvent);
            Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.prepare." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".begin", this.toString()));
            try {
                this.prepareImpl(deploySequenceId, shell);
            }
            catch (DeployException e) {
                e.setSource(this);
                throw e;
            }
            Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.prepare." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".end", this.toString()));
            this.listenerSupport_.firePrepared(deployEvent);
            shell.getSequenceStack().pop();
            this.checkIfCancelled(runner);
        }
        finally {
            if (runner != null) {
                runner.removeProgressListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(int deploySequenceId, DeployShell shell) throws DeployException {
        ProgressObject runner = ShellAdapter.getInstance(shell).getDeploymentProgressObject();
        try {
            if (runner != null) {
                runner.addProgressListener(this);
            }
            this.checkIfCancelled(runner);
            shell.getSequenceStack().push(this.sequenceId_);
            DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
            this.listenerSupport_.fireWillDeploy(deployEvent);
            Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.deploy." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".begin", this.toString()));
            try {
                this.deployImpl(deploySequenceId, shell);
            }
            catch (DeployException e) {
                e.setSource(this);
                throw e;
            }
            Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.deploy." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".end", this.toString()));
            this.listenerSupport_.fireDeployed(deployEvent);
            shell.getSequenceStack().pop();
            this.checkIfCancelled(runner);
        }
        finally {
            if (runner != null) {
                runner.removeProgressListener(this);
            }
        }
    }

    protected boolean isDeploymentCancelled() {
        return this.deploymentCancelled_;
    }

    @Override
    public void handleEvent(ProgressEvent dpe) {
        if (dpe.getType().equals(ProgressEvent.CANCEL_EVENT_TYPE)) {
            this.deploymentCancelled_ = true;
        }
    }

    public void throwExceptionIfCancelEventReceived() throws DeployException {
        if (this.deploymentCancelled_) {
            this.throwCancelDeployException();
        }
    }

    @Override
    public void finish(int deploySequenceId, DeployShell shell) {
        shell.getSequenceStack().push(this.sequenceId_);
        DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
        this.listenerSupport_.fireWillFinish(deployEvent);
        Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.finish." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".begin", this.toString()));
        this.finishImpl(deploySequenceId, shell);
        Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.finish." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".end", this.toString()));
        this.listenerSupport_.fireFinished(deployEvent);
        shell.getSequenceStack().pop();
        Assert.checkTracking((String)(this.getClass().getName() + "-" + Thread.currentThread().getName()), (Object)this);
        Assert.endTracking((String)(this.getClass().getName() + "-" + Thread.currentThread().getName()));
    }

    @Override
    public void cancel(int deploySequenceId, DeployShell shell) {
        shell.getSequenceStack().push(this.sequenceId_);
        DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
        this.listenerSupport_.fireWillCancel(deployEvent);
        Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.cancel." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".begin", this.toString()));
        this.cancelImpl(deploySequenceId, shell);
        Assert.check((boolean)oracle.jdevimpl.deploy.fwk.DeploymentManager.printDebug("deployer.cancel." + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + ".end", this.toString()));
        this.listenerSupport_.fireCancelled(deployEvent);
        shell.getSequenceStack().pop();
    }

    protected void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
    }

    protected abstract void deployImpl(int var1, DeployShell var2) throws DeployException;

    protected void finishImpl(int deploySequenceId, DeployShell shell) {
    }

    protected void cancelImpl(int deploySequenceId, DeployShell shell) {
    }

    private synchronized DeployEvent createEvent(int originalSequence, int currentSequence, DeployShell shell) {
        if (this.deployEvent_ == null) {
            this.deployEvent_ = DeployEvent.create(0, 0, null, AbstractDeployer.unwrap(this));
        }
        this.deployEvent_.setOriginalSequence(originalSequence);
        this.deployEvent_.setCurrentSequence(currentSequence);
        this.deployEvent_.setShell(shell);
        return this.deployEvent_;
    }

    private static Deployer unwrap(Deployer deployer) {
        if (deployer instanceof SequenceDeployer) {
            return AbstractDeployer.unwrap(((SequenceDeployer)deployer).getDeployer());
        }
        return deployer;
    }

    public String toString() {
        return "<deployer  class=\"" + this.getClass().getName() + "\" seqId=\"" + this.sequenceId_ + "\" seqName=\"" + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + "\"/>";
    }
}

