/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullPrintWriter;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdevimpl.deploy.fwk.ArchiveIO;
import oracle.jdevimpl.deploy.res.FwkArb;

public class JarIO
extends ArchiveIO {
    private static final int BUFFER_SIZE = 8192;
    private boolean compressed_;
    private int compressionLevel_ = -1;

    public JarIO() {
        this(false);
    }

    public JarIO(boolean compressed) {
        this.compressed_ = compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed_ = compressed;
    }

    public void setCompressionLevel(int level) {
        assert (level >= -1 && level <= 9);
        this.compressionLevel_ = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(Archive archive, URL outputURL, PrintWriter printWriter, boolean forceRewrite) throws IOException {
        BufferedOutputStream outputStream;
        block21: {
            if (!forceRewrite && !this.needToWriteArchive(archive, outputURL, printWriter)) {
                return;
            }
            this.removeArchive(outputURL);
            outputStream = null;
            JarOutputStream jos = null;
            try {
                if (printWriter == null) {
                    printWriter = new NullPrintWriter();
                }
                outputStream = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)outputURL));
                jos = new JarOutputStream(outputStream);
                if (archive.isIncludeManifest()) {
                    ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
                    jos.putNextEntry(manifestEntry);
                    archive.getManifest().write(jos);
                    jos.closeEntry();
                }
                jos.setMethod(this.compressed_ ? 8 : 0);
                if (this.compressed_) {
                    jos.setLevel(this.compressionLevel_);
                }
                Iterator<ArchiveEntry> iter = archive.getArchiveEntries();
                byte[] buffer = new byte[8192];
                while (iter.hasNext()) {
                    ArchiveEntry entry = null;
                    try {
                        while (iter.hasNext()) {
                            long lastModified;
                            entry = iter.next();
                            if (!this.canAddEntry(entry)) continue;
                            JarEntry jarEntry = new JarEntry(entry.getName());
                            long expectedSize = -1L;
                            if (!this.compressed_) {
                                this.initStoredZipEntry(entry, jarEntry, -1L, printWriter);
                            }
                            if ((lastModified = URLFileSystem.lastModified((URL)entry.getURL())) >= 0L) {
                                jarEntry.setTime(lastModified);
                            }
                            jos.putNextEntry(jarEntry);
                            InputStream in = null;
                            try {
                                int bytesRead;
                                in = this.openInputStream(entry);
                                int totalSize = 0;
                                while ((bytesRead = in.read(buffer, 0, 8192)) >= 0) {
                                    jos.write(buffer, 0, bytesRead);
                                    totalSize += bytesRead;
                                }
                                if (in == null) continue;
                            }
                            catch (Throwable throwable) {
                                if (in == null) throw throwable;
                                try {
                                    in.close();
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    e.printStackTrace(printWriter);
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace(printWriter);
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        printWriter.println(JarIO.archiveEntryException(archive, e, entry));
                    }
                    catch (IOException e) {
                        throw new IOException(JarIO.archiveEntryException(archive, e, entry));
                    }
                }
                if (jos == null) break block21;
            }
            catch (Throwable throwable) {
                if (jos != null) {
                    JarIO.forceClose(jos, printWriter, outputStream);
                    throw throwable;
                }
                if (outputStream == null) throw throwable;
                JarIO.forceClose(outputStream, printWriter);
                throw throwable;
            }
            JarIO.forceClose(jos, printWriter, outputStream);
            return;
        }
        if (outputStream == null) return;
        JarIO.forceClose(outputStream, printWriter);
    }

    protected InputStream openInputStream(ArchiveEntry entry) throws IOException {
        return URLFileSystem.openInputStream((URL)entry.getURL());
    }

    protected boolean canAddEntry(ArchiveEntry entry) {
        return entry != null && entry.getURL() != null;
    }

    private boolean needToWriteArchive(Archive archive, URL outputURL, PrintWriter printWriter) {
        block11: {
            if (URLFileSystem.exists((URL)outputURL)) {
                try {
                    final JarIndex jarIndex = JarUtil.getJarIndex((URL)outputURL);
                    if (jarIndex == null) break block11;
                    Iterator<ArchiveEntry> iter = archive.getArchiveEntries();
                    final HashMap<String, URL> entries = new HashMap<String, URL>();
                    while (iter.hasNext()) {
                        ArchiveEntry entry = iter.next();
                        if (entry == null || entry.getURL() == null || entry.getName() == null || entry.getName().equals("connections.xml") || entry.getName().equals("WEB-INF/classes/connections.xml")) continue;
                        entries.put(entry.getName(), entry.getURL());
                    }
                    final boolean[] retVal = new boolean[]{false};
                    jarIndex.visit(new JarIndex.Visitor(){
                        private int n;

                        public boolean visit(JarIndexEntry entry) {
                            String entryName = entry.getName();
                            URL url = (URL)entries.remove(entryName);
                            if (url != null) {
                                long timestampInJar = jarIndex.getTimestamp(entryName);
                                long timestampOnDisk = URLFileSystem.lastModified((URL)url);
                                if (timestampOnDisk > timestampInJar) {
                                    retVal[0] = true;
                                    return false;
                                }
                                if (this.n++ < 3) {
                                    boolean isCurEntryCompressed;
                                    boolean bl = isCurEntryCompressed = entry.getCompressedSize() < entry.getSize();
                                    if (JarIO.this.compressed_ != isCurEntryCompressed) {
                                        if (!"META-INF/MANIFEST.MF".equals(entryName)) {
                                            retVal[0] = true;
                                            return false;
                                        }
                                        --this.n;
                                    }
                                }
                            } else if (!"META-INF/MANIFEST.MF".equals(entryName)) {
                                retVal[0] = true;
                                return false;
                            }
                            return true;
                        }
                    });
                    if (retVal[0]) {
                        return true;
                    }
                    if (!entries.isEmpty()) {
                        return true;
                    }
                    boolean curHasManifest = jarIndex.exists("META-INF/MANIFEST.MF");
                    if (archive.isIncludeManifest() != curHasManifest) {
                        return true;
                    }
                    if (archive.isIncludeManifest()) {
                        try {
                            Manifest curManifest = new Manifest(jarIndex.openInputStream("META-INF/MANIFEST.MF"));
                            if (!archive.getManifest().equals(curManifest)) {
                                return true;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(printWriter);
                            return true;
                        }
                    }
                    return false;
                }
                catch (IOException e) {
                    printWriter.println(FwkArb.format(45, e.getLocalizedMessage()));
                }
            }
        }
        return true;
    }

    private static String archiveEntryException(Archive archive, Exception e, ArchiveEntry entry) {
        if (entry == null) {
            return FwkArb.format(41, e.getClass());
        }
        if (archive != null && entry.getName() != null && archive.isIncludeManifest() && entry.getName().equals("META-INF/MANIFEST.MF")) {
            return FwkArb.format(40, e.getClass(), entry.getURL());
        }
        if (entry.getURL() != null) {
            return FwkArb.format(42, e.getClass(), entry.getURL());
        }
        if (entry.getName() != null) {
            return FwkArb.format(43, entry.getName());
        }
        return FwkArb.format(41, e.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStoredZipEntry(ArchiveEntry entry, ZipEntry zipEntry, long expectedSize, PrintWriter log) throws IOException {
        InputStream in = null;
        try {
            int bytesRead;
            in = this.openInputStream(entry);
            byte[] bytes = new byte[8192];
            CRC32 crc32 = new CRC32();
            long totalSize = 0L;
            while ((bytesRead = in.read(bytes, 0, 8192)) >= 0) {
                crc32.update(bytes, 0, bytesRead);
                if (expectedSize < 0L || (totalSize += (long)bytesRead) < expectedSize) continue;
                break;
            }
            long crc = crc32.getValue();
            zipEntry.setCrc(crc);
            zipEntry.setSize(totalSize);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace(log);
                }
            }
        }
    }

    private static void forceClose(ZipOutputStream zipOut, PrintWriter printWriter, OutputStream out) {
        try {
            zipOut.close();
        }
        catch (IOException e) {
            JarIO.forceClose(out, printWriter);
        }
    }

    private static void forceClose(OutputStream out, PrintWriter printWriter) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace(printWriter);
            }
        }
    }
}

