/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.ProgressEvent;
import oracle.jdeveloper.deploy.ProgressListener;
import oracle.jdeveloper.deploy.ProgressState;
import oracle.jdeveloper.deploy.Runnable;
import oracle.jdeveloper.deploy.Stateful;
import oracle.jdeveloper.deploy.StatefulDeployment;
import oracle.jdeveloper.deploy.contrib.Listener;
import oracle.jdeveloper.deploy.eventhub.EventHub;
import oracle.jdeveloper.deploy.eventhub.spi.AbstractHandle;
import oracle.jdeveloper.deploy.events.DeploymentStateChange;
import oracle.jdeveloper.deploy.spi.ProgressObject;
import oracle.jdevimpl.deploy.res.FwkArb;

public abstract class RunnableImpl
implements Runnable,
ProgressObject,
Stateful {
    private int _deploySequence;
    private DeployShell _shell;
    private Icon _icon;
    private String _shortLabel;
    private String _longLabel;
    private String _toolTipText;
    private int _deployCounter = 0;
    private Object _state = ProgressState.UNDEFINED;
    private List<ProgressListener> _apiListeners = new ArrayList<ProgressListener>();
    private List<oracle.jdeveloper.deploy.spi.ProgressListener> _spiListeners = new ArrayList<oracle.jdeveloper.deploy.spi.ProgressListener>();

    public RunnableImpl(int sequence, DeployShell shell) {
        this._deploySequence = sequence;
        this._shell = shell;
    }

    public DeployShell getDeployShell() {
        return this._shell;
    }

    @Override
    public Object getState() {
        return this._state;
    }

    public void setShortLabel(String label) {
        this._shortLabel = label;
    }

    public void setLongLabel(String label) {
        this._longLabel = label;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public void setTooltipText(String text) {
        this._toolTipText = text;
    }

    public String getShortLabel() {
        return this._shortLabel;
    }

    public String getLongLabel() {
        return this._longLabel;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProgressListener(ProgressListener apiListener) {
        List<ProgressListener> list = this._apiListeners;
        synchronized (list) {
            this._apiListeners.add(apiListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProgressListener(ProgressListener apiListener) {
        List<ProgressListener> list = this._apiListeners;
        synchronized (list) {
            this._apiListeners.remove(apiListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireApiEvent(ProgressEvent dpe) {
        ProgressListener[] listenerArray;
        List<ProgressListener> list = this._apiListeners;
        synchronized (list) {
            listenerArray = this._apiListeners.toArray(new ProgressListener[0]);
        }
        for (ProgressListener apiPl : listenerArray) {
            apiPl.handleEvent(dpe);
        }
    }

    public void fireExceptionEvent(Exception exception) {
        this._state = ProgressState.FINISHED_WITH_EXCEPTION;
        ProgressEvent dpe = new ProgressEvent(this, ProgressEvent.EXCEPTION_EVENT_TYPE);
        dpe.setData(exception);
        this.fireApiEvent(dpe);
    }

    public void fireStartedEvent() {
        ++this._deployCounter;
        if (this._deployCounter == 1) {
            this._state = ProgressState.RUNNING;
            this.fireApiEvent(new ProgressEvent(this, ProgressEvent.START_EVENT_TYPE));
        }
    }

    public void fireFinishedEvent() {
        --this._deployCounter;
        if (this._deployCounter == 0) {
            if (this._state != ProgressState.FINISHED_WITH_EXCEPTION) {
                this._state = ProgressState.FINISHED;
            }
            this.fireApiEvent(new ProgressEvent(this, ProgressEvent.FINISH_EVENT_TYPE));
        }
    }

    @Override
    public void fireMessageEvent(String message) {
        ProgressEvent dpe = new ProgressEvent(this, ProgressEvent.MESSAGE_EVENT_TYPE);
        dpe.setData(message);
        this.fireApiEvent(dpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProgressListener(oracle.jdeveloper.deploy.spi.ProgressListener spiListener) {
        List<oracle.jdeveloper.deploy.spi.ProgressListener> list = this._spiListeners;
        synchronized (list) {
            this._spiListeners.add(spiListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProgressListener(oracle.jdeveloper.deploy.spi.ProgressListener spiListener) {
        List<oracle.jdeveloper.deploy.spi.ProgressListener> list = this._spiListeners;
        synchronized (list) {
            this._spiListeners.remove(spiListener);
        }
    }

    @Override
    public void cancel() {
        if (this._state == ProgressState.CANCELLING) {
            this._shell.getLogger().warning(FwkArb.getString(50));
            return;
        }
        this._state = ProgressState.CANCELLING;
        this._shell.getLogger().severe(FwkArb.getString(49));
        oracle.jdeveloper.deploy.spi.ProgressEvent dpe = new oracle.jdeveloper.deploy.spi.ProgressEvent(this, oracle.jdeveloper.deploy.spi.ProgressEvent.CANCEL_EVENT_TYPE);
        this.fireSpiEvent(dpe);
    }

    @Override
    public Logger getLogger() {
        DeployShell shell = this.getDeployShell();
        if (shell != null) {
            return shell.getLogger();
        }
        return null;
    }

    public void fireSpiEvent(final oracle.jdeveloper.deploy.spi.ProgressEvent dpe) {
        Thread processMessageThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                oracle.jdeveloper.deploy.spi.ProgressListener[] listenerArray;
                List list = RunnableImpl.this._spiListeners;
                synchronized (list) {
                    listenerArray = RunnableImpl.this._spiListeners.toArray(new oracle.jdeveloper.deploy.spi.ProgressListener[0]);
                }
                for (oracle.jdeveloper.deploy.spi.ProgressListener spiPl : listenerArray) {
                    spiPl.handleEvent(dpe);
                }
            }
        };
        processMessageThread.start();
    }

    protected abstract void deploy(DeployShell var1) throws Exception;

    protected void deploy() throws Exception {
        this.deploy(this.getDeployShell());
    }

    protected void printUnwrappedExceptionMessage(Throwable e, Logger logger) {
        Throwable t = e.getCause();
        if (t != null && t != e) {
            if (ModelUtil.hasLength((String)e.getMessage()) && !e.getMessage().equals(t.toString())) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.printUnwrappedExceptionMessage(t, logger);
        } else {
            Object o;
            StringBuffer s = new StringBuffer();
            if (e instanceof DeployException && (o = ((DeployException)e).getSource()) != null) {
                String name = null;
                try {
                    Method getName = o.getClass().getMethod("getName", new Class[0]);
                    Object ret = getName.invoke(o, new Object[0]);
                    if (ret != null) {
                        name = ret.toString();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                name = name == null ? o.getClass().getName() : name;
                s.append(" (");
                s.append(name);
                s.append(")");
            }
            logger.log(Level.SEVERE, e.getMessage() + s.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.fireStartedEvent();
            this.deploy();
        }
        catch (Exception e) {
            this.fireExceptionEvent(e);
        }
        finally {
            this.fireFinishedEvent();
        }
    }

    @Override
    public void initializeState() {
        StatefulDeployment.getOrCreateStatefulDeployment(this._deploySequence, this._shell).initializeState();
    }

    @Override
    public void invalidateState() {
        StatefulDeployment.getStatefulDeployment(this._shell).invalidateState();
    }

    @Override
    public void releaseState() {
        StatefulDeployment.getStatefulDeployment(this._shell).releaseState();
    }

    @Override
    public Runnable.Handle attachStateChangeListener(Listener<DeploymentStateChange> listener) {
        Runnable.Handle handle = this.attachDisabledStateChangeListener(listener);
        handle.enable();
        return handle;
    }

    @Override
    public Runnable.Handle attachDisabledStateChangeListener(Listener<DeploymentStateChange> listener) {
        StatefulDeployment.Handle handle = StatefulDeployment.getOrCreateStatefulDeployment(this._deploySequence, this._shell).attachDisabledStateChangeListener(listener);
        return new HandleImpl(handle, false);
    }

    private class HandleImpl
    extends AbstractHandle
    implements Runnable.Handle {
        private HandleImpl(EventHub.Handle delegate, boolean isEnabled) {
            super(delegate, isEnabled);
        }
    }
}

