/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.prf.spi;

import java.util.ArrayList;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBBuilder;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;
import oracle.jdeveloper.deploy.prf.spi.BuilderContext;
import oracle.jdeveloper.deploy.prf.spi.Recognizer;
import oracle.jdeveloper.deploy.prf.spi.Recognizers;

public class RecognizersImpl
extends Recognizers {
    ArrayList<MetaClass<Recognizer>> recognizers_ = new ArrayList();

    public void register(Class<? extends Recognizer> recognizer) {
        this.register((MetaClass<Recognizer>)new MetaClass(recognizer.getClassLoader(), recognizer.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MetaClass<Recognizer> recognizer) {
        ArrayList<MetaClass<Recognizer>> arrayList = this.recognizers_;
        synchronized (arrayList) {
            if (this.recognizers_.contains(recognizer)) {
                throw new IllegalStateException("Recognizer " + recognizer.getClassName() + " already registered");
            }
            this.recognizers_.add(recognizer);
        }
    }

    public void unregister(Class<? extends Recognizer> recognizer) {
        this.unregister((MetaClass<Recognizer>)new MetaClass(recognizer.getClassLoader(), recognizer.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregister(MetaClass<Recognizer> recognizer) {
        ArrayList<MetaClass<Recognizer>> arrayList = this.recognizers_;
        synchronized (arrayList) {
            if (!this.recognizers_.contains(recognizer)) {
                throw new IllegalStateException("Recognizer " + recognizer.getClassName() + " not registerd");
            }
            this.recognizers_.remove(recognizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OBRecognizer<Element, Profile, Context>> getAllRecognizers() {
        ArrayList<OBRecognizer<Element, Profile, Context>> newList = new ArrayList<OBRecognizer<Element, Profile, Context>>();
        ArrayList<MetaClass<Recognizer>> arrayList = this.recognizers_;
        synchronized (arrayList) {
            for (MetaClass<Recognizer> rc : this.recognizers_) {
                try {
                    Recognizer r = (Recognizer)rc.newInstance();
                    if (r instanceof OBRecognizer) {
                        newList.add((OBRecognizer)((Object)r));
                        continue;
                    }
                    newList.add(new RecognizerPatternAdapter(r));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return newList;
    }

    private class RecognizerPatternAdapter
    implements OBRecognizer<Element, Profile, Context> {
        final Recognizer recognizer_;

        RecognizerPatternAdapter(Recognizer recognizer) {
            this.recognizer_ = recognizer;
        }

        @Override
        public OBBuilder<Element, Profile, Context> recognize(Element recognize, OBContext<Element, Profile, Context> context, Class classOrIntf) {
            return this.recognizer_.recognize(recognize, (BuilderContext)((Object)context), classOrIntf);
        }
    }
}

