/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import java.util.ArrayList;
import java.util.Collections;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.DiscoveredDependable;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DependableFactory;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.spi.DependableFactory;
import oracle.jdeveloper.deploy.spi.HashDependableReader;
import oracle.jdeveloper.deploy.spi.HashDependableWriter;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;

public class DeploymentDependableRecognizer
extends DependableRecognizer {
    static final String DEPLOY_DEPENDABLE_IDSTAMP = "deployDependable";

    public Dependable create(Context context) {
        DependableFactory.Parms parms = new DependableFactory.Parms(new Context(context));
        assert (parms.getParent() != null);
        assert (parms.getOrigin() != null);
        parms.setDepth(DependableFactory.Parms.Depth.SELF);
        ArrayList dependables = new ArrayList();
        try {
            DependableFactory[] factory = ToolkitFactory.Utils.narrowBuild(parms.getContext(), DependableFactory.class, new DependableFactory[0]);
            for (int i = 0; i < factory.length; ++i) {
                Dependable[] deps = factory[i].createDependables();
                Collections.addAll(dependables, deps);
            }
        }
        catch (ToolkitBuildException ex) {
            // empty catch block
        }
        return dependables.size() > 0 ? (Dependable)dependables.get(0) : null;
    }

    public HashStructure toHashStructure(Dependable d, Element source) {
        ToolkitRegistry reg = ToolkitRegistry.getInstance();
        Context ctx = new Context(source);
        HashDependableWriter.SpiData data = HashDependableWriter.SpiData.getInstance(ctx);
        data.setDependable(d);
        try {
            ToolkitBuilder builder = reg.getBuilder(ctx, HashDependableWriter.class);
            HashDependableWriter[] writers = builder.narrowBuildToolkits(new HashDependableWriter[0]);
            HashStructure hash = HashStructure.newInstance();
            writers[0].write(hash);
            HashStructure deployDependable = HashStructure.newInstance();
            deployDependable.putHashStructure(DEPLOY_DEPENDABLE_IDSTAMP, hash);
            return deployDependable;
        }
        catch (ToolkitBuildException e) {
            return null;
        }
    }

    public Dependable toDependable(HashStructure hash, Element source) {
        HashStructure dependableHash = null;
        dependableHash = !hash.containsKey(DEPLOY_DEPENDABLE_IDSTAMP) ? hash : hash.getHashStructure(DEPLOY_DEPENDABLE_IDSTAMP);
        ToolkitRegistry reg = ToolkitRegistry.getInstance();
        Context ctx = new Context(source);
        HashDependableReader.SpiData data = HashDependableReader.SpiData.getInstance(ctx);
        data.setHashStructure(dependableHash);
        try {
            ToolkitBuilder builder = reg.getBuilder(ctx, HashDependableReader.class);
            HashDependableReader[] readers = builder.narrowBuildToolkits(new HashDependableReader[0]);
            return readers[0].read();
        }
        catch (ToolkitBuildException e) {
            Assert.println((String)"Warning: Deployment Dependable Recognizer did not recognize passed HashStructure");
            return null;
        }
    }

    public Iterable<DiscoveredDependable> discover(Context context) {
        return null;
    }
}

