/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleEvent;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleListener;
import oracle.jdevimpl.deploy.res.StripeArb;
import oracle.jdevimpl.deploy.stripe.InputStreamProvider;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;
import oracle.jdevimpl.deploy.stripe.OutputStreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProviderFactory;
import oracle.jdevimpl.deploy.stripe.URLStreamProviderFactory;

public abstract class AbstractModuleIO
implements DeploymentModuleIO {
    protected URL url_;
    protected DeploymentModule archive_;
    protected StreamProviderFactory providerFactory_;
    HashSet<OutputStreamProvider> openedOutputStreamProviders_ = new HashSet();
    HashMap<String, OutputStreamProvider> modifiedEntries_ = new HashMap();
    HashMap<OutputStreamProvider, ArrayList<InputStreamProvider>> pinnedProviders_ = new HashMap();
    ModuleListener moduleListener_ = null;

    public AbstractModuleIO() {
        this(new URLStreamProviderFactory());
    }

    public AbstractModuleIO(StreamProviderFactory streamProviderFactory) {
        this.setStreamProviderFactory(streamProviderFactory);
    }

    @Override
    public void setArchive(DeploymentModule archive) throws IOException {
        if (this.archive_ != null) {
            this.archive_.removeChangeListener(this.moduleListener_);
            this.moduleListener_ = null;
        }
        this.rollback();
        this.archive_ = archive;
        this.moduleListener_ = new ModuleListener(this);
        this.archive_.addChangeListener(this.moduleListener_);
    }

    public DeploymentModule getArchive() {
        return this.archive_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        try {
            this.commitImpl();
            Assert.println((String)("Archive committed. " + this.getURL()));
        }
        finally {
            this.invalidateOpenOutputStreams();
        }
    }

    public boolean isModified(ArchiveEntry entry) {
        return this.modifiedEntries_.get(entry.getName()) != null;
    }

    protected void invalidateOpenOutputStreams() {
        this.openedOutputStreamProviders_.clear();
    }

    protected void purgeModifications(String entry) {
        this.modifiedEntries_.remove(entry);
    }

    public abstract void commitImpl() throws IOException;

    @Override
    public abstract void rollback() throws IOException;

    public abstract boolean isArchiveReadOnly();

    OutputStreamProvider getOutputStreamProvider(ArchiveEntry entry) {
        StreamProviderFactory factory = this.getStreamProviderFactory();
        return factory.createTempOutputProvider(entry);
    }

    InputStreamProvider getInputStreamProvider(OutputStreamProvider provider) {
        StreamProviderFactory factory = this.getStreamProviderFactory();
        return factory.createInputProvider(provider);
    }

    OutputStreamProvider getInputOnlyStreamProvider(ArchiveEntry entry) {
        StreamProviderFactory factory = this.getStreamProviderFactory();
        return factory.createOriginalReadOnlyProvider(entry);
    }

    public StreamProviderFactory getStreamProviderFactory() {
        return this.providerFactory_;
    }

    public void setStreamProviderFactory(StreamProviderFactory factory) {
        this.providerFactory_ = factory;
    }

    OutputStream openOutputStream(ArchiveEntry entry) throws IOException {
        OutputStreamProvider provider = this.getOutputStreamProvider(entry);
        this.openedOutputStreamProviders_.add(provider);
        provider.addChangeListener(new StreamCloseListener(provider));
        return provider.getOutputStream();
    }

    synchronized void outputStreamClosed(OutputStreamProvider output) throws IOException {
        String entryName = output.getEntry().getName();
        if (output.isDirty()) {
            if (!this.openedOutputStreamProviders_.contains(output)) {
                output.release();
                throw new IOException(StripeArb.getString(0));
            }
            OutputStreamProvider oldProvider = this.modifiedEntries_.get(entryName);
            if (oldProvider != null && this.pinnedProviders_.get(oldProvider) == null) {
                oldProvider.release();
            }
            Assert.check((output.getStatus() == 3 ? 1 : 0) != 0);
            this.modifiedEntries_.put(entryName, output);
        } else {
            output.release();
        }
        this.openedOutputStreamProviders_.remove(output);
    }

    synchronized InputStream openInputStream(ArchiveEntry entry) throws IOException {
        OutputStreamProvider provider = this.modifiedEntries_.get(entry.getName());
        if (provider == null) {
            provider = this.getInputOnlyStreamProvider(entry);
        }
        InputStreamProvider newProvider = this.getInputStreamProvider(provider);
        ArrayList<InputStreamProvider> currentStreams = this.pinnedProviders_.get(provider);
        if (currentStreams == null) {
            currentStreams = new ArrayList();
            this.pinnedProviders_.put(provider, currentStreams);
        }
        currentStreams.add(newProvider);
        newProvider.addChangeListener(new StreamCloseListener(newProvider, provider));
        return newProvider.getInputStream();
    }

    synchronized void inputStreamClosed(StreamProvider inputProvider, StreamProvider outputProvider) throws IOException {
        ArrayList<InputStreamProvider> streams = this.pinnedProviders_.get(outputProvider);
        streams.remove(inputProvider);
        if (streams.size() == 0) {
            this.pinnedProviders_.remove(outputProvider);
            String entryName = outputProvider.getEntry().getName();
            if (this.modifiedEntries_.get(entryName) != outputProvider) {
                outputProvider.release();
            }
        }
        inputProvider.release();
    }

    @Override
    public URL getURL() {
        return this.url_;
    }

    @Override
    public void setURL(URL url) {
        this.url_ = url;
    }

    @Override
    public void load() throws IOException {
        this.load(this.getURL());
    }

    @Override
    public void load(URL url) throws IOException {
        this.rollback();
    }

    @Override
    public OutputStream getOutputStream(ArchiveEntry entry) throws IOException {
        if (this.isArchiveReadOnly()) {
            throw new IOException(StripeArb.format(1, this.getURL()));
        }
        return this.openOutputStream(entry);
    }

    @Override
    public InputStream getInputStream(ArchiveEntry entry) throws IOException {
        return this.openInputStream(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws IOException {
        IOException e = null;
        try {
            ArrayList<InputStreamProvider> isProviders = new ArrayList<InputStreamProvider>();
            for (OutputStreamProvider key : this.pinnedProviders_.keySet()) {
                for (InputStreamProvider isp : this.pinnedProviders_.get(key)) {
                    isProviders.add(isp);
                }
            }
            for (InputStreamProvider isp : isProviders) {
                try {
                    isp.getInputStream().close();
                }
                catch (IOException exc) {
                    e = e == null ? exc : e;
                }
            }
            Assert.check((this.pinnedProviders_.size() == 0 ? 1 : 0) != 0, (String)("Output streams still open: " + this.pinnedProviders_.size()));
            for (OutputStreamProvider provider : this.modifiedEntries_.values()) {
                try {
                    Assert.check((provider.getStatus() == 3 ? 1 : 0) != 0, (String)"Expected output stream to be closed");
                    provider.release();
                }
                catch (IOException exc) {
                    e = e == null ? exc : e;
                }
            }
            for (OutputStreamProvider provider : this.openedOutputStreamProviders_) {
                try {
                    provider.getOutputStream().close();
                }
                catch (IOException exc) {
                    e = e == null ? exc : e;
                }
            }
        }
        finally {
            if (e != null) {
                throw e;
            }
        }
    }

    class ModuleListener
    implements DeploymentModuleListener {
        final AbstractModuleIO moduleIO;

        ModuleListener(AbstractModuleIO moduleIO) {
            this.moduleIO = moduleIO;
        }

        @Override
        public void moduleChanged(DeploymentModuleEvent event) {
            if (event.getType() == 7) {
                ArchiveEntry entry = event.getArchiveEntry();
                this.moduleIO.purgeModifications(entry.getName());
            }
        }
    }

    static class CouchedException
    extends RuntimeException {
        CouchedException(Exception e) {
            super(e);
        }
    }

    class StreamCloseListener
    implements ChangeListener {
        OutputStreamProvider output_;
        InputStreamProvider input_;

        StreamCloseListener(OutputStreamProvider output) {
            this.output_ = output;
            this.input_ = null;
        }

        StreamCloseListener(InputStreamProvider input, OutputStreamProvider output) {
            this.output_ = output;
            this.input_ = input;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MonitoredStream st = (MonitoredStream)e.getSource();
            if (st.getStatus() == 3) {
                try {
                    if (this.input_ != null) {
                        AbstractModuleIO.this.inputStreamClosed(this.input_, this.output_);
                    } else {
                        AbstractModuleIO.this.outputStreamClosed(this.output_);
                    }
                }
                catch (IOException exc) {
                    throw new CouchedException(exc);
                }
            }
        }
    }
}

