/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleEvent;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdeveloper.deploy.DeploymentModuleListener;
import oracle.jdeveloper.deploy.StateException;
import oracle.jdevimpl.deploy.logging.DeployLogOutputStream;

public class DeploymentModuleImpl
extends DeploymentModule {
    DeploymentModuleIO io_;
    Logger logger_;
    TagSupport tagSupport_ = new TagSupport();
    HashStructure properties_ = HashStructure.newInstance();
    boolean initialized = false;
    boolean released = false;
    final EventListenerList listeners_ = new EventListenerList();
    static DefaultModuleIOFactoryImpl defaultModuleIOFactory_ = new DefaultModuleIOFactoryImpl();

    private DeploymentModuleImpl() {
    }

    public DeploymentModuleImpl(Archive archive, DeploymentModuleIO moduleIO, Logger logger, Object[] initialTags) {
        this.logger_ = logger == null ? Logger.getLogger("oracle.jdeveloper.deploy") : logger;
        this.io_ = moduleIO;
        try {
            this.io_.setArchive(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fireModuleCreated();
        if (archive != null) {
            archive.copyTo(this);
        }
        this.tagSupport_.add(initialTags);
        this.initialized = true;
        this.released = false;
    }

    @Override
    public void addContents(ArchiveEntry cdaPacket) {
        DeploymentModuleImpl.assertNotReleased(this);
        super.addContents(cdaPacket);
        this.fireEntryAdded(cdaPacket);
    }

    @Override
    public ArchiveEntry removeEntry(String entryName) {
        DeploymentModuleImpl.assertNotReleased(this);
        ArchiveEntry entry = super.removeEntry(entryName);
        if (entry != null) {
            this.fireEntryRemoved(entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveEntry renameEntry(String fromName, String toName) {
        DeploymentModuleImpl.assertNotReleased(this);
        int READ_BLOCK_SIZE = 2048;
        if (fromName.equals(toName)) {
            return null;
        }
        ArchiveEntry from = this.getEntryByName(fromName);
        if (from == null) {
            return null;
        }
        ArchiveEntry to = new ArchiveEntry(toName, null);
        InputStream in = null;
        OutputStream out = null;
        try {
            int r;
            this.addContents(to);
            in = this.openInputStream(from);
            out = this.openOutputStream(to);
            byte[] buffer = new byte[2048];
            do {
                if ((r = in.read(buffer)) < 0) continue;
                out.write(buffer, 0, r);
            } while (r >= 0);
        }
        catch (IOException e) {
            ArchiveEntry archiveEntry;
            try {
                this.removeEntry(toName);
                archiveEntry = null;
            }
            catch (Throwable throwable) {
                DeploymentModule.close(in, out);
                throw throwable;
            }
            DeploymentModule.close(in, out);
            return archiveEntry;
        }
        DeploymentModule.close(in, out);
        this.removeEntry(fromName);
        return to;
    }

    @Deprecated
    public static DeploymentModuleImpl create(String moduleIO) {
        return DeploymentModuleImpl.create(null, moduleIO, null, null);
    }

    public static DeploymentModuleImpl create(Archive archive, String ioModule, Logger logger, Object[] initialTags) {
        DeploymentModuleIOFactory factory = DeploymentModuleImpl.getModuleIOFactory();
        Assert.check((factory != null ? 1 : 0) != 0, (String)"Could not find any I/O modules for this deployment");
        return new DeploymentModuleImpl(archive, factory.create(ioModule), logger, initialTags);
    }

    @Override
    public void commit() throws DeployException {
        DeploymentModuleImpl.assertNotReleased(this);
        this.fireModuleWillCommit();
        try {
            this.io_.commit();
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
        this.fireModuleCommitted();
    }

    @Override
    public void rollback() throws DeployException {
        DeploymentModuleImpl.assertNotReleased(this);
        this.fireModuleWillRollback();
        try {
            this.io_.rollback();
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
        this.fireModuleRolledback();
    }

    @Override
    public void load() throws IOException {
        this.io_.load();
    }

    @Override
    public OutputStream openOutputStream(ArchiveEntry entry) throws IOException {
        DeploymentModuleImpl.assertNotReleased(this);
        return this.io_.getOutputStream(entry);
    }

    @Override
    public InputStream openInputStream(ArchiveEntry entry) throws IOException {
        DeploymentModuleImpl.assertNotReleased(this);
        return this.io_.getInputStream(entry);
    }

    @Override
    public Logger getLogger() {
        return this.logger_;
    }

    @Override
    public PrintWriter getPrintWriter() {
        DeployLogOutputStream os = new DeployLogOutputStream(this.logger_);
        os.setCurrentLevel(Level.ALL);
        PrintWriter writer = new PrintWriter(os);
        return writer;
    }

    @Override
    public DeploymentModule[] getContainedModules() {
        return new DeploymentModule[0];
    }

    private static void assertNotReleased(DeploymentModuleImpl module) {
        if (module.released) {
            throw new IllegalStateException("Deployment Module has already been released");
        }
    }

    public static void close(Throwable throwable, Object[] streams) throws Throwable {
        for (int i = 0; i < streams.length; ++i) {
            Object obj = streams[i];
            if (obj instanceof InputStream) {
                try {
                    ((InputStream)obj).close();
                }
                catch (IOException e) {}
                continue;
            }
            if (!(obj instanceof OutputStream)) continue;
            try {
                ((OutputStream)obj).close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void close(Object[] streams) {
        try {
            DeploymentModuleImpl.close(null, streams);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(DeploymentModuleListener listener) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.add(DeploymentModuleListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(DeploymentModuleListener listener) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.remove(DeploymentModuleListener.class, listener);
        }
    }

    void fireModuleCreated() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 1);
        this.fireEvent(event);
    }

    void fireModuleWillCommit() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 2);
        this.fireEvent(event);
    }

    void fireModuleCommitted() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 5);
        this.fireEvent(event);
    }

    void fireModuleWillRollback() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 3);
        this.fireEvent(event);
    }

    void fireModuleRolledback() {
        DeploymentModuleEvent event = new DeploymentModuleEvent(this, 4);
        this.fireEvent(event);
    }

    void fireEntryAdded(ArchiveEntry entry) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 6, entry);
        this.fireEvent(event);
    }

    void fireEntryRemoved(ArchiveEntry entry) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 7, entry);
        this.fireEvent(event);
    }

    void fireTagAdded(Object tag) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 8, tag);
        this.fireEvent(event);
    }

    void fireTagRemoved(Object tag) {
        DeploymentModuleEvent event = new DeploymentModuleEvent((DeploymentModule)this, 9, tag);
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(DeploymentModuleEvent event) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            for (DeploymentModuleListener listener : (DeploymentModuleListener[])this.listeners_.getListeners(DeploymentModuleListener.class)) {
                listener.moduleChanged(event);
            }
        }
    }

    public static void addModuleIOFactoryImpl(DeploymentModuleIOFactory factory) {
        defaultModuleIOFactory_.add(factory);
    }

    public static DeploymentModuleIOFactory getModuleIOFactory() {
        return defaultModuleIOFactory_;
    }

    @Override
    public void releaseState() throws StateException {
        try {
            this.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void release() throws DeployException {
        try {
            this.io_.release();
            this.released = true;
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
    }

    @Override
    public URL getURL() {
        return this.io_.getURL();
    }

    @Override
    public void setURL(URL targetURL) throws IOException {
        this.io_.setURL(targetURL);
    }

    @Override
    public void setModuleIO(String ioModule) {
        DeploymentModuleIOFactory factory = DeploymentModuleImpl.getModuleIOFactory();
        Assert.check((factory != null ? 1 : 0) != 0, (String)"Could not find any I/O modules for this deployment");
        this.io_ = factory.create(ioModule);
        Assert.check((this.io_ != null ? 1 : 0) != 0, (String)"Could not find any I/O modules for this deployment");
        try {
            this.io_.setArchive(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTag(Object tag) {
        this.tagSupport_.add(tag);
    }

    @Override
    public Object[] getTags() {
        return this.tagSupport_.getTags();
    }

    @Override
    public Object removeTag(Object tag) {
        return this.tagSupport_.remove(tag);
    }

    public HashStructure getProperties() {
        return this.properties_;
    }

    @Override
    public Object copyTo(Object target) {
        DeploymentModuleImpl copy = target != null ? (DeploymentModuleImpl)target : new DeploymentModuleImpl();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(DeploymentModuleImpl copy) {
        super.copyTo(copy);
        copy.properties_ = this.properties_.copyTo(null);
        this.tagSupport_.copyTo(copy.tagSupport_);
        copy.logger_ = this.logger_;
    }

    @Override
    public DeploymentModuleIO getModuleIO() {
        return this.io_;
    }

    @Override
    public void setModuleId(String id) {
        this.properties_.putString("MODULE_ID", id);
    }

    @Override
    public String getModuleId() {
        return this.properties_.getString("MODULE_ID");
    }

    class TagSupport {
        TreeSet<Object> tags_ = new TreeSet();

        TagSupport() {
        }

        TagSupport(TagSupport t) {
            for (Object o : t.tags_) {
                this.add(o);
            }
        }

        void add(Object tag) {
            this.tags_.add(tag);
            DeploymentModuleImpl.this.fireTagAdded(tag);
        }

        void add(Object[] tags) {
            if (tags == null) {
                return;
            }
            for (Object tag : tags) {
                this.add(tag);
            }
        }

        Object[] getTags() {
            return this.tags_.toArray();
        }

        Object remove(Object tag) {
            boolean removed = this.tags_.remove(tag);
            if (removed) {
                DeploymentModuleImpl.this.fireTagRemoved(tag);
                return tag;
            }
            return null;
        }

        public Object copyTo(Object o) {
            TagSupport copy = o == null ? new TagSupport() : (TagSupport)o;
            this.copyToImpl(copy);
            return copy;
        }

        protected void copyToImpl(TagSupport t) {
            t.tags_ = new TreeSet<Object>((SortedSet<Object>)this.tags_);
        }
    }

    static class DefaultModuleIOFactoryImpl
    extends ArrayList<DeploymentModuleIOFactory>
    implements DeploymentModuleIOFactory {
        DefaultModuleIOFactoryImpl() {
        }

        @Override
        public DeploymentModuleIO create(String moduleIO) {
            for (int i = this.size() - 1; i >= 0; --i) {
                DeploymentModuleIO io = ((DeploymentModuleIOFactory)this.get(i)).create(moduleIO);
                if (io == null) continue;
                return io;
            }
            return null;
        }
    }
}

