/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.config.FileAssociations;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.config.FileTypesClosure;
import oracle.ideimpl.config.FileTypesPrefs;
import oracle.ideimpl.editor.DeclarativeEditorAddin;
import oracle.ideimpl.editor.DefaultEditorManager;
import oracle.ideimpl.editor.DefaultEditorsPrefs;
import oracle.ideimpl.resource.FileBundle;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.PlatformUtils;

public class DocumentExtensionsPanel
extends DefaultTraversablePanel {
    private static boolean DEBUG;
    private Collection<String> _nonDeclarativeExtensionsToClasses;
    private Collection<String> _nonDeclarativeExtensionsToContentTypes;
    private Collection<String> _nonDeclarativeDocInfoNodeTypes;
    private Collection<String> _nonRegisteredDocInfoNodeTypes;
    public static final Color COLOR_PINK;
    public static final Color COLOR_YELLOW;
    public static final Color COLOR_NO_DOCINFO;
    public static final Color COLOR_NONDECLARATIVE_DOCINFO;
    public static final Color COLOR_NONDECLARATIVE_CONTENTTYPE;
    public static final Color COLOR_NONDECLARATIVE_EXTENSION;
    public static final Color COLOR_NONDECLARATIVE_EDITOR;
    private Map<String, DocRecord> _docRecordCache;
    private Map<String, ExtInfo> _extInfoCache;
    private Map<String, EditorAddin[]> _editorAddinCache;
    private Map<String, String> _extensionToNodeTypeMapOnEntry;
    private Map<String, String> _extensionToContentTypeMap;
    private Map<String, String> _extensionToContentTypeMapOnEntry;
    private Map<String, String> _defaultEditorMap;
    private Map<String, String> _defaultEditorMapOnEntry;
    private Map<String, Boolean> _associationMap;
    private static final Map<String, Boolean> _appliedAssociationMap;
    private Map<String, Boolean> _sessionExtensions = new HashMap<String, Boolean>();
    private static final boolean IS_WINDOWS;
    private final JTabbedPane _tabbedPane = new JTabbedPane();
    private final JPanel _fileTypesPanel = new JPanel();
    private final FileTypesTable _fileTypesTable = new FileTypesTable();
    private final JPanel _fileTypesDetailPanel = new JPanel();
    private final JButton _addButton = new JButton();
    private final JButton _removeButton = new JButton();
    private final JLabel _fileTypeLabel = new JLabel();
    private final JComboBox _fileTypeCombo = new JComboBox();
    private final JLabel _contentLabel = new JLabel();
    private final JRadioButton _contentTextRadioButton = new JRadioButton();
    private final JRadioButton _contentBinaryRadioButton = new JRadioButton();
    private JCheckBox _openWithCheckBox;
    private TitledBorder _fileTypesDetailBorder;
    private final JPanel _defaultEditorsPanel = new JPanel();
    private final DefaultEditorsTable _defaultEditorsTable = new DefaultEditorsTable();
    private final JPanel _defaultEditorsDetailPanel = new JPanel();
    private final JLabel _defaultEditorLabel = new JLabel();
    private final JComboBox _defaultEditorCombo = new JComboBox();
    private final JLabel _defaultEditorCustomizedLabel = new JLabel();
    private final JPanel _spacerPanel = new JPanel();
    private TitledBorder _defaultEditorsDetailBorder;

    public DocumentExtensionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setHelpID("f1_idedidesetfiletypes_html");
    }

    public void onEntry(TraversableContext tc) {
        this.loadFrom(tc.getPropertyStorage());
    }

    public void onExit(TraversableContext tc) {
        this.commitTo(tc.getPropertyStorage());
    }

    public void cancel(ApplyEvent e) {
    }

    private void jbInit() throws Exception {
        this.buildLayouts();
        this.initializeFromResources();
        ButtonGroup contentButtonGroup = new ButtonGroup();
        contentButtonGroup.add(this._contentTextRadioButton);
        contentButtonGroup.add(this._contentBinaryRadioButton);
        contentButtonGroup = null;
        this._fileTypesDetailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this._fileTypesDetailPanel.setBorder(this._fileTypesDetailBorder);
        CustomComboBoxRenderer renderer = new FileTypeComboBoxRenderer(this._fileTypeCombo);
        this._fileTypeCombo.setRenderer(renderer);
        this._defaultEditorsDetailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this._defaultEditorsDetailPanel.setBorder(this._defaultEditorsDetailBorder);
        renderer = new DefaultEditorComboBoxRenderer(this._defaultEditorCombo);
        renderer.setRendererFlags(1);
        this._defaultEditorCombo.setRenderer(renderer);
        this.attachListeners();
    }

    private void buildLayouts() {
        Insets i = new Insets(2, 2, 2, 2);
        LayoutBuilder builder = new LayoutBuilder();
        builder.add((Component)new JScrollPane((Component)((Object)this._fileTypesTable)), i, 3, true, true);
        builder.nl();
        builder.addHFiller();
        builder.add((Component)this._addButton, i, 1, false, false);
        builder.add((Component)this._removeButton, i, 1, false, false);
        builder.nl();
        builder.add((Component)this._fileTypesDetailPanel, i, 3, false, true);
        builder.nl();
        builder.addToPanel((Container)this._fileTypesPanel);
        builder = new LayoutBuilder();
        builder.add((Component)this._fileTypeLabel, i, 2, false, false);
        builder.add((Component)this._fileTypeCombo, i, 2, false, true);
        builder.nl();
        builder.add((Component)this._contentLabel, i, 1, false, false);
        builder.addHGap();
        builder.add((Component)this._contentTextRadioButton, i, 1, false, false);
        builder.add((Component)this._contentBinaryRadioButton, i, 1, false, true);
        builder.nl();
        if (IS_WINDOWS) {
            this._openWithCheckBox = new JCheckBox();
            builder.add((Component)this._openWithCheckBox, i, 4, false, true);
            builder.nl();
        }
        builder.addToPanel((Container)this._fileTypesDetailPanel);
        builder = new LayoutBuilder();
        builder.add((Component)new JScrollPane((Component)((Object)this._defaultEditorsTable)), i, 1, true, true);
        builder.nl();
        builder.add((Component)this._spacerPanel, i, 1, false, true);
        builder.nl();
        builder.add((Component)this._defaultEditorsDetailPanel, i, 1, false, true);
        builder.nl();
        builder.addToPanel((Container)this._defaultEditorsPanel);
        builder = new LayoutBuilder();
        builder.add((Component)this._defaultEditorLabel, i, 1, false, false);
        builder.addHGap();
        builder.add((Component)this._defaultEditorCombo, i, 1, false, true);
        builder.nl();
        builder.addHGap();
        builder.addHGap();
        builder.add((Component)this._defaultEditorCustomizedLabel, i, 1, false, true);
        builder.nl();
        builder.addToPanel((Container)this._defaultEditorsDetailPanel);
        this.setLayout(new BorderLayout());
        this._tabbedPane.add(this._fileTypesPanel);
        this._tabbedPane.add(this._defaultEditorsPanel);
        this.add(this._tabbedPane, "Center");
    }

    private void initializeFromResources() {
        this._tabbedPane.setTitleAt(0, FileBundle.getBundle().getString("FILE_TYPES_LABEL"));
        this._tabbedPane.setTitleAt(1, FileBundle.getBundle().getString("DEFAULT_EDITORS_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)FileBundle.getBundle().getString("ADD_BUTTON_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)FileBundle.getBundle().getString("REMOVE_BUTTON_LABEL"));
        ResourceUtils.resLabel((JLabel)this._fileTypeLabel, (Component)this._fileTypeCombo, (String)FileBundle.getBundle().getString("FILE_TYPE_LABEL"));
        ResourceUtils.resLabel((JLabel)this._contentLabel, (Component)this._contentTextRadioButton, (String)FileBundle.getBundle().getString("CONTENT_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._contentTextRadioButton, (String)FileBundle.getBundle().getString("CONTENT_TEXT"));
        ResourceUtils.resButton((AbstractButton)this._contentBinaryRadioButton, (String)FileBundle.getBundle().getString("CONTENT_BINARY"));
        if (IS_WINDOWS) {
            ResourceUtils.resButton((AbstractButton)this._openWithCheckBox, (String)MessageFormat.format(FileBundle.getBundle().getString("OPEN_WITH_LABEL"), Ide.getProgramShortName()));
        }
        ResourceUtils.resLabel((JLabel)this._defaultEditorLabel, (Component)this._defaultEditorCombo, (String)FileBundle.getBundle().getString("DEFAULT_EDITOR_LABEL"));
    }

    private void attachListeners() {
        this._fileTypesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e) {
                DocumentExtensionsPanel.this._fileTypesTable_valueChanged(e);
            }
        });
        this._addButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                DocumentExtensionsPanel.this._addButton_actionPerformed(e);
            }
        });
        this._removeButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                DocumentExtensionsPanel.this._removeButton_actionPerformed(e);
            }
        });
        this._fileTypeCombo.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent e) {
                DocumentExtensionsPanel.this._fileTypeCombo_itemStateChanged(e);
            }
        });
        this._contentTextRadioButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                DocumentExtensionsPanel.this._contentTextRadioButton_actionPerformed(e);
            }
        });
        this._contentBinaryRadioButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                DocumentExtensionsPanel.this._contentBinaryRadioButton_actionPerformed(e);
            }
        });
        if (IS_WINDOWS) {
            this._openWithCheckBox.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    DocumentExtensionsPanel.this._openWithCheckBox_actionPerformed(e);
                }
            });
        }
        this._defaultEditorsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e) {
                DocumentExtensionsPanel.this._defaultEditorsTable_valueChanged(e);
            }
        });
        this._defaultEditorCombo.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent e) {
                DocumentExtensionsPanel.this._defaultEditorCombo_itemStateChanged(e);
            }
        });
    }

    private void loadFrom(PropertyStorage prefs) {
        if (DEBUG) {
            this._nonDeclarativeExtensionsToClasses = new ArrayList<String>();
            this._nonDeclarativeExtensionsToContentTypes = new ArrayList<String>();
            this._nonDeclarativeDocInfoNodeTypes = new ArrayList<String>();
            this._nonRegisteredDocInfoNodeTypes = new ArrayList<String>();
        }
        this._docRecordCache = this.createDocRecordCache(prefs);
        this._extInfoCache = this.createExtInfoCache(prefs);
        this._editorAddinCache = DocumentExtensionsPanel.createEditorAddinCache();
        this._extensionToNodeTypeMapOnEntry = this.convertDocRecordsToExtensionToNodeTypeMap(this._docRecordCache);
        this._extensionToContentTypeMap = new HashMap<String, String>();
        FileTypesPrefs fileTypes = FileTypesPrefs.getInstance((PropertyStorage)prefs);
        for (String ext : fileTypes.getExtensionsToContentTypes().keySet()) {
            String contentType = fileTypes.getContentType(ext);
            if (contentType == null) continue;
            this._extensionToContentTypeMap.put(ext, contentType);
        }
        this._extensionToContentTypeMapOnEntry = new HashMap<String, String>(this._extensionToContentTypeMap);
        this._defaultEditorMap = new HashMap<String, String>();
        DefaultEditorsPrefs defaultEditors = DefaultEditorsPrefs.getInstance((PropertyStorage)prefs);
        HashStructure editorTypes = defaultEditors.getNodeTypesToEditorTypes();
        for (String docClass : defaultEditors.getNodeTypes()) {
            this._defaultEditorMap.put(docClass, editorTypes.getString(docClass));
        }
        this._defaultEditorMapOnEntry = new HashMap<String, String>(this._defaultEditorMap);
        if (IS_WINDOWS) {
            this._associationMap = new HashMap<String, Boolean>(_appliedAssociationMap);
            Set<Map.Entry<String, Boolean>> extensions = this._associationMap.entrySet();
            for (Map.Entry<String, Boolean> item : extensions) {
                if (!item.getValue().booleanValue()) continue;
                this._extInfoCache.get(item.getKey()).setAssociated(true);
            }
        }
        this._fileTypesTable.installModel(this.createFileTypesTableModel());
        this._defaultEditorsTable.installModel(this.createDefaultEditorsTableModel());
        this._fileTypeCombo.setModel(this.createFileTypeComboModel());
        this._fileTypesTable_valueChanged(null);
        this._defaultEditorsTable_valueChanged(null);
        Dimension detailSize = new Dimension(Math.max(this._fileTypesDetailPanel.getPreferredSize().width, this._defaultEditorsDetailPanel.getPreferredSize().width), Math.max(this._fileTypesDetailPanel.getPreferredSize().height, this._defaultEditorsDetailPanel.getPreferredSize().height));
        this._fileTypesDetailPanel.setPreferredSize(detailSize);
        this._defaultEditorsDetailPanel.setPreferredSize(detailSize);
        this._spacerPanel.setPreferredSize(this._addButton.getPreferredSize());
        if (DEBUG) {
            for (Map.Entry<String, Boolean> o : Recognizer.getExtensionToMetaClassMap().keySet()) {
                this._nonDeclarativeExtensionsToClasses.add(((File)((Object)o)).getPath());
            }
            for (Map.Entry<String, Boolean> o : Recognizer.getExtensionToContentTypeMap().keySet()) {
                this._nonDeclarativeExtensionsToContentTypes.add(((File)((Object)o)).getPath());
            }
            for (Map.Entry<String, Boolean> o : Recognizer.getDeclarativeExtensionToContentTypeMap().keySet()) {
                this._nonDeclarativeExtensionsToContentTypes.remove(((File)((Object)o)).getPath());
            }
            LinkedHashSet<String> allNodeTypes = new LinkedHashSet<String>();
            allNodeTypes.addAll(this._docRecordCache.keySet());
            allNodeTypes.addAll(this._editorAddinCache.keySet());
            for (String nodeType : allNodeTypes) {
                if (Recognizer.getDocumentInfo((String)nodeType) == null) {
                    this._nonRegisteredDocInfoNodeTypes.add(nodeType);
                    continue;
                }
                if (Recognizer.getDocumentInfoForDeclarativeEntries((String)nodeType) != null) continue;
                this._nonDeclarativeDocInfoNodeTypes.add(nodeType);
            }
        }
    }

    private void commitTo(PropertyStorage prefs) {
        FileTypesPrefs fileTypes = FileTypesPrefs.getInstance((PropertyStorage)prefs);
        this._extensionToContentTypeMapOnEntry.keySet().removeAll(this._extensionToContentTypeMap.keySet());
        for (String string : this._extensionToContentTypeMapOnEntry.keySet()) {
            fileTypes.getExtensionsToContentTypes().remove(string);
        }
        for (Map.Entry entry : this._extensionToContentTypeMap.entrySet()) {
            fileTypes.setContentType((String)entry.getKey(), (String)entry.getValue());
        }
        Map<String, String> extensionToNodeTypeMap = this.convertDocRecordsToExtensionToNodeTypeMap(this._docRecordCache);
        this._extensionToNodeTypeMapOnEntry.keySet().removeAll(extensionToNodeTypeMap.keySet());
        for (String string : this._extensionToNodeTypeMapOnEntry.keySet()) {
            fileTypes.getExtensionsToNodeTypes().remove(string);
        }
        for (Map.Entry<String, String> entry : extensionToNodeTypeMap.entrySet()) {
            fileTypes.setNodeType(entry.getKey(), entry.getValue());
        }
        DefaultEditorsPrefs defaultEditors = DefaultEditorsPrefs.getInstance((PropertyStorage)prefs);
        this._defaultEditorMapOnEntry.keySet().removeAll(this._defaultEditorMap.keySet());
        HashStructure hashStructure = defaultEditors.getNodeTypesToEditorTypes();
        for (String string : this._defaultEditorMapOnEntry.keySet()) {
            hashStructure.remove(string);
        }
        for (Map.Entry<String, String> entry : this._defaultEditorMap.entrySet()) {
            defaultEditors.setEditorType(entry.getKey(), entry.getValue());
        }
        if (IS_WINDOWS) {
            FileAssociations.setAssociations(this._associationMap);
            this._associationMap.clear();
            this._sessionExtensions.clear();
            _appliedAssociationMap.clear();
            _appliedAssociationMap.putAll(this._associationMap);
        }
    }

    private Map<String, String> convertDocRecordsToExtensionToNodeTypeMap(Map<String, DocRecord> docRecordCache) {
        HashMap<String, String> extensionToNodeTypeMap = new HashMap<String, String>();
        for (Map.Entry<String, DocRecord> entry : docRecordCache.entrySet()) {
            for (ExtInfo ext : entry.getValue().getUserExtensions()) {
                extensionToNodeTypeMap.put(ext.getExtension(), entry.getKey());
            }
        }
        return extensionToNodeTypeMap;
    }

    private Map<String, DocRecord> createDocRecordCache(PropertyStorage prefs) {
        final HashMap<String, DocRecord> docRecordCache = new HashMap<String, DocRecord>();
        new FileTypesClosure(prefs){

            protected void runImpl(String ext, String docClass, boolean custom) {
                DocumentInfo info = DocumentExtensionsPanel.this.getDocumentInfoOrDefault(docClass);
                if (info.isHidden()) {
                    return;
                }
                DocRecord record = (DocRecord)docRecordCache.get(docClass);
                if (record == null) {
                    record = new DocRecord(docClass, info);
                    docRecordCache.put(docClass, record);
                }
                if (custom) {
                    record.addUserExtension(ext);
                } else {
                    record.addIdeExtension(ext);
                }
            }
        }.run();
        return docRecordCache;
    }

    private DocumentInfo getDocumentInfoOrDefault(String type) {
        DocumentInfo info = Recognizer.getDocumentInfo((String)type);
        return info != null ? info : this.defaultInfo(type);
    }

    private DocumentInfo defaultInfo(String type) {
        return new DocumentInfo(this.shortLabel(type));
    }

    private String shortLabel(String label) {
        int index = label.lastIndexOf(46);
        return index < 0 ? label : label.substring(index + 1, label.length());
    }

    private Map<String, ExtInfo> createExtInfoCache(PropertyStorage prefs) {
        final HashMap<String, ExtInfo> extInfoCache = new HashMap<String, ExtInfo>();
        new FileTypesClosure(prefs){

            protected void runImpl(String ext, String docClass, boolean custom) {
                ExtInfo info = new ExtInfo(ext, !custom);
                extInfoCache.put(ext, info);
            }
        }.run();
        return extInfoCache;
    }

    private static final Map<String, EditorAddin[]> createEditorAddinCache() {
        Class[] elementTypes;
        HashMap<String, EditorAddin[]> result = new HashMap<String, EditorAddin[]>();
        ArrayList<String> elementClassNames = new ArrayList<String>(Arrays.asList(EditorManager.getEditorManager().getStaticElementClassNames()));
        for (String elementClassName : elementClassNames) {
            EditorAddin[] editorAddins;
            if (elementClassName == null || (editorAddins = EditorManager.getEditorManager().getStaticAddins(elementClassName)).length == 0) continue;
            result.put(elementClassName, editorAddins);
        }
        for (Class elementType : elementTypes = EditorManager.getEditorManager().getStaticElementTypes()) {
            String docClass = elementType.getName();
            EditorAddin[] editorAddins = EditorManager.getEditorManager().getStaticAddins(elementType);
            if (editorAddins.length == 0) continue;
            EditorAddin[] cachedAddins = (EditorAddin[])result.get(docClass);
            if (cachedAddins != null) {
                ArrayList<EditorAddin> mergedAddins = new ArrayList<EditorAddin>(Arrays.asList(cachedAddins));
                Comparator<EditorAddin> c = new Comparator<EditorAddin>(){

                    @Override
                    public final int compare(EditorAddin ea1, EditorAddin ea2) {
                        return DocumentExtensionsPanel.getEditorClassNameFromEditorAddin(ea1).compareTo(DocumentExtensionsPanel.getEditorClassNameFromEditorAddin(ea2));
                    }
                };
                Collections.sort(mergedAddins, c);
                for (EditorAddin editorAddin : editorAddins) {
                    if (Collections.binarySearch(mergedAddins, editorAddin, c) >= 0) continue;
                    mergedAddins.add(editorAddin);
                }
                editorAddins = mergedAddins.toArray(new EditorAddin[mergedAddins.size()]);
            }
            result.put(docClass, editorAddins);
        }
        Iterator itr = result.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (Recognizer.getDocumentInfo((String)((String)entry.getKey())) != null || ((EditorAddin[])entry.getValue()).length >= 2) continue;
            itr.remove();
        }
        return result;
    }

    private static EditorAddin getRoleOverrideEditor(Map<String, EditorAddin[]> editorAddinCache, String docClass) {
        EditorAddin result = null;
        String editorName = DefaultEditorManager.getRoleOverrideEditorName((String)docClass);
        if (editorName != null) {
            block0: for (Map.Entry<String, EditorAddin[]> entry : editorAddinCache.entrySet()) {
                EditorAddin[] editorAddins = entry.getValue();
                for (int i = 0; i < editorAddins.length; ++i) {
                    EditorAddin editorAddin = editorAddins[i];
                    if (!editorName.equals(DocumentExtensionsPanel.getEditorClassNameFromEditorAddin(editorAddin))) continue;
                    result = editorAddin;
                    continue block0;
                }
            }
        }
        return result;
    }

    private TableModel createFileTypesTableModel() {
        FileTypesTableModel model = new FileTypesTableModel();
        HashSet<String> extensionHash = new HashSet<String>();
        model.addColumn(FileBundle.getBundle().getString("COLUMN_EXTENSION"));
        model.addColumn(FileBundle.getBundle().getString("COLUMN_FILE_TYPE"));
        if (IS_WINDOWS) {
            model.addColumn(MessageFormat.format(FileBundle.getBundle().getString("COLUMN_OPEN_WITH"), Ide.getProgramShortName()));
        }
        for (DocRecord rec : this._docRecordCache.values()) {
            for (ExtInfo extInfo : rec.getExtensions()) {
                String extension = extInfo.getExtension();
                if (extensionHash.contains(extension)) continue;
                extensionHash.add(extension);
                if (IS_WINDOWS) {
                    boolean associated = FileAssociations.isAssociated((String)extension);
                    extInfo.setAssociated(associated);
                    this._extInfoCache.put(extInfo.getExtension(), extInfo);
                    model.addRow(new Object[]{extension, rec.getDocClass(), associated ? OracleIcons.getIcon((String)"check.png") : null});
                    continue;
                }
                model.addRow(new Object[]{extension, rec.getDocClass()});
            }
        }
        return model;
    }

    private TableModel createDefaultEditorsTableModel() {
        DefaultEditorsTableModel model = new DefaultEditorsTableModel();
        model.addColumn(FileBundle.getBundle().getString("COLUMN_FILE_TYPE"));
        model.addColumn(FileBundle.getBundle().getString("COLUMN_DEFAULT_EDITOR"));
        for (Map.Entry<String, EditorAddin[]> entry : this._editorAddinCache.entrySet()) {
            String docClass = entry.getKey();
            EditorAddin[] editorAddins = entry.getValue();
            EditorAddin editorAddin = null;
            if (this._defaultEditorMap.containsKey(docClass)) {
                String editorClassName = this._defaultEditorMap.get(docClass);
                for (int i = 0; i < editorAddins.length; ++i) {
                    if (!DocumentExtensionsPanel.getEditorClassNameFromEditorAddin(editorAddins[i]).equals(editorClassName)) continue;
                    editorAddin = editorAddins[i];
                    break;
                }
            } else {
                editorAddin = DocumentExtensionsPanel.getRoleOverrideEditor(this._editorAddinCache, docClass);
                if (editorAddin == null) {
                    for (int i = 0; i < editorAddins.length; ++i) {
                        if (!editorAddins[i].isDefault()) continue;
                        editorAddin = editorAddins[i];
                        break;
                    }
                }
            }
            if (editorAddin == null && editorAddins.length > 0) {
                editorAddin = editorAddins[0];
            }
            if (editorAddin != null && editorAddins.length == 1 && (editorAddin.getMenuSpecification() == null || editorAddin.getMenuSpecification().label == null || Recognizer.getDocumentInfo((String)docClass) == null) || editorAddin == null) continue;
            model.addRow(new Object[]{docClass, editorAddin});
        }
        return model;
    }

    private static final String getEditorClassNameFromEditorAddin(EditorAddin editorAddin) {
        if (editorAddin instanceof DeclarativeEditorAddin) {
            return ((DeclarativeEditorAddin)editorAddin).getEditorMetaClass().getClassName();
        }
        return editorAddin.getEditorClass().getName();
    }

    private ComboBoxModel createFileTypeComboModel() {
        SortedComboBoxModel model = new SortedComboBoxModel();
        model.setComparator((Comparator)new FileTypeComparator());
        Iterator<String> itr = this._docRecordCache.keySet().iterator();
        while (itr.hasNext()) {
            model.addElement((Object)itr.next());
        }
        return model;
    }

    private ComboBoxModel createDefaultEditorComboModel(String docClass) {
        SortedComboBoxModel model = new SortedComboBoxModel();
        model.setComparator((Comparator)new DefaultEditorComparator());
        if (docClass == null) {
            return model;
        }
        EditorAddin[] editorAddins = this._editorAddinCache.get(docClass);
        for (int i = 0; editorAddins != null && i < editorAddins.length; ++i) {
            model.addElement((Object)editorAddins[i]);
        }
        return model;
    }

    private void setFileTypesDetailEnabled(boolean enabled) {
        this._removeButton.setEnabled(enabled);
        this._fileTypeLabel.setEnabled(enabled);
        this._fileTypeCombo.setEnabled(enabled);
    }

    private void setFileTypesDetailContentEnabled(boolean enabled) {
        this._contentLabel.setEnabled(enabled);
        this._contentTextRadioButton.setEnabled(enabled);
        this._contentBinaryRadioButton.setEnabled(enabled);
    }

    private void setDefaultEditorsDetailEnabled(boolean enabled) {
        this._defaultEditorLabel.setEnabled(enabled);
        this._defaultEditorCombo.setEnabled(enabled);
        this._defaultEditorCustomizedLabel.setEnabled(enabled);
    }

    private void repaintFileTypesDetailPanel() {
        this.repaintPanel(this._fileTypesDetailPanel);
    }

    private void repaintDefaultEditorsDetailPanel() {
        this.repaintPanel(this._defaultEditorsDetailPanel);
    }

    private void repaintPanel(JPanel panel) {
        panel.invalidate();
        panel.validate();
        panel.repaint();
    }

    private ContentType findContentTypeFromExtension(String ext) {
        ContentType contentType = null;
        if (contentType == null) {
            String name = this._extensionToContentTypeMap.get(ext);
            ContentType contentType2 = contentType = name != null ? ContentType.valueOf((String)name) : null;
        }
        if (contentType == null) {
            contentType = this.findNonNullContentTypeFromExtension(ext);
        }
        return contentType;
    }

    private final ContentType findNonNullContentTypeFromExtension(String ext) {
        ContentType contentType = this.findRecognizerContentType(ext);
        return contentType != null ? contentType : ContentType.TEXT;
    }

    private final ContentType findRecognizerContentType(String ext) {
        if (ext != null && ext.length() > 0) {
            return (ContentType)Recognizer.getDeclarativeExtensionToContentTypeMap().get(Recognizer.sanitizeExtension((String)ext));
        }
        return null;
    }

    private void changeSelectionContentType(ContentType contentType) {
        this._extensionToContentTypeMap.put(this._fileTypesTable.getSelectedExtension(), contentType.name());
    }

    private void changeDefaultEditor(String docClass, EditorAddin editorAddin) {
        if (docClass == null || editorAddin == null) {
            return;
        }
        this._defaultEditorMap.put(docClass, DocumentExtensionsPanel.getEditorClassNameFromEditorAddin(editorAddin));
    }

    private void updateDefaultEditorCustomizedLabel(String docClass, EditorAddin editorAddin) {
        if (docClass == null || editorAddin == null) {
            this._defaultEditorCustomizedLabel.setText(" ");
            return;
        }
        EditorAddin defaultEditorAddin = DocumentExtensionsPanel.getRoleOverrideEditor(this._editorAddinCache, docClass);
        if (defaultEditorAddin == null) {
            EditorAddin[] addins;
            for (EditorAddin addin : addins = this._editorAddinCache.get(docClass)) {
                if (defaultEditorAddin != null && Version.DEBUG_BUILD != 0) {
                    Logger log = Logger.getLogger(DocumentExtensionsPanel.class.getName());
                    log.warning("More than one default editor for '" + docClass + "'.");
                    log.warning("current default: " + defaultEditorAddin.getEditorClass().getName());
                    log.warning("new default: " + addin.getEditorClass().getName());
                }
                if (!addin.isDefault()) continue;
                defaultEditorAddin = addin;
            }
        }
        if (editorAddin == defaultEditorAddin) {
            this._defaultEditorCustomizedLabel.setText(FileBundle.getBundle().getString("DEFAULT_EDITOR_UNCHANGED"));
        } else if (defaultEditorAddin != null) {
            String defaultEditorLabel = defaultEditorAddin.getMenuSpecification().label;
            this._defaultEditorCustomizedLabel.setText(MessageFormat.format(FileBundle.getBundle().getString("DEFAULT_EDITOR_CHANGED"), defaultEditorLabel));
        }
    }

    private void _fileTypesTable_valueChanged(ListSelectionEvent e) {
        ContentType contentType;
        String extension = this._fileTypesTable.getSelectedExtension();
        String docClass = this._fileTypesTable.getSelectedDocClass();
        ExtInfo extInfo = extension != null ? this._extInfoCache.get(extension) : null;
        this.setFileTypesDetailEnabled(extInfo != null && !extInfo.isLocked());
        this.setFileTypesDetailContentEnabled(extInfo != null);
        this._fileTypesDetailBorder.setTitle(MessageFormat.format(FileBundle.getBundle().getString("FILE_TYPES_DETAIL"), extInfo != null ? extInfo.toString() : ""));
        if (extension == null) {
            this.repaintFileTypesDetailPanel();
            return;
        }
        if (docClass != null) {
            this._fileTypeCombo.setSelectedItem(docClass);
        }
        this._contentTextRadioButton.setSelected((contentType = this.findContentTypeFromExtension(extension)) == ContentType.TEXT);
        this._contentBinaryRadioButton.setSelected(contentType == ContentType.BINARY);
        if (DEBUG) {
            if (this._nonDeclarativeExtensionsToContentTypes.contains(extension)) {
                this._contentTextRadioButton.setBackground(COLOR_NONDECLARATIVE_CONTENTTYPE);
                this._contentBinaryRadioButton.setBackground(COLOR_NONDECLARATIVE_CONTENTTYPE);
                this._contentTextRadioButton.setToolTipText("Content type for extension '" + extension + "' was not registered declaratively through node-recognizers-hook/url-recognizer/extension-to-content-type trigger hook");
                this._contentBinaryRadioButton.setToolTipText(this._contentTextRadioButton.getToolTipText());
            } else {
                this._contentTextRadioButton.setBackground(null);
                this._contentBinaryRadioButton.setBackground(null);
                this._contentTextRadioButton.setToolTipText(null);
                this._contentBinaryRadioButton.setToolTipText(null);
            }
        }
        if (IS_WINDOWS) {
            this._openWithCheckBox.setSelected(extInfo != null && extInfo.isAssociated());
        }
        this.repaintFileTypesDetailPanel();
    }

    private void _addButton_actionPerformed(ActionEvent e) {
        String label;
        AddExtensionDialog dlg = new AddExtensionDialog((Component)((Object)this));
        String title = FileBundle.getBundle().getString("ADD_EXT_TITLE");
        if (!dlg.show(title, label = FileBundle.getBundle().getString("EXT_LABEL"), "f1_idedaddextension_html")) {
            return;
        }
        String extension = DocRecord.sanitizeExtensionAsString(dlg.getInputValue());
        if (IS_WINDOWS) {
            ((FileTypesTableModel)((Object)this._fileTypesTable.getModel())).addRow(new Object[]{extension, DeployableTextNode.class.getName(), OracleIcons.getIcon((String)"check.png")});
        } else {
            ((FileTypesTableModel)((Object)this._fileTypesTable.getModel())).addRow(new Object[]{extension, DeployableTextNode.class.getName()});
        }
        this._fileTypesTable.reSort();
        ExtInfo extInfo = this._docRecordCache.get(DeployableTextNode.class.getName()).addUserExtension(extension);
        if (IS_WINDOWS) {
            this._associationMap.put(extension, Boolean.TRUE);
            extInfo.setAssociated(true);
            if (!this._sessionExtensions.containsKey(extension)) {
                this._sessionExtensions.put(extension, Boolean.TRUE);
            }
        }
        this._extInfoCache.put(extension, extInfo);
        this._fileTypesTable.setSelectedExtension(extension);
        this._fileTypesTable_valueChanged(null);
    }

    private void _removeButton_actionPerformed(ActionEvent e) {
        int row = this._fileTypesTable.getSelectedRowInModel();
        String extension = this._fileTypesTable.getSelectedExtension();
        String docClass = this._fileTypesTable.getSelectedDocClass();
        if (!MessageDialog.optionalConfirm((String)"Ide.FileTypes.RemoveConfirm", null, (Object)MessageFormat.format(FileBundle.getBundle().getString("CONFIRM_REMOVE"), extension), (String)FileBundle.getBundle().getString("CONFIRM_REMOVE_TITLE"), null)) {
            return;
        }
        this._extInfoCache.remove(extension);
        if (IS_WINDOWS) {
            if (this._sessionExtensions.containsKey(extension) && this._sessionExtensions.get(extension).booleanValue()) {
                this._associationMap.remove(extension);
                this._sessionExtensions.remove(extension);
            } else {
                this._associationMap.put(extension, Boolean.FALSE);
                this._sessionExtensions.put(extension, Boolean.FALSE);
            }
        }
        this._extensionToContentTypeMap.remove(extension);
        FileTypesTableModel model = (FileTypesTableModel)((Object)this._fileTypesTable.getModel());
        model.removeRow(this._fileTypesTable.rowIndexOfExtension(extension, (TableModel)((Object)model)));
        this._fileTypesTable.reSort();
        this._docRecordCache.get(docClass).removeUserExtension(extension);
        if (this._fileTypesTable.getRowCount() <= 0) {
            return;
        }
        this._fileTypesTable.setSelectedRow(Math.min(row, this._fileTypesTable.getRowCount() - 1));
        this._fileTypesTable_valueChanged(null);
    }

    private void _fileTypeCombo_itemStateChanged(ItemEvent e) {
        String userDocClass;
        String extension = this._fileTypesTable.getSelectedExtension();
        String docClass = this._fileTypesTable.getSelectedDocClass();
        if (docClass.equals(userDocClass = (String)this._fileTypeCombo.getSelectedItem())) {
            return;
        }
        this._docRecordCache.get(docClass).removeUserExtension(extension);
        ExtInfo oldInfo = this._extInfoCache.get(extension);
        ExtInfo extInfo = this._docRecordCache.get(userDocClass).addUserExtension(extension);
        if (oldInfo.isAssociated()) {
            extInfo.setAssociated(true);
            this._associationMap.put(extension, true);
        }
        this._extInfoCache.put(extension, extInfo);
        FileTypesTableModel model = (FileTypesTableModel)((Object)this._fileTypesTable.getModel());
        int row = this._fileTypesTable.rowIndexOfExtension(extension, (TableModel)((Object)model));
        this._fileTypesTable.setBaseModelDocClassValue(userDocClass, row);
        this.changeSelectionContentType(this.findNonNullContentTypeFromExtension(extension));
        this._fileTypesTable_valueChanged(null);
    }

    private void _contentTextRadioButton_actionPerformed(ActionEvent e) {
        this.changeSelectionContentType(ContentType.TEXT);
    }

    private void _contentBinaryRadioButton_actionPerformed(ActionEvent e) {
        this.changeSelectionContentType(ContentType.BINARY);
    }

    private void _openWithCheckBox_actionPerformed(ActionEvent e) {
        ExtInfo extInfo;
        String extension = this._fileTypesTable.getSelectedExtension();
        boolean selected = this._openWithCheckBox.isSelected();
        ExtInfo extInfo2 = extInfo = extension != null ? this._extInfoCache.get(extension) : null;
        if (extInfo == null) {
            return;
        }
        this._associationMap.put(extension, selected);
        extInfo.setAssociated(selected);
        this._extInfoCache.put(extension, extInfo);
        FileTypesTableModel model = (FileTypesTableModel)((Object)this._fileTypesTable.getModel());
        int row = this._fileTypesTable.rowIndexOfExtension(extension, (TableModel)((Object)model));
        this._fileTypesTable.setBaseModelOpenWithValue(this._openWithCheckBox.isSelected() ? OracleIcons.getIcon((String)"check.png") : null, row);
        this._fileTypesTable_valueChanged(null);
    }

    private void _defaultEditorsTable_valueChanged(ListSelectionEvent e) {
        String docClass = this._defaultEditorsTable.getSelectedDocClass();
        EditorAddin editorAddin = this._defaultEditorsTable.getSelectedEditorAddin();
        if (docClass != null) {
            this._defaultEditorCombo.setModel(this.createDefaultEditorComboModel(docClass));
        }
        this.setDefaultEditorsDetailEnabled(docClass != null && this._defaultEditorCombo.getModel().getSize() > 1);
        this._defaultEditorsDetailBorder.setTitle(MessageFormat.format(FileBundle.getBundle().getString("DEFAULT_EDITORS_DETAIL"), docClass != null ? RendererUtil.getDocumentLabel(docClass) : ""));
        if (docClass == null) {
            this.repaintDefaultEditorsDetailPanel();
            return;
        }
        if (editorAddin != null) {
            this._defaultEditorCombo.setSelectedItem(editorAddin);
        }
        this.updateDefaultEditorCustomizedLabel(docClass, editorAddin);
        this.repaintDefaultEditorsDetailPanel();
    }

    private void _defaultEditorCombo_itemStateChanged(ItemEvent e) {
        EditorAddin userEditorAddin;
        String docClass = this._defaultEditorsTable.getSelectedDocClass();
        EditorAddin editorAddin = this._defaultEditorsTable.getSelectedEditorAddin();
        if (editorAddin.equals(userEditorAddin = (EditorAddin)this._defaultEditorCombo.getSelectedItem())) {
            return;
        }
        DefaultEditorsTableModel model = (DefaultEditorsTableModel)((Object)this._defaultEditorsTable.getModel());
        int row = this._defaultEditorsTable.rowIndexOfDocClass(docClass, (TableModel)((Object)model));
        this._defaultEditorsTable.setBaseModelEditorAddinValue(userEditorAddin, row);
        this.changeDefaultEditor(docClass, userEditorAddin);
        this.updateDefaultEditorCustomizedLabel(docClass, userEditorAddin);
    }

    static {
        Assert.execute((Runnable)new Runnable(){

            @Override
            public final void run() {
                DEBUG = true;
            }
        });
        COLOR_PINK = new Color(255, 206, 206);
        COLOR_YELLOW = new Color(255, 255, 206);
        COLOR_NO_DOCINFO = COLOR_PINK;
        COLOR_NONDECLARATIVE_DOCINFO = COLOR_YELLOW;
        COLOR_NONDECLARATIVE_CONTENTTYPE = COLOR_YELLOW;
        COLOR_NONDECLARATIVE_EXTENSION = COLOR_YELLOW;
        COLOR_NONDECLARATIVE_EDITOR = COLOR_YELLOW;
        _appliedAssociationMap = new HashMap<String, Boolean>();
        IS_WINDOWS = PlatformUtils.isWindows() && System.getProperty("ide.shell.enableFileTypeAssociation") != null;
    }

    private class AddExtensionDialog
    extends SimpleInputDialog {
        AddExtensionDialog(Component parent) {
            super(parent);
        }

        public boolean validate(String extension) {
            int index = extension.lastIndexOf(".");
            if (index > 0) {
                String msg = MessageFormat.format(FileBundle.getBundle().getString("INVALID_EXT"), extension);
                JOptionPane.showMessageDialog((Component)this.getDialog(), msg, FileBundle.getBundle().getString("ADD_EXT_TITLE"), 0);
                return false;
            }
            extension = DocRecord.sanitizeExtensionAsString(extension);
            if (DocumentExtensionsPanel.this._extInfoCache.containsKey(extension)) {
                String msg = MessageFormat.format(FileBundle.getBundle().getString("DUPLICATE_EXT"), extension);
                JOptionPane.showMessageDialog((Component)this.getDialog(), msg, FileBundle.getBundle().getString("ADD_EXT_TITLE"), 0);
                return false;
            }
            return true;
        }
    }

    private class DefaultEditorTableCellRenderer
    extends CustomTableCellRenderer {
        private DefaultEditorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            MenuSpec menuSpec = ((EditorAddin)value).getMenuSpecification();
            if (menuSpec == null || menuSpec.label == null) {
                this.setText(DocumentExtensionsPanel.getEditorClassNameFromEditorAddin((EditorAddin)value));
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = menuSpec.getIcon()) == null) {
                icon = new EmptyIcon();
            }
            if (icon != null && !table.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            this.setText(menuSpec.label);
            if (DEBUG) {
                if (!isSelected) {
                    this.setBackground(null);
                }
                this.setToolTipText(null);
                if (value != null && !(value instanceof DeclarativeEditorAddin)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NONDECLARATIVE_EDITOR);
                    }
                    this.setToolTipText("Editor '" + ((EditorAddin)value).getEditorClass().getName() + "' was not declaratively associated with this node type through an editors/editor trigger hook");
                }
            }
            return this;
        }
    }

    private class FileTypeTableOpenWithRenderer
    extends CustomTableCellRenderer {
        private FileTypeTableOpenWithRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String unchecked = FileBundle.getBundle().getString("UNCHECKED_TEXT");
            this.setToolTipText(unchecked);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = OracleIcons.getIcon((String)"check.png");
                String checked = FileBundle.getBundle().getString("CHECKED_TEXT");
                this.setToolTipText(checked);
            }
            if (icon != null && !table.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }
    }

    private class FileTypeTableCellRenderer
    extends CustomTableCellRenderer {
        private FileTypeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            this.setText(RendererUtil.getDocumentLabel((String)value));
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = RendererUtil.getDocumentIcon((String)value)) == null) {
                icon = new EmptyIcon();
            }
            if (icon != null && !table.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            if (DEBUG) {
                String nodeType = (String)value;
                if (!isSelected) {
                    this.setBackground(null);
                }
                this.setToolTipText(null);
                if (nodeType != null && DocumentExtensionsPanel.this._nonDeclarativeDocInfoNodeTypes.contains(nodeType)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NONDECLARATIVE_DOCINFO);
                    }
                    this.setToolTipText("Document information for '" + nodeType + "' was not registered declaratively through node-recognizers-hook/document-infos/document-info trigger hook");
                }
                if (nodeType != null && DocumentExtensionsPanel.this._nonRegisteredDocInfoNodeTypes.contains(nodeType)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NO_DOCINFO);
                    }
                    this.setToolTipText("No registered document information for '" + nodeType + "', requires use of node-recognizers-hook/document-infos/document-info trigger hook");
                }
            }
            return this;
        }
    }

    private class ExtensionTableCellRenderer
    extends CustomTableCellRenderer {
        private ExtensionTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (DEBUG) {
                String ext = (String)value;
                if (!isSelected) {
                    this.setBackground(null);
                }
                this.setToolTipText(null);
                if (ext != null && DocumentExtensionsPanel.this._nonDeclarativeExtensionsToClasses.contains(ext)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NONDECLARATIVE_EXTENSION);
                    }
                    this.setToolTipText("Extension '" + ext + "' was not registered declaratively through node-recognizers-hook/url-recognizer/file-extension trigger hook");
                }
            }
            return c;
        }
    }

    private abstract class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private int _rendererFlags;

        private CustomTableCellRenderer() {
        }

        public void setRendererFlags(int rendererFlags) {
            this._rendererFlags = rendererFlags;
        }

        public int getRendererFlags() {
            return this._rendererFlags;
        }
    }

    private class DefaultEditorComboBoxRenderer
    extends CustomComboBoxRenderer {
        DefaultEditorComboBoxRenderer(JComboBox comboBox) {
            super(comboBox);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            MenuSpec menuSpec = ((EditorAddin)value).getMenuSpecification();
            if (menuSpec == null || menuSpec.label == null) {
                this.setText(DocumentExtensionsPanel.getEditorClassNameFromEditorAddin((EditorAddin)value));
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = menuSpec.getIcon();
            }
            if (icon != null && !this.getComboBox().isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            this.setText(menuSpec.label);
            if (DEBUG) {
                if (!isSelected) {
                    this.setBackground(null);
                }
                this.setToolTipText(null);
                if (value != null && !(value instanceof DeclarativeEditorAddin)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NONDECLARATIVE_EDITOR);
                    }
                    this.setToolTipText("Editor '" + ((EditorAddin)value).getEditorClass().getName() + "' was not declaratively associated with this node type through an editors/editor trigger hook");
                }
            }
            return this;
        }
    }

    private class FileTypeComboBoxRenderer
    extends CustomComboBoxRenderer {
        FileTypeComboBoxRenderer(JComboBox comboBox) {
            super(comboBox);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(null);
            this.setText("");
            if (value == null) {
                return this;
            }
            this.setText(RendererUtil.getDocumentLabel((String)value));
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = RendererUtil.getDocumentIcon((String)value);
            }
            if (icon != null && !this.getComboBox().isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            if (DEBUG) {
                String nodeType = (String)value;
                if (!isSelected) {
                    this.setBackground(null);
                }
                this.setToolTipText(null);
                if (nodeType != null && DocumentExtensionsPanel.this._nonDeclarativeDocInfoNodeTypes.contains(nodeType)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NONDECLARATIVE_DOCINFO);
                    }
                    this.setToolTipText("Document information for '" + nodeType + "' was not registered declaratively through node-recognizers-hook/document-infos/document-info trigger hook");
                }
                if (nodeType != null && DocumentExtensionsPanel.this._nonRegisteredDocInfoNodeTypes.contains(nodeType)) {
                    if (!isSelected) {
                        this.setBackground(COLOR_NO_DOCINFO);
                    }
                    this.setToolTipText("No registered document information for '" + nodeType + "', requires use of node-recognizers-hook/document-infos/document-info trigger hook");
                }
            }
            return this;
        }
    }

    private abstract class CustomComboBoxRenderer
    extends DefaultListCellRenderer {
        private final JComboBox _comboBox;
        private int _rendererFlags;

        CustomComboBoxRenderer(JComboBox comboBox) {
            this._comboBox = comboBox;
        }

        public JComboBox getComboBox() {
            return this._comboBox;
        }

        public void setRendererFlags(int rendererFlags) {
            this._rendererFlags = rendererFlags;
        }

        public int getRendererFlags() {
            return this._rendererFlags;
        }
    }

    private static class EmptyIcon
    implements Icon {
        private final int _iconWidth;
        private final int _iconHeight;

        EmptyIcon() {
            this(16, 16);
        }

        EmptyIcon(int iconWidth, int iconHeight) {
            this._iconWidth = iconWidth;
            this._iconHeight = iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this._iconWidth;
        }

        @Override
        public int getIconHeight() {
            return this._iconHeight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private static class RendererUtil {
        private RendererUtil() {
        }

        public static final Icon createDisabledIcon(Icon icon) {
            if (!(icon instanceof ImageIcon)) {
                return icon;
            }
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }

        public static final String getDocumentLabel(String docClass) {
            String label;
            DocumentInfo docInfo = Recognizer.getDocumentInfo((String)docClass);
            String string = label = docInfo != null ? docInfo.getLabel() : null;
            if (label != null) {
                return label;
            }
            label = docClass;
            int i = label.lastIndexOf(46);
            if (i < 0 || i >= label.length() - 1) {
                return label;
            }
            label = label.substring(i + 1);
            return label;
        }

        public static final Icon getDocumentIcon(String docClass) {
            DocumentInfo docInfo = Recognizer.getDocumentInfo((String)docClass);
            return docInfo != null ? docInfo.getIcon() : null;
        }
    }

    private static interface RendererFlags {
        public static final int HIDE_ICONS = 1;
    }

    private class DefaultEditorComparator
    extends CustomStringComparator {
        private DefaultEditorComparator() {
        }

        @Override
        protected int compareImpl(Object o1, Object o2) {
            MenuSpec menuSpec1 = ((EditorAddin)o1).getMenuSpecification();
            MenuSpec menuSpec2 = ((EditorAddin)o2).getMenuSpecification();
            String s1 = menuSpec1 != null ? menuSpec1.label : o1.toString();
            String s2 = menuSpec2 != null ? menuSpec2.label : o2.toString();
            return this.getStringCollator().compare(s1, s2);
        }
    }

    private class FileTypeComparator
    extends CustomStringComparator {
        private FileTypeComparator() {
        }

        @Override
        protected int compareImpl(Object o1, Object o2) {
            String s1 = RendererUtil.getDocumentLabel((String)o1);
            String s2 = RendererUtil.getDocumentLabel((String)o2);
            return this.getStringCollator().compare(s1, s2);
        }
    }

    private class CustomStringComparator
    implements Comparator {
        private final Collator _stringCollator = (Collator)Collator.getInstance().clone();

        private CustomStringComparator() {
            this._stringCollator.setStrength(0);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return this.compareImpl(o1, o2);
        }

        protected int compareImpl(Object o1, Object o2) {
            return this.getStringCollator().compare(o1.toString(), o2.toString());
        }

        protected Collator getStringCollator() {
            return this._stringCollator;
        }
    }

    private class DefaultEditorsTableModel
    extends GenericBaseTableModel {
        private DefaultEditorsTableModel() {
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            if (column == 0) {
                return new FileTypeComparator();
            }
            if (column == 1) {
                return new DefaultEditorComparator();
            }
            return null;
        }
    }

    private class FileTypesTableModel
    extends GenericBaseTableModel {
        private FileTypesTableModel() {
        }

        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            if (column == 0) {
                return new CustomStringComparator();
            }
            if (column == 1) {
                return new FileTypeComparator();
            }
            return null;
        }
    }

    private class DefaultEditorsTable
    extends MasterTable {
        private DefaultEditorsTable() {
        }

        public void setSelectedDocClass(String docClass) {
            this.setSelectedRow(this.rowIndexOfDocClass(docClass));
        }

        public String getSelectedDocClass() {
            int row = this.getSelectedRowInModel();
            return row >= 0 ? (String)this.getModel().getValueAt(row, 0) : null;
        }

        public EditorAddin getSelectedEditorAddin() {
            int row = this.getSelectedRowInModel();
            return row >= 0 ? (EditorAddin)this.getModel().getValueAt(row, 1) : null;
        }

        public int rowIndexOfDocClass(String docClass) {
            return this.rowIndexOfValue(docClass, 0);
        }

        public int rowIndexOfDocClass(String docClass, TableModel model) {
            return this.rowIndexOfValue(docClass, 0, model);
        }

        public void setBaseModelEditorAddinValue(EditorAddin editorAddin, int row) {
            this.setBaseModelCellValue(editorAddin, row, 1);
        }

        @Override
        protected void initializeCellRenderers() {
            this.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new CustomGenericTableCellRenderer(new FileTypeTableCellRenderer())));
            DefaultEditorTableCellRenderer renderer = new DefaultEditorTableCellRenderer();
            renderer.setRendererFlags(1);
            this.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new CustomGenericTableCellRenderer(renderer)));
        }
    }

    private class CustomGenericTableCellRenderer
    extends GenericTableCellRenderer {
        CustomGenericTableCellRenderer(TableCellRenderer defaultRenderer) {
            super(defaultRenderer);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (DEBUG) {
                return this.getBaseRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class FileTypesTable
    extends MasterTable {
        private FileTypesTable() {
        }

        public void setSelectedExtension(String extension) {
            this.setSelectedRow(this.rowIndexOfExtension(extension));
        }

        public String getSelectedExtension() {
            int row = this.getSelectedRowInModel();
            return row >= 0 ? (String)this.getModel().getValueAt(row, 0) : null;
        }

        public String getSelectedDocClass() {
            int row = this.getSelectedRowInModel();
            return row >= 0 ? (String)this.getModel().getValueAt(row, 1) : null;
        }

        public int rowIndexOfExtension(String extension) {
            return this.rowIndexOfValue(extension, 0);
        }

        public int rowIndexOfExtension(String extension, TableModel model) {
            return this.rowIndexOfValue(extension, 0, model);
        }

        public void setBaseModelDocClassValue(String docClass, int row) {
            this.setBaseModelCellValue(docClass, row, 1);
        }

        public void setBaseModelOpenWithValue(Object obj, int row) {
            this.setBaseModelCellValue(obj, row, 2);
        }

        @Override
        protected void initializeCellRenderers() {
            this.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new CustomGenericTableCellRenderer(new ExtensionTableCellRenderer())));
            this.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new CustomGenericTableCellRenderer(new FileTypeTableCellRenderer())));
            if (IS_WINDOWS) {
                TableColumn column = this.getColumnModel().getColumn(2);
                CustomGenericTableCellRenderer renderer = new CustomGenericTableCellRenderer(new FileTypeTableOpenWithRenderer());
                column.setCellRenderer((TableCellRenderer)((Object)renderer));
            }
        }
    }

    private abstract class MasterTable
    extends GenericTable {
        private MasterTable() {
            this.setSelectionMode(0);
            this.setUseTransferHandler(false);
            if (DEBUG) {
                this.setRolloverHighlightingEnabled(false);
            }
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            this.initializeCellRenderers();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            this.setAutoResizeMode(3);
            ((DefaultTableModel)this.getModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (model.getRowCount() > 0) {
                this.setRowSelectionInterval(0, 0);
            }
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void reSort() {
            this.setSortColumn(this.getSortColumn(), this.isSortAscending());
        }

        public void setSortColumn(int modelColumn, boolean isSortAscending) {
            int row = this.getSelectedRowInModel();
            Object keyValue = row >= 0 ? this.getModel().getValueAt(row, 0) : null;
            super.setSortColumn(modelColumn, isSortAscending);
            this.selectRowFromKeyValue(keyValue);
        }

        public void setSelectedRow(int row) {
            if (row < 0 && row >= this.getRowCount()) {
                return;
            }
            this.setSelectedRowInModel(row);
            this.scrollToSelection();
        }

        public void setBaseModelCellValue(Object aValue, int row, int column) {
            Object keyValue = this.getModel().getValueAt(row, 0);
            int selectedRow = this.getSelectedRowInModel();
            boolean reSelect = selectedRow >= 0 ? this.getModel().getValueAt(selectedRow, 0).equals(keyValue) : false;
            this.getModel().setValueAt(aValue, row, column);
            ((AbstractTableModel)this.getModel()).fireTableCellUpdated(row, column);
            super.setSortColumn(this.getSortColumn(), this.isSortAscending());
            if (reSelect) {
                this.selectRowFromKeyValue(keyValue);
            }
        }

        public int rowIndexOfValue(Object aValue, int column) {
            return this.rowIndexOfValue(aValue, column, this.getModel());
        }

        public int rowIndexOfValue(Object aValue, int column, TableModel model) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                if (!model.getValueAt(i, column).equals(aValue)) continue;
                return i;
            }
            return -1;
        }

        protected abstract void initializeCellRenderers();

        private void selectRowFromKeyValue(Object keyValue) {
            int row = this.getSelectedRowInModel();
            int row2 = -1;
            if (keyValue != null) {
                row2 = this.rowIndexOfValue(keyValue, 0);
            }
            if (row < 0 || row2 < 0 || row == row2) {
                return;
            }
            this.setSelectedRow(row2);
        }
    }

    private static final class ExtInfo {
        private boolean _locked;
        private String _extension;
        private boolean _associated;

        public ExtInfo(String extension, boolean locked) {
            this._extension = DocRecord.sanitizeExtensionAsString(extension);
            this._locked = locked;
            this._associated = false;
        }

        public boolean isLocked() {
            return this._locked;
        }

        public boolean isAssociated() {
            return this._associated;
        }

        public String getExtension() {
            return this._extension;
        }

        public void setAssociated(boolean associated) {
            this._associated = associated;
        }

        public String toString() {
            return this._extension;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ExtInfo && this.equalsImpl((ExtInfo)o);
        }

        protected final boolean equalsImpl(ExtInfo other) {
            return other._extension.equals(this._extension);
        }
    }

    private static final class DocRecord {
        private final String _docClass;
        private final DocumentInfo _info;
        private Collection<ExtInfo> _ideExtensions = new LinkedHashSet<ExtInfo>();
        private Collection<ExtInfo> _userExtensions = new LinkedHashSet<ExtInfo>();

        DocRecord(String docClass, DocumentInfo info) {
            this._docClass = docClass;
            this._info = info;
        }

        static final String sanitizeExtensionAsString(String extension) {
            return Recognizer.sanitizeExtension((String)extension).getPath();
        }

        final String getDocClass() {
            return this._docClass;
        }

        final ExtInfo addIdeExtension(String ext) {
            ExtInfo info = new ExtInfo(ext, true);
            this._ideExtensions.add(info);
            return info;
        }

        final ExtInfo addUserExtension(String ext) {
            ExtInfo info = new ExtInfo(ext, false);
            this._userExtensions.add(info);
            return info;
        }

        final void removeUserExtension(String ext) {
            this._userExtensions.remove(new ExtInfo(ext, false));
        }

        final Collection<ExtInfo> getUserExtensions() {
            return Collections.unmodifiableCollection(this._userExtensions);
        }

        final Collection<ExtInfo> getExtensions() {
            ArrayList<ExtInfo> extensions = new ArrayList<ExtInfo>();
            for (ExtInfo ext : this._ideExtensions) {
                extensions.add(ext);
            }
            for (ExtInfo ext : this._userExtensions) {
                extensions.add(ext);
            }
            return Collections.unmodifiableCollection(extensions);
        }
    }
}

