/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.PrintWriter;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.Random;

class DynaHashTest2 {
    DynaHashTest2() {
    }

    public static void main(String[] args) throws IOException {
        DynaHash.oassert.setSuppressionLevel(2);
        int nDistinct = 100;
        int nIters = 10000;
        long seed = 0L;
        if (args.length > 0) {
            nDistinct = Integer.valueOf(args[0]);
        }
        if (args.length > 1) {
            nIters = Integer.valueOf(args[1]);
        }
        if (args.length > 2) {
            seed = Long.valueOf(args[2]);
        }
        System.out.println("DynaHash test 2, nDistinct: " + nDistinct + ", nIters " + nIters + ", seed: " + seed);
        DynaHash dh = new DynaHash(new Identifier(){

            public int hash(Object obj) {
                return (Integer)obj;
            }

            public boolean identify(Object obj1, Object obj2) {
                return obj1 == obj2;
            }
        });
        Random rnd = new Random(seed);
        for (int i = 0; i < nIters; ++i) {
            Integer value = null;
            value = (Integer)dh.insert(new Integer(Math.round(rnd.nextFloat() * (float)nDistinct)));
            if (value == null) continue;
            System.err.println("Found erroneous previous value: " + value);
        }
        PrintWriter w = new PrintWriter(System.out);
        dh.getStats().print(w);
        w.flush();
        dh.checkIntegrity();
    }
}

