/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.Assertion;
import oracle.aurora.util.DynaHash;

class HashBucket {
    int bPower;
    int bMask;
    int size;
    Object[] tab;
    int select;
    int shift;
    int removed;
    HashBucket next;
    static Object deleted = new Object();

    int getBMask() {
        return (1 << this.bPower) - 1;
    }

    int getTabSize() {
        return 1 << this.bPower;
    }

    HashBucket(HashBucket next, int bPower, int select) {
        this.bPower = bPower;
        this.bMask = this.getBMask();
        this.next = next;
        this.size = 0;
        this.tab = new Object[this.getTabSize()];
        this.select = select;
        this.shift = 31;
        while (this.shift > 0 && (1 << this.shift & select) == 0) {
            --this.shift;
        }
        this.removed = 0;
    }

    int probe(DynaHash dh, Object obj, int hash, boolean insert) {
        int idx = (hash >>= this.shift) & this.bMask;
        int decr = (hash >> this.bPower | 1) & this.bMask;
        int firstDeleted = -1;
        for (int i = 0; i < this.tab.length; ++i) {
            if (this.tab[idx] == null) {
                return insert ? (firstDeleted == -1 ? idx : firstDeleted) : -1;
            }
            if (this.tab[idx] == deleted) {
                if (insert && firstDeleted == -1) {
                    firstDeleted = idx;
                }
            } else if (insert ? (dh.ident == null ? this.tab[idx].equals(obj) : dh.ident.identify(this.tab[idx], obj)) : (dh.ident == null ? this.tab[idx].equals(obj) : dh.ident.findIdentify(this.tab[idx], obj))) {
                return idx;
            }
            idx = idx - decr & this.bMask;
        }
        return firstDeleted;
    }

    int succProbeLength(DynaHash dh, Object obj, int hash) {
        int idx = (hash >>= this.shift) & this.bMask;
        int decr = (hash >> this.bPower | 1) & this.bMask;
        for (int i = 0; i < this.tab.length; ++i) {
            if (this.tab[idx] == obj) {
                return i + 1;
            }
            idx = idx - decr & this.bMask;
        }
        Assertion.oassert(false);
        return 0;
    }

    int failProbeLength(DynaHash dh, int hash) {
        int idx = (hash >>= this.shift) & this.bMask;
        int decr = (hash >> this.bPower | 1) & this.bMask;
        for (int i = 0; i < this.tab.length; ++i) {
            if (this.tab[idx] == null) {
                return i + 1;
            }
            idx = idx - decr & this.bMask;
        }
        Assertion.oassert(false);
        return 0;
    }

    void reinsert(DynaHash dh, boolean checked) {
        for (int i = 0; i < this.tab.length; ++i) {
            if (this.tab[i] == null || this.tab[i] == deleted) continue;
            if (checked) {
                dh.insert(this.tab[i]);
                continue;
            }
            dh.reinsert(this.tab[i]);
        }
    }

    void grow(DynaHash dh) {
        Object[] old = this.tab;
        ++this.bPower;
        this.bMask = this.getBMask();
        this.tab = new Object[this.getTabSize()];
        this.size = 0;
        this.removed = 0;
        for (int i = 0; i < old.length; ++i) {
            if (old[i] == null || old[i] == deleted) continue;
            dh.reinsert(old[i]);
        }
    }

    void checkIntegrity(DynaHash dh, int idx) {
        int count = 0;
        int rcount = 0;
        for (int i = 0; i < this.tab.length; ++i) {
            if (this.tab[i] == deleted) {
                ++rcount;
                continue;
            }
            if (this.tab[i] == null) continue;
            ++count;
            int hash = dh.ident == null ? this.tab[i].hashCode() : dh.ident.hash(this.tab[i]);
            Assertion.oassert(dh.buckets[hash & dh.dMask] == this);
            Assertion.oassert(this.probe(dh, this.tab[i], hash, false) == i);
        }
        Assertion.oassert(count == this.size && this.removed == rcount && (float)this.size <= dh.fillFactor * (float)this.tab.length);
    }
}

