/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.status.Severity;
import oracle.javatools.status.Status;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.service.Violation;

class DefaultStatus
implements Status {
    private boolean unknown;
    private volatile boolean stale;
    private int errors;
    private int warnings;
    private int advisories;
    private int incompletes;
    private static final Log LOG = new Log("status");
    private static final Log LOG_ISSUES = new Log("status-issues");

    DefaultStatus() {
        this.unknown = true;
        this.stale = true;
    }

    DefaultStatus(Status status) {
        this.unknown = status.getSeverity() == Severity.UNKNOWN;
        this.stale = status.isStale();
        this.errors = status.getErrorCount();
        this.warnings = status.getWarningCount();
        this.advisories = status.getAdvisoryCount();
        this.incompletes = status.getIncompleteCount();
    }

    void addViolation(Severity severity, Violation violation, int transformMask) {
        LOG_ISSUES.trace("adding {0} to {1}: {2}", (Object)severity, (Object)this, (Object)violation);
        switch (severity) {
            case ERROR: {
                ++this.errors;
                break;
            }
            case WARNING: {
                ++this.warnings;
                break;
            }
            case INCOMPLETE: {
                ++this.incompletes;
                break;
            }
            case ADVISORY: {
                ++this.advisories;
            }
        }
    }

    void addException(Throwable exception, URL file, Project project, Workspace workspace, ModelFactory factory) {
        LOG.trace("adding exception to {0}: {1}", (Object)this, (Object)exception);
        ++this.errors;
    }

    void markUnauditable(URL file, Project project, Workspace workspace, ModelFactory factory) {
        LOG.trace("marking {0} unauditable", (Object)this);
        ++this.warnings;
    }

    void markUnsupported(URL file, Project project, Workspace workspace, ModelFactory factory) {
        assert (LOG.trace("marking {0} unsupported", (Object)this));
    }

    void markCurrent() {
        assert (LOG.trace("marking {0} current", (Object)this));
        this.unknown = false;
        this.stale = false;
    }

    void markStale() {
        assert (LOG.trace("marking {0} stale", (Object)this));
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public Severity getSeverity() {
        if (this.unknown) {
            return Severity.UNKNOWN;
        }
        if (this.errors > 0) {
            return Severity.ERROR;
        }
        if (this.warnings > 0) {
            return Severity.WARNING;
        }
        if (this.incompletes > 0) {
            return Severity.INCOMPLETE;
        }
        if (this.advisories > 0) {
            return Severity.ADVISORY;
        }
        return Severity.OK;
    }

    public int getErrorCount() {
        return this.errors;
    }

    public int getWarningCount() {
        return this.warnings;
    }

    public int getIncompleteCount() {
        return this.incompletes;
    }

    public int getAdvisoryCount() {
        return this.advisories;
    }

    public String toString() {
        return this.classLabel() + "[" + Integer.toHexString(System.identityHashCode(this)) + (this.stale ? ", stale, " : ", ") + (this.unknown ? "unknown, " : "") + this.errors + "/" + this.warnings + "/" + this.incompletes + "/" + this.advisories + "]";
    }

    String classLabel() {
        return "Status";
    }
}

