/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.status.editor.EditorIssue;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.status.Status;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;

final class EditorIssueList
implements Status,
Iterable<EditorIssue> {
    private final int errorCount;
    private final int warningCount;
    private final int incompleteCount;
    private final int advisoryCount;
    private final List<EditorIssue> issues = new ArrayList<EditorIssue>();
    private final List<EditorIssue> issuesWithTransforms = new ArrayList<EditorIssue>();
    private final ModelAdapter documentModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorIssueList(IssueList issues, BasicDocument document) {
        this.errorCount = issues.getErrorCount();
        this.warningCount = issues.getWarningCount();
        this.incompleteCount = issues.getIncompleteCount();
        this.advisoryCount = issues.getAdvisoryCount();
        if (issues.size() == 0) {
            this.documentModel = null;
            return;
        }
        this.documentModel = ((Violation)issues.getIssueAt(issues.size() - 1)).getLocation().getModel();
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        ArrayList<Violation> list = new ArrayList<Violation>(1);
        list.add(null);
        for (int i = 0; i < issues.size(); ++i) {
            boolean hasTransforms;
            boolean errorAndHasStandardTransforms;
            Violation violation = (Violation)issues.getIssueAt(i);
            list.set(0, violation);
            if (violation.getSeverity() == Severity.ERROR) {
                errorAndHasStandardTransforms = transformer.hasStandardTransforms(list);
                hasTransforms = errorAndHasStandardTransforms || transformer.hasSuppressionTransforms(list, null);
            } else {
                errorAndHasStandardTransforms = false;
                hasTransforms = transformer.hasTransforms(list, null);
            }
            EditorIssue editorViolation = new EditorIssue(violation, hasTransforms, errorAndHasStandardTransforms);
            this.issues.add(editorViolation);
            if (!hasTransforms) continue;
            this.issuesWithTransforms.add(editorViolation);
        }
        document.readLock();
        try {
            for (EditorIssue issue : this.issues) {
                issue.adjustFocusLocation(document, this.documentModel);
            }
        }
        finally {
            document.readUnlock();
        }
        Collections.sort(this.issues);
        Collections.sort(this.issuesWithTransforms);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getAdvisoryCount() {
        return this.advisoryCount;
    }

    public int getIncompleteCount() {
        return this.incompleteCount;
    }

    public Severity getSeverity() {
        if (this.errorCount > 0) {
            return Severity.ERROR;
        }
        if (this.warningCount > 0) {
            return Severity.WARNING;
        }
        if (this.incompleteCount > 0) {
            return Severity.INCOMPLETE;
        }
        if (this.advisoryCount > 0) {
            return Severity.ADVISORY;
        }
        return Severity.OK;
    }

    public boolean isStale() {
        return false;
    }

    public List<EditorIssue> getIssuesWithTransforms() {
        return this.issuesWithTransforms;
    }

    public void clear() {
        this.issues.clear();
    }

    public int size() {
        return this.issues.size();
    }

    public List<EditorIssue> getIntersectingIssues(int offset) {
        ArrayList<EditorIssue> matched = new ArrayList<EditorIssue>();
        for (EditorIssue issue : this.issues) {
            Location location = issue.getFocusLocation();
            if (issue.getOffset() > offset) break;
            if (offset > location.getEndOffset()) continue;
            matched.add(issue);
        }
        return matched;
    }

    public List<EditorIssue> getIntersectingIssuesWithTransforms(int offset) {
        ArrayList<EditorIssue> matched = new ArrayList<EditorIssue>();
        for (EditorIssue issue : this.issuesWithTransforms) {
            Location location = issue.getFocusLocation();
            if (issue.getOffset() > offset) break;
            if (offset > location.getEndOffset()) continue;
            matched.add(issue);
        }
        return matched;
    }

    boolean hasIntersectingTransforms(int offset, int endOffset) {
        EditorIssue issue;
        Location location;
        int issueOffset;
        Iterator<EditorIssue> i$ = this.issuesWithTransforms.iterator();
        while (i$.hasNext() && (issueOffset = (location = (issue = i$.next()).getFocusLocation()).getOffset()) <= endOffset) {
            int issueEndOffset = location.getEndOffset();
            if (Math.max(offset, issueOffset) > Math.min(endOffset, issueEndOffset)) continue;
            return true;
        }
        return false;
    }

    public List<EditorIssue> getIntersectingIssuesWithTransforms(int offset, int endOffset) {
        EditorIssue issue;
        Location location;
        int issueOffset;
        ArrayList<EditorIssue> matched = new ArrayList<EditorIssue>();
        Iterator<EditorIssue> i$ = this.issuesWithTransforms.iterator();
        while (i$.hasNext() && (issueOffset = (location = (issue = i$.next()).getFocusLocation()).getOffset()) <= endOffset) {
            int issueEndOffset = location.getEndOffset();
            if (Math.max(offset, issueOffset) > Math.min(endOffset, issueEndOffset)) continue;
            matched.add(issue);
        }
        return matched;
    }

    @Override
    public Iterator<EditorIssue> iterator() {
        return this.issues.iterator();
    }
}

