/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.awt.BorderLayout;
import java.util.Properties;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.JDBCBasicPanel;

public class JDBCConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = -2722778367897023975L;
    private JDBCBasicPanel m_basicPanel;
    private final String DRIVER_MISSING = "DRIVER.MISSING";

    public JDBCConnectionPanel() {
        this.setLayout(new BorderLayout());
        this.m_basicPanel = new JDBCBasicPanel(this);
        this.add(this.m_basicPanel, "Center");
    }

    public void clear() {
    }

    public Properties getConnectionProperties() {
        this.m_props.setProperty("subtype", "JDBC");
        this.m_props.setProperty("RaptorConnectionType", "JDBC");
        this.m_basicPanel.populateComponent(this.m_props);
        return this.m_props;
    }

    public String getConnectionType() {
        return "JDBC";
    }

    public String getDriver() {
        if (System.getProperty("generic.jdbc", "false").equals("true") && RaptorExtensionConstants.isStandAlone()) {
            return this.m_basicPanel.getDriverClass();
        }
        return "DRIVER.MISSING";
    }

    public void setDefaultPrompts() {
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("customUrl");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        if (string.startsWith("jdbc:odbc")) {
            bl = true;
        }
        if (bl) {
            string3 = properties.getProperty("dataSourceName");
            string4 = properties.getProperty("parameters");
        } else {
            string2 = properties.getProperty("driver");
            string5 = string;
        }
        if (bl) {
            this.m_basicPanel.setDriverType(true);
            this.m_basicPanel.setDsn(string3);
            this.m_basicPanel.setExtraParams(string4);
        } else {
            this.m_basicPanel.setDriverType(false);
            this.m_basicPanel.setDriverClass(string2);
            this.m_basicPanel.setThirdPartyJdbcUrl(string5);
        }
    }
}

