/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.thirdparty.jdbc.JDBCBasicPanel;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.Version;

public class JdbcConnectionRecognizer
implements ConnectionRecognizer {
    public static String getURL(Connection connection) {
        String string = null;
        try {
            Method method;
            Class<Connection> clazz = null;
            try {
                clazz = Class.forName("sun.jdbc.odbc.JdbcOdbcConnection").asSubclass(Connection.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null && clazz.isAssignableFrom(connection.getClass()) && (method = clazz.getDeclaredMethod("getURL", new Class[0])) != null) {
                string = (String)method.invoke((Object)connection, new Object[0]);
            }
        }
        catch (Exception exception) {
            Logger.warn(JDBCBasicPanel.class, (Throwable)exception);
        }
        return string;
    }

    public ConnectionInfo createConnectionInfo(String string, Connection connection) {
        ConnectionInfo connectionInfo = null;
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
            Version version = DBUtil.getDbVersion((Connection)connection);
            String string2 = JdbcConnectionRecognizer.getURL(connection);
            if (string2 != null && string2.indexOf("Microsoft Access") == -1) {
                connectionInfo = new ConnectionInfo(string, connection, version, "ODBCBridge", null, databaseMetaData.getUserName());
            }
        }
        catch (SQLException sQLException) {
            Logger.warn(JDBCBasicPanel.class, (Throwable)sQLException);
        }
        return connectionInfo;
    }
}

