/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sybase;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sybase.BasicPanel;
import oracle.dbtools.thirdparty.sybase.SybaseBrowserAddin;
import oracle.ide.util.ResourceUtils;

public class SybaseConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _panel;
    private BasicPanel _basicPanel;
    private CardLayout _layout;
    public static final String DRIVER_CLASSNAME = "net.sourceforge.jtds.jdbc.Driver";
    public static final String HOST = "localhost";
    public static final String PORT = "5000";
    public static String SYBASE_WINDOWS_AUTHENTICATION = "sybase_windows_authentication";
    public static String IS_WINDOWS = "is_windows";
    public static String SYBASE_DEFAULT_PASSWORD = "sybase_default_password";
    public static String SYBASE_DOMAIN = "sybase_domain";

    public SybaseConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._basicPanel = new BasicPanel(this);
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this._panel.add((Component)this._basicPanel, "Basic");
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._layout.show(this._panel, "Basic");
    }

    private Properties getInput(Properties properties) {
        if (this._basicPanel.get_autoPasswordCheck().isSelected()) {
            properties.put(SYBASE_DEFAULT_PASSWORD, Boolean.TRUE.toString());
            properties.setProperty("password", "");
            properties.setProperty("NoPasswordConnection", Boolean.FALSE.toString());
        } else {
            properties.put(SYBASE_DEFAULT_PASSWORD, Boolean.FALSE.toString());
            properties.setProperty("NoPasswordConnection", Boolean.TRUE.toString());
        }
        properties.setProperty("subtype", SybaseBrowserAddin.SUBTYPE_SYBASE);
        properties.setProperty("driver", DRIVER_CLASSNAME);
        properties.setProperty("RaptorConnectionType", "Sybase");
        if (this._basicPanel.get_windowsAuthenticate().isSelected()) {
            if (this._basicPanel.get_isWindows()) {
                properties.put("user", "");
                properties.put("password", "");
                properties.put(SYBASE_DOMAIN, "");
                properties.put(IS_WINDOWS, Boolean.TRUE.toString());
            } else {
                properties.put(SYBASE_DOMAIN, this._basicPanel.getTfdDomain().getText());
            }
            properties.put(SYBASE_WINDOWS_AUTHENTICATION, Boolean.TRUE.toString());
        }
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.populateComponent(properties);
        return properties;
    }

    private CDComponentView getPanel() {
        return this._basicPanel;
    }

    public void clear() {
        this._basicPanel.clear();
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this._basicPanel.tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this._basicPanel.tfdPort.setText(string2 != null ? string2 : PORT);
        boolean bl = Boolean.parseBoolean(properties.getProperty(SYBASE_WINDOWS_AUTHENTICATION, "false"));
        this._basicPanel.setWindowsAuthSelected(bl);
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(SYBASE_DEFAULT_PASSWORD, "false"));
        this._basicPanel.setDefaultPasswordSelected(bl2);
        this._basicPanel.setDomain(properties.getProperty(SYBASE_DOMAIN, ""));
        properties.setProperty("ConnName", this.getConnectionName());
        this._basicPanel.retrieveDatabase(properties);
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }

    public void setDefaultPrompts() {
        this._basicPanel.setDefaultPrompts();
        this.getDialog().useUserName(true);
        this.getDialog().usePassword(true);
    }

    public String getConnectionType() {
        return "Sybase";
    }
}

