/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.teradata;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.teradata.TeradataBasicPanel;
import oracle.ide.util.ResourceUtils;

public class TeradataConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _panel;
    private TeradataBasicPanel _teradataBasicPanel;
    private CardLayout _layout;
    private static final String DRIVER_CLASSNAME = "com.teradata.jdbc.TeraDriver";
    public static final String HOST = "localhost";
    public static final String PORT = "1025";

    public TeradataConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._teradataBasicPanel = new TeradataBasicPanel();
        this._teradataBasicPanel.setDefaultPrompts();
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        this._panel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this._panel.add((Component)this._teradataBasicPanel, "Center");
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    private Properties getInput(Properties properties) {
        properties.setProperty("subtype", "Teradata");
        properties.setProperty("driver", DRIVER_CLASSNAME);
        properties.setProperty("RaptorConnectionType", "Teradata");
        properties.setProperty("NoPasswordConnection", Boolean.TRUE.toString());
        this._teradataBasicPanel.populateComponent(properties);
        return properties;
    }

    public void setDialog(ConnectionDialog connectionDialog) {
        super.setDialog(connectionDialog);
        this.getDialog().attachEnterKey((Component)this._teradataBasicPanel);
    }

    public void clear() {
        this._teradataBasicPanel.clear();
    }

    public void updatePrompts(final Properties properties) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    properties.setProperty("ConnName", TeradataConnectionPanel.this.getConnectionName());
                    try {
                        TeradataConnectionPanel.this._teradataBasicPanel.updatePrompts(properties);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }

    public void setDefaultPrompts() {
        this._teradataBasicPanel.setDefaultPrompts();
        this.getDialog().useUserName(true);
        this.getDialog().usePassword(true);
    }

    public String getConnectionType() {
        return "Teradata";
    }
}

