/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.tools.DbCartToolRegistry;
import oracle.dbtools.dbcart.tools.IDbCartTool;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;

public class DbCartController
implements ContextMenuListener,
ActionListener {
    private static DbCartController _instance;

    private DbCartController() {
    }

    public static synchronized DbCartController getInstance() {
        if (_instance == null) {
            _instance = new DbCartController();
        }
        return _instance;
    }

    public void installToolbar(Toolbar toolbar) {
        this.loadToolbarGroup(toolbar, 0);
        this.loadToolbarGroup(toolbar, 2);
        this.loadToolbarGroup(toolbar, 1);
        this.loadToolbarGroup(toolbar, 3);
        UIUtils.setupAccelerators((Toolbar)toolbar, (String)"oracle/dbtools/dbcart/accelerators.xml");
        this.toggleToolbar();
    }

    private void loadToolbarGroup(Toolbar toolbar, int n) {
        if (toolbar.getComponentCount() > 0) {
            toolbar.addSeparator();
        }
        List<String> list = DbCartToolRegistry.getTypes(n);
        for (String string : list) {
            IDbCartTool iDbCartTool = DbCartToolRegistry.getTool(string);
            IdeAction ideAction = iDbCartTool.getAction();
            ideAction.setEnabled(iDbCartTool.isEnabled());
            this.handleButton(ideAction, toolbar, iDbCartTool.isVisible());
        }
    }

    private void handleButton(IdeAction ideAction, Toolbar toolbar, boolean bl) {
        ToolButton toolButton = toolbar.add((ToggleAction)ideAction);
        toolButton.setVisible(bl);
        toolButton.setName(ideAction.getValue("Name").toString());
        ideAction.putValue("BUTTON", (Object)toolButton);
    }

    public void toggleToolbar() {
        List<String> list = DbCartToolRegistry.getTypes();
        for (String string : list) {
            IDbCartTool iDbCartTool = DbCartToolRegistry.getTool(string);
            iDbCartTool.toolWillEnable();
        }
        if (DbCartUtil.getTabPage() != null) {
            DbCartUtil.getTabPage().enableScriptActions();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

