/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.config.DbCartUserDiffConfig;
import oracle.dbtools.dbcart.tools.DbCartUtilityTool;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.dbdiff.DBDiffApi;
import oracle.dbtools.raptor.dbdiff.DbCartDiffOptions;
import oracle.dbtools.raptor.dbdiff.ui.DbDiffDdlOptionsPanel;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class DbCartDiffTool
extends DbCartUtilityTool
implements LayoutControl {
    public static final String TYPE = "Diff";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_diff");
    private JEWTDialog _actionDialog;
    private DbCartDiffOptions _diffOptions;
    private DDLFormat _ddlFormat;
    private JPanel _ddlPanel;
    private TitledPane _titledDestPane;
    private JPanel _instructionPanel;
    private JPanel _configPanel;
    private JPanel _bottomPanel;
    private JPanel _mainPanel;
    private JMultiLineLabel _instructions;
    private JLabel _destLab;
    private ButtonGroup _destGroup = new ButtonGroup();
    private JRadioButton _destCart = new JRadioButton();
    private JRadioButton _destConn = new JRadioButton();
    private JComboBox _destCartCombo = new JComboBox();
    private OracleConnectionComboBox _destConnSelector = new OracleConnectionComboBox();
    private static DbDiffDdlOptionsPanel _ddlOptions;
    private DbCartUserDiffConfig _config = new DbCartUserDiffConfig();
    private DBDiffApi _toolApi;
    private boolean _isDestSingleSchema;

    public DbCartDiffTool() {
        super(TYPE, 3);
    }

    @Override
    public IdeAction getAction() {
        this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("DIFF_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"showdifferences.png"), null, (boolean)true);
        this._action.addController((Controller)this);
        return this._action;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            this.showDialog();
            return true;
        }
        return false;
    }

    public void showDialog() {
        String string = DbCartAddinArb.getString("DIFF_DIALOG_TITLE");
        this._mainPanel = new JPanel(new BorderLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._mainPanel, "f1_diffobjects_html");
        this._bottomPanel = new JPanel();
        this._bottomPanel.setLayout(new GridBagLayout());
        this.createValidator((DBConnectionComboBox)this._destConnSelector);
        this._destConnSelector.getJComboBox().setSelectedIndex(-1);
        ResourceUtils.resButton((AbstractButton)this._destCart, (String)DbCartAddinArb.getString("CART_LABEL"));
        ResourceUtils.resButton((AbstractButton)this._destConn, (String)DbCartAddinArb.getString("CONN_LABEL"));
        this._ddlFormat = new DDLFormat();
        this._ddlFormat.setDDLOptionsEnabled(false);
        this._ddlFormat.setShowDDLOptionsEnabled(false);
        this._ddlFormat.isExtractEnabled(true);
        this._ddlFormat.setShowCompareOptionsEnabled(true);
        _ddlOptions = new DbDiffDdlOptionsPanel(this._ddlFormat);
        this._destGroup.add(this._destCart);
        this._destGroup.add(this._destConn);
        this._destCart.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (DbCartUtil.getPanel().getTabPageNames().size() > 1) {
                    DbCartDiffTool.this._destCartCombo.setEnabled(true);
                    DbCartDiffTool.this._isDestSingleSchema = DbCartUtil.isSingleSchema((String)DbCartDiffTool.this._destCartCombo.getSelectedItem());
                    _ddlOptions.enableIgnoreSchema(DbCartDiffTool.this._isDestSingleSchema);
                    DbCartDiffTool.this._ddlFormat.setIgnoreSchema(DbCartDiffTool.this._isDestSingleSchema);
                } else {
                    DbCartDiffTool.this._destCartCombo.setEnabled(false);
                    DbCartDiffTool.this._destConnSelector.getJComboBox().setEnabled(true);
                    DbCartDiffTool.this._isDestSingleSchema = true;
                    _ddlOptions.enableIgnoreSchema(DbCartDiffTool.this._isDestSingleSchema);
                }
            }
        });
        if (DbCartUtil.getPanel().getTabPageNames().size() > 1) {
            this._destCart.setSelected(true);
            this._destCart.setEnabled(true);
        } else {
            this._destConn.setSelected(true);
            this._isDestSingleSchema = true;
            this._destCart.setEnabled(false);
        }
        this._ddlFormat.setIgnoreSchema(true);
        this._destCartCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    DbCartDiffTool.this._isDestSingleSchema = DbCartUtil.isSingleSchema((String)DbCartDiffTool.this._destCartCombo.getSelectedItem());
                    _ddlOptions.enableIgnoreSchema(DbCartDiffTool.this._isDestSingleSchema);
                    DbCartDiffTool.this._ddlFormat.setIgnoreSchema(DbCartDiffTool.this._isDestSingleSchema);
                }
            }
        });
        this._destCartCombo.removeAllItems();
        String string2 = DbCartUtil.getPanel().getSelectedTabPageName();
        for (String object2 : DbCartUtil.getPanel().getTabPageNames()) {
            if (string2.equals(object2)) continue;
            this._destCartCombo.addItem(object2);
        }
        if (this._destCartCombo.getItemCount() > 0) {
            this._destCartCombo.setSelectedIndex(0);
        }
        this._destLab = new JLabel(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DEST_LABEL")));
        this._destLab.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("DEST_LABEL")));
        this._instructions = new JMultiLineLabel(DbCartAddinArb.getString("DIFF_INSTRUCTIONS"));
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this._destCart, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this._destCartCombo, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this._destConn, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this._destConnSelector.getJComboBox(), LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)2);
        this._titledDestPane = new TitledPane((Component)this._destLab, (Component)LayoutControl.GBC.createTitledSubPanel(null, (Component)jPanel));
        this._ddlPanel = _ddlOptions.getPanel();
        this._bottomPanel.add((Component)this._titledDestPane, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._bottomPanel.add((Component)this._ddlPanel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)this._bottomPanel, (int)2);
        this._instructionPanel = LayoutControl.GBC.createPanel();
        this._configPanel = this.getConfigPanel();
        this._instructionPanel.add((Component)this._configPanel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this._instructionPanel.add((Component)this._instructions, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        LayoutControl.GBC.addSpring((JPanel)this._instructionPanel, (int)2, (int)1);
        this.addPanels();
        this._mainPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._mainPanel, null, (String)string, (int)14);
        this._actionDialog.pack();
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartDiffTool.this._diffOptions = new DbCartDiffOptions();
                    DbCartDiffTool.this._diffOptions.setDDLFormat(_ddlOptions.getFormat());
                    DbCartDiffTool.this._diffOptions.setSourceName(DbCartUtil.getPanel().getSelectedTabPageName());
                    ArrayList<ExtractObject> arrayList = DbCartDiffTool.this.getClonedExtractObjects();
                    ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
                    for (ExtractObject object2 : arrayList) {
                        if (object2.isTypeScript()) continue;
                        arrayList2.add(object2);
                    }
                    ArrayList<ExtractObject> arrayList3 = DbCartUtil.validateUniqueObjects(arrayList2, DbCartDiffTool.this._diffOptions.getDDLFormat().getGenerateSchema());
                    DbCartDiffTool.this._diffOptions.setSourceExtractObjectList(arrayList2);
                    DbCartDiffTool.this._diffOptions.isDestCart(DbCartDiffTool.this._destCart.isSelected());
                    Object var6_7 = null;
                    ArrayList<Object> arrayList4 = new ArrayList();
                    if (DbCartDiffTool.this._destCart.isSelected()) {
                        arrayList = DbCartDiffTool.this.getClonedExtractObjects((String)DbCartDiffTool.this._destCartCombo.getSelectedItem(), false);
                        DbCartDiffTool.this._diffOptions.setDestName((String)DbCartDiffTool.this._destCartCombo.getSelectedItem());
                        ArrayList<ExtractObject> arrayList5 = new ArrayList<ExtractObject>();
                        for (ExtractObject extractObject : arrayList) {
                            if (extractObject.isTypeScript()) continue;
                            arrayList5.add(extractObject);
                        }
                        DbCartDiffTool.this._diffOptions.setDestExtractObjectList(arrayList5);
                        arrayList4 = DbCartUtil.validateUniqueObjects(arrayList5, DbCartDiffTool.this._diffOptions.getDDLFormat().getGenerateSchema());
                    } else {
                        DbCartDiffTool.this._diffOptions.setDestName(DbCartDiffTool.this._destConnSelector.getCurrentConnectionName());
                    }
                    if (!arrayList3.isEmpty() || !arrayList4.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = "";
                        if (!arrayList3.isEmpty()) {
                            if (DbCartDiffTool.this._diffOptions.getDDLFormat().getGenerateSchema()) {
                                stringBuilder.append(DbCartAddinArb.format("NON_UNIQUE_CART3", DbCartAddinArb.getString("SOURCE_PARM")) + "\n\n");
                            } else {
                                stringBuilder.append(DbCartAddinArb.format("NON_UNIQUE_CART_NOSCHEMA2", DbCartAddinArb.getString("SOURCE_PARM")) + "\n\n");
                            }
                            Iterator<Object> iterator = arrayList3.iterator();
                            while (iterator.hasNext()) {
                                void var9_14;
                                ExtractObject extractObject = (ExtractObject)iterator.next();
                                stringBuilder.append((String)var9_14 + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + " " + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                                String string2 = ", ";
                            }
                            stringBuilder.append("\n");
                        }
                        if (!arrayList4.isEmpty()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\n");
                            }
                            if (DbCartDiffTool.this._diffOptions.getDDLFormat().getGenerateSchema()) {
                                stringBuilder.append(DbCartAddinArb.format("NON_UNIQUE_CART3", DbCartAddinArb.getString("DEST_PARM")) + "\n\n");
                            } else {
                                stringBuilder.append(DbCartAddinArb.format("NON_UNIQUE_CART_NOSCHEMA2", DbCartAddinArb.getString("DEST_PARM")) + "\n\n");
                            }
                            for (ExtractObject extractObject : arrayList4) {
                                void var9_16;
                                stringBuilder.append((String)var9_16 + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + " " + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                                String string3 = ", ";
                            }
                            stringBuilder.append("\n");
                        }
                        stringBuilder.append(DbCartAddinArb.getString("CONTINUE"));
                        bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)DbCartAddinArb.getString("CART_WARNING_TITLE"), (String)"DBCART_NON_UNIQUE_OBJECT_ERROR");
                    }
                    if (bl) {
                        DbCartDiffTool.this._toolApi = new DBDiffApi();
                        DbCartDiffTool.this._toolApi.setDeploy(DbCartDiffTool.this._diffOptions);
                        DbCartDiffTool.this._toolApi.doDiffWithDialog();
                        DbCartDiffTool.this._actionDialog.setVisible(false);
                        DbCartDiffTool.this._actionDialog.dispose();
                    }
                }
            }
        };
        this._actionDialog.addActionListener(actionListener);
        Dimension dimension = this._mainPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 50;
        int n2 = (int)dimension.getWidth() + 28;
        this._actionDialog.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
        WizardLauncher.runDialog((JDialog)this._actionDialog);
    }

    private void createValidator(DBConnectionComboBox dBConnectionComboBox) {
        final JComboBox jComboBox = dBConnectionComboBox.getJComboBox();
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                final String string = (String)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1 && ModelUtil.hasLength((String)string)) {
                    final WaitCursor waitCursor = new WaitCursor((Component)DbCartDiffTool.this._actionDialog);
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(DbCartAddinArb.getString("CONN_CHECK"), true, IRaptorTaskRunMode.TASKVIEWER){

                        protected Void doWork() throws TaskException {
                            try {
                                Connections.getInstance().getConnection(string);
                            }
                            catch (DBException dBException) {
                                throw new TaskException((Throwable)dBException);
                            }
                            return null;
                        }
                    };
                    raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanup(true);
                        }

                        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                            Throwable throwable;
                            Throwable throwable2 = raptorTaskEvent.getThrowable();
                            while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                                throwable2 = throwable;
                            }
                            ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                            this.cleanup(true);
                        }

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanup(false);
                        }

                        private void cleanup(final boolean bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    waitCursor.hide();
                                    if (bl) {
                                        jComboBox.setSelectedIndex(-1);
                                    }
                                }
                            });
                        }
                    });
                    waitCursor.show();
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            }
        });
    }

    private void addPanels() {
        this._mainPanel.add((Component)this._instructionPanel, "North");
        this._mainPanel.add((Component)this._bottomPanel, "Center");
    }

    @Override
    public void openConfigOptions() {
        URL uRL = this._chooser.getSelectedURL();
        try {
            this._config = new DbCartUserDiffConfig(DbCartUserDiffConfig.importFrom(uRL));
            String string = this._config.getString("DbCartConfig");
            if (string == null) {
                string = DbCartAddinArb.getString("XML_FILE_NO_KEY");
            }
            if (!string.equals("diff_tool")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"diff_tool\"", string), (String)DbCartAddinArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
            } else {
                String string2;
                boolean bl = this._config.getString("DEST_TYPE").equals("CART");
                String string3 = this._config.getString("DEST_NAME");
                if (bl) {
                    this._destCart.setSelected(bl);
                    if (!this.setCombo(string3, this._destCartCombo)) {
                        string2 = string3 == null || string3.length() == 0 ? DbCartAddinArb.getString("XML_CART_ERROR_MESSAGE2") : DbCartAddinArb.format("XML_CART_ERROR_MESSAGE1", string3);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DbCartAddinArb.getString("XML_CART_ERROR_TITLE"), (String)"XML_CART_ERROR_TITLE");
                    }
                } else {
                    this._destConn.setSelected(!bl);
                    if (!this.setCombo(string3, this._destConnSelector.getJComboBox())) {
                        string2 = string3 == null || string3.length() == 0 ? DbCartAddinArb.getString("XML_CONN_ERROR_MESSAGE4") : DbCartAddinArb.format("XML_CONN_ERROR_MESSAGE3", string3);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DbCartAddinArb.getString("XML_CONN_ERROR_TITLE"), (String)"XML_CONN_ERROR_TITLE");
                    }
                }
                this._config.copyToDDLFormat(this._ddlFormat);
                this._ddlFormat.isExtractEnabled(DbCartUtil.getTableModel().isAnyDDLRows());
                _ddlOptions.setFormat(this._ddlFormat);
                boolean bl2 = DbCartUtil.getTableModel().isAnyDDLRows();
                _ddlOptions.getExportDDLComponent().setSelected(bl2);
                _ddlOptions.getExportDDLComponent().setEnabled(false);
                _ddlOptions.enableOptions(bl2);
                this._actionDialog.repaint();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void saveConfigOptions() {
        URL uRL = this.getConfigURL();
        try {
            this._config.putString("DbCartConfig", "diff_tool");
            this._config.putString("DEST_TYPE", this._destCart.isSelected() ? "CART" : "CONN");
            this._config.putString("DEST_NAME", this._destCart.isSelected() ? (String)this._destCartCombo.getSelectedItem() : (String)this._destConnSelector.getJComboBox().getSelectedItem());
            this._config.copyFromDDLFormat(_ddlOptions.getFormat());
            this._config.exportTo(uRL);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

