/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataState;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Offline3rdPartyPrintStream;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

class Teradata12BTEQExternalSQLLoaderState
extends TeradataState {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getClass().getName());
    protected TeradataMachine machine = null;
    protected StringTemplateGroup m_templateGroup = null;

    public Teradata12BTEQExternalSQLLoaderState(TeradataMachine teradataMachine) {
        super(teradataMachine);
    }

    @Override
    public String getDataExportCommmand(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        String string3 = null;
        try {
            String string4;
            String string5;
            String string6;
            this.loadTemplates();
            if (string2.toLowerCase().endsWith(".dat")) {
                string6 = "data/" + string2.substring(0, string2.length() - 4) + ".exp";
                string5 = "data/" + string2.substring(0, string2.length() - 4) + ".dat";
                string4 = "data/" + string2.substring(0, string2.length() - 4) + ".csv";
            } else {
                string6 = "data/" + string2 + ".exp";
                string5 = "data/" + string2 + ".dat";
                string4 = "data/" + string2 + ".csv";
            }
            String string7 = migrationConfig.getEndColumnDelimiter();
            String string8 = "'" + string7 + "'";
            String string9 = migrationConfig.getEndRowDelimiter();
            String string10 = "'" + string9 + "'";
            String string11 = string.substring(0, string.indexOf("."));
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string12 = mdColumn.getColumnType();
                String string13 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string13, string12, n, n2);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Convert");
            stringTemplate.reset();
            stringTemplate.setAttribute("expfile", (Object)string6);
            stringTemplate.setAttribute("datfile", (Object)string5);
            stringTemplate.setAttribute("csvfile", (Object)string4);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string8);
            stringTemplate.setAttribute("eord", (Object)string10);
            stringTemplate.setAttribute("platformWindows", (Object)bl);
            string3 = stringTemplate.toString();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCSV(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray) {
        String string2 = "";
        try {
            StringTemplate stringTemplate;
            this.loadTemplates();
            StringTemplate stringTemplate2 = stringTemplate = this.m_templateGroup.getTemplateDefinition("GenerateControlCSV");
            synchronized (stringTemplate2) {
                stringTemplate.reset();
                for (MdColumn mdColumn : mdColumnArray) {
                    stringTemplate.setAttribute("columndetails", (Object)new TeradataState.ColumnDetails(mdColumn));
                }
                stringTemplate.setAttribute("table", (Object)string);
                string2 = stringTemplate.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    @Override
    public String getDataExportScript(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        try {
            this.loadTemplates();
            String string3 = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".exp" : "data/" + string2 + ".exp";
            String string4 = migrationConfig.getEndColumnDelimiter();
            String string5 = "'" + string4 + "'";
            String string6 = migrationConfig.getEndRowDelimiter();
            String string7 = "'" + string6 + "'";
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string8 = mdColumn.getColumnType();
                String string9 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string9, string8, n, n2);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Unload");
            stringTemplate.reset();
            stringTemplate.setAttribute("outfile", (Object)string3);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string5);
            stringTemplate.setAttribute("eord", (Object)string7);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return stringTemplate.toString();
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        return null;
    }

    @Override
    public String getColumnPattern(String string, String string2, int n, int n2) {
        String string3 = "";
        if (string2.equals("DECIMAL")) {
            string3 = "CAST(CAST(\"" + string + "\" AS DECIMAL(" + n + "," + n2 + ")) AS CHAR(" + (n + 2) + "))";
        } else if (string2.equals("DATE")) {
            string3 = "\"" + string + "\"(FORMAT 'Y4-MM-DD') (CHAR(10))";
        } else if (string2.equals("ANSITIME")) {
            string3 = "\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)') (CHAR(15))";
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            string3 = "\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)Z') (CHAR(21))";
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string3 = "\"" + string + "\"(FORMAT 'Y4-MM-DDbHH:MI:SS.S(6)') (CHAR(26))";
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            string3 = "\"" + string + "\"(FORMAT 'Y4-MM-DD HH:MI:SS.S(6)Z') (CHAR(31))";
        } else if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
            string3 = "CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + "))";
        } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string3 = "CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + "))";
        } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
            string3 = "CAST(\"" + string + "\" AS INTERVAL DAY(1) TO SECOND(" + n2 + "))";
        } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
            string3 = "CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH)";
        } else if (string2.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string3 = "CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH)";
        } else {
            string3 = "\"" + string + "\"";
        }
        return string3;
    }

    @Override
    public Object[] generateExternalTableColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return mdColumnArray2;
    }

    @Override
    public String generateExternalColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            String string;
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(this.maybeQuoteExternalFieldReference(teradataMachine, mdColumn2, mdColumn));
            stringBuffer.append(' ');
            stringBuffer.append(this.formatSQLLoaderColumn(teradataMachine, mdColumn2, mdColumn, i + 1 >= mdColumnArray2.length));
            if (i < mdColumnArray2.length - 1) {
                stringBuffer.append(", \n");
            }
            if (!(string = mdColumn2.getColumnType()).equals("BYTELARGEOBJECT") && !string.equals("CHARLARGEOBJECTLATIN") && !string.equals("CHARLARGEOBJECTGRAPHIC") && !string.equals("CHARLARGEOBJECTUNICODE") && !string.equals("CHARLARGEOBJECTKANJI1") && !string.equals("CHARLARGEOBJECTKANJISJIS")) continue;
            vector.add(mdColumn);
        }
        stringBuffer.append("\n");
        if (vector.size() > 0) {
            stringBuffer.append(")\nCOLUMN TRANSFORMS\n(\n");
            String string = "    ";
            for (MdColumn mdColumn : vector) {
                stringBuffer.append(string);
                stringBuffer.append(mdColumn.getColumnName());
                stringBuffer.append(" FROM LOBFILE(");
                stringBuffer.append(mdColumn.getColumnName());
                stringBuffer.append("_FILE) ");
                stringBuffer.append(mdColumn.getColumnType().toUpperCase().endsWith("CLOB") ? "CLOB" : "BLOB");
                string = ",\n    ";
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String generateExternalSelectColumnList(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        String string = "";
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(string);
            stringBuffer.append(mdColumn.getColumnName());
            string = ",";
        }
        return stringBuffer.toString();
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        return null;
    }

    @Override
    public String maybeQuoteExternalFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + mdColumn2.getColumnName()));
            stringBuffer.append(" CHAR(1),\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        String string = mdColumn.getColumnType();
        if (string.equals("BYTELARGEOBJECT") || string.equals("CHARLARGEOBJECTLATIN") || string.equals("CHARLARGEOBJECTGRAPHIC") || string.equals("CHARLARGEOBJECTUNICODE") || string.equals("CHARLARGEOBJECTKANJI1") || string.equals("CHARLARGEOBJECTKANJISJIS")) {
            stringBuffer.append("_FILE VARCHARC(6, 256)");
        }
        return stringBuffer.toString();
    }

    @Override
    public String formatSQLLoaderColumn(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2, boolean bl) {
        String string = "";
        String string2 = mdColumn2.getColumnName();
        boolean bl2 = mdColumn.getNullableFlag();
        String string3 = mdColumn.getColumnType();
        Integer n = mdColumn.getPrecision() == null ? 0 : mdColumn.getPrecision();
        Integer n2 = mdColumn.getScale() == null ? 0 : mdColumn.getScale();
        String string4 = "";
        if (bl2) {
            string4 = " NULLIF " + teradataMachine.trunk30("NL_" + string2) + "='Y'";
        }
        if (string3.equals("DECIMAL")) {
            string = "DECIMAL EXTERNAL(" + (n + 2) + ")" + string4;
        } else if (string3.equals("BYTEINT")) {
            string = "INTEGER(1)" + string4;
        } else if (string3.equals("SMALLINT")) {
            string = "INTEGER(2)" + string4;
        } else if (string3.equals("INTEGER")) {
            string = "INTEGER(4)" + string4;
        } else if (string3.equals("BIGINTEGER")) {
            string = "DECIMAL EXTERNAL(21)" + string4;
        } else if (string3.equals("REAL")) {
            string = "DOUBLE" + string4;
        } else if (string3.equals("DATE")) {
            string = "CHAR(10) DATE_FORMAT DATE 'YYYY-MM-DD'" + string4;
        } else if (string3.equals("ANSITIME")) {
            string = "CHAR(15) DATE_FORMAT TIMESTAMP 'HH24:MI:SS.FF6'" + string4;
        } else if (string3.equals("ANSITIMEWITHTIMEZONE")) {
            string = "CHAR(21) DATE_FORMAT TIMESTAMP WITH TIME ZONE MASK 'HH24:MI:SS.FF6TZH:TZM'" + string4;
        } else if (string3.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string = "CHAR(26) DATE_FORMAT TIMESTAMP MASK 'YYYY-MM-DD HH24:MI:SS.FF6'" + string4;
        } else if (string3.equals("TIMESTAMPWITHTIMEZONE")) {
            string = "CHAR(31) DATE_FORMAT TIMESTAMP WITH TIME ZONE MASK 'YYYY-MM-DD HH24:MI:SS.FF6TZH:TZM'" + string4;
        } else if (string3.equals("DAY") || string3.equals("DAYHOUR") || string3.equals("DAYMINUTE") || string3.equals("DAYSECOND")) {
            string = "CHAR(" + (n + 10 + (n2 > 0 ? n2 + 1 : 0)) + ")" + string4;
        } else if (string3.equals("HOUR") || string3.equals("HOURMINUTE") || string3.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string = "CHAR(" + (n + 10 + (n2 > 0 ? n2 + 1 : 0)) + ")" + string4;
        } else if (string3.equals("MINUTE") || string3.equals("MINUTETOSECOND") || string3.equals("SECOND")) {
            string = "CHAR(" + (11 + (n2 > 0 ? n2 + 1 : 0)) + ")" + string4;
        } else if (string3.equals("YEAR") || string3.equals("YEARMONTH")) {
            string = "CHAR(" + (n + 4) + ")" + string4;
        } else if (string3.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string = "CHAR(" + (n + 4) + ")" + string4;
        } else if (string3.equals("BYTELARGEOBJECT") || string3.equals("CHARLARGEOBJECTLATIN") || string3.equals("CHARLARGEOBJECTGRAPHIC") || string3.equals("CHARLARGEOBJECTUNICODE") || string3.equals("CHARLARGEOBJECTKANJI1") || string3.equals("CHARLARGEOBJECTKANJISJIS")) {
            string = "";
        } else if (string3.equals("BYTEFIXED")) {
            string = "RAW(" + n + ")" + string4;
        } else if (string3.equals("BYTEVARYING")) {
            string = "VARRAWC(5," + n + ")" + string4;
        } else if (string3.equals("CHARFIXEDLATIN")) {
            string = "CHAR(" + n + ")" + string4;
        } else if (string3.equals("CHARFIXEDGRAPHIC") || string3.equals("CHARFIXEDUNICODE")) {
            string = "CHAR(" + n / 2 + ")" + string4;
        } else if (string3.equals("CHARFIXEDKANJI1") || string3.equals("CHARFIXEDKANJISJIS")) {
            string = "CHAR(" + n + ")" + string4;
        } else if (string3.equals("CHARVARYINGLATIN")) {
            string = "VARCHARC(6, " + n + ")" + string4;
        } else if (string3.equals("CHARVARYINGGRAPHIC") || string3.equals("CHARVARYINGUNICODE") || string3.equals("CHARVARYINGKANJI1") || string3.equals("CHARVARYINGKANJISJIS")) {
            string = "VARCHARC(6, " + n + ")" + string4;
        } else {
            string = "XXX(" + string3 + ")XXX";
            System.out.println("UNHANDLED TYPE " + string3 + string4);
        }
        return string;
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    @Override
    public void postProcessTableData(Teradata12Offline3rdPartyPrintStream teradata12Offline3rdPartyPrintStream, String string) throws Exception {
        String string2 = string.endsWith(".dat") ? string.substring(0, string.length() - 4).replaceAll("[ \\\\/$]", "_") : string.replaceAll("[ \\\\/$]", "_");
        teradata12Offline3rdPartyPrintStream.println(teradata12Offline3rdPartyPrintStream.getChannels().get(":#:SCRIPT:"), ":#:SCRIPT:java -jar convertdata.jar data" + File.separator + string2 + ".csv " + "data" + File.separator + string2 + ".exp " + "data" + File.separator + string2 + ".dat", true);
    }

    @Override
    public String getSQLLoaderCommand(TeradataMachine teradataMachine, String string, String string2, boolean bl) {
        this.loadTemplates();
        return "";
    }
}

