/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.diff;

import java.util.HashMap;
import oracle.xml.diff.DiffOp;
import oracle.xml.diff.ErrorMessageFetcher;
import oracle.xml.diff.Options;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XmlInternalUtils {
    static ErrorMessageFetcher messageFetcher = ErrorMessageFetcher.newInstance(null);

    XmlInternalUtils() {
    }

    static ErrorMessageFetcher getMessageFetcher() {
        return messageFetcher;
    }

    static boolean equal(Node node, Node node2, Options options) {
        return XmlInternalUtils.equal(node, node2, true, options);
    }

    static boolean equal(Node node, Node node2, boolean bl, Options options) {
        Node node3;
        if (node == node2) {
            return true;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (node.getNodeType() != 2 && node.getNodeType() != 4 && node.getNodeType() != 8 && node.getNodeType() != 11 && node.getNodeType() != 9 && node.getNodeType() != 1 && node.getNodeType() != 7 && node.getNodeType() != 3) {
            return false;
        }
        if (!XmlInternalUtils.areNameAndValueEqual(node, node2, options)) {
            return false;
        }
        if (bl && !XmlInternalUtils.attributesEqual(node, node2, options)) {
            return false;
        }
        Node node4 = node.getFirstChild();
        for (node3 = node2.getFirstChild(); node4 != null && node3 != null; node4 = node4.getNextSibling(), node3 = node3.getNextSibling()) {
            if (options.normalizeTextNodes()) {
                String string;
                if (node4.getNodeType() == 3 && node3.getNodeType() == 3) {
                    String string2;
                    string = XmlInternalUtils.getWholeText(node4).trim();
                    if (!string.equals(string2 = XmlInternalUtils.getWholeText(node3).trim())) {
                        return false;
                    }
                    node4 = XmlInternalUtils.skipToNextNonTextNode(node4);
                    node3 = XmlInternalUtils.skipToNextNonTextNode(node3);
                    if (node4 == null || node3 == null) {
                        break;
                    }
                } else if (node4.getNodeType() == 3) {
                    string = XmlInternalUtils.getWholeText(node4).trim();
                    if (!string.equals("")) {
                        return false;
                    }
                    if ((node4 = XmlInternalUtils.skipToNextNonTextNode(node4)) == null) {
                        break;
                    }
                } else if (node3.getNodeType() == 3) {
                    string = XmlInternalUtils.getWholeText(node3).trim();
                    if (!string.equals("")) {
                        return false;
                    }
                    if ((node3 = XmlInternalUtils.skipToNextNonTextNode(node3)) == null) break;
                }
            }
            if (XmlInternalUtils.equal(node4, node3, bl, options)) continue;
            return false;
        }
        if (node4 != null || node3 != null) {
            if (options.normalizeTextNodes()) {
                String string;
                boolean bl2 = false;
                boolean bl3 = false;
                if (node4 != null && node4.getNodeType() == 3 && (string = XmlInternalUtils.getWholeText(node4).trim()).equals("") && XmlInternalUtils.skipToNextNonTextNode(node4) == null) {
                    bl2 = true;
                }
                if (node3 != null && node3.getNodeType() == 3 && (string = XmlInternalUtils.getWholeText(node3).trim()).equals("") && XmlInternalUtils.skipToNextNonTextNode(node3) == null) {
                    bl3 = true;
                }
                return !(node4 != null && !bl2 || node3 != null && !bl3);
            }
            return false;
        }
        return true;
    }

    static Node skipToNextNonTextNode(Node node) {
        while (node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3) {
            node = node.getNextSibling();
        }
        return node.getNextSibling();
    }

    static boolean attributesEqual(Node node, Node node2, Options options) {
        if (!node.hasAttributes()) {
            if (node2.hasAttributes()) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    if (XmlInternalUtils.isXmlns(namedNodeMap.item(i))) continue;
                    return false;
                }
                return true;
            }
        } else {
            Node node3;
            if (!node2.hasAttributes()) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    if (XmlInternalUtils.isXmlns(namedNodeMap.item(i))) continue;
                    return false;
                }
                return true;
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            int n = namedNodeMap.getLength();
            int n2 = namedNodeMap2.getLength();
            for (int i = 0; i < n2; ++i) {
                node3 = namedNodeMap2.item(i);
                if (XmlInternalUtils.isXmlns(node3)) continue;
                if (node3.getLocalName() == null && node3.getNamespaceURI() == null && node3.getPrefix() == null) {
                    hashMap.put(node3.getNodeName(), node3);
                    continue;
                }
                hashMap.put(node3.getNamespaceURI() + " " + node3.getLocalName(), node3);
            }
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Node node4 = namedNodeMap.item(i);
                if (XmlInternalUtils.isXmlns(node4)) continue;
                ++n3;
                if (!(node4.getLocalName() == null && node4.getNamespaceURI() == null && node4.getPrefix() == null ? (node3 = (Attr)hashMap.get(node4.getNodeName())) == null || !node4.getNodeName().equals(node3.getNodeName()) || !XmlInternalUtils.isValueEqual(node4, node3, options) : (node3 = (Node)hashMap.get(node4.getNamespaceURI() + " " + node4.getLocalName())) == null || !XmlInternalUtils.areNameAndValueEqual(node4, node3, options))) continue;
                return false;
            }
            if (n3 != hashMap.size()) {
                return false;
            }
        }
        return true;
    }

    static boolean areNameAndValueEqual(Node node, Node node2, Options options) {
        if (node.getLocalName() == null && node.getNamespaceURI() == null && node.getPrefix() == null && node2.getLocalName() == null && node2.getNamespaceURI() == null && node2.getPrefix() == null && (node.getNodeName() == null ? node2.getNodeName() != null : !node.getNodeName().equals(node2.getNodeName()))) {
            return false;
        }
        if (node.getLocalName() == null ? node2.getLocalName() != null : !node.getLocalName().equals(node2.getLocalName())) {
            return false;
        }
        if (node.getNamespaceURI() == null ? node2.getNamespaceURI() != null : !node.getNamespaceURI().equals(node2.getNamespaceURI())) {
            return false;
        }
        if (!options.ignorePrefixDifferences() && (node.getPrefix() == null ? node2.getPrefix() != null : !node.getPrefix().equals(node2.getPrefix()))) {
            return false;
        }
        return XmlInternalUtils.isValueEqual(node, node2, options);
    }

    static boolean isValueEqual(Node node, Node node2, Options options) {
        return !(node.getNodeValue() == null ? node2.getNodeValue() != null : (node.getNodeType() == 3 && node2.getNodeType() == 3 && options.normalizeTextNodes() ? node2.getNodeValue() == null || !node.getNodeValue().trim().equals(node2.getNodeValue().trim()) : !node.getNodeValue().equals(node2.getNodeValue())));
    }

    static String getName(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                String string = null;
                string = node.getLocalName() == null && node.getNamespaceURI() == null && node.getPrefix() == null ? node.getNodeName() : node.getNamespaceURI() + " " + node.getLocalName();
                return string;
            }
            case 3: 
            case 4: 
            case 8: {
                return node.getNodeName();
            }
            case 7: {
                return "#processing-instruction";
            }
        }
        return null;
    }

    static String getNodeType(DiffOp diffOp) throws Exception {
        Node node = null;
        switch (diffOp.getOpName()) {
            case DELETE: {
                node = diffOp.getCurrent();
                break;
            }
            case INSERT_BY_APPENDING: 
            case INSERT_BEFORE_NODE: {
                node = diffOp.getNew();
            }
        }
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    return "element";
                }
                case 4: {
                    return "cdata";
                }
                case 8: {
                    return "comment";
                }
                case 3: {
                    return "text";
                }
                case 7: {
                    return "processing-instruction";
                }
                case 9: {
                    return "document";
                }
                case 11: {
                    return "document-fragment";
                }
                case 2: {
                    return "attribute";
                }
            }
        }
        return null;
    }

    static boolean isXmlns(Node node) {
        String string = node.getPrefix();
        String string2 = node.getLocalName();
        String string3 = node.getNodeName();
        return string != null && string.equals("xmlns") || string2 != null && string2.equals("xmlns") || string3 != null && string3.equals("xmlns");
    }

    static String constructElemOrAttrHashString(Node node, Options options) {
        String string = node.getLocalName() == null && node.getNamespaceURI() == null && node.getPrefix() == null ? node.getNodeName() + " " + node.getNodeValue() : (options.ignorePrefixDifferences() ? node.getNamespaceURI() + " " + node.getLocalName() + " " + node.getNodeValue() : node.getNamespaceURI() + " " + node.getPrefix() + " " + node.getLocalName() + " " + node.getNodeValue());
        return string;
    }

    static String getWholeText(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(node.getNodeValue());
        } while ((node = node.getNextSibling()) != null && node.getNodeType() == 3);
        return stringBuffer.toString();
    }

    static boolean ignoreNode(Node node) {
        return node.getNodeType() != 4 && node.getNodeType() != 8 && node.getNodeType() != 11 && node.getNodeType() != 9 && node.getNodeType() != 1 && node.getNodeType() != 2 && node.getNodeType() != 7 && node.getNodeType() != 3;
    }
}

