/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.spi.LookupProvider;
import javax.ide.spi.ProviderNotFoundException;
import javax.swing.JFrame;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeMainWindow;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.net.FileLocator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.osgi.OSGiIdeCore;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.boot.URLStreamHandlerFactoryQueue;
import oracle.ide.osgi.boot.api.SplashScreen;
import oracle.ide.osgi.extension.ExtensionCommandProvider;
import oracle.ide.osgi.extension.ExtensionManagerOSGiImpl;
import oracle.ide.osgi.extension.internal.ProxyResourceBundleProvider;
import oracle.ide.osgi.util.BundleUtil;
import oracle.ide.osgi.util.URLCopyUtil;
import oracle.ide.util.URLCopier;
import oracle.ide.util.URLCopierProvider;
import oracle.ide.util.VirtualToPhysicalURLMapper;
import oracle.ideimpl.Main;
import oracle.ideimpl.MainWindowImpl;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.openide.util.Lookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static Logger LOG = Logger.getLogger("oracle.ide.osgi");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        try {
            LOG.entering(Activator.class.getName(), "start(BundleContext)");
            context.registerService(CommandProvider.class.getName(), (Object)new ExtensionCommandProvider(), new Hashtable());
            Platform.initializeBundles(context);
            FileLocator.setLocator((FileLocator.ILocator)new FileLocator.ILocator(){

                public URL resolve(URL url) throws IOException {
                    return org.eclipse.core.runtime.FileLocator.resolve((URL)url);
                }
            });
            Activator.setIfNotAlreadySet("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
            Activator.setIfNotAlreadySet("javax.xml.parsers.SAXParserFactory", "oracle.xml.jaxp.JXSAXParserFactory");
            Activator.setIfNotAlreadySet("org.xml.sax.driver", "oracle.xml.parser.v2.SAXParser");
            String[] args = Activator.extractArgs(System.getProperty("oracle.ide.args"));
            LOG.fine("Arguments passed in: " + (args.length > 0 ? System.getProperty("oracle.ide.args") : "none"));
            try {
                IdeArgs ideArgs;
                boolean forceHeadless;
                boolean isRunnerOverride;
                String runnerClassName = System.getProperty("ide.runner.class");
                String runnerBundleName = System.getProperty("ide.runner.bundle");
                boolean bl = isRunnerOverride = runnerClassName != null && runnerBundleName != null;
                if (isRunnerOverride) {
                    LOG.fine("runner class is " + runnerClassName + ", runner bundle id is " + runnerBundleName);
                }
                if (!(forceHeadless = (ideArgs = new IdeArgs(args)).hasArg("-headless")) && !isRunnerOverride) {
                    Activator.setupWindow();
                }
                URLCopierProvider.setURLCopier((URLCopier)new URLCopyUtil());
                LookupProvider.setDefault((LookupProvider)new OSGiSensitiveLookupProvider());
                ElementVisitor.setResourceBundleProvider((ElementVisitor.ResourceBundleProvider)new ProxyResourceBundleProvider());
                URLStreamHandlerFactoryQueue.getInstance().setBundleContext(context);
                URLFileSystem.setURLStreamHandlerFactoryQueue((URLFileSystem.StreamHandlerFactoryQueue)URLStreamHandlerFactoryQueue.getInstance());
                VirtualToPhysicalURLMapper.addURLMapper((VirtualToPhysicalURLMapper.Interface)new VirtualToPhysicalURLMapper.Interface(){

                    public URL toURL(ExtensionSource source) {
                        try {
                            int bundleId = BundleUtil.extractBundleIdFromURI(source.getURI());
                            if (bundleId != -1) {
                                Bundle bundle = Platform.getBundleRegistry().getBundle(bundleId);
                                return org.eclipse.core.runtime.FileLocator.getBundleFile((Bundle)bundle).toURL();
                            }
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, "failed to locate file for bundle", e);
                        }
                        return null;
                    }
                });
                OSGiIdeCore osgiCore = new OSGiIdeCore(ideArgs);
                String starterClassName = System.getProperty("ide.starter.class");
                String starterBundleName = System.getProperty("ide.starter.bundle");
                IdeStarter starter = null;
                if (starterClassName != null && starterBundleName != null) {
                    LOG.fine("starter class is " + starterClassName + ", starter bundle id is " + starterBundleName);
                    Bundle starterBundle = Platform.getBundleRegistry().findBundle(starterBundleName);
                    if (starterBundle == null) {
                        LOG.severe("Cannot find starter bundle: " + starterBundleName);
                        isRunnerOverride = false;
                    } else {
                        LOG.fine("Loading starter class ...");
                        Class starterClass = starterBundle.loadClass(starterClassName);
                        LOG.fine("Starter class loaded. Instantiating starter class ...");
                        starter = (IdeStarter)starterClass.newInstance();
                        LOG.fine("Starter class instantiated");
                        String command = System.getProperty("ide.command");
                        LOG.fine("starting IDE with command: " + command);
                        starter.startIde(command, args, (IdeCore)osgiCore);
                    }
                } else {
                    ideArgs.setCreateUI(!forceHeadless);
                    LOG.fine("Starting IDE in standard mode");
                    Ide.startup((IdeCore)osgiCore);
                }
                if (isRunnerOverride) {
                    Bundle runnerBundle = Platform.getBundleRegistry().findBundle(runnerBundleName);
                    if (runnerBundle == null) {
                        LOG.severe("Cannot find runner bundle: " + runnerBundleName);
                    } else {
                        LOG.fine("Loading runner class ...");
                        if (runnerBundle.getState() == 2 || runnerBundle.getState() == 1) {
                            LOG.log(Level.SEVERE, runnerBundleName + " is not in a valid state: " + (runnerBundle.getState() == 2 ? "INSTALLED" : "UNINSTALLED") + " . Attempting to start for troubleshooting's sake ...");
                            runnerBundle.start();
                        }
                        Class runnerClass = runnerBundle.loadClass(runnerClassName);
                        LOG.fine("Runner class loaded. Instantiating runner class ...");
                        IdeRunner runner = (IdeRunner)runnerClass.newInstance();
                        LOG.fine("Runner class instantiated");
                        if (starter == null) {
                            starter = new IdeStarter(){

                                public void startIde(String command, String[] arguments, IdeCore core) {
                                }
                            };
                        }
                        runner.runCommand(starter);
                    }
                }
                if (Boolean.getBoolean("netbeans.close") && Boolean.getBoolean("com.oracle.jdev.measure.disk.touches")) {
                    System.setProperty("com.oracle.jdev.measure.disk.touches.off", "true");
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Failed to boot IDE cleanly", throwable);
            }
        }
        finally {
            LOG.exiting(Activator.class.getName(), "start(BundleContext)");
        }
    }

    private static String[] extractArgs(String args) {
        if (args != null && args.length() > 0) {
            return args.split("\t");
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupWindow() throws IOException {
        IdeMainWindow mainWindow = (IdeMainWindow)Lookup.getDefault().lookup(IdeMainWindow.class);
        if (mainWindow == null) {
            mainWindow = new MainWindowImpl();
        }
        SplashScreen.setMainWindow((JFrame)mainWindow);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            UIManager.getDefaults().put("ClassLoader", IdeCore.class.getClassLoader());
            Class cls = Platform.getBundleRegistry().findBundle("oracle.jewt-core").loadClass("oracle.bali.ewt.olaf2.OracleLookAndFeel");
            Thread.currentThread().setContextClassLoader(cls.getClassLoader());
            UIManager.setLookAndFeel(cls.getName());
        }
        catch (Exception e) {
            System.err.println("");
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void stop(BundleContext context) throws Exception {
        LOG.fine("Stopped IDE bundle");
    }

    private static void setIfNotAlreadySet(String factoryId, String factoryImplFQN) {
        if (System.getProperty(factoryId) == null) {
            System.setProperty(factoryId, factoryImplFQN);
        }
    }

    private static class OSGiSensitiveLookupProvider
    extends LookupProvider {
        private Map<Class, Collection> s_impls = new HashMap<Class, Collection>();

        private OSGiSensitiveLookupProvider() {
        }

        public Collection lookupAllImpl(ClassLoader loader, Class clazz) throws ProviderNotFoundException {
            try {
                if (clazz.equals(ExtensionRegistry.class)) {
                    if (!this.s_impls.containsKey(ExtensionRegistry.class)) {
                        ArrayList<ExtensionManagerOSGiImpl> cn = new ArrayList<ExtensionManagerOSGiImpl>();
                        cn.add(new ExtensionManagerOSGiImpl());
                        this.s_impls.put(ExtensionRegistry.class, cn);
                    }
                    return this.s_impls.get(ExtensionRegistry.class);
                }
                Enumeration<URL> en = Ide.class.getClassLoader().getResources("META-INF/services/" + clazz.getName());
                Collection all = this.lookupAll(Main.class.getClassLoader(), clazz, en);
                all.addAll(this.lookupAll(loader, clazz, loader.getResources("meta-inf/services/" + clazz.getName())));
                return all;
            }
            catch (IOException ioe) {
                throw new ProviderNotFoundException(clazz.getName(), (Throwable)ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection lookupAll(ClassLoader loader, Class clazz, Enumeration en) throws ProviderNotFoundException {
            ArrayList results = new ArrayList();
            while (en.hasMoreElements()) {
                URL url = (URL)en.nextElement();
                try {
                    InputStream is = url.openStream();
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                            try {
                                Class<?> inst = Class.forName(line, false, loader);
                                if (!clazz.isAssignableFrom(inst)) {
                                    throw new ProviderNotFoundException(inst + " is not correct type for service " + clazz);
                                }
                                results.add(inst.newInstance());
                            }
                            catch (Exception e) {
                                throw new ProviderNotFoundException("Failed to create service class " + line, (Throwable)e);
                            }
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new ProviderNotFoundException("Failed to load service class " + clazz, (Throwable)ioe);
                }
            }
            return results;
        }
    }
}

