/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension.internal;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ide.extension.ElementVisitor;
import oracle.ide.osgi.extension.internal.ClassLoaderProxy;

public class ProxyResourceBundleProvider
implements ElementVisitor.ResourceBundleProvider {
    public ResourceBundle getResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        return new ResourceBundleProxy(baseName, locale, loader);
    }

    private static class ResourceBundleProxy
    extends ResourceBundle {
        private final String m_baseName;
        private final Locale m_locale;
        private final ClassLoader m_loader;
        private volatile ResourceBundle m_delegate;

        private ResourceBundleProxy(String baseName, Locale locale, ClassLoader loader) {
            this.m_baseName = baseName;
            this.m_locale = locale;
            this.m_loader = loader;
            this.m_delegate = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object handleGetObject(String key) {
            if (this.m_loader instanceof ClassLoaderProxy) {
                ((ClassLoaderProxy)((Object)this.m_loader)).setProcessingNonExtInitClasses(true);
                try {
                    Object object = this.delegate().getObject(key);
                    return object;
                }
                finally {
                    ((ClassLoaderProxy)((Object)this.m_loader)).setProcessingNonExtInitClasses(false);
                }
            }
            return this.delegate().getObject(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.delegate().getKeys();
        }

        private ResourceBundle delegate() {
            if (this.m_delegate == null) {
                this.m_delegate = this.createDelegate();
            }
            return this.m_delegate;
        }

        private ResourceBundle createDelegate() {
            return ResourceBundle.getBundle(this.m_baseName, this.m_locale, this.m_loader);
        }
    }
}

