/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.inspector.ContextActionPanelHost;
import oracle.ide.inspector.InspectorBundle;
import oracle.ide.inspector.LazyLoadMenuButton;
import oracle.ide.natives.accessibility.HighContrast;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.util.ModelUtil;

public class ContextActionPanel
extends JPanel {
    private JScrollPane helpAreaScroll;
    private RichHintLabel helpArea;
    private JPanel optionPanel = new JPanel();
    private JComponent firstWithFocus;
    private Header helpHeader;
    private boolean helpAvailable = false;
    private static final Color BACKGROUND = new Color(240, 240, 240);
    private static final Color HELP_BORDER_COLOR = new Color(230, 230, 230);
    private static final Color HELP_BACKGROUND = new Color(250, 250, 250);
    private static final Color HELP_TITLE_FORECOLOR = new Color(49, 106, 196);
    private Dimension helpAreaSize;

    public ContextActionPanel() {
        this.setUpLayout();
        this.setUpContent();
        this.setBackground(ContextActionPanel.background());
    }

    private void setUpLayout() {
        this.setLayout(new GridBagLayout());
        this.optionPanel.setLayout(new GridBagLayout());
    }

    private void setUpContent() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.optionPanel, c);
        this.createHelpHeader();
        ++c.gridy;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.helpHeader, c);
        c.gridy = -1;
        c.gridheight = 0;
        c.fill = 1;
        c.weighty = 2.0;
        c.insets = new Insets(0, 10, 10, 10);
        this.createHelpArea();
        this.add((Component)this.helpAreaScroll, c);
        this.showOrHideHelp();
    }

    private void createHelpArea() {
        this.helpArea = new RichHintLabel();
        this.helpAreaScroll = new JScrollPane((Component)this.helpArea, 20, 30);
        this.helpAreaScroll.setFocusable(false);
        this.helpAreaScroll.setPreferredSize(new Dimension(180, 80));
        JViewport viewport = this.helpAreaScroll.getViewport();
        viewport.setFocusable(false);
        Border lineBorder = BorderFactory.createLineBorder(HELP_BORDER_COLOR, 1);
        this.helpArea.setBorder(lineBorder);
        this.helpArea.setBackground(HELP_BACKGROUND);
    }

    private void createHelpHeader() {
        this.helpHeader = new Header();
        this.helpHeader.setText(InspectorBundle.get("PROPERTY_HELP"));
        this.helpHeader.setExpanded(true);
        this.helpHeader.setLevel(Header.Level.SIMPLE);
        this.helpHeader.setForeground(HELP_TITLE_FORECOLOR);
        this.firstWithFocus = this.helpHeader;
        this.helpHeader.addKeyListener((KeyListener)new FocusArrowKeyNavigator());
        this.helpHeader.disclosureIcon().addKeyListener(new FocusArrowKeyNavigator());
        this.helpHeader.addHeaderListener(new HeaderListener(){

            public void headerExpanded(HeaderEvent event) {
                int h = ContextActionPanel.this.helpAreaScroll.getHeight();
                ContextActionPanel.this.helpAreaScroll.setVisible(true);
                Window p = SwingUtilities.getWindowAncestor(ContextActionPanel.this);
                p.setSize(p.getWidth(), p.getHeight() + (h + 10));
            }

            public void headerCollapsed(HeaderEvent event) {
                int h = ContextActionPanel.this.helpAreaScroll.getHeight();
                ContextActionPanel.this.storeHelpAreaSize();
                Window p = SwingUtilities.getWindowAncestor(ContextActionPanel.this);
                p.setSize(p.getWidth(), p.getHeight() - (h + 10));
                ContextActionPanel.this.helpAreaScroll.setVisible(false);
            }
        });
    }

    void storeHelpAreaSize() {
        if (this.helpArea == null || !this.helpArea.isVisible()) {
            return;
        }
        this.helpAreaSize = this.helpAreaScroll.getSize();
    }

    void applyHelpAreaSize() {
        if (this.helpAreaSize == null) {
            return;
        }
        this.helpAreaScroll.setPreferredSize(this.helpAreaSize);
    }

    boolean isHelpAreaExpanded() {
        return this.helpHeader != null && this.helpHeader.isExpanded();
    }

    public void giveFocus() {
        if (this.firstWithFocus == null) {
            this.firstWithFocus = this.helpHeader;
        }
        this.firstWithFocus.requestFocusInWindow();
    }

    private static Color background() {
        if (HighContrast.isHighContrastModeEnabled()) {
            return SystemColor.window;
        }
        return BACKGROUND;
    }

    public void render(SinglePropertyInfo property, ActionContext context, List<ActionGroup> actions, String helpText) {
        this.setHelpText(helpText);
        this.firstWithFocus = null;
        this.optionPanel.removeAll();
        int row = property.getPropertyModelRow();
        boolean writable = property.getPropertyModel().isPropertyWritable(row);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        JComponent last = null;
        Iterator<ActionGroup> it = actions.iterator();
        while (it.hasNext()) {
            ActionGroup group = it.next();
            for (Action action : group) {
                ActionContext.updateContextIn((Action)action, (ActionContext)context);
                LazyLoadMenuButton button = new LazyLoadMenuButton(action, context, property);
                button.setEnabled(writable);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Window window = SwingUtilities.getWindowAncestor(ContextActionPanel.this);
                        if (window instanceof ContextActionPanelHost) {
                            window.setVisible(false);
                            window.dispose();
                        }
                    }
                });
                MenuItemLikeRenderer.decorate(button);
                if (this.firstWithFocus == null) {
                    this.firstWithFocus = button;
                }
                this.optionPanel.add((Component)button, constraints);
                last = button;
                ++constraints.gridy;
            }
            if (!it.hasNext()) continue;
            Separator separator = new Separator();
            this.optionPanel.add((Component)separator, constraints);
            last = separator;
            ++constraints.gridy;
        }
        if (last != null && !(last instanceof Separator)) {
            Separator separator = new Separator();
            this.optionPanel.add((Component)separator, constraints);
            ++constraints.gridy;
        }
        if (this.firstWithFocus == null) {
            this.firstWithFocus = this.helpHeader;
        }
    }

    private void setHelpText(String text) {
        this.helpArea.setHtmlText(text);
        this.helpAvailable = ModelUtil.hasLength((String)text);
        this.showOrHideHelp();
        this.helpArea.setCaretPosition(0);
        this.helpArea.moveCaretPosition(0);
    }

    private void showOrHideHelp() {
        this.helpHeader.setVisible(this.helpAvailable);
        this.helpAreaScroll.setVisible(this.helpAvailable && this.helpHeader.isExpanded());
    }

    void printHelpAreaSize() {
        System.out.println("Help area: " + this.helpAreaScroll.getSize());
    }

    protected void installDefaults(JButton menuItem) {
        String prefix = "MenuItem";
        Object opaque = UIManager.get(prefix + ".opaque");
        if (opaque != null) {
            LookAndFeel.installProperty(menuItem, "opaque", opaque);
        } else {
            LookAndFeel.installProperty(menuItem, "opaque", Boolean.TRUE);
        }
        if (menuItem.getMargin() == null || menuItem.getMargin() instanceof UIResource) {
            menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        }
        LookAndFeel.installProperty(menuItem, "iconTextGap", new Integer(4));
        LookAndFeel.installBorder(menuItem, prefix + ".border");
        LookAndFeel.installProperty(menuItem, "borderPainted", UIManager.getBoolean(prefix + ".borderPainted"));
        LookAndFeel.installColorsAndFont(menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
    }

    private static class MenuItemLikeRenderer
    extends MouseAdapter
    implements FocusListener {
        static final Color OPTION_BACKGROUND_COLOR = new Color(240, 240, 240);
        private static final Color OPTION_FOREGROUND_COLOR = new Color(UIManager.getColor("MenuItem.foreground").getRGB());
        private static final Font OPTION_FONT = UIManager.getFont("MenuItem.font");
        private static final Color OPTION_SELECTION_BACKGROUND_COLOR = new Color(UIManager.getColor("MenuItem.selectionBackground").getRGB());
        private static final Color OPTION_SELECTION_FOREGROUND_COLOR = new Color(UIManager.getColor("MenuItem.selectionForeground").getRGB());
        private static final Insets OPTION_INSETS = new Insets(1, 1, 1, 1);
        private JButton b;

        static void decorate(JButton b) {
            new MenuItemLikeRenderer(b);
        }

        private MenuItemLikeRenderer(JButton b) {
            this.b = b;
            b.setHorizontalTextPosition(11);
            b.setHorizontalAlignment(10);
            b.setBackground(OPTION_BACKGROUND_COLOR);
            b.setForeground(OPTION_FOREGROUND_COLOR);
            b.setFont(OPTION_FONT);
            b.setBorderPainted(false);
            b.setFocusPainted(false);
            b.addMouseListener(this);
            b.addFocusListener(this);
            b.addKeyListener(new FocusArrowKeyNavigator());
            b.setMargin(OPTION_INSETS);
            Dimension size = b.getPreferredSize();
            b.setPreferredSize(new Dimension(size.width, 18));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.renderSelected();
            this.b.requestFocusInWindow();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.renderNormal();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.renderSelected();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.renderNormal();
        }

        private void renderSelected() {
            this.b.setBackground(OPTION_SELECTION_BACKGROUND_COLOR);
            this.b.setForeground(OPTION_SELECTION_FOREGROUND_COLOR);
        }

        private void renderNormal() {
            this.b.setBackground(OPTION_BACKGROUND_COLOR);
            this.b.setForeground(OPTION_FOREGROUND_COLOR);
        }
    }

    private static class FocusArrowKeyNavigator
    extends KeyAdapter {
        private FocusArrowKeyNavigator() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 40) {
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusNextComponent();
                return;
            }
            if (keyCode == 38) {
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusPreviousComponent();
                return;
            }
        }
    }

    private static class Separator
    extends JSeparator {
        private static Color LINE_COLOR = new Color(204, 204, 204);

        public Separator() {
            super(0);
            this.setOpaque(false);
            this.setBackground(MenuItemLikeRenderer.OPTION_BACKGROUND_COLOR);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension s = this.getSize();
            g.setColor(LINE_COLOR);
            g.drawLine(0, 0, s.width, 0);
        }

        public Dimension getPreferredSize(JComponent c) {
            return new Dimension(0, 1);
        }
    }
}

