/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.inspector.AbstractCustomEditorAction;
import oracle.bali.inspector.AbstractCustomEditorButton;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.editor.SinglePropertyInfo;
import oracle.ide.Ide;
import oracle.ide.inspector.ContextActionPanel;
import oracle.ide.inspector.ContextActionPanelHost;
import oracle.ide.inspector.InspectorBundle;
import oracle.ide.inspector.PropertyInfo;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class CustomEditorButton
extends AbstractCustomEditorButton
implements FocusListener {
    private static ContextActionPanel contextActionPanel = new ContextActionPanel();
    private static ContextActionPanelHost contextActionPanelHost = new ContextActionPanelHost((Window)Ide.getMainWindow());
    private static final Icon SIMPLE = OracleIcons.getIcon((String)"extras/small-gear.png");
    private static final Dimension NULL_DIMENSION = new Dimension(0, 0);
    private transient Border dropDownWithoutFocusBorder;
    private transient Border dropDownWithFocusBorder;

    public static void hidePopup() {
        contextActionPanelHost.setVisible(false);
    }

    CustomEditorButton(PropertyInfo property, Component editorComponent) {
        this(property.editorFactory(), property.model(), property.row, editorComponent);
        this.setName(MessageFormat.format("{0}.{1}", property.displayName(), this.getClass().getSimpleName()));
    }

    public CustomEditorButton(PropertyEditorFactory2 propertyEditor, PropertyModel model, int row, Component editorComponent) {
        super(propertyEditor, model, row, editorComponent);
        this.setOpaque(true);
        contextActionPanelHost.content(contextActionPanel);
    }

    @Deprecated
    public void releaseActionContext() {
    }

    public void setActionGroups(List<ActionGroup> groups) {
        if (this.actionCount(groups) == 1) {
            Action singleAction = this.singleAction(groups);
            if (singleAction instanceof AbstractCustomEditorAction) {
                this.renderAsSimpleButton(singleAction);
            } else {
                this.renderAsDropDownList(groups);
            }
        } else {
            this.renderAsDropDownList(groups);
        }
    }

    private void renderAsSimpleButton(Action singleAction) {
        this.setContentAreaFilled(false);
        Border border = this.hasFocus() ? this.dropDownWithFocusBorder() : this.dropDownWithoutFocusBorder();
        this.setBorder(border);
        this.setIcon(SIMPLE);
        this.getAccessibleContext().setAccessibleName(this.advancedEditorScreenReaderLabel());
        this.addFocusListener(this);
        this.setToolTipText(this.advancedEditorScreenReaderLabel());
        for (ActionListener l : this.getActionListeners()) {
            this.removeActionListener(l);
        }
        this.addActionListener(singleAction);
    }

    private String advancedEditorScreenReaderLabel() {
        String desc = CustomEditorButton.getPropertyDisplayName((SinglePropertyInfo)this);
        desc = desc != null ? desc + " " : "";
        int key = 35;
        return desc + InspectorArb.getString(key);
    }

    private void renderAsDropDownList(List<ActionGroup> groups) {
        this.setContentAreaFilled(false);
        Border border = this.hasFocus() ? this.dropDownWithFocusBorder() : this.dropDownWithoutFocusBorder();
        this.setBorder(border);
        this.setAction(this.popUpDialogAction(groups));
        this.setIcon(SIMPLE);
        this.getAccessibleContext().setAccessibleName(this.actionsButtonScreenReaderLabel());
        this.addFocusListener(this);
        this.setToolTipText(InspectorBundle.get("PROPERTY_ACTION_MENU_TOOLTIP"));
    }

    private String actionsButtonScreenReaderLabel() {
        String desc = CustomEditorButton.getPropertyDisplayName((SinglePropertyInfo)this);
        desc = desc != null ? desc + " " : "";
        int key = 36;
        return desc + InspectorArb.getString(key);
    }

    private Border dropDownWithoutFocusBorder() {
        if (this.dropDownWithoutFocusBorder != null) {
            return this.dropDownWithoutFocusBorder;
        }
        this.dropDownWithoutFocusBorder = new EmptyBorder(4, 4, 4, 4);
        return this.dropDownWithoutFocusBorder;
    }

    private Border dropDownWithFocusBorder() {
        if (this.dropDownWithFocusBorder != null) {
            return this.dropDownWithFocusBorder;
        }
        Border outside = UIManager.getBorder("List.focusCellHighlightBorder");
        EmptyBorder inside = new EmptyBorder(3, 3, 3, 3);
        this.dropDownWithFocusBorder = BorderFactory.createCompoundBorder(outside, inside);
        return this.dropDownWithFocusBorder;
    }

    private int actionCount(List<ActionGroup> groups) {
        int totalActions = 0;
        for (ActionGroup group : groups) {
            if (group == null) continue;
            totalActions += group.size();
        }
        return totalActions;
    }

    private Action popUpDialogAction(final List<ActionGroup> groups) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (groups.isEmpty() || !CustomEditorButton.this.isShowing()) {
                    return;
                }
                Point l = CustomEditorButton.this.getLocationOnScreen();
                Dimension d = CustomEditorButton.this.getSize();
                int x = l.x;
                int y = l.y + d.height;
                CustomEditorButton.this.renderAndShowPopupDialog(groups, new Point(x, y));
            }
        };
        return action;
    }

    private void renderAndShowPopupDialog(List<ActionGroup> groups, Point where) {
        ActionContext context = this.createActionContext();
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
        CustomEditorButton.renderAndShowPopupDialog(groups, context, (SinglePropertyInfo)this, w, where);
    }

    static void renderAndShowPopupDialog(List<ActionGroup> groups, ActionContext context, SinglePropertyInfo property, Window parent, Point where) {
        String title;
        String desc = CustomEditorButton.getPropertyDescription(property);
        if (desc == null) {
            desc = "";
        }
        if (CustomEditorButton.isEmpty(groups) && !ModelUtil.hasLength((String)desc)) {
            return;
        }
        contextActionPanel.render(property, context, groups, desc);
        String titleValue = CustomEditorButton.getPropertyDisplayName(property);
        String string = title = titleValue != null ? titleValue.toString() : "";
        if (!contextActionPanelHost.isSameOwner(parent)) {
            ContextActionPanelHost oldHost = contextActionPanelHost;
            if (oldHost.isVisible()) {
                oldHost.setVisible(false);
            }
            contextActionPanelHost = new ContextActionPanelHost(parent);
            oldHost.dispose();
        }
        contextActionPanelHost.content(contextActionPanel);
        contextActionPanelHost.title(title);
        contextActionPanelHost.pack();
        Point realWhere = where;
        if (property instanceof CustomEditorButton) {
            Dimension buttonSize = ((CustomEditorButton)property).getSize();
            realWhere = CustomEditorButton.whereToShowPopup(buttonSize, where);
        } else {
            realWhere = CustomEditorButton.whereToShowPopup(NULL_DIMENSION, where);
        }
        contextActionPanelHost.setLocation(realWhere);
        contextActionPanelHost.setVisible(true);
    }

    private static String getPropertyDescription(SinglePropertyInfo property) {
        return (String)CustomEditorButton.getPropertyValue(property.getPropertyModel(), PropertyModel.COLUMN_DESCRIPTION, property.getPropertyModelRow());
    }

    private static String getPropertyDisplayName(SinglePropertyInfo property) {
        return (String)CustomEditorButton.getPropertyValue(property.getPropertyModel(), PropertyModel.COLUMN_DISPLAY_NAME, property.getPropertyModelRow());
    }

    private static Object getPropertyValue(PropertyModel model, Object column, int row) {
        return model != null ? model.getData(column, row) : null;
    }

    private static Point whereToShowPopup(Dimension invokerSize, Point where) {
        int height;
        int x = where.x;
        int y = where.y;
        Dimension screenSize = CustomEditorButton.screenSize();
        Dimension hostSize = contextActionPanelHost.getSize();
        int width = hostSize.width;
        if (x + width > screenSize.width && (x = x - width + invokerSize.width) < 0) {
            x = 0;
        }
        if (y + (height = hostSize.height) > screenSize.height && (y = y - height + invokerSize.height) < 0) {
            y = 0;
        }
        return new Point(x, y);
    }

    private static Dimension screenSize() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = e.getDefaultScreenDevice().getDefaultConfiguration();
        Toolkit t = Toolkit.getDefaultToolkit();
        Insets insets = t.getScreenInsets(gc);
        Dimension screenSize = t.getScreenSize();
        screenSize.width -= insets.left + insets.right;
        screenSize.height -= insets.top + insets.bottom;
        return screenSize;
    }

    private Action singleAction(List<ActionGroup> groups) {
        ActionContext context = this.createActionContext();
        for (ActionGroup group : groups) {
            Iterator i$ = group.iterator();
            if (!i$.hasNext()) continue;
            Action action = (Action)i$.next();
            return ActionContext.updateContextIn((Action)action, (ActionContext)context);
        }
        return null;
    }

    private ActionContext createActionContext() {
        return new ActionContext(this.getEditorComponent(), (AbstractCustomEditorButton)this);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setBorder(this.dropDownWithoutFocusBorder());
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setBorder(this.dropDownWithFocusBorder());
    }

    public void setName(String name) {
        if (!ModelUtil.hasLength((String)name)) {
            return;
        }
        super.setName(name);
    }

    private static boolean isEmpty(List<ActionGroup> groups) {
        if (null == groups || groups.isEmpty()) {
            return true;
        }
        for (ActionGroup group : groups) {
            if (group.actions().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

