/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Ide;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.inspector.CustomEditorButton;
import oracle.ide.nulls.NullIcon;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentFaderFactory;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.templates.BalloonTemplate;
import oracle.javatools.ui.infotip.templates.Template;

final class EditorContainer
extends JPanel {
    private static final int MIN_WIDTH = 100;
    private static final String SHOW_BALLOON_KEY_FMT = "{0}.#__show_balloon";
    private static final String SHOW_BALLOON_KEY = MessageFormat.format("{0}.#__show_balloon", "InspectorWindow");
    private static final String LAYOUT_CONSTRAINTS = "insets 0, fill";
    private static final String COLUMN_CONSTRAINTS = "[grow]1[align right]";
    private static final NullIcon FILLER_ICON = new NullIcon(20, 20);
    private transient ComponentFaderFactory.MouseOverFadePolicy fadePolicy;
    private Component editor;
    private CustomEditorButton customEditorButton;

    private static boolean shouldShowBalloon() {
        try {
            if (Ide.getIdeArgs().hasArg("-nonag")) {
                return false;
            }
            if (!Ide.getIdeArgs().getCreateUI()) {
                return false;
            }
            return Ide.getDTCache().getBoolean(SHOW_BALLOON_KEY, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    EditorContainer(Component editor) {
        this(editor, null);
    }

    EditorContainer(Component editor, CustomEditorButton customEditorButton) {
        super((LayoutManager)new MigLayout(LAYOUT_CONSTRAINTS, COLUMN_CONSTRAINTS));
        this.setOpaque(false);
        this.update(editor);
        this.customEditorButton = customEditorButton;
        this.addComponents();
    }

    private void addComponents() {
        this.add(this.editor, "grow");
        if (this.customEditorButton != null) {
            this.fadePolicy = new ComponentFaderFactory.MouseOverFadePolicy(new Component[]{this.customEditorButton, this.editor});
            this.fadePolicy.setFade(1.0f);
            this.fadePolicy.setMaxFadeOut(1.0f);
            this.add(ComponentFaderFactory.createFadedComponent((JComponent)((Object)this.customEditorButton), (ComponentFaderFactory.FadePolicy)this.fadePolicy));
        } else {
            this.fadePolicy = null;
            this.add(new JLabel((Icon)FILLER_ICON));
        }
    }

    Component editor() {
        return this.editor;
    }

    CustomEditorButton customEditorButton() {
        return this.customEditorButton;
    }

    void updateWith(EditorContainer editorContainer) {
        this.updateWith(editorContainer.editor(), editorContainer.customEditorButton());
    }

    void addPropertyEditorToContainer() {
        this.updateWith(this.editor(), this.customEditorButton());
    }

    void updateWith(Component editor, CustomEditorButton customEditorButton) {
        Object futureFocusOwner = null;
        if (this.editor != null && this.editor.isFocusOwner()) {
            futureFocusOwner = editor;
        } else if (this.customEditorButton != null && this.customEditorButton.isFocusOwner()) {
            futureFocusOwner = customEditorButton;
        }
        this.update(editor);
        this.customEditorButton = customEditorButton;
        this.removeAll();
        this.addComponents();
        if (futureFocusOwner != null) {
            ((Component)futureFocusOwner).requestFocusInWindow();
        }
    }

    void clear() {
        this.customEditorButton = null;
        this.update((Component)null);
    }

    void update(Component editor) {
        this.editor = editor;
        if (this.editor == null) {
            return;
        }
        if (EditorContainer.shouldShowBalloon()) {
            AdapterManager.Factory.getAdapterManager().adapt((Object)this, InfoTip.class);
        }
        if (this.editor instanceof JCheckBox) {
            return;
        }
        Dimension preferred = this.editor.getPreferredSize();
        this.editor.setPreferredSize(new Dimension(5, preferred.height));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension fromSuper = super.getPreferredSize();
        if ((this.editor instanceof JTextField || this.editor instanceof JComboBox || this.editor instanceof JCheckBox) && fromSuper.width < 100) {
            fromSuper.width = 100;
        }
        return fromSuper;
    }

    ComponentFaderFactory.MouseOverFadePolicy getFadePolicy() {
        return this.fadePolicy;
    }

    static {
        if (EditorContainer.shouldShowBalloon()) {
            BalloonTemplate template = new BalloonTemplate();
            template.setTitle(OracleIcons.getIcon((String)"info.png"), InspectorArb.getString(37));
            String balloonText = InspectorArb.getString(38);
            SuperLabel balloonContent = new SuperLabel();
            balloonContent.setText(balloonText);
            balloonContent.setOpaque(false);
            balloonContent.setPreferredWrapWidth(250);
            template.setContent((JComponent)balloonContent);
            InfoTip balloon = new InfoTip((Template)template);
            AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new EditorContainerToInfotipAdapterFactory(balloon));
        }
    }

    private static final class EditorContainerToInfotipAdapterFactory
    implements AdapterFactory<EditorContainer, InfoTip>,
    Runnable {
        private final InfoTip balloon;
        private EditorContainer parent;

        private EditorContainerToInfotipAdapterFactory(InfoTip balloon) {
            this.balloon = balloon;
        }

        public InfoTip adapt(EditorContainer parent) {
            AdapterManager.Factory.getAdapterManager().unregisterFactory((AdapterFactory)this);
            Ide.getDTCache().putBoolean(SHOW_BALLOON_KEY, false);
            this.parent = parent;
            SwingUtilities.invokeLater(this);
            return this.balloon;
        }

        @Override
        public void run() {
            final EditorContainerToInfotipAdapterFactory runnable = this;
            final EditorContainer comp = this.parent;
            Window ancestor = SwingUtilities.getWindowAncestor(comp);
            if (null == ancestor) {
                comp.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        comp.removeAncestorListener(this);
                        SwingUtilities.invokeLater(runnable);
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }
                });
                return;
            }
            if (!comp.isShowing()) {
                comp.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                        comp.removeComponentListener(this);
                        SwingUtilities.invokeLater(runnable);
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
                return;
            }
            this.balloon.show((JComponent)comp);
        }
    }
}

