/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Dimension;
import java.awt.Insets;
import java.util.List;
import javax.swing.Box;
import oracle.bali.inspector.PropertyModel;
import oracle.ide.inspector.AbstractFormLayoutPanel;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyDisplayPanelLayout;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.RenderingOptimizer;
import oracle.ide.inspector.SingletonPropertyEditorUpdater;

public class PropertyDisplayPanel
extends AbstractFormLayoutPanel {
    private final PropertyDisplayPanelLayout layout;
    private RenderingOptimizer renderingOptimizer;
    private Orientation orientation = Orientation.VERTICAL;
    private Properties properties;

    public PropertyDisplayPanel(PropertyDisplayPanelLayout layout) {
        this.layout = layout;
        this.renderingOptimizer = new RenderingOptimizer();
        this.updateTargetPanel(this);
    }

    public void updateOnly(PropertyModel model) {
        if (this.properties == null) {
            super.removeAll();
            this.render(model);
            return;
        }
        this.properties.update(model, this.renderingOptimizer);
        this.renderingOptimizer.update(this.properties, SingletonPropertyEditorUpdater.instance(), this.orientation);
    }

    public void render(PropertyModel model) {
        this.properties = new Properties(model, this.renderingOptimizer, null);
        List<PropertyDisplayPanelLayout.Row> rows = this.layout.rows();
        if (rows.isEmpty()) {
            return;
        }
        for (PropertyDisplayPanelLayout.Row row : rows) {
            String[] propertyIds = row.propertyIds();
            int propertyCount = propertyIds.length;
            if (propertyCount == 1) {
                PropertyInfo property = this.properties.propertyById(propertyIds[0]);
                if (property == null) continue;
                super.renderProperty(property, this.layout.maxColumns(), 0, this.orientation);
                ++this.constraints().gridy;
                continue;
            }
            int startCell = 0;
            for (int i = 0; i < propertyCount; ++i) {
                PropertyInfo property = this.properties.propertyById(propertyIds[i]);
                if (property == null) continue;
                int editorWidth = i == propertyCount - 1 ? this.multiplePropertyEditorWidth(startCell) : 1;
                super.renderProperty(property, editorWidth, startCell, this.orientation);
                if (i != propertyCount - 1) {
                    ++startCell;
                    int fill = this.constraints().fill;
                    double weightx = this.constraints().weightx;
                    Insets insets = this.constraints().insets;
                    this.constraints().insets = new Insets(0, 0, 0, 0);
                    this.constraints().fill = 0;
                    this.constraints().weightx = 0.0;
                    ++this.constraints().gridx;
                    this.addToTargetPanel(this.space());
                    this.constraints().fill = fill;
                    this.constraints().weightx = weightx;
                    this.constraints().insets = insets;
                }
                startCell += 4;
            }
            ++this.constraints().gridy;
        }
        this.constraints().gridy = -1;
        this.constraints().fill = 1;
        this.constraints().gridheight = 0;
        this.constraints().gridwidth = 0;
        this.constraints().weighty = 1.0;
        this.addToTargetPanel(Box.createVerticalGlue());
    }

    private Box.Filler space() {
        Dimension d = this.dimension(3);
        return new Box.Filler(d, d, d);
    }

    private Dimension dimension(int width) {
        return new Dimension(width, 0);
    }

    private int multiplePropertyEditorWidth(int currentColumn) {
        return this.layout.maxColumns() - (currentColumn + 4) + 1;
    }
}

