/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.ide.inspector.FocusPainter;
import oracle.ide.inspector.InspectorBundle;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.PropertyInfo;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import oracle.javatools.ui.Borders;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.ModelUtil;

final class ValidationIssues {
    private static final FormatBundle BUNDLE = new FormatBundle(InspectorBundle.getBundle());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String HAS_ISSUES_PROPERTY = "hasIssues";

    static void addValidationIssues(Component editor, PropertyInfo property, Orientation orientation) {
        ValidationIssues.addValidationIssuesToEditor(editor, property, orientation);
        ValidationIssues.addFocusBorderToEditor(editor, orientation);
    }

    static void addValidationIssuesToEditor(Component editor, PropertyInfo property, Orientation orientation) {
        if (!(editor instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)editor;
        c.setToolTipText(null);
        Collection<? extends Issue> issues = property.validationIssues();
        if (issues == null || issues.isEmpty()) {
            c.putClientProperty(HAS_ISSUES_PROPERTY, null);
            if (c.hasFocus() && ValidationIssues.canHaveFocusBorder(editor)) {
                Color color = (Color)AdapterManager.Factory.getAdapterManager().adapt((Object)orientation, Color.class);
                Borders.attachBorder((JComponent)c, (Color)FocusPainter.FOCUS_BORDER, (Color)color);
            } else {
                Borders.restoreBorder((JComponent)c);
            }
            ValidationIssues.unregisterHoverable(c);
            return;
        }
        if (ValidationIssues.hasErrors(issues)) {
            ValidationIssues.addErrorBorderAndTooltip(c, issues, property);
            return;
        }
        if (ValidationIssues.hasWarnings(issues)) {
            ValidationIssues.addWarningBorderAndTooltip(c, issues, property);
            return;
        }
    }

    private static boolean hasErrors(Collection<? extends Issue> allIssues) {
        return ValidationIssues.hasIssuesWithSeverity(allIssues, Severity.ERROR);
    }

    private static boolean hasWarnings(Collection<? extends Issue> allIssues) {
        return ValidationIssues.hasIssuesWithSeverity(allIssues, Severity.WARNING);
    }

    private static boolean hasIssuesWithSeverity(Collection<? extends Issue> allIssues, Severity severity) {
        for (Issue issue : allIssues) {
            if (!severity.equals((Object)issue.getSeverity())) continue;
            return true;
        }
        return false;
    }

    private static void addFocusBorderToEditor(Component editor, Orientation orientation) {
        if (!ValidationIssues.canHaveFocusBorder(editor)) {
            return;
        }
        editor.addFocusListener(FocusPainter.painterFor(orientation));
    }

    private static boolean canHaveFocusBorder(Component editor) {
        if (editor instanceof JTextComponent) {
            return true;
        }
        if (editor instanceof JComboBox) {
            return ((JComboBox)editor).isEditable();
        }
        return false;
    }

    private static void addWarningBorderAndTooltip(JComponent editor, Collection<? extends Issue> issues, PropertyInfo info) {
        editor.putClientProperty(HAS_ISSUES_PROPERTY, true);
        Borders.attachWarningBorder((JComponent)editor);
        String toolTipText = ValidationIssues.toolTip(issues, editor.getFont());
        editor.setToolTipText(toolTipText);
        ValidationIssues.registerHoverable(editor, info, Severity.WARNING, toolTipText);
    }

    private static void addErrorBorderAndTooltip(JComponent editor, Collection<? extends Issue> issues, PropertyInfo info) {
        editor.putClientProperty(HAS_ISSUES_PROPERTY, true);
        Borders.attachErrorBorder((JComponent)editor);
        String toolTipText = ValidationIssues.toolTip(issues, editor.getFont());
        editor.setToolTipText(toolTipText);
        ValidationIssues.registerHoverable(editor, info, Severity.ERROR, toolTipText);
    }

    private static String toolTip(Collection<? extends Issue> issues, Font font) {
        StringBuilder b = new StringBuilder("<html><pre ");
        b.append(ValidationIssues.createCSSStyle(font));
        b.append(">");
        Iterator<? extends Issue> i = issues.iterator();
        while (i.hasNext()) {
            String message = i.next().getMessage();
            if (!ModelUtil.hasLength((String)message)) continue;
            b.append(message);
            if (!i.hasNext()) continue;
            b.append(LINE_SEPARATOR);
        }
        b.append("</pre></html>");
        return b.toString();
    }

    private static String createCSSStyle(Font font) {
        StringBuilder rule = new StringBuilder("style=\"");
        if (font != null) {
            rule.append("font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append("\"");
        return rule.toString();
    }

    private ValidationIssues() {
    }

    private static void registerHoverable(JComponent editor, PropertyInfo info, Severity severity, String message) {
        if (null == editor || null == info || null == severity || null == message || message.isEmpty()) {
            return;
        }
        ToolTipManager.sharedInstance().unregisterComponent(editor);
        HoverableImpl hoverable = new HoverableImpl(editor, info, severity, message);
    }

    private static void unregisterHoverable(JComponent editor) {
        if (null == editor) {
            return;
        }
        if (null != editor.getToolTipText()) {
            ToolTipManager.sharedInstance().registerComponent(editor);
        }
        HoverableRegistry.unregisterComponent((Component)editor);
    }

    private static final class HoverableImpl
    implements Hoverable,
    AncestorListener {
        private static final HoverFlavor ERRORS_FLAVOR = HoverFlavor.getFlavor((String)"errors");
        private final JComponent component;
        private final PropertyInfo propertyInfo;
        private final Severity severity;
        private final String message;
        private InfoTipHover hover;

        private HoverableImpl(JComponent component, PropertyInfo propertyInfo, Severity severity, String message) {
            this.component = component;
            this.propertyInfo = propertyInfo;
            this.severity = severity;
            this.message = message;
            if (this.component.isShowing()) {
                HoverableRegistry.registerComponent((Component)this.component, (Hoverable)this);
            }
            this.component.addAncestorListener(this);
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (!flavors.contains(ERRORS_FLAVOR)) {
                return null;
            }
            if (null == this.hover) {
                this.hover = this.initHover();
            }
            this.hover.showHover();
            return this.hover;
        }

        private InfoTipHover initHover() {
            JPanel tipContent = new JPanel();
            tipContent.setLayout((LayoutManager)new MigLayout("filly"));
            tipContent.setOpaque(false);
            JLabel iconLabel = new JLabel(this.severity.getIcon());
            iconLabel.setOpaque(false);
            tipContent.add(iconLabel);
            String propName = this.propertyInfo.displayName();
            String titleFmt = "PROPERTY_TIP_TITLE_WITH_PROPERTY_NAME";
            if (null == propName) {
                titleFmt = "PROPERTY_TIP_TITLE";
            }
            String title = BUNDLE.get(titleFmt, new Object[]{this.severity.getLabel(), propName});
            JLabel titleLabel = new JLabel(title);
            titleLabel.setOpaque(false);
            tipContent.add((Component)titleLabel, "wrap");
            JLabel descLabel = null;
            if (this.message.toLowerCase().startsWith("<html>")) {
                descLabel = new JLabel();
            } else {
                descLabel = new SuperLabel();
                ((SuperLabel)descLabel).setLabelOverride(true);
                descLabel.setFont(tipContent.getFont());
                FontMetrics fontMetrics = tipContent.getFontMetrics(tipContent.getFont());
                int width = (int)((double)SwingUtilities.computeStringWidth(fontMetrics, this.message) * 1.1);
                ((SuperLabel)descLabel).setPreferredWrapWidth(Math.min(250, width));
            }
            descLabel.setText(this.message);
            descLabel.setOpaque(false);
            tipContent.add((Component)descLabel, "span 2, growy");
            BasicTemplate template = new BasicTemplate((JComponent)tipContent);
            InfoTipHover hover = new InfoTipHover((Template)template, InfoTipStyles.DEFAULT, this.component, this.component.getBounds(), ERRORS_FLAVOR);
            return hover;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            HoverableRegistry.registerComponent((Component)this.component, (Hoverable)this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.component.removeAncestorListener(this);
            ValidationIssues.unregisterHoverable(this.component);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

