/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyValueApplier;

public class CheckBoxEditorSetup
extends EditorComponentSetup {
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof JCheckBox;
    }

    public void configure(final PropertyEditorFactory2 propertyEditor, final PropertyValueApplier applier, Component inlineEditor) {
        if (!this.canConfigure(inlineEditor)) {
            return;
        }
        final JCheckBox checkBox = (JCheckBox)inlineEditor;
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean selected = checkBox.isSelected();
                String oldValue = propertyEditor.getAsText();
                try {
                    applier.apply((Object)selected);
                }
                catch (Exception e) {
                    try {
                        boolean newValue = Boolean.parseBoolean(oldValue);
                        checkBox.setSelected(newValue);
                        propertyEditor.setAsText(oldValue);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    EditorFactoryUtils.showErrorMessage((Component)checkBox.getParent(), (Exception)e, (String)String.valueOf(selected));
                }
            }
        });
    }
}

