/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.find;

import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.inspector.layout.CustomGUIComponent;

public class SearchIterator
implements Iterator<Component> {
    private Container _rootContainer;
    private SearchNode _searchStack;

    public SearchIterator(Container container, boolean forward) {
        this._rootContainer = container;
        this._searchStack = new SearchNode(null, container, forward);
    }

    @Override
    public final boolean hasNext() {
        while (this._searchStack != null) {
            if (this._searchStack.hasNext()) {
                return true;
            }
            this._searchStack = this._searchStack.getParent();
        }
        return false;
    }

    @Override
    public final Component next() {
        if (this._searchStack == null) {
            throw new IllegalStateException();
        }
        Component result;
        while ((result = this._searchStack.next()) instanceof Container) {
            if (!this._searchStack.hasNext()) {
                this._searchStack = this._searchStack.getParent();
                return result;
            }
            if (!this.isSearchableContainer((Container)result)) continue;
            this._searchStack = this._searchStack.newNode((Container)result);
        }
        return result;
    }

    protected boolean isSearchableContainer(Container container) {
        return true;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private final class SearchNode {
        private SearchNode _parent;
        private Iterator<Component> _components;
        private Container _container;
        private boolean _forward;
        private boolean _done = false;

        private SearchNode(SearchNode parent, Container container, boolean forward) {
            this._parent = parent;
            this._container = container;
            this._forward = forward;
            this._components = this.getComponents();
        }

        private Iterator<Component> getComponents() {
            List<Component> children = this._container != SearchIterator.this._rootContainer && this._container instanceof JComponent && CustomGUIComponent.getCustomGUIComponent((JComponent)this._container) != null ? Collections.emptyList() : Arrays.asList(this._container.getComponents());
            if (!this._forward) {
                Collections.reverse(children);
            }
            return children.iterator();
        }

        private SearchNode newNode(Container container) {
            return new SearchNode(this, container, this._forward);
        }

        private boolean hasNext() {
            return !this._done;
        }

        private Component next() {
            if (this._done) {
                throw new IllegalStateException();
            }
            if (this._components.hasNext()) {
                return this._components.next();
            }
            this._done = true;
            return this._container;
        }

        public SearchNode getParent() {
            return this._parent;
        }
    }
}

